//! wd_macro: A useful macro library
mod stuext;
mod traitext;
use proc_macro::{TokenStream};


/// 为结构体字段添加链式set方法
/// ```rust
/// #[derive(ChainSet)]
/// struct Hello{
///     name:String,
/// }
/// #[test]
/// fn test_macro(){
///     let name = "hello".to_string();
///     let hello = Hello{name};
///     let hello = hello.cset_name("world".to_string());
///     println!("hello {}",hello.name)
/// }
/// ```
#[proc_macro_derive(ChainSet)]
pub fn chain_set(input: TokenStream) -> TokenStream {
    stuext::chain_set(input)
}

/// 为结构体字段添加get该字段的引用
/// ```rust
/// #[derive(ChainSet,Get)]
/// struct World{
///     name:String,
/// }
/// #[test]
/// fn test_macro_get(){
///     let world = World{name:String::from("hello")};
///     world.say_hello_get();
///     println!("hello {}",world.get_name())
/// }
/// ```
#[proc_macro_derive(Get)]
pub fn get(input: TokenStream) -> TokenStream {
    stuext::get(input)
}

/// 为接口添加异步方法
/// 需要引用如下两个包
/// ```rust
/// tokio = "1.1"
/// crossbeam = "0.7"
/// ```
///
/// example
///
/// ```rust
///#[tokio::main]
/// async fn main() {
///     let hs = HStruct{};
///     let res = hs.haha();
///     println!("result:{}",res)
/// }
///
/// pub trait Haha:Clone{
///     fn haha(&self)->u8;
/// }
/// #[derive(Clone)]
/// pub struct HStruct{}
///
/// #[wd_macro::wd_async_trait]
/// impl Haha for HStruct{
///     fn haha(&self)->u8{
///         return 6
///     }
/// }
/// ```
#[proc_macro_attribute]
pub fn wd_async_trait(args: TokenStream, input: TokenStream) -> TokenStream {
    traitext::wd_async_trait(args,input)
}