mod stuext;

use proc_macro::{TokenStream};

/// 为结构体字段添加链式set方法
/// #[derive(ChainSet)]
/// struct Hello{
///     name:String,
/// }
/// #[test]
/// fn test_macro(){
///     let name = "hello".to_string();
///     let hello = Hello{name};
///     let hello = hello.cset_name("world".to_string());
///     println!("hello {}",hello.name)
/// }
#[proc_macro_derive(ChainSet)]
pub fn chain_set(input: TokenStream) -> TokenStream {
    stuext::chain_set(input)
}

/// 为结构体字段添加get该字段的引用
/// #[derive(ChainSet,Get)]
/// struct World{
///     name:String,
/// }
/// #[test]
/// fn test_macro_get(){
///     let world = World{name:String::from("hello")};
///     world.say_hello_get();
///     println!("hello {}",world.get_name())
/// }
#[proc_macro_derive(Get)]
pub fn get(input: TokenStream) -> TokenStream {
    stuext::get(input)
}

