#![allow(unused_macros)]

#[macro_export]
macro_rules! log_debug {
    () => ({
        let line = line!();
        let file = file!();
        let _ = $crate::output($crate::DEBUG,file,line,String::new());
    });
    ($($arg:tt)*) => ({
        let line = line!();
        let file = file!();
        let value = format!($($arg)*);
        let _ = $crate::output($crate::DEBUG,file,line,value);
    })
}
#[macro_export]
macro_rules! log_debug_ln {
    ()=>({
        let line = line!();
        let file = file!();
        let value = "\n".to_string();
        let _ = $crate::output($crate::DEBUG,file,line,value);
    });
    ($($arg:tt)*) => ({
        let line = line!();
        let file = file!();
        let mut value = format!($($arg)*);
        value.push_str("\n");
        let _ = $crate::output($crate::DEBUG,file,line,value);
    })
}
#[macro_export]
macro_rules! log_info {
    () => ({
        let line = line!();
        let file = file!();
        let _ = $crate::output($crate::INFO,file,line,String::new());
    });
    ($($arg:tt)*) => ({
        let line = line!();
        let file = file!();
        let value = format!($($arg)*);
        let _ = $crate::output($crate::INFO,file,line,value);
    })
}
#[macro_export]
macro_rules! log_info_ln {
    ()=>({
        let line = line!();
        let file = file!();
        let value = "\n".to_string();
        let _ = $crate::output($crate::INFO,file,line,value);
    });
    ($($arg:tt)*) => ({
        let line = line!();
        let file = file!();
        let mut value = format!($($arg)*);
        value.push_str("\n");
        let _ = $crate::output($crate::INFO,file,line,value);
    })
}
#[macro_export]
macro_rules! log_warn {
    () => ({
        let line = line!();
        let file = file!();
        let _ = $crate::output($crate::WARN,file,line,String::new());
    });
    ($($arg:tt)*) => ({
        let line = line!();
        let file = file!();
        let value = format!($($arg)*);
        let _ = $crate::output($crate::WARN,file,line,value);
    })
}
#[macro_export]
macro_rules! log_warn_ln {
    ()=>({
        let line = line!();
        let file = file!();
        let value = "\n".to_string();
        let _ = $crate::output($crate::WARN,file,line,value);
    });
    ($($arg:tt)*) => ({
        let line = line!();
        let file = file!();
        let mut value = format!($($arg)*);
        value.push_str("\n");
        let _ = $crate::output($crate::WARN,file,line,value);
    })
}
#[macro_export]
macro_rules! log_error {
    () => ({
        let line = line!();
        let file = file!();
        let _ = $crate::output($crate::ERROR,file,line,String::new());
    });
    ($($arg:tt)*) => ({
        let line = line!();
        let file = file!();
        let value = format!($($arg)*);
        let _ = $crate::output($crate::ERROR,file,line,value);
    })
}
#[macro_export]
macro_rules! log_error_ln {
    ()=>({
        let line = line!();
        let file = file!();
        let value = "\n".to_string();
        let _ = $crate::output($crate::ERROR,file,line,value);
    });
    ($($arg:tt)*) => ({
        let line = line!();
        let file = file!();
        let mut value = format!($($arg)*);
        value.push_str("\n");
        let _ = $crate::output($crate::ERROR,file,line,value);
    })
}
#[macro_export]
macro_rules! log_panic {
    ()=>({
        let line = line!();
        let file = file!();
        let mut value = "null\n".to_string();
        let _ = $crate::output($crate::PANIC,file,line,value.clone());
        value.pop();
        panic!(value)
    });
    ($($arg:tt)*) => ({
        let line = line!();
        let file = file!();
        let mut value = format!($($arg)*);
        value.push_str("\n");
        let _ = $crate::output($crate::PANIC,file,line,value.clone());
        value.pop();
        panic!(value)
    })
}


//直接对错误进行处理
#[macro_export]
macro_rules! res_error {
    ($result:expr) => ({
        match $result {
            Err(e)=>{
                let line = line!();
                let file = file!();
                let mut value = format!("{}",e.to_string());
                let _ = $crate::output($crate::ERROR,file,line,value);
                None
            }
            Ok(res)=>{
                Some(res)
            }
        }
    });
    ($result:expr;$($arg:tt)*) => ({
        match $result {
            Err(e)=>{
                let line = line!();
                let file = file!();
                let mut value = format!($($arg)*);
                let error = format!(" error:{}",e.to_string());
                value.push_str(&error);
                let _ = $crate::output($crate::ERROR,file,line,value);
                None
            }
            Ok(res)=>{
                Some(res)
            }
        }
    })
}
//存在错误则打印，没有错误则返回
#[macro_export]
macro_rules! res_error_ln {
    ($result:expr) => ({
        match $result {
            Err(e)=>{
                let line = line!();
                let file = file!();
                let mut value = format!("{}\n",e.to_string());
                let _ = $crate::output($crate::ERROR,file,line,value);
                None
            }
            Ok(res)=>{
                Some(res)
            }
        }
    });
    ($result:expr;$($arg:tt)*) => ({
        match $result {
            Err(e)=>{
                let line = line!();
                let file = file!();
                let mut value = format!($($arg)*);
                let error = format!(" error={}\n",e.to_string());
                value.push_str(&error);
                let _ = $crate::output($crate::ERROR,file,line,value);
                None
            }
            Ok(res)=>{
                Some(res)
            }
        }
    })
}
#[macro_export]
macro_rules! res_panic {
    ($result:expr)=>{
        match $result {
            Err(e)=>{
                let line = line!();
                let file = file!();
                let mut error = format!(" error:{}",e.to_string());
                error.push_str("\n");
                let _ = $crate::output($crate::PANIC,file,line,error.clone());
                error.pop();
                panic!(error);
            }
            Ok(res)=>{
               res
            }
        }
    };
    ($result:expr;$($arg:tt)*) => ({
        match $result {
            Err(e)=>{
                let line = line!();
                let file = file!();
                let mut value = format!($($arg)*);
                let error = format!(" error:{}",e.to_string());
                value.push_str(&error);
                value.push_str("\n");
                let _ = $crate::output($crate::PANIC,file,line,value.clone());
                value.pop();
                panic!(value);
            }
            Ok(res)=>{
               res
            }
        }
    });
}