#[macro_use] mod log_macro;
// mod log_out;
mod log_config;

pub use log_config::{set_level,set_prefix,show_time,show_file_line,output_to_file};
pub use log_config::{get_level,get_prefix,output};
pub use log_config::{DEBUG,INFO,WARN,ERROR,PANIC};






#[cfg(test)]
mod tests {
    use crate::{show_time, show_file_line, set_prefix, set_level, DEBUG, output, output_to_file, INFO};
    #[test]
    fn log_config() {
        //Set log level, default:Debug
         set_level( INFO);
        //Set the log output prefix, default:"wd_log"
         set_prefix("WDLOG");
        //Whether to display the print time, default:true
         show_time(false);
        //Whether to display the location, default:true
         show_file_line(false);
        //Set output to a file, default:stdout
         output_to_file("./log.txt").expect("file open failed");
         log_debug_ln!("this is file output");
    }
    #[test]
    fn log_print(){
         log_debug!("hello world");
         log_debug_ln!("hello world");
         log_info!("hello world");
         log_info_ln!("hello world");
         log_warn!("hello world");
         log_warn_ln!("hello world");
         log_error!("hello world");
         log_error_ln!("hello world");
    }
    #[test]
    #[should_panic]
    fn log_panic(){
         log_panic!("hello world");
    }
    #[test]
    fn error(){
        let result = Err("hello");
        let _res:Option<()> =  res_error!(result);
        let _res:Option<()> =  res_error_ln!(result);

        let _res:Option<()> =  res_error!(result;"this is {}","error");
        let _res:Option<()> =  res_error_ln!(result;"this is {}","error");

        let result:Result<&str,&str> = Ok("world");
        let res:Option<&str> =  res_error!(result);
        assert_eq!(res,Some("world"))
    }
    #[test]
    #[should_panic]
    fn res_panic(){
        let result:Result<&str,&str> = Ok("hello");
        let res =  res_panic!(result;"succes");
        println!("{}",res);
        let result = Err("hello");
        //It can lead to panic
        let _ =  res_panic!(result;"this is {}","error");
    }
}
