[wd_log][docsrs]: A Rust library providing a lightweight logging facade
========================================

[![wd_log GitHub Actions][gh-image]][gh-checks]
[![wd_log on crates.io][cratesio-image]][cratesio]
[![wd_log on docs.rs][docsrs-image]][docsrs]
[![License](https://img.shields.io/crates/l/lazy_static.svg)](https://gitee.com/yutiandou/wd_log/blob/master/LICENSE)

[gh-image]: https://github.com/chronotope/chrono/workflows/test/badge.svg
[gh-checks]: https://gitee.com/yutiandou/wd_log/tree/master
[cratesio-image]: https://img.shields.io/crates/v/wd_log.svg
[cratesio]: https://crates.io/crates/wd_log
[docsrs-image]: https://docs.rs/wd_log/badge.svg
[docsrs]: https://docs.rs/wd_log
[gitter-image]: https://badges.gitter.im/wd_log-rs/wd_log.svg
[gitter]: https://gitter.im/wd_log-rs/wd_log

> This is a Rust Log Crate. Log output is mainly achieved through macros. Log composite output will be supported in future releases. The following features are now supported.
    
- [x] configurable
- [x] color identification
- [x] output to file
- [ ] combination field (coding)

The current version is preliminary and will get better in the future.

## Getting Started
wd_log is available on crates.io. It is recommended to look there for the newest released version, as well as links to the newest builds of the docs.

At the point of the last update of this README, the latest published version could be used like this:

Add the following dependency to your Cargo manifest...
```rust
[dependencies]
wd_log = "0.1"
```

## Example
#### config
```rust
    //Set log level, default:Debug
    wd_log::set_level(wd_log::INFO);
    //Set the log output prefix, default:"wd_log"
    wd_log::set_prefix("WDLOG");
    //Whether to display the print time, default:true
    wd_log::show_time(false);
    //Whether to display the location, default:true
    wd_log::show_file_line(false);
    //Set output to a file, default:stdout
    wd_log::output_to_file("./log.txt").expect("file open failed");
```

#### print<br>
- By default there is no line break; macros ending in '_ln' indicate line breaks.
```rust
    wd_log::log_debug!("hello world");
    wd_log::log_debug_ln!("hello world");
    wd_log::log_info!("hello world");
    wd_log::log_info_ln!("hello world");
    wd_log::log_warn!("hello world");
    wd_log::log_warn_ln!("hello world");
    wd_log::log_error!("hello world");
    wd_log::log_error_ln!("hello world");
```
- Allows empty and formatted printing
```rust
    wd_log::log_debug!();
    wd_log::log_debug!("{} {}","hello","world");
```
- panic
```rust
    //After printing, trigger panic.
    wd_log::log_panic!("hello world");
```

#### result type deal
- Macros that begin with 'res_' can handle the result type
- if result is Err, print an error and return None
- if result if Ok(T), direct return Some(T)
```rust
    let result = Err("hello");
    let _res:Option<()> = wd_log::res_error!(result);
    let _res:Option<()> = wd_log::res_error_ln!(result);

    let _res:Option<()> = wd_log::res_error!(result;"this is {}","error");
    let _res:Option<()> = wd_log::res_error_ln!(result;"this is {}","error");

    let result:Result<&str,&str> = Ok("world");
    let res:Option<&str> = wd_log::res_error!(result);
    assert_eq!(res,Some("world"))
```
- if result is Err, res_panic will panic after printing this error
- if result is Ok(T), direct return Some(T)
```rust
        let result:Result<&str,&str> = Ok("hello");
        let res = wd_log::res_panic!(result;"succes");
        println!("{}",res);
        let result = Err("hello");
        //It can lead to panic
        let _ = wd_log::res_panic!(result;"this is {}","error");
```

## License

Licensed under either of

 * Apache License, Version 2.0, ([LICENSE-APACHE](LICENSE-APACHE) or http://www.apache.org/licenses/LICENSE-2.0)
 * MIT license ([LICENSE-MIT](LICENSE-MIT) or http://opensource.org/licenses/MIT)

at your option.

## Contribution
Unless you explicitly state otherwise, any contribution intentionally submitted for inclusion in the work by you, as defined in the Apache-2.0 license, shall be dual licensed as above, without any additional terms or conditions.