mod entity;
mod interface;
mod polling;

pub use interface::{BalancingCall,BalancingStrategy};
pub use polling::Polling;
pub use entity::Balancing;

#[cfg(test)]
mod test{
    use crate::{BalancingCall, Balancing, Polling};

    #[test]
    fn test_main(){
        println!("hello,world")
    }
    struct Service {
        name:&'static str
    }
    impl Service{
        fn new(name:&'static str)->Self{
            Self{name}
        }
    }
    #[async_trait::async_trait]
    impl BalancingCall<String, String> for Service{
        async fn call(&self, reqs: String) -> Option<String> {
            Some(format!("request:{} -> response:{}",reqs,self.name))
        }
    }
    #[tokio::test(flavor = "multi_thread", worker_threads = 1)]
    async fn test_polling(){
        wd_log::log_debug_ln!("start test polling");
        let bl = Balancing::new()
            .set_strategy(Polling::new().breadth_first());

        bl.add(1,Service::new("我是第一个节点"),1).await;
        bl.add(2,Service::new("我是第二个节点"),2).await;
        bl.add(3,Service::new("我是第三个节点"),3).await;

        for i in (0..9).map(|x|x as usize) {
            let resp = bl.call(i.to_string()).await;
            if let Some(s) = resp{
                wd_log::log_debug_ln!("-> {}",s)
            }
        }
        bl.remove(2).await;
        wd_log::log_debug_ln!("===================> 移除2号节点===========================");
        for i in (0..9).map(|x|x as usize) {
            let resp = bl.call(i.to_string()).await;
            if let Some(s) = resp{
                wd_log::log_debug_ln!("-> {}",s)
            }
        }
        bl.remove(1).await;
        bl.remove(3).await;
        wd_log::log_debug_ln!("===================> 移除全部节点===========================");
        for i in (0..3).map(|x|x as usize) {
            let resp = bl.call(i.to_string()).await;
            if let Some(s) = resp{
                wd_log::log_debug_ln!("-> {}",s);
            }else{
                wd_log::log_debug_ln!("-> 当前没有存活的节点");
            }
        }
    }
}