use crate::{BalancingCall,BalancingStrategy,Polling};
use std::sync::Arc;
use std::collections::HashMap;
use tokio::sync::RwLock;
use std::ops::DerefMut;
use std::hash::Hash;


pub struct Balancing<K,Req, Res>{
    map:RwLock<HashMap<K,Box<dyn BalancingCall<Req, Res>>>>,
    strategy:Arc<dyn BalancingStrategy<K> + Send + Sync + 'static>,
}
impl<K:Clone + Eq + Hash + Send + Sync + 'static,Req, Res> Balancing<K,Req, Res>{
    pub fn new()->Self{
        let map = RwLock::new(HashMap::new());
        let strategy = Arc::new(Polling::new());
        Self{map,strategy}
    }
    pub fn set_strategy(mut self, strategy:impl BalancingStrategy<K> + Send + Sync + 'static) ->Self {
        let strategy = Arc::new(strategy);
        self.strategy = strategy;
        self
    }
    pub async fn add<N:BalancingCall<Req, Res>+'static>(&self,key:K,n:N,w:usize){
        if w <= 0{
            return;
        }
        let mut map = self.map.write().await;
        let map = map.deref_mut();
        map.insert(key.clone(),Box::new(n));
        self.strategy.add(key,w).await;
    }
    pub async fn remove(&self,key:K){
        let mut map = self.map.write().await;
        let map = map.deref_mut();
        map.remove(&key);
        self.strategy.remove(key).await;
    }
    pub async fn call(&self,reqs:Req)->Option<Res>{
        let map = self.map.read().await;
        if let Some(k) = self.strategy.select().await {
            if let Some(node) = map.get(&k) {
                return node.call(reqs).await
            }
        }
        None
    }
}