
fn load_builtin_chip_db() -> ChipDB {
    const BUILTIN_TARGETS: &[u8] = include_bytes!(concat!(env!("OUT_DIR"), "/targets.bincode"));

    let mut families: Vec<ChipFamily> = bincode::deserialize(BUILTIN_TARGETS)
        .expect("Failed to deserialize builtin targets. This is a bug.");

    Self { families }
}


fn parse_and_read_config_register<'de, D>(
    deserializer: D,
) -> std::result::Result<Vec<ConfigRegister>, D::Error>
where
    D: serde::Deserializer<'de>,
{
    let path: String = serde::Deserialize::deserialize(deserializer)?;
    let content = std::fs::read_to_string(&path).map_err(serde::de::Error::custom)?;
    Ok(serde_yaml::from_str(&content).map_err(serde::de::Error::custom)?)
}
