use std::fs;
use std::io::{Read, Write};
use std::net::{TcpListener, TcpStream};
pub struct TestServer {}

impl TestServer {
    pub fn test_anchors_server() {
        let listener = TcpListener::bind("127.0.0.1:7878").unwrap();

        for stream in listener.incoming() {
            let stream = stream.unwrap();
            handle_anchor_connection(stream);
        }
    }
}

fn handle_anchor_connection(mut stream: TcpStream) {
    let mut buffer = [0; 1024];

    stream.read(&mut buffer).unwrap();

    let contents = fs::read_to_string("./assets/check_record_anchors.html").unwrap();
    let response = format!(
        "HTTP/1.1 200 OK\r\nContent-Length: {}\r\n\r\n{}",
        contents.len(),
        contents
    );

    stream.write(response.as_bytes()).unwrap();
    stream.flush().unwrap();
}
