use crate::records::HtmlRecord;

mod clients;
pub mod pressers;
pub mod records;
mod test_server;

#[cfg(test)]
mod tests {
    use crate::pressers::HtmlPresser;
    use crate::test_server;
    use crate::test_server::TestServer;
    use std::thread;
    macro_rules! aw {
        ($e:expr) => {
            tokio_test::block_on($e)
        };
    }

    #[test]
    fn press_urls() {
        let press_urls = aw!(HtmlPresser::press_urls("https://example.com", 1, 1));
        let url = press_urls.unwrap();

        assert_eq!(url.len(), 1);
    }

    #[test]
    fn press_curated_urls_nm() {
        let pressed_urls = aw!(HtmlPresser::press_curated_urls(
            "https://example.com",
            "no_match123",
            1,
            1
        ));
        let url = pressed_urls.unwrap();

        assert_eq!(url.len(), 0);
    }

    #[test]
    fn press_curated_urls_m() {
        let pressed_urls = aw!(HtmlPresser::press_curated_urls(
            "https://example.com",
            ".",
            1,
            1
        ));
        let url = pressed_urls.unwrap();

        assert_eq!(url.len(), 1);
    }

    #[test]
    fn press_recs_blind() {
        let pressed_recs = aw!(HtmlPresser::press_records_blind("https://funnyjunk.com", 2));
        let rec = pressed_recs.unwrap();

        assert_eq!(rec.len(), 2);
    }

    #[test]
    fn press_recs_vector() {
        let pressed_recs = aw!(HtmlPresser::press_records(vec!["https://example.com"]));
        let rec = pressed_recs.unwrap();

        assert_eq!(rec.len(), 1);
    }

    #[test]
    fn press_recs_single() {
        let pressed_recs = aw!(HtmlPresser::press_record("https://example.com"));
        let rec = pressed_recs.unwrap();

        assert_eq!(rec.origin, "https://example.com/");
    }

    /*

    record tests

     */
    #[test]
    fn test_server_works() {
        thread::spawn(move || {
            TestServer::test_anchors_server();
        });

        let pressed_rec = aw!(HtmlPresser::press_record("http://127.0.0.1:7878"));

        assert_eq!(pressed_rec.is_ok(), true);
    }

    #[test]
    fn record_domain_anchors() {
        thread::spawn(move || {
            TestServer::test_anchors_server();
        });

        let pressed_rec = aw!(HtmlPresser::press_record("http://127.0.0.1:7878"));
        let mut rec = pressed_rec.unwrap();
        rec.origin = "https://example.com".to_string();
        let domain_anchors = rec.domain_anchors();

        assert_eq!(domain_anchors.len(), 5);
    }

    #[test]
    fn record_non_domain_anchors() {
        thread::spawn(move || {
            TestServer::test_anchors_server();
        });

        let pressed_rec = aw!(HtmlPresser::press_record("http://127.0.0.1:7878"));
        let mut rec = pressed_rec.unwrap();
        rec.origin = "https://example.com".to_string();
        let domain_anchors = rec.non_domain_anchors();

        assert_eq!(domain_anchors.len(), 5);
    }
}
fn get_document() -> String {
    "".to_string()
}
