use crate::records::HtmlRecord;
use http::{HeaderMap, HeaderValue};
use std::collections::HashMap;
use url::Url;

///public function
/// takes in a url string (complete "https://example.com")
/// returns an HtmlDocument if good, reqwest error if bad
/// basically just assembles after making a client side call
pub async fn fetch_html_record(url_str: &str) -> Result<HtmlRecord, reqwest::Error> {
    let url_parsed = Url::parse(url_str).expect("cannot parse");
    let res = reqwest::get(url_parsed.as_str()).await?;
    let mut headers_map = convert_headermap(res.headers());
    let status_value = vec![res.status().as_u16().to_string()];

    headers_map.insert(String::from("status"), status_value);

    let body_value = res.text().await?;
    let record: HtmlRecord = HtmlRecord {
        origin: url_parsed.to_string(),
        headers: headers_map,
        body: body_value,
    };

    Ok(record)
}

///private method
///takes in a header map and converts it to a hashmap
/// used to help build the http record
/// shamelessy ripped off.
/// i didn't record the source :(
fn convert_headermap(headers: &HeaderMap<HeaderValue>) -> HashMap<String, Vec<String>> {
    let mut header_hashmap = HashMap::new();

    for (k, v) in headers {
        let k = k.as_str().to_owned();
        let v = String::from_utf8_lossy(v.as_bytes()).into_owned();
        header_hashmap.entry(k).or_insert_with(Vec::new).push(v)
    }

    header_hashmap
}
