mod clients;
pub mod documents;
pub mod workers;

#[cfg(test)]
mod tests {
    //use std::io::Error;
    //use tokio_test::*;
    use crate::{workers::WaxWorker};

    macro_rules! aw {
        ($e:expr) => {
            tokio_test::block_on($e)
        };
      }

      #[test]
    fn press_urls() {
        let press_urls = aw!(WaxWorker::press_urls("https://example.com",1,1));
        let url = press_urls.unwrap();
        assert_eq!(url.len(), 1);
    }

    #[test]
    fn press_curated_urls_nm() {
        let pressed_urls = aw!(WaxWorker::press_curated_urls("https://example.com","no_match123",1,1));
        let url = pressed_urls.unwrap();
        println!("{:?}", url);
        assert_eq!(url.len(), 0);
    }

    #[test]
    fn press_curated_urls_m() {
        let pressed_urls = aw!(WaxWorker::press_curated_urls("https://example.com",".",1,1));
        let url = pressed_urls.unwrap();
        println!("{:?}", url);
        assert_eq!(url.len(), 1);
    }

    #[test]
    fn press_docs_blind() {
        let pressed_docs = aw!(WaxWorker::press_documents_blind("https://example.com",1));
        let doc = pressed_docs.unwrap();
        assert_eq!(doc.len(), 1);
    }

    #[test]
    fn press_docs_vector() {
        let pressed_docs = aw!(WaxWorker::press_documents(vec!["https://example.com"]));
        let doc = pressed_docs.unwrap();
        assert_eq!(doc.len(), 1);
    }

    #[test]
    fn press_docs_single() {
        let pressed_docs = aw!(WaxWorker::press_document("https://example.com"));
        let doc = pressed_docs.unwrap();
        assert_eq!(doc.origin, "https://example.com/");
    }
}
