![WASI logo](/WASI.png)

## Agenda for the November 19 video call of WASI Subgroup

- **Where**: zoom.us
- **When**: November 19, 16:00-17:00 UTC
- **Location**: *link on calendar invite*
- **Contact**:
    - Name: Dan Gohman
    - Email: hello@sunfishcode.online

### Registration

None required if you've attended before. Email Dan Gohman to sign up if it's
your first time. The meeting is open to CG members only.

## Logistics

The meeting will be on a zoom.us video conference.
Installation is required, see the calendar invite.

## Agenda items

1. Opening, welcome and roll call
    1. Please help add your name to the meeting notes.
    1. Please help take notes.
    1. Thanks!
1. Review of action items from previous meeting(s).
    1. Ralph Squillance to write up a draft on "WASI experimental" or
       versioning for WASI API experimentation.
1. Removing support for `seekdir`/`telldir` from wasi-filesystem
    1. https://github.com/WebAssembly/wasi-filesystem/issues/7
1. Filesystem Case Insensitivity
    1. https://github.com/WebAssembly/wasi-filesystem/issues/5
    1. https://github.com/nicowilliams/ietf-fs-i18n

## Meeting Notes

### Attendees
- Peter Huene
- Sam Clegg (SC)
- Lin Clark (LC)
- Andrew Brown
- Dan Gohman (DG)
- Sergey Rubanov
- Syrus Akbary (SA)
- Matt Fisher
- Eric Rosenberg
- Ralph Squillace (RS)
- Till Schneidereit (TS)
- Harun Oz
- Pat Hickey (PH)

### Action Items from Last Week
RS: had conversation with Pat and Dan about how people are testing out experimental proposals. Pretty obv that we wanted to use these experiments for inputs. At same time, second issue was wanting to be very clear that none of the experiments were destined to the spec

Wanted people to be able to play with sockets in Krustlet. Dan proposed creating an experimental namespace. Ralph will now begin tackling the doc. Will talk with Fastly about how they are handling exp.

DG: need standard convention for naming

SC: Are you talking about system level imports?

DG: We have wasi_ naming convention. Should be a naming convention for things not in snapshot yet

RS: That makes sense. Explicitly not destined to be migrated. Signal that these are things to be used as ways of stimulating thought. Kind of a firewall between these and what’s going into the spec.

DG: One additional thing—some prior art wrt web standards e.g. vendor prefixes. We can probably avoid

SC: How would we avoid. By not shipping prod VMs with them enabled?

DG: Yes, or behind flags

TS: Situation might become slightly different once module linking and ability to virtualize comes in. Then you could say you don’t need to ship as long as you provide a shim implemented in user space

SC: presumably not the module name

PH: unfortunate that there’s only one name

DG: Module linking has concept of nested modules. Might be useful

PH: That’s used for definitions but not for imports.

SC: You can chain imports

TS: IIRC you have to re-export

DG: typically you do, but … if we don’t have this, then mangling

PH: we need this before module linking lands in any toolchain. 

From chat: 
wasi_experimental_tests?
wasi_experimental_temp?
From Pat Hickey to Everyone:  12:16 PM
wasi_experimental_<modulename> for a mangling scheme

**ACTION ITEM: Ralph will compile doc**

### Removing support for seekdir/telldir from wasi-filesystem

DG: from days when OSs used flat lists. Now they are BTrees. These have become awkward abstractions.

DG: want to remove from WASI altogether. Can’t do a 64 bit seekdir. In order to satisfy POSIX, we’d need to do some complicated indirection. Theoretically possible, but think better to remove altogether.

SC: Proposal is just to remove, not emulate in user space?

DG: I don’t think it’s worth it unless use case

SA: Don’t have context, but what do you think wouldn’t be possible?

DG: ls will work. This is why I’m asking whether anyone has heard of someone using this. Scan through, then restart from beginning, and then keep going is pretty rare. This originated when it was hard to keep file in memory at same time

RS: What’s request? Could potentially search GitHub. There are tools

DG: Found a million hits in code, a lot are libc code

SC: Yeah, we’ll need to skip headers and impls

TS: Have experience from TC39. People have tried to use as code search, but there’s quite a lot more dark matter that’s not in public repos, and also test suites are copied all over place and not ways to exclude. Perhaps possible to do regex to exclude

RS: Both MS and GitHub have internal tools for this. GH is strongly motivated to make this work. If we can write a user story that’s in the sweet spot, I will see what can be done as a feature, either privately or as a preview test, or ultimately as a public feature

DG: That feature would be really useful for other questions too

RS: I do need a user story to pursue in an aggressive way, but I think they actively want user stories.

DG: WASI libc is already trying to guess what you’ll need.

RS: Side issue—feature set is that we want to know what the community is using.

DG: Roughly the plan for removal is to remove from libc. Second step is to remove from WASI itself, removing parameter and introducing rewind call

**ACTION ITEM: Ralph will use internal tool to search for use**
**(possible) ACTION ITEM: Put together user story for feature that would allow WASI SG to search for usage of other APIs**

### Filesystem Case Insensitivity

DG: GitHub repos and offline chatting. ONe question, what is the goal of the ___ API Fully deterministic? Will behave same way across all platforms. 

DG: People want to access existing files that already have their own restrictions. Hard to abstract away. If we can assume WASI runtime owns filesystem, could do a lot, but if we assume you have your own files, we have to pass it on to applications. Somewhat unfortunate, but after a lot of discussion think we’re going non-deterministic. Best we can do is good debugging tools. Those wouldn’t be part of the spec, just side debugging tools. Disappointing from the Wasm perspective, where we try to be deterministic. Not within our power at the WASI level to choose one side

DG: Also want to mention, link in meeting notes that will hopefully turn into an IETF proposal that will define portable semantics

### Additional Questions

SA: One quick question. What do you want me to do with the logo

DG: Researching IP rules

LC: I can help with this and serve as point of contact

SA: Lmk if you need changes to the PR

