![WASI logo](/WASI.png)

## Agenda for the May 30 video call of WASI Subgroup

- **Where**: zoom.us
- **When**: May 30, 16:00-17:00 UTC
- **Location**: *link on calendar invite*
- **Contact**:
    - Name: Dan Gohman
    - Email: sunfish@mozilla.com

### Registration

None required if you've attended before. Email Dan Gohman to sign up if it's
your first time. The meeting is open to CG members only.

## Logistics

The meeting will be on a zoom.us video conference.
Installation is required, see the calendar invite.

## Agenda items

1. Opening, welcome and roll call
    1. Opening of the meeting
    1. Introduction of attendees
1. Find volunteers for note taking (acting chair to volunteer)
1. Adoption of the agenda
1. Proposals and discussions
    1. Review of action items from prior meeting.
        - Import names
    1. Weak imports
        - https://github.com/WebAssembly/WASI/issues/36
           - Relationship to core wasm feature testing?
              - https://github.com/WebAssembly/design/issues/1280
           - Should we push for weak imports in the core wasm spec?
           - Looking for volunteers to draft a weak-import custom section doc
    1. Where should wasi-sysroot live?
        - https://github.com/WebAssembly/reference-sysroot/pull/11
    1. Identify a module for an MVP.
    1. (Time permitting) Plan iteration on additional modules

1. Closure

## Agenda items for future meetings

*None*

### Schedule constraints

*None*

## Meeting Notes

2019-05-02 WebAssembly CG WASI Subgroup Video Meeting Notes

Agenda: https://github.com/WebAssembly/WASI/blob/main/meetings/2019/WASI-05-30.md

Attendees:

Dan Gohman
Luke Imhoff
Alex Crichton
Martin Becze
Mark S. Miler
Pat Hickey
Tyler McMullen
Thomas Lively
Dan Gebhardt
Sam Clegg
Mark McCaskey
Nick Hynes
Nathaniel McCallum
Lin Clark
Yury Delendik
Mingqiu Sun


Meeting notes:

Review action items:

Sam has a document about import naming. TODO: insert the link here. We’ll discuss it in the next meeting.

Action item: Sam to send out the import naming document.

Weak imports:

“Weak” in this context is not related to weak GC references.

Desire to avoid depending on GC spec
Depend instead of reference types
Pat and others: push back on depending on reference types which aren’t in wasm MVP and not all tools support yet, causing schedule delays.
Mark Miller: How do capabilities work if we don’t have references?
Discussion of the mechanics of i32 file descriptors, which are forgeable, and which don’t enforce PoLA
Luke Wagner: Multiple tables may help i32-based environments have better granularity.
If you’re using C, you have to trust anyone you share your linear memory with. But other tools and languages and implementation strategies could do better.
Discussion of techniques to achieve various granularities of PoLA.


Action item: Sam to write up a name mangling proposal.

Action item: Mark Miller to write up a vision document for using reference types and reference-counted closures in WASI.

Existing toolchains for C-family and similar languages don’t use references. They typically need bindings tools to interoperate with reference-using APIs

Discussion of how bindings work in various languages.


Action item: Dan to rename wasi-sysroot to wasi-libc

Discussion of the WASI repo structure, pros and cons of using multiple repos, inside and outside the org

Discussion about organizations and repos. Emscripten has its own org. LLVM wasm backend is maintained in a third party repository. Concern about having things in the WebAssembly org might raise the barrier to entry for contributing. Having things in the WebAssembly org may make things easier to find.

Action item: Mark Miller to write up a vision document for using OCAP in WASI.
