# Documentation

WASI documentation includes:
 - [Overview](WASI-overview.md): provides an introduction to WASI and its history
 - [Goals](HighLevelGoals.md): a succinct list of WASI's design goals
 - [Design Principles](DesignPrinciples.md): discusses details on the principles of capability-based security, scope,
 POSIX/Web, etc.
 - [WITX](witx.md): an introduction to the WITX specification language
 - [Process](Process.md): describes how to move a WASI proposal in to the specification
 - [Proposals](Proposals.md): lists the current WASI proposals by phase

Additionally, here are some links that may be helpful in understanding WASI:
 - The blog post introducing WASI: [Standardizing WASI: A system interface to run WebAssembly outside the web](https://hacks.mozilla.org/2019/03/standardizing-wasi-a-webassembly-system-interface/)
 - The [wasi.dev](https://wasi.dev) web site includes links to more information about WASI, including how to get started using it
 - This repository's [issue tracker](https://github.com/WebAssembly/WASI/issues) 