![WASI logo](/WASI.png)

## Agenda for the December 3 video call of WASI Subgroup

- **Where**: zoom.us
- **When**: December 3, 16:00-17:00 UTC
- **Location**: *link on calendar invite*
- **Contact**:
    - Name: Lin Clark
    - Email: lclark@fastly.com

### Registration

None required if you've attended before. Email Lin Clark to sign up if it's
your first time. The meeting is open to CG members only.

## Logistics

The meeting will be on a zoom.us video conference.
Installation is required, see the calendar invite.

## Agenda items

1. Opening, welcome and roll call
    1. Please help add your name to the meeting notes.
    1. Please help take notes.
    1. Thanks!
1. Review of action items from previous meeting(s).
    1. Ralph Squillace to write up a draft on "WASI experimental" or versioning for WASI API experimentation.
1. Proposals and discussions
    1. Discussion topic: Repository organization to enable independent proposal repos ([#360](https://github.com/WebAssembly/WASI/issues/360))
    1. Discussion topic: Using releases to make the repo citable ([#356](https://github.com/WebAssembly/WASI/issues/356))

## Meeting Notes

### Attendees
Lin Clark (LC)
Pat Hickey (PAH)
Martin Duke (MD)
Andrew Brown (AB)
Dan Gohman (DG)
Till Schneidereit (TS)
Matt Fisher (MF)
Mingqiu Sun (MS)
Mark McCaskey (MM)
Johnnie Birch (JB)
Ralph Squillace (RS)
Peter Huene (PEH)
Sam Clegg (SBC)

LC: Action items from last meeting - Ralph is not on the call, so we’ll skip over follow ups with him

LC: Dan put up a PR yesterday about repo organization to enable independent proposal repos

DG: In a CG there's the core spec repo, and proposals that add new features are fork repos of the spec. When a proposal gets to stage 5 (spec), the proposal gets merged into the central repository. We want WASI to have a parallel structure to this.

DG: One thing we want to move away from is a single snapshot path. So when we make a snapshot its url remains stable (we don't put it into old). What this enables is one snapshot referring to another. We want documentation to describe the differences between snapshots and eventually tools will too. Stable URLs are a good first step towards that

DG: Another feature is moving away from ephemeral. That was envisioned as the place where we do development, where PRs target, but we want to move all development into proposal repositories. The main proposal repo will no longer have an ephemeral directory.
DG: A final piece of this is a place in the repo for a script, similar to core CG’s test suite repository, that pulls in the proposals from all the places they live, and creates the snapshot. All of the proposals will be separate modules in the snapshot.

AB: When do proposal repos get added to the script so they land in the snapshot?

DG: As soon as you create them you can create a PR to the script. One rule we could have is that if there's a merge conflict or other obvious errors we just skip over merging a proposal for now. But we want a snapshot to contain all proposals.

DG: In the root spec repo, there will be a `standards/` directory, it's empty for now because we aren't at stage 5 yet. But out in the proposals they can put whatever they want to land in the spec repo snapshot in their `standards/` directory. This convention is that we don't have to wait for everyone to sync up

TS: Will it make sense to say “only show me sections for proposals for stage of my choice in the rendered output”.

DG: We don't have that information yet but that's a good idea. Maybe a magic doc comment in the witx files. Or we can iterate

TS: There has to be some index about pulling in the proposals, and that can contain the metadata about what stage various proposals are at.

AB: This is a better system than we have today

DG: We are learning from our mistakes

TS: We need to iterate on the infrastructure of the spec in a central place, and make use of it without copying code over, are you envisioning the proposals will pull in the (upstream) spec repo? And we iterate on that outside of the snapshot mechanism?

DG: Some proposals need to make change to witx. They all have a witx crate in them to make changes to how witx works. You can experiment there and make a non-snapshot PR into the spec repo to merge bigger changes in. You can keep 

PAH: For some changes to WITX, it would make sense to do in the core spec repo and then proposals merge or rebase

DG: That is something that becomes more awkward with this setup. The question is would you also modify existing snapshots to use the new syntax? Because if not, then snapshots don’t work with new tooling.


PAH: let’s set that discussion aside. We have been updating to keep semantics but use new syntax. The hard part of this is that if we have to make a breaking change to WITX that could affect our ability to merge in proposals that haven’t taken in the breaking changes yet. Is it the responsibility of WITX maintainer to un-break all the proposals?

DG: Initial way that falls out is that the script that merges will run the new version of the tool over that. If it doesn’t run, we leave out of the snapshot

PAH: That sounds fine to me. What I’m thinking now is the CGs waterfall, continuous integration of tip of tree which makes it possible to find before releases. Could run it on a cron job and does red/green for various proposals

DG: If someone wants to set up a waterfall, that would be good. Might be more than we need right now.

PAH: If you have to update both your WITX files and ref implementation on downstream tooling, might not be able you

DG: You can do it on your local as a champion

PAH: This also makes me think about the value of the snapshot version being date based. You could have an id and a date. E.g. nightly-YYYY-MM-DD. That could give people ability to find breakages before time for snapshot. I think the biggest thing I’ve messed up in WASI and WITX is not having tooling that makes ephemeral work. Want the new process to be tip of tree always working. I could be wrong on that, but that’s my personal feeling.

DG: Ephemeral in main repo goes away. If they want to dev in standards dir, they can. If they have their own ephemeral, then it’s on them to keep it working.

TS: It seems to me that there’s value in cross-proposal CI so that you don’t find out when cutting a snapshot more work to do. I could see value in /standards and /in-progress, where we maybe have GitHub action that tries to do an integration build

PAH: I think I agree. I would love it if the CI action could be run in any of the fork repos so that they could alert on their own breakage.

DG: If we put that in the main repo, then they’ll all have a fork of it

PAH: They’d be able to id if any contrib to main repo is breaking. That’s an implementation detail.

TS: I feel like it would also be kind of nice to have a snapshot that’s always up to date for what it looks like today with all proposals combined.

LC: Are there more questions? (no). Dan what are the next steps?
DG: I can make a PR into the spec repo and proposal repos to adopt the new organization. The first step is to reorganize the spec repo and get the scripts setup, then reach out to the proposal champions to integrate up there.

LC: You can put that list of work into the issue and we can distribute that work out.

LC: Ralph has joined, do you want to talk about experimental stuff at all or next time?

RS: I need more time before I present that.

LC: Next thing on the agenda, we need to talk about releases. Someone is asking us to make citation easier using a tool called zenodo. For that to work we need to cut (GitHub) releases. Should we do this and when should we do them? It seems like we should do them when we do a snapshot. Does anyone have opinions on this?

JB: Question about zenodo: what does that tool do?

LC: It (??) DOI’s. I don’t know exactly why a DOI is important for a bibliography but its recommended over a URL when possible by the (APA?). The tool archives the data associated with the DOI, I believe.

LC: Then we’ll start cutting releases with snapshots. We can do one release now to capture the current snapshot. I’ll work with the wasm cg chair to get zenodo configured for the repo.

LC: Any other topics? (None)
