![WASI logo](/WASI.png)

## Agenda for the October 24 video call of WASI Subgroup

- **Where**: zoom.us
- **When**: October 24, 16:00-17:00 UTC
- **Location**: *link on calendar invite*
- **Contact**:
    - Name: Dan Gohman
    - Email: sunfish@mozilla.com

### Registration

None required if you've attended before. Email Dan Gohman to sign up if it's
your first time. The meeting is open to CG members only.

## Logistics

The meeting will be on a zoom.us video conference.
Installation is required, see the calendar invite.

## Agenda items

1. Opening, welcome and roll call
    1. Opening of the meeting
    1. Introduction of attendees
1. Find volunteers for note taking (acting chair to volunteer)
1. Adoption of the agenda
1. Proposals and discussions
    1. WASI and OCap
         1. https://github.com/WebAssembly/WASI/issues/109#issuecomment-541191297
         1. https://github.com/WebAssembly/WASI/pull/69
    1. "Handle" terminology
         1. https://github.com/WebAssembly/WASI/issues/62
         1. https://github.com/WebAssembly/WASI/pull/117
    1. Quick ping on reordering `clockid_t` values
         1. https://github.com/WebAssembly/WASI/pull/112/files
    1. Modularization update
         1. https://github.com/WebAssembly/WASI/pull/98
         1. https://github.com/WebAssembly/WASI/issues/2
    1. Some good first issues
         1. Make __wasi_linkcount_t 64-bit
             1. https://github.com/WebAssembly/WASI/issues/70
         1. Incorrect size returned by __wasi_environ_sizes_get
             1. https://github.com/WebAssembly/WASI/issues/27
         1. Make clocks/random into capabilities
             1. https://github.com/WebAssembly/WASI/issues/118
             1. Should random continue to be `random_get`, or should it become
                `fd_read` from a special stream?

1. Closure

## Meeting Notes

Attendees:

Dan Gohman
Mark Miller
Mark McCaskey
Pat Hickey
Barbara Nichols
Andrew Brown
Peter Huene
Artur Jamro
Till Schneidereit
Luke Wagner
Yury Delendik
Alon Zakai
Alex Crichton
Aaron Turner
Jacob Gravelle
Wvo
Sam Clegg

Meeting notes:

Dan: First discussion is WASI and OCAP. We have Mark Miller here. First off, what does OCAP mean and why is it interesting, and second what do we want to do. Mark can you please talk about what fine grained OCAP means.

Mark: We have to distinguish two forms of fine grain. What is the unit of computation being protected, and what is the nature of a permission that can be separately reified (turned into something that can be passed around). Wasm has a coarse-grained unit of protected computation - a wasm module instance. It has a flat address space (two: memory for data, and functions, are separate). All toolchains are currently built around the assumption that all Wasm modules that are linked together share a memory and function table. I’ll introduce the term “compartment” for all Wasm instances that share those address spaces. Inside that compartment, all computations inside are vulnerable to all other computations inside. We’ll eventually address that better with the GC proposal but thats a way out and we wont address it further in this conversation.
The other issue is what is the unit of passable permission. Thats permission to access outside resources and also for units of computation to effect each other. We’ll assume that there are a set of separate compartments that are units of protection - their only initial relationship is through imported and exported functions. As far as the Wasm mechanism is concerned, import functions between compartments are a perfect OCAP protection mechanism. (details this by example)
Currently the only things that Wasm can pass over function interfaces are numbers (ints and floats). As a result the permissions communicated between compartments are only communicated statically - you can't pass them dynamically once compartments are linked. So you can convey permission at whatever fine-grain you want by having many different exported functions. You can use procedural abstraction to attenuate permissions, e.g. you can use a function to provide an abstraction of a read-write file as an append-only file.

Dan: I want to temporarily ignore address spaces and tables: in a world where we have references, does it make sense to talk about compartments still?

Mark: Current Wasm architecture plus references still has flat address spaces - our current toolchains push us into it, there will still be multiple module instances linked together sharing address spaces.

Dan: I’m trying to hypothetically see if we take address spaces out of the situation and have wasm gc everywhere, are compartments still relevant?

Mark: In that hypothetical the Wasm module can use the memory and table space as empty, and Wasm becomes a fine-grained object capability machine.

Dan: The question that came up on github is that we currently are trying to do much finer grained permissions than the function level.

Mark: Yes in the hypothetical GC situation you have capabilities that are fine grained at the level of the objects in your programming language

Dan: How do we bridge the gap between the situation we have now, with these compartments and the failures of granularity associated with that, and where we want to be with GC with finer grained permissions.

Till: What about the host?  (I didn’t follow this close enough for good note taking)

Mark: There are OCAP languages and operating systems, and research on running OCAP languages on a OCAP operating system with a bridge between the language’s idea of capabilities and the operating system - when you’re writing in the language its as if the operating system’s view of capabilities are just ordinary programming language capabilities.

Mark: If you design that all interfaces between compartments are designed around reference types, the inter-compartment protocols that are natural to future GC based compartments.

Mark: Even with reference types, the notion of a virtualizable capability is the natural way to express capabilities in the 

In the Wasm GC machine there’s support for both virtualizable and abstract datatype capabilities, theres no penalty for virtualizable capabilities and its quite natural. In the current world the only way cross-compartment is abstract datatype capabilities. That’s going to be an impedance mismatch.

Dan: I’d like to steer this back towards what do we do with WASI right now for languages that don't have GC or reference types. Its going to be a long term problem because we’re going to have C/C++ forever. How can we deal with an integer based approach that can approximate reference types in a useful way, at the penalty of being coarser grained?

Mark: Let’s take very basic C++ as the representative (worst) case. There’s two approaches: one is the approach the Cheri team (University of Cambridge) has taken, they’ve added reference types to existing RISC machine architectures as additional instructions and registers and used that to put protection boundaries inside existing C/C++ code. They built a compiler and LLVM fork that can run in two modes: one mode every C++ pointer is turned into a Cheri capability, at which point you’re treating the Cheri hardware like we’d eventaully do Wasm GC.

Dan: In Cheri pointers are still bit patterns right?

Mark: Sort of, in the other compilation mode: in that mode the pointers are still bit patterns that are readable, but the capability gives you a range of addressable memory (which is potentially very fine grained) that is valid to dereference. This is expensive and not really what we’re doing with Wasm GC.

(at this point i lost the ability to follow and take good notes)

Dan: Any solution that involves users annotating their source code is going to get a lot of resistance from our users. Any solution where capabilities are held on by a side table and theres bit patterns in the wasm, is better for C compatibility but not the best for actually doing OCAP. Cheri is cool but it doesn't magically solve our problems here yet.

Mark: A completely different way to approach this issue: Let’s say all your inter-compartment capability interfaces are defined in an IDL, and then we can generate (like capnp) bindings to particular non-capability-based ABIs, so only the code generated from the IDL directly handles the reference types and does the context switch between compartments. All of the C code just uses the C ABI bindings generated by the IDL. Those ABI  bindings use integers that require the capabilities be looked up from tables

Till: A lot of this is actively in the works as the interface types proposal. A lot of these concerns are actively being addressed by how WASI and interface types are developing. The biggest thing is that moving capabilities from being expressed as integers to references, and all compartment interfaces are in terms of reference. Inside a compartment you can do whatever you like.

Dan: We have an IDL now where we’re moving to talk about APIs in terms of references. At the WASI level we should design in references using OCAP.

Jacob: In the interface types polyfill we have a way to automate the side-table translation so you don’t have to even generate glue code, its just done in javascript (the host) for you. You can add an interface instruction to convert an index into a ref. This lets us use C without annotations beyond the toolchain knowing about interface types.

Dan: Next topic: there's a virtualization doc that is coming along, and a paper
http://www.cs.cmu.edu/~aldrich/papers/ecoop17modules.pdf
(summarizes part of paper in way I couldnt follow for notes)

Dan: Mark’s idea of virtualizatbility is an object with vtables inside them.
(more discussion of the paper)

Mark: I’ll have to read the paper to understand this fully.

http://www.cs.cmu.edu/~aldrich/papers/ecoop17modules.pdf

Mark: Just followed the link, I know this paper. The language in the paper is fine-grained OCAP, individual objects are vtable-like. In that language, there’s still an issue of how you start the world off - a static configuration with good safety properties so you can move forward with dynamic properties. This paper is about the initial permissions with least-authority linkage between the modules. It is in the context of a dynamic system with full fine-grained virtualizability. I don’t see exactly how that addresses our Wasm representation problem, we still cant use references as fine-grained virtualizable capabilities.

Dan: I think we should table and continue this discussion at a different time. I’d like to go to the rest of the agenda for the remaining 15 mins.

Dan: What do we call handles, or descriptors? PR 117, or the last comments on issue 62 on file descriptors vs handles. POSIX has called things file descriptors when they're not really files. I want to talk about OCAP capabilities as handles.

Mark: Historically, descriptors and capabilities are aligned, and the numbers you are familiar with as file descriptors are often just called indices, so clists are the list of capabilities and clist indices are the file descriptor ints you know.

Dan: We settled more or less on Handle as an identifier that refers to a capability. When we say handles we’re just saying the OCAP sense. Does that make sense?

Mark: Yes!

Dan: Let’s call that a decision then.

Dan: Witx files are up in the repos, you can make a PR into the ephemeral phase and we can then promote that to unstable when a decent number are landed and move on to implementing it.


Dan: Moving on to the modularization update: look at PR 98 for the basic change. This wont be the end of the story for modularization, but its a logical first step.

Sam: Does this change the import field name strings?

Dan: Yes, right now “wasi\_unstable” is the module name everything imports from. 

Sam: Yes I see that there are N different modules. 

Dan: Does it make sense to limit witx to one module per file? Wat only allows one module per file.

Pat: We have to figure out how to deal with type names being global, we’ll need some sort of namespacing and import mechanism.

Dan: Ok, we’ll figure that out and move forward.

Dan: I put some basic issues in the agenda that are hopefully straightforward to implement. I’d like to encourage more people to step in and make PRs on the witx files and get involved.

Dan: for example on the issue about using capabilities for randomness, we can propose solutions with PRs that change the witx.
