![WASI logo](/WASI.png)

## Agenda for the October 15 in-person meeting of the WASI Subgroup

- **Where**: 10355 N De Anza Blvd, Cupertino, CA 95014, USA
- **When**: October 15, 1:00pm PDT
- **Contact**:
    - Name: Dan Gohman
    - Email: sunfish@mozilla.com

### Registration

This meeting is open to WebAssembly CG members only. To register, please
visit the CG participants page:

https://www.w3.org/community/webassembly/participants

Also, the host for this in-person meeting has requested we provide a list
of attendees, so please email Dan Gohman if you plan on attending.

## Agenda items

The topic for this meeting is low-level WebAssembly APIs for
HTTP (servers and clients).

## Meeting Notes

Attendees:

Dan Gohman
Syrus Akbary
John Plevyak
Pitor Sikora
Alon Zakai
Mark Nottingham
Leif Hedstrom
Jorge Lopez Silva
Pat Hickey
Johnnie Birch
Roberto Peon

Meeting Notes:

Presentation: [Proxy-WASM: a “standard” WebAssembly interface for the data plane, Piotr Sikora, John Plevyak](https://docs.google.com/presentation/d/1QMGEuVD9p5iNbzxzgT4p2PXpxg1MjfSbpbJdw6g6Q_Y/edit?usp=sharing)
Resources:
[WebAssembly in Envoy](https://docs.google.com/document/d/1HLV35OZP0A_a8dVjDo4kwTsovDkaycS83ZLKFpG9W8Q/edit)

<Presentation>Described the envoy use case and then reviewed an API (logs, network, http, etc)

Dan: Is there a main function?
Piotr: No, there is no main. The module functions are the entry points

Dan: How is `__post_instantiate` used?
Piotr: It’s an initialization function which is called at Vm startup, which may live across multiple requests.

Dan: Does `proxy_set_effective_context` imply persistent state?
Piotr: That’s an ABI design question, it could work that way or by passing in the context to each call.

Roberto: Is there an api for caching
Piotr: Not at the moment. Not supported by envoy.
Roberto: What about streaming? What if the data you’re receiving is not in order?
Pat: We have a different proposal that addresses this.
Piotr: We don’t have an answer for this yet.

Syrus: Have you thought about using this proxy api on the client-side (browser, [via extensions](https://developer.chrome.com/extensions/webRequest)) as well?
Piotr: Our use case is not focused on that

Roberto: Are you thinking about having a Session abstraction in addition to Connection?
John: We don’t have it yet, but we may add it in the future

Jorge: Version management?
<discussion> limitations of current toolchains mean that the abi version is encoded as numbers in a function symbol name. But this can change as tools and standardization progress.
Pat: optional imports may alleviate some of the versioning problems too


Presentation: [“What HTTP Needs from WebAssembly”](https://github.com/WebAssembly/WASI/blob/main/meetings/2019/What%20HTTP%20Needs%20from%20WebAssembly.pdf), Mark Nottingham

Roberto: What about multiple headers with one name?
Mark: [paraphrase] we probably need to talk about that

Dan: Does this include DNS?
Mark: Yes, the API accepts names, and they are translated implicitly

Discussion of optional imports, which will be important as different use cases will need different parts of these APIs.
Spec: https://github.com/WebAssembly/WASI/blob/main/design/optional-imports.md

(general presentation of the people in the meeting)

Dan: Could you use this for general-purpose HTTP programming?
Mark: Yes, there are some features which are proxy-specific, but this could be used for clients and servers


Presentation: [WASI HTTP proposal](https://github.com/pchickey/wasi_http_strawman), Pat Hickey

John: This concept of futures doesn’t allow you to chain futures, right?
Pat: Yes, this is a difference from JS futures

Pat: This is a low-level API; most customers would be using higher-level libraries on top of this

John: This API allows you to decide what you want to poll for

Pat: The `future_close` function allows you to release resources

Roberto: How much would this API change if you had threads?
Pat: Our goal is mostly to have threads in the background, so that users don’t need to worry about them. But some users may want more threads in the future. We don’t have all the answers here yet.

Alon: The `request_new` function takes a string url; how does this relate to `path_open` which doesn’t support absolute paths?
Dan: That’s a good point; one possibility is to change this API to make URL access more capability-oriented
John: That enables nested sandboxing
Alon: This model entails some overhead. If every WASI API uses OCAP, it could add up

Action items:
Dan to post a skeleton Reactor design document
Dan to finish WASI modularization API
Pat to make a Futures proposal
John, Piotr, Mark. Pat to flesh out their API proposals offline and figure out next steps
