![WASI logo](/WASI.png)

## Agenda for the March 12 video call of WASI Subgroup

- **Where**: zoom.us
- **When**: March 12, 17:00-18:00 UTC
- **Location**: *link on calendar invite*
- **Contact**:
    - Name: Dan Gohman
    - Email: sunfish@mozilla.com

### Registration

None required if you've attended before. Email Dan Gohman to sign up if it's
your first time. The meeting is open to CG members only.

## Logistics

The meeting will be on a zoom.us video conference.
Installation is required, see the calendar invite.

## Agenda items

1. Opening, welcome and roll call
    1. Please help add your name to the meeting notes.
    1. Please help take notes.
    1. Thanks!
1. Proposals and discussions
    1. Crypto API now has its own repository:
        - https://github.com/WebAssembly/WASI-crypto
        - Let's talk about process and expectations.
    1. Merging send/recv into write/read:
        - https://github.com/WebAssembly/WASI/pull/240
        - This is a complex proposal, but the intention is to simplify
          the I/O story as we contemplate new kinds of streams and messages.

## Meeting Notes

Attendees:

Dan Gohman
Jan Falkin
Mike Trinkala
Lee Campbell
Andrew Brown
Ralph Squillace
Johnnie Birch
Benjamin Brittain
Mark McCaskey

Meeting notes:

Crypto API now has its own repository:
https://github.com/WebAssembly/WASI-crypto
Let's talk about process and expectations.

Merging send/recv into write/read:
https://github.com/WebAssembly/WASI/pull/240
This is a complex proposal, but the intention is to simplify the I/O story as we contemplate new kinds of streams and messages.
It’s difficult to comment because it’s a big and fairly abstract PR
Prototype implementation would help people see how this works out in practice
Impromptu questions:
Is it ok to have ambient authorities for debugging facilities such as logging?
BB, Lee: Yes, handles are good
Making it ambient is a decrease in potential power of the system

Impromptu agenda item:

DG: Is it ok if we have ambient authorities producing handles if the handles themselves can’t be used to do any I/O?
Sealed capabilities are a useful concept.
Lee: Avoid ambient authorities.
BB: Capabilities aren’t just security, they also allow compositional design patterns.
Lee: eg. logging. Where does the log output go? If you make it a handle, now you can send different handles that represent different sinks.
Logging for debugging vs logging for production, perhaps are not so different use cases.
Lee: A really powerful feature would be to have move-only semantics for handles, so you can send an instance a handle and it can be sure it’s the only instance with access to it.
DG: Reference types proposal doesn’t have move-only semantics, but it’s something to think about
Lee: Reference-counting can lead to awkward edge cases where references are kept live, or have aliases, in surprising ways. 
In Fuchsia, fd’s are 64-bit numbers and not reused.
WebAssembly/interface-types
BB: Move semantics changes how I’d design WASI APIs
Eg. capabilities for memory regions. What does it look like to transfer a handle for one of these to another instance?
Lee: Let’s have a discussion on rights, what rights look like, do we have a handle hierarchy?
WASI doesn’t predefine __unix__.
RS: GIve people a new engine, and it’s an easier step for people to take to port to. Guide them to doing the thing they want to do. Think of this as a new target. Don’t roll in old metaphors.
Lee: If something doesn’t build, then you know what you have to fix. If it builds but doesn’t work, now you have to debug it.
