![WASI logo](/WASI.png)

## Agenda for the January 16 video call of WASI Subgroup

- **Where**: zoom.us
- **When**: January 16, 17:00-18:00 UTC
- **Location**: *link on calendar invite*
- **Contact**:
    - Name: Dan Gohman
    - Email: sunfish@mozilla.com

### Registration

None required if you've attended before. Email Dan Gohman to sign up if it's
your first time. The meeting is open to CG members only.

## Logistics

The meeting will be on a zoom.us video conference.
Installation is required, see the calendar invite.

## Agenda items

1. Opening, welcome and roll call
    1. Please help add your name to the meeting notes.
    1. Please help take notes.
    1. Thanks!
1. Proposals and discussions
    1. WASI design principles PR:
        1. https://github.com/WebAssembly/WASI/pull/192
    1. What should `poll` for no events do?
        1. https://github.com/WebAssembly/WASI/pull/193

## Meeting Notes

Attendees:

Dan Gohman
Jan Falkin
Johnnie Birch
Sam Clegg
Wouter van Oortmerssen
Mingqiu Sun
Andrew Brown
Alex Crichton
Peter Huene
Stefan Junker
Aaron Turner
Radu Matei
Brian Hardock
Ralph Squillace

Meeting notes:

##Pull 192: https://github.com/WebAssembly/WASI/pull/192
(...)
Note SJ: not sure about a conclusion on this one

## Link-time virtualization: https://github.com/WebAssembly/WASI/pull/69

DG: A way to override imports with alternative implementations of the same API

Sbc: How about using the term “interposition” vs “virtualization”?
(...)
Sbc: I’m okay with “virtualization” as long as we know we don’t mean dynamic dispatch
DG: let’s discuss dynamic dispatch. 
Sbc:  I like the idea of keeping system interfaces simple and not bring in object orientation
DG: okay, can revisit this later. It’s also tricky cause it depends on features which aren’t done yet, namely interface types and (...)
Sbc: embedder decides linking, so they could have interposition or not, so the module isn’t in the position to dictate that
DG: How linking is being done today is not final

Existing virtualization doc: https://github.com/WebAssembly/WASI/pull/69

Close this PR for now, citing the fact that the spec mechanisms we need to do this aren’t well defined yet, so we’ll focus on the simple thing for now.

## POSIX compatibility
DG: people are surprised that WASI does not align with POSIX. We see justified reasons for this, but it means that applications will have to port to WASI and can’t just recompile for a different target. For compatibility we can have an emulation layer, but for more performance usage to the native syscalls will be beneficial.
Sbc: agree that we need a compatibility layer for easier transition to WASI
DG: once we have a better solution for accessing files, a lot of concerns will go away


## What should poll for no events do? https://github.com/WebAssembly/WASI/pull/193
DG: As WASM doesn’t have signal handlers and might never have, does it make sense to poll indefinitely with no subscribers?
PH: Personally I think it should return `EINVAL` see (https://github.com/WebAssembly/WASI/pull/193#issuecomment-572737431)
AB: what happens to existing programs if we change this?
PH: if we start returning EINVAL from this, probably no one’s checking for it
DG: we could expose the change through a link failure with helpful documentation references. We could also put the feature back in once we have signals

## Framebuffer API https://github.com/WebAssembly/WASI/issues/174
AT: 
Sbc: Is this using an mmap’ed file?
DG: I don’t know the API, but could we mmap the file into the runtime
Sbc: it probably needs an extra copy for copying between WASI and host memory
AT: Is this a good idea or do we need WebGL, and only that?
DG: we don’t have to wait for use cases which require WebGL, and we can implement the simple thing (framebuffer) now
AT: are there documents on how to get started with new syscalls?
DG: A C header file would be enough to get started.
AT: Cool, so I’ll get started on that
DG: are we going to have an audio API too?
AT: probably
DG: we’ll have to be careful about synchronizing the data flow
Sbc: Will consumers call these functions directly as opposed to using a libc wrapper
DG/Sbc: (...) probably?
DG: It’ll be great to have this so other API functions can follow this trail, like bulk copy, clearing the screen. So we can figure out questions like if we should pull those APIs in the WASI SDK, etc.

## Presence on the upcoming in-person meeting?
Sbc to file an issue.




PE: Will be presenting on an embedder api for wasi at the cg meeting.
Sbc: maybe we should open an issue to collect items and see if it justifies an in-person meeting

## Status on networking syscalls
DG: fastly and DG had an in-person meeting to discuss HTTP proxy API. Lots of pressure on network API due to asynchronous requirements, which depends on mechanisms which we don’t have (standardized) yet, e.g. coroutines, expressing synchronicity in interface types, etc.
PH: where’s this work tracked?
DG: there aren’t specific issues 
SBC: Isn’t libevent which is synchronous the defacto standard?
DG: async depends on which level in the stack you’re looking at. Something which looks async to the application using callbacks, might be using a poll loop a layer below.
DG: we could have a single event loop for various events which is great for API builders, but not for application builders which might want their own event loop
SJ: what next steps are required to progress here?
DG: figuring out async, and then we need a proposal. We want to avoid a system which has either all networking or no networking. Ideally we’d like to have handles. Please reach out to me so we can discuss ideas. 
