![WASI logo](/WASI.png)

## Agenda for the June 27 video call of WASI Subgroup

- **Where**: zoom.us
- **When**: June 27, 16:00-17:00 UTC
- **Location**: *link on calendar invite*
- **Contact**:
    - Name: Dan Gohman
    - Email: sunfish@mozilla.com

### Registration

None required if you've attended before. Email Dan Gohman to sign up if it's
your first time. The meeting is open to CG members only.

## Logistics

The meeting will be on a zoom.us video conference.
Installation is required, see the calendar invite.

## Agenda items

1. Opening, welcome and roll call
    1. Opening of the meeting
    1. Introduction of attendees
1. Find volunteers for note taking (acting chair to volunteer)
1. Adoption of the agenda
1. Proposals and discussions
    1. Review of action items from prior meeting.
        - Import names
            - https://github.com/WebAssembly/design/issues/1286
        - Weak imports
            - https://github.com/WebAssembly/WASI/pull/47
    1. Meeting Schedule
        - It was pointed out that having the WASI meetings the same week
          as the CG meetings is inconvenient for some. Should we change
          the schedule?
    1. IDL
        - Cap'n Proto: - https://github.com/WebAssembly/WASI/pull/58
        - What action items can we take here?
    1. Blockchain call extension
        - https://github.com/WebAssembly/WASI/issues/56
        - Meta-discussion: How should we approach new API proposals?

1. Closure

## Agenda items for future meetings

*None*

### Schedule constraints

*None*

## Meeting Notes

2019-06-27 WebAssembly CG WASI Subgroup Video Meeting Notes

Agenda: https://github.com/WebAssembly/WASI/blob/main/meetings/2019/WASI-06-27.md

Attendees:

Dan Gohman
Luke Imhoff
Sergey Rubanov
Paul Dworzanski
Pat Hickey
Alex Crichton
Martin Becze
Till Schneidereit
Lin Clark
Mark Miller
Mark McCaskey
Sam Clegg
Nick Hynes
Jakub Konka
Jlbirch
vwo

Meeting notes:

DG: Second agenda:
Luke Imhoff seconded. (Till seconds for posterity)

DG: Import names Proposal: presenter is not here, lets move on to the Weak imports proposal

SC: We talked about the weak imports proposal at the Wasm CG meeting about whether to represent weakness in the function name versus a custom section.

DG: … align with the (missed it) proposal

SC: I can update the proposal to go back to being a custom section. The function is imported as normal but whether or not it is allowed to be missing at runtime is specified in a custom section

DG: This allows us to skip all the questions about name mangling, polluting the import/export space

SC: One issue is that the embedders will have programmatic access to the module versus parsing the bytes, e.g. through the javascript api.

DG: It makes sense for there to be a custom section javascript api that can do this for you.

SC: I’ll update the PR to go back to custom sections

DG: What is the point where we can establish a baseline for modularity and move on to breaking up the stuff currently known as wasi core into modules?

LI: Will the JS embedding have a weak imports attribute on imports? What about support in all the browsers?

DG: If someone doesnt support the custom section then they just have to resolve all of the weak imports, and if they cant provide all imports then instantiation will fail.

LI: Can toolchains ship js that detect that instantiation failed, and use a different binary?

SC: The point of weak imports is that only a single binary is needed

DG: In web use cases browsers might not support the weak imports natively but you’ll be shipping a JS polyfill for those to implement WASI anyway. You either support WASI or you don’t. Supporting WASI includes support for weak imports.

LI: Will there be a document that explains the layering of these various features required to support WASI?

DG: Sam’s document is a start on that. We need to do more to clarify on the layering. Sam, Can you add more to the document to show how it fits into the bigger picture?

SC: Yes it makes sense to make all of that part of the core wasi spec. The things we’re talking about being in the core so far are the import system, modularity, naming conventions, application lifecycle

DG: This will be easier to do once we have more of the import stuff in place. I’m proposing we defer more explanation until we have the import system figured out.

LI: There was back-and-forth about different patterns of WASI modules, reactor and command, in the spec - was there more discussion about that?

DG: That is ongoing. This can be an adjunct to snowman bindings - the reactor and command model can be adjunct to the spec about bindings, since bindings are specifically about how to use a module, and so is a description of the lifecycle

SC: ES6 Modules need the same sort of lifecycle support as WASI does

DG: We’ll also want a custom section to say the entry points of applications and so on.

LI: Where do I subscribe to updates on this, how far is it in chromium or mozilla?

DG: I don’t know about that, https://github.com/WebAssembly/esm-integration tracks the ESM integration status but nobody here knows about the status of it in browsers right now.

TS: The status of Node is they have almost complete implementation. I’m not aware of browser implementations that have made significant progress.

LC: I’m not aware of any advances of implementations, apple had an early implementation but i’m not aware of updates given the changes to the proposal.

DG: Let’s move on to the next item, left out of the agenda: last meeting Mark Miller discussed a vision document that laid out the use of Object Capabilities (OCap) in wasi.

MM: Yes thanks for the reminder. It had dropped out of mind.

DG: That’s ok we’re all busy here.

MM: At the wasm blockchain meeting we discussed styles of ocap systems that do not support virtualizability, versus method style, where the behavior of a call on an object is up to the implementer. (...) and I looked at using a Capnp-like IDL to describe APIs in an object style. (unintelligible) looked at an IDL that could fetch type bindings and an adaptor from old style bindings to new style, to realize the virtualizaiblity of ocap systems.

TS: Mark you’re dropping out a third of the time unfortunately.

MM: Ok I will put my concerns in the document that I need to write.

DG: Mark and I discussed this and it is a big idea that I think needs to be explained in detail.

DG: At the CG we had feedback on the meeting schedule. Right now we’re on the same week as the Wasm meeting, an arbitrary choice. Would people prefer to change it to the opposite week?

LI:  I’m the one that brought it up, it would be nice to have more open time around lunch on these weeks (in my time zone).

DG: As a poll, does anyone object to moving it to the opposite week from the CG meeting?

(no objections)
DG: Then we’ll skip next week, the next meeting will be scheduled for 3 weeks out so that it alternates with the WASM CG call.

DG: We also have an agenda item for talking about the CapnP issue: https://github.com/WebAssembly/WASI/issues/56, Martin can you fill us in:

MB: I prototyped what it would look like to describe the interface in terms of capnp, we got feedback on that which was helpful. The impression I got from everyone is that customizing the Capnp idl is appropriate, we’ll write a custom IDL that is influenced by capnp and I’m working on that right now.

MM: You saw my attempt at a BNF of the relevant subset of Capnp?

MB: Yes I want to rework my pull request with that in mind. We want to pull out the versioning integers on all of the methods, and adding (missed it). It would be nice if we could express things like the ability to import globals, memories, tables, as well as functions. It would be nice if it looked like the rest of the webassembly stack, so I was looking at using s-expressions.

MB: We need to figure out how this maps to the snowman bindings, I talked to Dan who explained more about how that worked. I see the point of the snowman bindings now. I think it would be interesting to reuse the ideas from the GC proposal re defining structs and so on, and having a binding section from the snowman proposal to describe how they are bound.

TS: Martin, the original motivation of snowman bindings (prev webidl bindings prev host bindings) was to make DOM apis fast, interacting with them directly from wasm rather than going through javascript. While by now we have lots of reasons to want these bindings, that is still a requirement of the snowman bindings. How are you making sure that your work stays compatible with that, or are you focusing on the syntax layer and it won’t interfere with that?

MB: I’m not considering how we’re binding to JavaScript, just interested in how to express the structures that these interfaces pass around - e.g. how do we express the structure of a directory entry and how do we read and write to it? That is partially covered by what snowman bindings does so we should reuse that. Maybe snowman bindings does cover everything we need. But the syntax should look like everything else

TS: It seems like the syntax is purely in the tooling space

MB: We have the syntax from GC to express struct and arrays, I think that's all we need to express things like directory entries. I want to reuse that syntax, and use that as a path for compatibility with GC implementations in the future.

DG: Take the set of bindings and types we have in wasi core as the base language, and the IDL describes what those are and gives us the clean descriptions we want

MB: The tooling is a big hurdle in webidl right now, we want to make it easier for people to read and write these descriptions.

TS: That makes sense. Luke wagner has had a lot of conversations around this, including with all the webidl people. They are all open to improving things. Its clear that snowman bindings won't be webidl bindings, but they need to be semantically compatible enough to describe the dom bindings pieces. If we end up having different surface syntaxes, thats fine because its mostly about tooling, but I also think we should have something that is not gratuitously different. One constraint is that browser implementers will have to be able to consume webidl in order to make the dom bindings work (already used throughout browsers). Keep in mind that there are constraints that don’t allow us to completely evolve this tooling in ways that break the DOM bindings use case.

DG: If you can go with whats in snowman bindings now, and build on top of that, then we can achieve the parity we’re going for without defining new semantics. The key vocabulary is the types and the operations. Webidl has a lot of things in it that are distracting, even if you reduce it down to just the parts we need there are still syntax things like how “unsigned long” is the way to write u64, so i’m sympathetic to changing that syntax.

MM: When I did my minimal BNF subset of capnp, I did take a look at the WASI ABI document and all of the capnp names for the types like u64 seemed obviously much better. I did not include wasm-specific concepts like memory, I agree that's an important thing to figure out how to accommodate.

DG: Actions going forward: martin will take the capnp PR and make a version with the new syntax.

MB: I will get that done in the next week and get more feedback.

MM: There is a long term issue of how we support, at the wasm level, how we manage method dispatch. There are several ways we could map that to the current wasm, none of which are very natural. This problem goes away with GC but I continue to assume that is a long ways out. The smallest step from where we are to a natural method dispatch binding would be to add sum types, where sum types are passed on the stack rather than by separate allocation of reference counts, and the message - the thing that one invokes - would be a sum type where the constructor is the method name, and the contents of that branch of the sum type are the arguments, and the pattern match at the receiver would be the method dispatch. Given that we’re doing an IDL we dont have to decide up-front what the method dispatch representation is, but it would be good to have a candidate in mind.

DG: My understanding is that not everyone has seen material on dynamic dispatch, so it would be a good thing to start with a paper on how dynamic dispatch works and what use cases it has
MB: Once we have proper function references doesn’t that cover? Are sum types part of GC?

MM: The repr of sum types I’m thinking of would not require dynamic allocation so we could implement it before GC. It would still be a significant additional piece of engineering. The problem with just using function pointers is that method dispatch with what we have now, the options are 1. You pass by copy a record of function references, and the client of the object invokes a method by looking up the method name in that record, the problem with that is the size of the reference to the object is passed by copy and proportional in size to the num of methods on the type.
2. You pass by reference a … it loses the static type information given our current system, so you’d have to cast after the method lookup to the right signature.
None of these are natural for intra-module communication given the current wasm representation of things.

DG: One thing we talked about was virtualizing an API and how we might do that. Dynamic dispatch approach allows you to virtualize in more ways. There are a lot of new ideas here and we need to motivate what problems we’re solving here and spread the ideas more broadly.

DG: Lets move on to the next issue, the blockchain call extension. The main thing I want to address is the meta-discussion of whether this digs inside wasi. Nick are you here?

DG: I encourage folks in the blockchain space to submit proposals, it fits well with our modularization story. It is a bit ahead of the curve as we’re still figuring out how imports and weak import names and so on.

DG: Implementers of wasi that don’t have anything to do with blockchain wouldn’t have to implement these interfaces but its good to have the standard for how they work all in one system.

NH: (missed it)

MB: It would be nice if we had an interface for persistently storing function references and loading them. One idea is that we could extend the number of file types to one that could load a function reference and put it into an anyfunc table. This would require the call-ref operation to call the method, from in the function refs proposal.

MB: The file types we have now are a file, directory, block device, character device. Are there problems with extending those filetypes?

DG: Part of that question we might not quite be ready to answer yet. Does anyone have problems with extending the idea of a stream beyond posix-style streams?

LI: If plan 9 could do it we can to
DG: We can talk more about stream APIs but I think extending streams to be useful for blockchains is a good idea, as long as it does not incur a cost to implementors that dont need blockchain.

LI: We say blockchain but is any o f that not descended from etherium?

NH: I want to generalize this in way for systems beyond etherium descendents

MB: I worked on ewasm and dfinity, I also want this interface to work beyond etherium family as well.

MM: The plan at agoric for using blockchain and wasm is not etherium-like, it is consistent with ocap approach, and the issue of dynamic dispatch becomes important to us.

DG: For some context there's discussion in the CG about webvms and the requirement for 2 implementations that are webvms. In wasi we’ve decided that the committee would accept non webvm implementations and make decisions on what exact vms would be accepted as we go

LI: Whatever system we come up with should handle more than just one currency, it should handle multiple currencies on a single chain

MB: We should standardize that we aren’t dealing with one particular currency. This would probably be a good document to put together.

DG: We should record our thoughts on what requirements we have for blockchains. Martin can you write up … we want diversity, we want to make sure we’re standardizing on something that more than one implementation will use.

NH and MB will collaborate on that document.

DG: Any further items?

Meeting adjourned
