![WASI logo](/WASI.png)

## Agenda for the May 16 video call of WASI Subgroup

- **Where**: zoom.us
- **When**: May 16, 16:00-17:00 UTC
- **Location**: *link on calendar invite*
- **Contact**:
    - Name: Dan Gohman
    - Email: sunfish@mozilla.com

### Registration

None required if you've attended before. Email Dan Gohman to sign up if it's
your first time. The meeting is open to CG members only.

## Logistics

The meeting will be on a zoom.us video conference.
Installation is required, see the calendar invite.

## Agenda items

1. Opening, welcome and roll call
    1. Opening of the meeting
    1. Introduction of attendees
1. Find volunteers for note taking (acting chair to volunteer)
1. Adoption of the agenda
1. Proposals and discussions
    1. Meeting schedule
        * We have one report of a scheduling conflict on Thursdays. How do
          Wednesdays at this same time work?
    1. Review of action items from prior meeting.
    1. Updated [High-Level Goals] proposal for WASI
    1. The MVP
        * Module system issues: https://github.com/WebAssembly/WASI/labels/module_system
        * Versioning vs. feature detection
        * [Semver]?
            - What about wildcards or other requirement specifications?
            - If we do semver, we'll be looking for a volunteer to look into
              the specifics and make a concrete proposal.
        * Weak imports?
            - See https://github.com/WebAssembly/WASI/issues/36 for some ideas.
        * Namespacing schemes
            - "wasi:name:semver" (https://github.com/WebAssembly/WASI/issues/2#issuecomment-482630978)
            - Other suggestions?
    1. Standardization phases
        * https://github.com/WebAssembly/WASI/issues/38

1. Closure

[High-Level Goals]: https://github.com/WebAssembly/WASI/blob/high-level-goals/docs/HighLevelGoals.md
[Semver]: https://semver.org/

## Agenda items for future meetings

*None*

### Schedule constraints

*None*

## Meeting Notes

2019-05-02 WebAssembly CG WASI Subgroup Video Meeting Notes

Agenda: https://github.com/WebAssembly/WASI/blob/main/meetings/2019/WASI-05-16.md

Attendees:

Dan Gohman
Thomas Lively
Luke Imhoff
Sergey Rubanov
Wouter van Oortmerssen
Jacob Gravelle
Mingqiu Sun
Yury Delendik
Ryan Levick
Paul Dworzanski
Alex Crichton
Derek Schuff
Mark S. Miller
Sam Clegg
Nick Fitzgerald
Arun Purushan
Mark McCaskey
Dan Gebhardt
Paul Schoenfelder
Till Schneidereit
Johnie L Birch Jr
Luke Wagner
Pat Hickey
Tyler McMullen


Meeting notes:


Meeting schedule
We have one report of a scheduling conflict on Thursdays. How do Wednesdays at this same time work?
Conflicts on Wednesday for Google WASM team
Later on Thursday would work, but it doesn’t work for Europe
FINAL: Sticking with same date/time

 Review of action items from prior meeting.
    
Dan: Module system issues are up.
Dan: Also took an action to look for an in-person meeting time, not complete yet.
Ryan: I went through and summarized issues in the WASI issue tracker. We can continue to evolve the organization scheme. I looked at moving issues over from the wasmtime tracker and we may need to dedup them first.
Dan: We will follow up offline.


Updated [High-Level Goals] proposal for WASI

Dan: Derek had a question about the meaning of namespacing. My sense is we don’t need to be terribly specific here.
Derek: I may have added some more words in there, but I think we’re all on the same page.
Dan: We can merge the High Level Goals as is, and folks can do PRs to elaborate on it. Do we have consensus to land it?
Luke Imhoff: It says “through a capability based API”, does that imply a focus on security?
Dan: I think capability-based implies that
Mark Miller: Capabilities enable a design for security, they don’t imply security
Dan: Does the current wording capture enough of the intent to build a secure interface?
Luke I: We want to emphasize that capabilities can be subdivided, are unforgable, so that we’re not no better than posix.
Mark: We could write down the important capability design principles elsewhere.
Luke I: Is there an article that summarizes your current thinking on this?
Mark: There’s related topics on object capabilities
Till: We didn’t go with object capabilities because not all languages are capable of expressing those.
Mark: Object capabilities are not specific to programming language object level capabilities. There are operating systems that use object capabilities
Luke I: Lets merge what we have and make a PR later that describes what we mean by object capability?
Mark: I will find some writing on object capability principles to link to
Till: So we can land what we have now?
Luke I, Mark M assent
Dan: I will take an action item to land that.

The MVP
Module system issues: https://github.com/WebAssembly/WASI/labels/module_system
Versioning vs. feature detection
[Semver]?
What about wildcards or other requirement specifications?
If we do semver, we'll be looking for a volunteer to look into the specifics and make a concrete proposal.

Weak imports?
See https://github.com/WebAssembly/WASI/issues/36 for some ideas.
Namespacing schemes
"wasi:name:semver" (https://github.com/WebAssembly/WASI/issues/2#issuecomment-482630978)
Other suggestions?


Dan: Looks like things got renamed and moved around a bit, lets skip forward to semver.

Dan: Semver is the default choice, but the question is how you apply it, what sort of wildcards and specifiers you use when encoding dependencies.

Dan: What im looking for is someone to make a proposal about how the various details of semver wildcards work, and bring it to the meeting next week. I know there are many options but I don’t know which one to pick.

Mark: To clarify is this for all of WASI or for the various modules?

Dan: The goal is to specify the foundation of how modules will interact, this is an important part of that. We will probably have opportunities to revise it

Luke I: How flexible will we be with regards to revisions to the interfaces? E.g. fixing bugs means breaking binary compat

Dan: We have to assume that we can impose our own rules for how strict we are about bugfixes. We’ll just have to make judgement calls as we go

Sam K: Will the version be in the import name themselves?

Dan: That is an obvious place to put it. <someone> has a proposal but they’re out sick today

Till: This would make it hard to make minor updates, because then you’d have to change names every time a version changes.

Dan: Resolution of imports happens in the VM. So we can program how that works

Till: If resolution happens in a client they may not have a complete index of all modules available.

Dan: The current proposal (wasi:package:semver) assumes all modules are packaged & available together. If we want to have something more elaborate - a url, a hash string, those are possibilities.

Luke I: Its desirable for the resolver to have some way to find other versions, so that you can specify dependencies as “greater than this patch but not incompatible”

Till: If resolution has to happen using a map, you can put the version numbers in the map, rather than in identifiers

Dan: Resolution is necessarily not the host, some earlier packaging step can occur that takes advantage of semantic information

Luke I: is it always a precise version in the import name? (some examples given)

Dan: We should make a convention about whether the VM is going to download modules for you, or the VM is going to just resolve links as they exist

Tlively: It sounds like we have differences in opinion about who should be doing resolution of version numbers to packages, and where packages come from. Before agreeing on specifics we should figure out the user story and what goals we’re trying to achieve with the versioning scheme

Dan: Sounds good, does anyone want to propose a story or a set of scenarios to look at?

Pat: I can provide a story for our use case, but I want to get input from others as well.

Dan: Moving on to the next item, Weak Imports. In Issue 36, there is discussion about not wanting a system that forces an additional indirection e.g. through a GC Ref.

Sam Klegg: In your example of importing v2 features and then an optional v3 feature

Dan: V2 to V3 is a major semver bump, If it was a minor bump maybe that would be OK. What about e.g. most features from 2.2, and this new feature from 2.3 would be nice to use if its available, but if not I’ll fall back.

Luke I: If you’re importing from different versions are those versions separate instances

Dan: That’s up to the VM and the module API

Sam K: We don’t want to have two versions of the same module instantiated to satisfy a dep.

Sam K: Would you put a weak dependency on an entire module, or just on an import?
Dan: I think we want the ability to do both. E.g. If we have a filesystem, then we will use it to do stuff, and also if the filesystem supports this individual extra feature, i’ll use it. In both cases we want to be able to fall back.

Sam K: Seems like lots of overlap with the semver proposal

Dan: Semver just gives you the minimum requirement to be functional, weak imports are for things that may or may not be present

Luke I: Semver protects you from the ABA problem, where the function name and signature stays the same but the functionality totally changed.

Dan: You could have a weak import, and the weak import itself could have a semver tag on it, or other semver relation operators. I’m looking for a general sense from the group whether this general idea is what we want to pursue. Out of all the proposals it has the advantage of not implying indirection.

Luke I: Does this mean that wasm is going to have to support weak imports so that there is no indirection cost?

Dan: It would be a requirement of the engine to implement imports so that there is no indirection cost.

Sam K: We’re explicitly trying to not push a new concept into the core spec

Dan: Is there consensus about not trying to push new concepts into the core spec?

Jacob: are we going to expect this in web embeddings?

Luke Wagner: You could polyfill this on the web using javascript stubs

Luke Wagner: Rather than mangling the string name maybe you could use a regex to carve out what part of an import name is the name, and the rest is the wasi-specific specifiers like version, weak

(Some discussion on details of those ideas)

Dan: Is the basic idea of weak import, somehow mangled into import names, 

Jacob: We could use custom sections for this.

(Some discussion of how you might use a custom section)

Luke I: If the custom section gets stripped thats a bad sign about your toolchain in the first place. I prefer this to string mangling, it doesn’t eat names that now become reserved

Dan: There are escape characters and ways we can make name mangling work.

Tlively, Luke I, Sam C: all in support of using custom sections as opposed to name mangling

Luke I: Import maps are separate from the module itself, or you could put a default map in at build time, but the idea is that it makes polyfill possible

Sam C: There would be a lot of repetition of these annotation in the import names, custom section could solve that

Dan: Pushback that custom sections are for non-semantic information

Paul S: Would this mean we now require those custom sections?

Sam C: its extra information that says the module would like to have the following version, the following weak sym. The engine could throw it away and it would still possibly work

Jacob: This is roughly what we’re trying to solve in the webidl proposal as well, we’re specifying a custom section.

(Some discussion)

Sam C: You’re describing the environment in which you’d like to be run, and the engine may be able to provide the right implementation there

Luke I: tooling is easier with custom sections, you won’t have to change imports and byte offsets and so on.

Luke I: The import map proposal says to just specify the bare name to import, and 

Dan: Does someone want to champion writing down how using a custom section for this will work?

Sam C: I will write something down for the next meeting [action item]

Standardization phases
https://github.com/WebAssembly/WASI/issues/38

Dan: Derek wrote up a proposal of phases (linked above). In the core wasm they use the concept of web engines implementing a proposal as part of gating moving it forward. We have more non-web embeddings to consider here.

Luke I: We should document why we made certain arguments about compatibility as we go along.

Dan: Rationale is important, should that process live in the phase document?

(?): Maybe when we move to stage 3 with a proposal it should come with an agreement about what stage 4 may be.

Derek: My desire was just to come up with something that mirrors the CG without specific opinions on exactly how. What do we want the role of the subgroup vs the CG to be? Should the CG just rubber-stamp things?

Derek: We haven’t talked about the goals for the WASI api spec, should it go through the W3C WG process?

Dan: That is what I want us to do.

Till: wrt where it lives exactly, it could be a sibling to the JS API.

Dan: this is a non-web use case and W3C is a web org but I don’t think its a problem in practice.

Derek: This is something between the core spec and the JS API. WASI will build on top of core. Maybe some of the WASI loading semantics will be baked into the JS spec, or maybe not.

Dan: How the individual module specs get packaged into a spec document is something we can resolve in the future.

Till: Volunteers to champion the phases document
