![WASI logo](/WASI.png)

## Agenda for the May 2 video call of WASI Subgroup

- **Where**: zoom.us
- **When**: May 2, 16:00-17:00 UTC
- **Location**: *link on calendar invite*
- **Contact**:
    - Name: Dan Gohman
    - Email: sunfish@mozilla.com

### Registration

None required if you've attended before. Email Dan Gohman to sign up if it's
your first time. The meeting is open to CG members only.

## Logistics

The meeting will be on a zoom.us video conference.
Installation is required, see the calendar invite.

## Agenda items

1. Opening, welcome and roll call
    1. Opening of the meeting
    1. Introduction of attendees
1. Find volunteers for note taking (acting chair to volunteer)
1. Adoption of the agenda
1. Proposals and discussions
    1. Review of action items from prior meeting.
    1. Overall introduction, overview of meetings and processes
    1. Proposed [High-Level Goals] for WASI
    1. Form a plan for organizing open ideas and suggestions.
        * Currently we have issues and ideas spread across a few different places:
           - https://github.com/WebAssembly/WASI/issues
           - https://github.com/CraneStation/wasmtime/issues?q=is%3Aissue+is%3Aopen+label%3AWASI
           - https://github.com/CraneStation/wasmtime/blob/master/docs/WASI-some-possible-changes.md
           - https://github.com/CraneStation/wasmtime/blob/master/docs/WASI-possible-future-features.md
        * In future meetings we can go through the issues and decide which
          milestones to assign them to.
    1. Subgroup activities
        * The MVP
           - Discuss what needs to be done for the MVP
           - Build documentation, testsuite, tools
        * WASI libc, in https://github.com/WebAssembly/reference-sysroot/pull/11
        * Discussion of future features
    1. How often should we have video-call meetings? When should we schedule them?
    1. Should we have an official adjunct meeting at the WebAssembly CG
       in-person meeting [in June](https://github.com/WebAssembly/meetings/blob/master/2019/CG-06.md)?
1. Closure

[High-Level Goals]: https://github.com/WebAssembly/WASI/blob/high-level-goals/docs/HighLevelGoals.md

## Agenda items for future meetings

*None*

### Schedule constraints

*None*

## Meeting Notes

2019-05-02 WebAssembly CG WASI Subgroup Video Meeting Notes

Agenda: https://github.com/WebAssembly/WASI/blob/main/meetings/2019/WASI-05-02.md

Attendees:

Dan Gohman
Paul Dworzanski
Christopher Serr
Birch Jr, Johnnie L
Eric Sink
Pat Hickey
Mingqiu Sun
Sam Clegg
Till Schneidereit
Luke Wagner
Ryan Levick
Yoshua Wuyts
Mark McCaskey
Alex Beregszaszi
Tyler McMullen
Derek Schuff
Mark Miller
Paul Schoenfelder
Dan Gebhardt
Martin Becze
Nathaniel McCallum
Lin Clark
Alex Crichton
Gus Caplan

Meeting notes:

Adoption of Agenda: Tyler McMullen seconds

Action items: None, first meeting!

Dan: Process is consensus-driven. We want to avoid coming down to a
vote. When there is disagreement we want to find out the reasons why. We
have a straw poll mechanism to help find that out.

Categorizing our issues:

Dan: Issues were initially filed on wasmtime issue tracker, now
they’re on the WASI issue tracker. Need a volunteer to summarize,
organize those issues, bring them onto one tracker.

Ryan Levick volunteers.

Dan: First thing to go through is go through and label everything. MVP

Dan: Which issues belong to the MVP, which belong to other milestones.

High level goals:

Dan: with the Wasm standard the first thing we wrote was a high
level goals document. Are there any objections or questions?
https://github.com/WebAssembly/WASI/blob/high-level-goals/docs/HighLevel
Goals.md

Dan: People have asked about threads and many other features that are
not mentioned in these goals. We’ll eventually come up with a design
roadmap to cover those sort of features.

Nathaniel McCallum: can you define MVP?

Dan: Smallest thing we can do and still have some value. Specifically:
IO streams, filesystems, randomness, clocks. There’s lots of work to
do on the details of these, test suites etc, but we have people using
this so far and finding it useful.

Dan: MVP does not include creating sockets. There are a lot of open
questions about how these will work wrt security, portability.

Nathaniel: if we’re defining MVP as what we first want to ship, this
may be too large. If its the goal for the body overall it may be too
small.

Dan: We could take out randomness and clocks if you think they don’t
belong.

Nathaniel: We don’t intend to ship filesystems at all in the first
version of our product. That set of APIs is pretty large. We should trim
down this list to do something small but do it very well.

Till: There are people here that consider filesystem support a bare
minimum to be useful. This may be a false dilemma, if we modularize the
spec to make filesystems and network io as different modules, we can
move them out of the subgroup and into the main body for standardization
when they are ready. If you need to focus on network rather than
filesystems, you can push on that module separately. Neither need to
block the other.

Nathaniel: My question isn’t what we seek to do as a working group
versus what MVP means in this context. This seems to be somewhere in
the middle. I’m ok with leaving it as it is but clarification is
useful Dan: As we get into details if we find filesystem is taking a
lot of time we can move it out of the MVP.

Nathaniel: I’m OK with this.

Paul S: what is WASI Core?

Dan: WASI Core is a set of modules, it should have a module for
filesystems, io streams, arguments and environment variables.

Dan: The idea of WASI Core isn’t an exhaustive list of primitives but
just enough to be useful for a subset of us.

Luke: Filesystems are have a lot of ways they can be sliced, io streams
to stdout are enough for some applications, so we don’t have to
provide every single part of the API at once.

Till: We need to specify how modules hang together on a fundamental
level, and then we may not even need MVP beyond that, since modules can
be moved to standardization whenever they are ready.

Derek Schuff: People here have different ideas of what they consider
minimum viable, so we should come up with the way modules work and
complete two of them that interoperate, and work out the fundamental
modularity problems like dependencies, then the details of what comes in
particular modules can come later.

Till: We should do enough that the module system is proven out, we
don’t need to define exactly what that means ahead of time

Nathaniel: This is a good definition of MVP. There doesn’t appear to
be anything about versioning in the high level goals

Dan: That is an oversight, versioning is an important thing to solve.
Versioning and/or feature detection.

Luke: There may be room for a new MVP document describing this ideas
about modules, at least two of them work.

Derek: We need to iterate on what we consider MVP right now, but that
doesn't mean we have the wrong high level goal.

Dan: Maybe the goals should say: we want to have an MVP and then defer
what that means. MVP is just for a moment in time, it doesn’t stick
around forever.

Dan: I’ll take action item to take out the details about what modules
from that document, and also to add versioning and feature detection.

Nathaniel: assent

Till: Is the scope of this subgroup exhausted once MVP is reached or is
it an ongoing activity to feed modules into the CG?

Nathaniel: in IETF we specify exactly what we want to accomplish as a
group and then disband it afterwards. I don't know if that is what W3C
asks us to do.

Dan: The parent WASM CG doesn’t have a concept of when we’re done.

Luke: The WG does have a charter that they renew periodically, but that
is a formalism. We should be like the CG and have a work stream and not
worry about the higher level details.

Derek: In C++ they have standing subgroups with an area of focus, WASI
is like that. We can argue in the CG about how we spec the WASI outputs

Till: So the goal is to move things out of this subgroup into the CG and
WG in the shape of individual proposals, where the initial proposal is
the core spec of how modules work with at least two modules, and then
individual modules go through their own proposal process after that.

Luke: Reaching the WG is a long way from where we are now. We are going
to radically change some of these APIs once certain WASM features become
widespread. We will iterate a lot

Dan: There are different levels of standards here. Does that make sense?
There is kind of an unbounded surface area for APIs and the vision for
this subgroup will be to standardize those. I can imagine a structure
with champions following the CG. Right now there is the core features
and in the future we could setup new champions for new features.

Dan: Moving on to other activities. We should define what the MVP is.
The very minimal thing we could do is something with just two modules.
Anything more than what WASI core is probably too much. How do we decide
what is in there right now that we should take out?

Nathaniel: Lets pick a small task and accomplish it

Derek: Do we want to define any kind of process for phases of APIs? We
want to get proposals out there and give people time to try it out. I
get the sense that we will have even more stakeholders than in the CG.
How do we track changes over time and put our stamp of approval on them.


Dan: I suggest we start by copying the CG process. Someone should
volunteer to start by copying the CG document and make proposed changes
to it? There are 5 phases. I think this is roughly what we want to
follow It might be too web focuses.

Derek: I don’t mind taking that on.

Eric: The thing about MVP is different perspectives about what is M and
what is V. How far apart are we? Its helpful to envision the data points
of the M and V axis. Somebody said “no need to filesystems” someone
else said they are important for a lot of uses. Just one example. We
maybe want list other cases and cather before we judge and refine.

Til: Do we even need to decide on the set of functionality. If we do
our job right on the fundamental module system then a lot of the actual
development of the individual modules could happen in parallel. They
don’t need to block each other. Obviously the overarching goal is
consistency between modules but independent development might work.

Nathanial: The module are really our MVP. Module + versions / feature
detection. But I do think polling would be good to decide what to focus
on first.

Dan: Not so much who wants what, but who is willing to shut up do the
work and get things done. My main worry with filesystem is that once we
start looking at portability seriously that we might want to move it out
of the MVP. But if people really want to move it forward it would still
make sense. Different to minimal, more about the timeline.

Nathaniel: Why don’t we define MVP and modules plus versioning. And
move to a time-based process where we release say, every 6 months.

Eric: We are challenging the definition of Viable. I love the idea of
modules and feature definition but I don't think that is viable. We can
define modules with defining any of them.

Nathanial: We did mention having 2 modules and minimum. And having
reserved names as part of them module system. Even if we don’t ship
a whole bunch of modules it doesn’t mean that there aren’t modules
yet.

Derek: Users are going to want the ability to define their own APIs so
even a module system is viable even without any “approved” modules.

Til: Is viable the right terminology?

Luke: Perhaps MVP is not right.

Dan: Should we start by defining a module system and some minimal
modules, or should we try to have a few more features. Poll?

Jlbirch: What can’t we have both?

Dan: Initially I proposed a bunch of modules such as filesystems etc

Nathaniel: The idea of an MVP at least in standards language might carry
a bunch of meaning that we might not want. I quite like the idea that
the only thing you need to be standards compliant is the idea of modules
and namespaces

Eric: me too.

Luke: Related thing? Do we want the MVP terminology?

Nathaniel: Should we call it minimal implementation requirements?

Til: Is some ways is a minimum viable spec.

Dan: Should we start with the very first stage which includes modules,
namespacing.

Alex B: I’m coming from the blockchain space, looking at how to
integrate wasm into ethereum. At least the core WASI filesystem spec
doesn’t make sense for us right now. I was confused that the MVP
discussion presented no use cases. I hope to get out of wasi a process
for how to define modules (and versioning) and we will be able to define
modules relevant to the blockchain space.

Poll Results: SA: 16 A: 3 N: 2 DA: 0 SDA: 0

Dan: Should we have an official adjunct meeting at the CG meeting in
spain?

Pat: The few of us who have spoken previously discussed meeting the day
before the meeting starts.

Paul: I’m planning on being there and would like to be there.

Dan: I will take an action item to look into scheduling.

Dan: we should probably try to do it during the CG meeting.

Should we do an offline poll to schedule this?

Dan: Someone open an issue for scheduling in the wasi repo.

Final discussions:

Pat: Is this group going to be responsible for maintaining the sysroot
and the SDK that comes with it? I can still keep on doing the work if
needed.

Dan: My original idea was that it was going to be moved to this group.
It's becoming more clear it should live outside, but open to opinions
here.

Nathaniel: It might be handy for us to gather a list of people who are
involved in the standards process what they are working on and how they
are using it. The other thing that might be useful for MVP would be to
decide what does it take to standardize a module?

Dan: I don’t think this has been done before. I would appreciate
proposals.

Derek: The phase proposal is going to touch on that . If we have some
phase criteria for the advancement of modules.

Nathaniel: Tests should be part of this process.

Luke: WG specs and distinct requirement.

Dan: Thanks everybody. We are open to ideas about how to do versioning
and feature detection.
