![WASI logo](/WASI.png)

## Agenda for the March 26 video call of WASI Subgroup

- **Where**: zoom.us
- **When**: March 26, 16:00-17:00 UTC
- **Location**: *link on calendar invite*
- **Contact**:
    - Name: Dan Gohman
    - Email: sunfish@mozilla.com

### Registration

None required if you've attended before. Email Dan Gohman to sign up if it's
your first time. The meeting is open to CG members only.

## Logistics

The meeting will be on a zoom.us video conference.
Installation is required, see the calendar invite.

## Agenda items

1. Opening, welcome and roll call
    1. Please help add your name to the meeting notes.
    1. Please help take notes.
    1. Thanks!
1. Proposals and discussions
    1. WASI currently uses a POSIX-like `errno` enum, but that seems
       not well suited for less POSIX-like APIs:
       https://github.com/WebAssembly/WASI-crypto/pull/13#issuecomment-599324384
       Many systems have evolved to having a single error enum shared
       across the whole system. Is it ok if we don't aim for that?
    1. POSIX tries hard not to let syscalls cause segfaults, returning
       things like `EFAULT` instead. There may be some value in this for
       POSIX compatibility, but how valuable is this otherwise? Should
       other WASI APIs be allowed to trap?
    1. Evolving idea: wasi-sdk API for extra emulation:
       1. `-D_WASILIBC_EMULATED_MMAN`
       1. `-D_WASILIBC_EMULATED_PAUSE`
       1. `-D_WASILIBC_EMULATED_RAISE`
       1. ...
       1. `-D_WASILIBC_EMULATED_ALL` ?
       and
       1. `-lwasi-emulated-mman`
       1. `-lwasi-emulated-pause`
       1. `-lwasi-emulated-raise`
       1. ...
       1. `-lwasi-emulated-all` ?
    1. [Proxy-Wasm](https://github.com/proxy-wasm) update.

## Meeting Notes

Attendees:

Dan Gohman
Jan Falkin
Lee Campbell
Till Schneidereit
Alex Crichton
Andrew Brown
Mingqiu Sun
Olaf Tomalka
Piotr Sikora
Pat Hickey
Peter Huene
Sam Clegg
Johnnie Birch
Wouter van Oortmerssen
Luke Wagner
Aaron Turner
Benjamin Brittain
Taylor Thomas
John Plevyak
Ralph Squillace
Brian Hardock

Meeting notes:

WASI currently uses a POSIX-like errno enum, but that seems not well suited for less POSIX-like APIs: https://github.com/WebAssembly/WASI-crypto/pull/13#issuecomment-599324384 Many systems have evolved to having a single error enum shared across the whole system. Is it ok if we don't aim for that?
Lee: we need standardized ways to propagate errors throughout the system which is generic over all kinds of APIs
PH: Design a way to structure and compose errors. We should do this with types, rather than integer ranges.
SBC: Capability system is one of the unifying parts of WASI, there will be errors common to all capability operations.
PCH: Compositional errors might be something like a sum type of different errors.
Bwb: Strings as errors have lots of awkward problems, including internationalization.
PCH: Being able to use any type gives us the power to describe errors.
Jplev: Have a generic error codes, with ways to map to them.
Sbc: Don’t redeclare the same errors as POSIX
Pat: APIs define the things they need now, and we’ll work on factoring things out and composition as we go forward.
Lee: POSIX is a C API and we can map WASI errors to POSIX errno as needed.


POSIX tries hard not to let syscalls cause segfaults, returning things like EFAULT instead. There may be some value in this for POSIX compatibility, but how valuable is this otherwise? Should other WASI APIs be allowed to trap?
Sbc: one of our objectives is to be able to implement WASI as wasm modules.
Lee, sbc: We seem to need core language support for catching traps to really figure this out.
Evolving idea: wasi-sdk API for extra emulation:
```
-D_WASILIBC_EMULATED_MMAN
-D_WASILIBC_EMULATED_PAUSE
-D_WASILIBC_EMULATED_RAISE
...
-D_WASILIBC_EMULATED_ALL ? and
-lwasi-emulated-mman
-lwasi-emulated-pause
-lwasi-emulated-raise
...
-lwasi-emulated-all ?
```
Lee: Do we need the `-l`s? We can just put everythgin in libc.a and it’ll only get linked in 
Proxy-Wasm update.
This is an update from the previous presentation in October.
Consolidated many callbacks from the previous presentationtation.

Sbc: Have you looked at creating a witx description?
Piotr: Not yet; we’re still iterating on the API.
Sbc: Do proxy implementations need to implement all callbacks, or are some of the m optional?
Piotr: Some are optional. If you’re only implementing HTTP, you only need to impelment HTTP callbacks.
PH: This proposal is great, and also very big, can we factor out pieces that can be used in other contexts?
 
Adapting the core CG Phases for WASI.
https://github.com/WebAssembly/proposals/
“Two or more Web VMs”

Reference interpreter, formal semantics

Fitting the existing phases into the process
