![WASI logo](/WASI.png)

## Agenda for the November 07 video call of WASI Subgroup

- **Where**: zoom.us
- **When**: November 07, 17:00-18:00 UTC
- **Location**: *link on calendar invite*
- **Contact**:
    - Name: Dan Gohman
    - Email: sunfish@mozilla.com

### Registration

None required if you've attended before. Email Dan Gohman to sign up if it's
your first time. The meeting is open to CG members only.

## Logistics

The meeting will be on a zoom.us video conference.
Installation is required, see the calendar invite.

## Agenda items

1. Opening, welcome and roll call
    1. Opening of the meeting
    1. Introduction of attendees
1. Find volunteers for note taking (acting chair to volunteer)
1. Adoption of the agenda
1. Proposals and discussions
    1. Publishing a first snapshot
         1. https://github.com/WebAssembly/WASI/issues/138
    1. Issues for discussion
         1. Make clocks/random into capabilities
             1. https://github.com/WebAssembly/WASI/issues/118
             1. Should random continue to be `random_get`, or should it become
                `fd_read` from a special stream?
         1. Increase the timestamp range
             1. https://github.com/WebAssembly/WASI/issues/33 
         1. Remove remaining "process" dependencies
             1. https://github.com/WebAssembly/WASI/issues/26
             1. Remove `CLOCK_PROCESS_CPUTIME_ID`?

1. Closure

## Meeting Notes

Attendees:

Dan Gohman
Stefan Junker
Mark Bestavros
Nathaniel McCallum
Johnnie Birch Jr.
Mark S. Miller
Alon Zakai
Yury Delendik
Alex Chrichton
Luke Wagner
Mark McCaskey
Pat Hickey
Sam Clegg
Peter Huene
Alon Zakai


Meeting notes:

## Making a first snapshot - call it “snapshot”

AI: Dan to add a note to the phases document about how we make syntax changes to old versions while keeping the ABI compatible

## Make clocks/random into capabilities 

DG: Currently clocks/random are ambient authority in WASI. Can keep compatibility with (C-style) programs out there which expect this to be the case? If so, how?
LW: Would this step mean that the program will always ask for clocks/random with the future option of allowing to not ask for it?
DG: What troubles me about that is that we’d still have to think about the mechanism for asking for it

(discussion about clocks/random as stream vs. datagram)

## Increase the timestamp range 

DG: this would be a good opportunity for someone who just wants to do this for the sake of learning how to change the API. happy to talk about this offline

## Remove remaining "process" dependencies 

(discussion about exception handling in JS when interacting with WASM)

DG: proc_raise is going away, proc_exit should ideally be implemented in terms of unwinding, though there are some details to figure out there. Can we remove the process-oriented clock identifiers?

(Discussion, concluding in general approval)

(Discussion of whether a “gas” clock could be defined; see also

https://medium.com/@erights/a-pack-of-watchdogs-is-cheaper-than-gas-7e118edfb4cc

Answer: there are some potentially subtle issues — programs could use this to determine how much time other parts of the program take, which may be undesirable. In any case, WASI itself would have no trouble defining new kinds of clocks in the future.)

NM: Our implementation is able to implement the process-oriented clocks efficiently. If we remove them today, could they be reintroduced in the future if we want them?
DG: Yes, once we have modularity established and optional imports, it would be straightforward to add new features like this.

NM: Is working on a proposal for a high level crypto API
MM: A request would be to not have the keys and algorithms in the same address space.. 
