;; Tests for i16x8 arithmetic operations on major boundary values and all special values.


(module
  (func (export "i16x8.extmul_low_i8x16_s") (param v128 v128) (result v128) (i16x8.extmul_low_i8x16_s (local.get 0) (local.get 1)))
  (func (export "i16x8.extmul_high_i8x16_s") (param v128 v128) (result v128) (i16x8.extmul_high_i8x16_s (local.get 0) (local.get 1)))
  (func (export "i16x8.extmul_low_i8x16_u") (param v128 v128) (result v128) (i16x8.extmul_low_i8x16_u (local.get 0) (local.get 1)))
  (func (export "i16x8.extmul_high_i8x16_u") (param v128 v128) (result v128) (i16x8.extmul_high_i8x16_u (local.get 0) (local.get 1)))
)


;; i16x8.extmul_low_i8x16_s
(assert_return (invoke "i16x8.extmul_low_i8x16_s" (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)
                                                  (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
                                                  (v128.const i16x8 0 0 0 0 0 0 0 0))
(assert_return (invoke "i16x8.extmul_low_i8x16_s" (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)
                                                  (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1))
                                                  (v128.const i16x8 0 0 0 0 0 0 0 0))
(assert_return (invoke "i16x8.extmul_low_i8x16_s" (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1)
                                                  (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1))
                                                  (v128.const i16x8 1 1 1 1 1 1 1 1))
(assert_return (invoke "i16x8.extmul_low_i8x16_s" (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)
                                                  (v128.const i8x16 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1))
                                                  (v128.const i16x8 0 0 0 0 0 0 0 0))
(assert_return (invoke "i16x8.extmul_low_i8x16_s" (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1)
                                                  (v128.const i8x16 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1))
                                                  (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1))
(assert_return (invoke "i16x8.extmul_low_i8x16_s" (v128.const i8x16 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1)
                                                  (v128.const i8x16 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1))
                                                  (v128.const i16x8 1 1 1 1 1 1 1 1))
(assert_return (invoke "i16x8.extmul_low_i8x16_s" (v128.const i8x16 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63)
                                                  (v128.const i8x16 64 64 64 64 64 64 64 64 64 64 64 64 64 64 64 64))
                                                  (v128.const i16x8 4032 4032 4032 4032 4032 4032 4032 4032))
(assert_return (invoke "i16x8.extmul_low_i8x16_s" (v128.const i8x16 64 64 64 64 64 64 64 64 64 64 64 64 64 64 64 64)
                                                  (v128.const i8x16 64 64 64 64 64 64 64 64 64 64 64 64 64 64 64 64))
                                                  (v128.const i16x8 4096 4096 4096 4096 4096 4096 4096 4096))
(assert_return (invoke "i16x8.extmul_low_i8x16_s" (v128.const i8x16 -63 -63 -63 -63 -63 -63 -63 -63 -63 -63 -63 -63 -63 -63 -63 -63)
                                                  (v128.const i8x16 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64))
                                                  (v128.const i16x8 4032 4032 4032 4032 4032 4032 4032 4032))
(assert_return (invoke "i16x8.extmul_low_i8x16_s" (v128.const i8x16 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64)
                                                  (v128.const i8x16 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64))
                                                  (v128.const i16x8 4096 4096 4096 4096 4096 4096 4096 4096))
(assert_return (invoke "i16x8.extmul_low_i8x16_s" (v128.const i8x16 -65 -65 -65 -65 -65 -65 -65 -65 -65 -65 -65 -65 -65 -65 -65 -65)
                                                  (v128.const i8x16 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64))
                                                  (v128.const i16x8 4160 4160 4160 4160 4160 4160 4160 4160))
(assert_return (invoke "i16x8.extmul_low_i8x16_s" (v128.const i8x16 125 125 125 125 125 125 125 125 125 125 125 125 125 125 125 125)
                                                  (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1))
                                                  (v128.const i16x8 125 125 125 125 125 125 125 125))
(assert_return (invoke "i16x8.extmul_low_i8x16_s" (v128.const i8x16 126 126 126 126 126 126 126 126 126 126 126 126 126 126 126 126)
                                                  (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1))
                                                  (v128.const i16x8 126 126 126 126 126 126 126 126))
(assert_return (invoke "i16x8.extmul_low_i8x16_s" (v128.const i8x16 128 128 128 128 128 128 128 128 128 128 128 128 128 128 128 128)
                                                  (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1))
                                                  (v128.const i16x8 -128 -128 -128 -128 -128 -128 -128 -128))
(assert_return (invoke "i16x8.extmul_low_i8x16_s" (v128.const i8x16 -126 -126 -126 -126 -126 -126 -126 -126 -126 -126 -126 -126 -126 -126 -126 -126)
                                                  (v128.const i8x16 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1))
                                                  (v128.const i16x8 126 126 126 126 126 126 126 126))
(assert_return (invoke "i16x8.extmul_low_i8x16_s" (v128.const i8x16 -127 -127 -127 -127 -127 -127 -127 -127 -127 -127 -127 -127 -127 -127 -127 -127)
                                                  (v128.const i8x16 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1))
                                                  (v128.const i16x8 127 127 127 127 127 127 127 127))
(assert_return (invoke "i16x8.extmul_low_i8x16_s" (v128.const i8x16 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128)
                                                  (v128.const i8x16 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1))
                                                  (v128.const i16x8 128 128 128 128 128 128 128 128))
(assert_return (invoke "i16x8.extmul_low_i8x16_s" (v128.const i8x16 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127)
                                                  (v128.const i8x16 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127))
                                                  (v128.const i16x8 16129 16129 16129 16129 16129 16129 16129 16129))
(assert_return (invoke "i16x8.extmul_low_i8x16_s" (v128.const i8x16 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128)
                                                  (v128.const i8x16 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128))
                                                  (v128.const i16x8 16384 16384 16384 16384 16384 16384 16384 16384))
(assert_return (invoke "i16x8.extmul_low_i8x16_s" (v128.const i8x16 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128)
                                                  (v128.const i8x16 -127 -127 -127 -127 -127 -127 -127 -127 -127 -127 -127 -127 -127 -127 -127 -127))
                                                  (v128.const i16x8 16256 16256 16256 16256 16256 16256 16256 16256))
(assert_return (invoke "i16x8.extmul_low_i8x16_s" (v128.const i8x16 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255)
                                                  (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
                                                  (v128.const i16x8 0 0 0 0 0 0 0 0))
(assert_return (invoke "i16x8.extmul_low_i8x16_s" (v128.const i8x16 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255)
                                                  (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1))
                                                  (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1))
(assert_return (invoke "i16x8.extmul_low_i8x16_s" (v128.const i8x16 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255)
                                                  (v128.const i8x16 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1))
                                                  (v128.const i16x8 1 1 1 1 1 1 1 1))
(assert_return (invoke "i16x8.extmul_low_i8x16_s" (v128.const i8x16 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255)
                                                  (v128.const i8x16 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127))
                                                  (v128.const i16x8 -127 -127 -127 -127 -127 -127 -127 -127))
(assert_return (invoke "i16x8.extmul_low_i8x16_s" (v128.const i8x16 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255)
                                                  (v128.const i8x16 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128))
                                                  (v128.const i16x8 128 128 128 128 128 128 128 128))
(assert_return (invoke "i16x8.extmul_low_i8x16_s" (v128.const i8x16 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255)
                                                  (v128.const i8x16 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255))
                                                  (v128.const i16x8 1 1 1 1 1 1 1 1))

;; i16x8.extmul_high_i8x16_s
(assert_return (invoke "i16x8.extmul_high_i8x16_s" (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)
                                                   (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
                                                   (v128.const i16x8 0 0 0 0 0 0 0 0))
(assert_return (invoke "i16x8.extmul_high_i8x16_s" (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)
                                                   (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1))
                                                   (v128.const i16x8 0 0 0 0 0 0 0 0))
(assert_return (invoke "i16x8.extmul_high_i8x16_s" (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1)
                                                   (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1))
                                                   (v128.const i16x8 1 1 1 1 1 1 1 1))
(assert_return (invoke "i16x8.extmul_high_i8x16_s" (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)
                                                   (v128.const i8x16 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1))
                                                   (v128.const i16x8 0 0 0 0 0 0 0 0))
(assert_return (invoke "i16x8.extmul_high_i8x16_s" (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1)
                                                   (v128.const i8x16 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1))
                                                   (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1))
(assert_return (invoke "i16x8.extmul_high_i8x16_s" (v128.const i8x16 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1)
                                                   (v128.const i8x16 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1))
                                                   (v128.const i16x8 1 1 1 1 1 1 1 1))
(assert_return (invoke "i16x8.extmul_high_i8x16_s" (v128.const i8x16 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63)
                                                   (v128.const i8x16 64 64 64 64 64 64 64 64 64 64 64 64 64 64 64 64))
                                                   (v128.const i16x8 4032 4032 4032 4032 4032 4032 4032 4032))
(assert_return (invoke "i16x8.extmul_high_i8x16_s" (v128.const i8x16 64 64 64 64 64 64 64 64 64 64 64 64 64 64 64 64)
                                                   (v128.const i8x16 64 64 64 64 64 64 64 64 64 64 64 64 64 64 64 64))
                                                   (v128.const i16x8 4096 4096 4096 4096 4096 4096 4096 4096))
(assert_return (invoke "i16x8.extmul_high_i8x16_s" (v128.const i8x16 -63 -63 -63 -63 -63 -63 -63 -63 -63 -63 -63 -63 -63 -63 -63 -63)
                                                   (v128.const i8x16 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64))
                                                   (v128.const i16x8 4032 4032 4032 4032 4032 4032 4032 4032))
(assert_return (invoke "i16x8.extmul_high_i8x16_s" (v128.const i8x16 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64)
                                                   (v128.const i8x16 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64))
                                                   (v128.const i16x8 4096 4096 4096 4096 4096 4096 4096 4096))
(assert_return (invoke "i16x8.extmul_high_i8x16_s" (v128.const i8x16 -65 -65 -65 -65 -65 -65 -65 -65 -65 -65 -65 -65 -65 -65 -65 -65)
                                                   (v128.const i8x16 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64))
                                                   (v128.const i16x8 4160 4160 4160 4160 4160 4160 4160 4160))
(assert_return (invoke "i16x8.extmul_high_i8x16_s" (v128.const i8x16 125 125 125 125 125 125 125 125 125 125 125 125 125 125 125 125)
                                                   (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1))
                                                   (v128.const i16x8 125 125 125 125 125 125 125 125))
(assert_return (invoke "i16x8.extmul_high_i8x16_s" (v128.const i8x16 126 126 126 126 126 126 126 126 126 126 126 126 126 126 126 126)
                                                   (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1))
                                                   (v128.const i16x8 126 126 126 126 126 126 126 126))
(assert_return (invoke "i16x8.extmul_high_i8x16_s" (v128.const i8x16 128 128 128 128 128 128 128 128 128 128 128 128 128 128 128 128)
                                                   (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1))
                                                   (v128.const i16x8 -128 -128 -128 -128 -128 -128 -128 -128))
(assert_return (invoke "i16x8.extmul_high_i8x16_s" (v128.const i8x16 -126 -126 -126 -126 -126 -126 -126 -126 -126 -126 -126 -126 -126 -126 -126 -126)
                                                   (v128.const i8x16 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1))
                                                   (v128.const i16x8 126 126 126 126 126 126 126 126))
(assert_return (invoke "i16x8.extmul_high_i8x16_s" (v128.const i8x16 -127 -127 -127 -127 -127 -127 -127 -127 -127 -127 -127 -127 -127 -127 -127 -127)
                                                   (v128.const i8x16 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1))
                                                   (v128.const i16x8 127 127 127 127 127 127 127 127))
(assert_return (invoke "i16x8.extmul_high_i8x16_s" (v128.const i8x16 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128)
                                                   (v128.const i8x16 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1))
                                                   (v128.const i16x8 128 128 128 128 128 128 128 128))
(assert_return (invoke "i16x8.extmul_high_i8x16_s" (v128.const i8x16 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127)
                                                   (v128.const i8x16 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127))
                                                   (v128.const i16x8 16129 16129 16129 16129 16129 16129 16129 16129))
(assert_return (invoke "i16x8.extmul_high_i8x16_s" (v128.const i8x16 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128)
                                                   (v128.const i8x16 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128))
                                                   (v128.const i16x8 16384 16384 16384 16384 16384 16384 16384 16384))
(assert_return (invoke "i16x8.extmul_high_i8x16_s" (v128.const i8x16 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128)
                                                   (v128.const i8x16 -127 -127 -127 -127 -127 -127 -127 -127 -127 -127 -127 -127 -127 -127 -127 -127))
                                                   (v128.const i16x8 16256 16256 16256 16256 16256 16256 16256 16256))
(assert_return (invoke "i16x8.extmul_high_i8x16_s" (v128.const i8x16 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255)
                                                   (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
                                                   (v128.const i16x8 0 0 0 0 0 0 0 0))
(assert_return (invoke "i16x8.extmul_high_i8x16_s" (v128.const i8x16 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255)
                                                   (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1))
                                                   (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1))
(assert_return (invoke "i16x8.extmul_high_i8x16_s" (v128.const i8x16 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255)
                                                   (v128.const i8x16 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1))
                                                   (v128.const i16x8 1 1 1 1 1 1 1 1))
(assert_return (invoke "i16x8.extmul_high_i8x16_s" (v128.const i8x16 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255)
                                                   (v128.const i8x16 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127))
                                                   (v128.const i16x8 -127 -127 -127 -127 -127 -127 -127 -127))
(assert_return (invoke "i16x8.extmul_high_i8x16_s" (v128.const i8x16 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255)
                                                   (v128.const i8x16 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128))
                                                   (v128.const i16x8 128 128 128 128 128 128 128 128))
(assert_return (invoke "i16x8.extmul_high_i8x16_s" (v128.const i8x16 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255)
                                                   (v128.const i8x16 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255))
                                                   (v128.const i16x8 1 1 1 1 1 1 1 1))

;; i16x8.extmul_low_i8x16_u
(assert_return (invoke "i16x8.extmul_low_i8x16_u" (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)
                                                  (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
                                                  (v128.const i16x8 0 0 0 0 0 0 0 0))
(assert_return (invoke "i16x8.extmul_low_i8x16_u" (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)
                                                  (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1))
                                                  (v128.const i16x8 0 0 0 0 0 0 0 0))
(assert_return (invoke "i16x8.extmul_low_i8x16_u" (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1)
                                                  (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1))
                                                  (v128.const i16x8 1 1 1 1 1 1 1 1))
(assert_return (invoke "i16x8.extmul_low_i8x16_u" (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)
                                                  (v128.const i8x16 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1))
                                                  (v128.const i16x8 0 0 0 0 0 0 0 0))
(assert_return (invoke "i16x8.extmul_low_i8x16_u" (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1)
                                                  (v128.const i8x16 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1))
                                                  (v128.const i16x8 255 255 255 255 255 255 255 255))
(assert_return (invoke "i16x8.extmul_low_i8x16_u" (v128.const i8x16 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1)
                                                  (v128.const i8x16 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1))
                                                  (v128.const i16x8 -511 -511 -511 -511 -511 -511 -511 -511))
(assert_return (invoke "i16x8.extmul_low_i8x16_u" (v128.const i8x16 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63)
                                                  (v128.const i8x16 64 64 64 64 64 64 64 64 64 64 64 64 64 64 64 64))
                                                  (v128.const i16x8 4032 4032 4032 4032 4032 4032 4032 4032))
(assert_return (invoke "i16x8.extmul_low_i8x16_u" (v128.const i8x16 64 64 64 64 64 64 64 64 64 64 64 64 64 64 64 64)
                                                  (v128.const i8x16 64 64 64 64 64 64 64 64 64 64 64 64 64 64 64 64))
                                                  (v128.const i16x8 4096 4096 4096 4096 4096 4096 4096 4096))
(assert_return (invoke "i16x8.extmul_low_i8x16_u" (v128.const i8x16 -63 -63 -63 -63 -63 -63 -63 -63 -63 -63 -63 -63 -63 -63 -63 -63)
                                                  (v128.const i8x16 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64))
                                                  (v128.const i16x8 -28480 -28480 -28480 -28480 -28480 -28480 -28480 -28480))
(assert_return (invoke "i16x8.extmul_low_i8x16_u" (v128.const i8x16 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64)
                                                  (v128.const i8x16 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64))
                                                  (v128.const i16x8 -28672 -28672 -28672 -28672 -28672 -28672 -28672 -28672))
(assert_return (invoke "i16x8.extmul_low_i8x16_u" (v128.const i8x16 -65 -65 -65 -65 -65 -65 -65 -65 -65 -65 -65 -65 -65 -65 -65 -65)
                                                  (v128.const i8x16 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64))
                                                  (v128.const i16x8 -28864 -28864 -28864 -28864 -28864 -28864 -28864 -28864))
(assert_return (invoke "i16x8.extmul_low_i8x16_u" (v128.const i8x16 125 125 125 125 125 125 125 125 125 125 125 125 125 125 125 125)
                                                  (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1))
                                                  (v128.const i16x8 125 125 125 125 125 125 125 125))
(assert_return (invoke "i16x8.extmul_low_i8x16_u" (v128.const i8x16 126 126 126 126 126 126 126 126 126 126 126 126 126 126 126 126)
                                                  (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1))
                                                  (v128.const i16x8 126 126 126 126 126 126 126 126))
(assert_return (invoke "i16x8.extmul_low_i8x16_u" (v128.const i8x16 128 128 128 128 128 128 128 128 128 128 128 128 128 128 128 128)
                                                  (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1))
                                                  (v128.const i16x8 128 128 128 128 128 128 128 128))
(assert_return (invoke "i16x8.extmul_low_i8x16_u" (v128.const i8x16 -126 -126 -126 -126 -126 -126 -126 -126 -126 -126 -126 -126 -126 -126 -126 -126)
                                                  (v128.const i8x16 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1))
                                                  (v128.const i16x8 -32386 -32386 -32386 -32386 -32386 -32386 -32386 -32386))
(assert_return (invoke "i16x8.extmul_low_i8x16_u" (v128.const i8x16 -127 -127 -127 -127 -127 -127 -127 -127 -127 -127 -127 -127 -127 -127 -127 -127)
                                                  (v128.const i8x16 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1))
                                                  (v128.const i16x8 -32641 -32641 -32641 -32641 -32641 -32641 -32641 -32641))
(assert_return (invoke "i16x8.extmul_low_i8x16_u" (v128.const i8x16 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128)
                                                  (v128.const i8x16 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1))
                                                  (v128.const i16x8 32640 32640 32640 32640 32640 32640 32640 32640))
(assert_return (invoke "i16x8.extmul_low_i8x16_u" (v128.const i8x16 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127)
                                                  (v128.const i8x16 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127))
                                                  (v128.const i16x8 16129 16129 16129 16129 16129 16129 16129 16129))
(assert_return (invoke "i16x8.extmul_low_i8x16_u" (v128.const i8x16 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128)
                                                  (v128.const i8x16 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128))
                                                  (v128.const i16x8 16384 16384 16384 16384 16384 16384 16384 16384))
(assert_return (invoke "i16x8.extmul_low_i8x16_u" (v128.const i8x16 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128)
                                                  (v128.const i8x16 -127 -127 -127 -127 -127 -127 -127 -127 -127 -127 -127 -127 -127 -127 -127 -127))
                                                  (v128.const i16x8 16512 16512 16512 16512 16512 16512 16512 16512))
(assert_return (invoke "i16x8.extmul_low_i8x16_u" (v128.const i8x16 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255)
                                                  (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
                                                  (v128.const i16x8 0 0 0 0 0 0 0 0))
(assert_return (invoke "i16x8.extmul_low_i8x16_u" (v128.const i8x16 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255)
                                                  (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1))
                                                  (v128.const i16x8 255 255 255 255 255 255 255 255))
(assert_return (invoke "i16x8.extmul_low_i8x16_u" (v128.const i8x16 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255)
                                                  (v128.const i8x16 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1))
                                                  (v128.const i16x8 -511 -511 -511 -511 -511 -511 -511 -511))
(assert_return (invoke "i16x8.extmul_low_i8x16_u" (v128.const i8x16 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255)
                                                  (v128.const i8x16 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127))
                                                  (v128.const i16x8 32385 32385 32385 32385 32385 32385 32385 32385))
(assert_return (invoke "i16x8.extmul_low_i8x16_u" (v128.const i8x16 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255)
                                                  (v128.const i8x16 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128))
                                                  (v128.const i16x8 32640 32640 32640 32640 32640 32640 32640 32640))
(assert_return (invoke "i16x8.extmul_low_i8x16_u" (v128.const i8x16 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255)
                                                  (v128.const i8x16 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255))
                                                  (v128.const i16x8 -511 -511 -511 -511 -511 -511 -511 -511))

;; i16x8.extmul_high_i8x16_u
(assert_return (invoke "i16x8.extmul_high_i8x16_u" (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)
                                                   (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
                                                   (v128.const i16x8 0 0 0 0 0 0 0 0))
(assert_return (invoke "i16x8.extmul_high_i8x16_u" (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)
                                                   (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1))
                                                   (v128.const i16x8 0 0 0 0 0 0 0 0))
(assert_return (invoke "i16x8.extmul_high_i8x16_u" (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1)
                                                   (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1))
                                                   (v128.const i16x8 1 1 1 1 1 1 1 1))
(assert_return (invoke "i16x8.extmul_high_i8x16_u" (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)
                                                   (v128.const i8x16 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1))
                                                   (v128.const i16x8 0 0 0 0 0 0 0 0))
(assert_return (invoke "i16x8.extmul_high_i8x16_u" (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1)
                                                   (v128.const i8x16 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1))
                                                   (v128.const i16x8 255 255 255 255 255 255 255 255))
(assert_return (invoke "i16x8.extmul_high_i8x16_u" (v128.const i8x16 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1)
                                                   (v128.const i8x16 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1))
                                                   (v128.const i16x8 -511 -511 -511 -511 -511 -511 -511 -511))
(assert_return (invoke "i16x8.extmul_high_i8x16_u" (v128.const i8x16 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63)
                                                   (v128.const i8x16 64 64 64 64 64 64 64 64 64 64 64 64 64 64 64 64))
                                                   (v128.const i16x8 4032 4032 4032 4032 4032 4032 4032 4032))
(assert_return (invoke "i16x8.extmul_high_i8x16_u" (v128.const i8x16 64 64 64 64 64 64 64 64 64 64 64 64 64 64 64 64)
                                                   (v128.const i8x16 64 64 64 64 64 64 64 64 64 64 64 64 64 64 64 64))
                                                   (v128.const i16x8 4096 4096 4096 4096 4096 4096 4096 4096))
(assert_return (invoke "i16x8.extmul_high_i8x16_u" (v128.const i8x16 -63 -63 -63 -63 -63 -63 -63 -63 -63 -63 -63 -63 -63 -63 -63 -63)
                                                   (v128.const i8x16 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64))
                                                   (v128.const i16x8 -28480 -28480 -28480 -28480 -28480 -28480 -28480 -28480))
(assert_return (invoke "i16x8.extmul_high_i8x16_u" (v128.const i8x16 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64)
                                                   (v128.const i8x16 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64))
                                                   (v128.const i16x8 -28672 -28672 -28672 -28672 -28672 -28672 -28672 -28672))
(assert_return (invoke "i16x8.extmul_high_i8x16_u" (v128.const i8x16 -65 -65 -65 -65 -65 -65 -65 -65 -65 -65 -65 -65 -65 -65 -65 -65)
                                                   (v128.const i8x16 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64))
                                                   (v128.const i16x8 -28864 -28864 -28864 -28864 -28864 -28864 -28864 -28864))
(assert_return (invoke "i16x8.extmul_high_i8x16_u" (v128.const i8x16 125 125 125 125 125 125 125 125 125 125 125 125 125 125 125 125)
                                                   (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1))
                                                   (v128.const i16x8 125 125 125 125 125 125 125 125))
(assert_return (invoke "i16x8.extmul_high_i8x16_u" (v128.const i8x16 126 126 126 126 126 126 126 126 126 126 126 126 126 126 126 126)
                                                   (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1))
                                                   (v128.const i16x8 126 126 126 126 126 126 126 126))
(assert_return (invoke "i16x8.extmul_high_i8x16_u" (v128.const i8x16 128 128 128 128 128 128 128 128 128 128 128 128 128 128 128 128)
                                                   (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1))
                                                   (v128.const i16x8 128 128 128 128 128 128 128 128))
(assert_return (invoke "i16x8.extmul_high_i8x16_u" (v128.const i8x16 -126 -126 -126 -126 -126 -126 -126 -126 -126 -126 -126 -126 -126 -126 -126 -126)
                                                   (v128.const i8x16 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1))
                                                   (v128.const i16x8 -32386 -32386 -32386 -32386 -32386 -32386 -32386 -32386))
(assert_return (invoke "i16x8.extmul_high_i8x16_u" (v128.const i8x16 -127 -127 -127 -127 -127 -127 -127 -127 -127 -127 -127 -127 -127 -127 -127 -127)
                                                   (v128.const i8x16 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1))
                                                   (v128.const i16x8 -32641 -32641 -32641 -32641 -32641 -32641 -32641 -32641))
(assert_return (invoke "i16x8.extmul_high_i8x16_u" (v128.const i8x16 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128)
                                                   (v128.const i8x16 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1))
                                                   (v128.const i16x8 32640 32640 32640 32640 32640 32640 32640 32640))
(assert_return (invoke "i16x8.extmul_high_i8x16_u" (v128.const i8x16 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127)
                                                   (v128.const i8x16 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127))
                                                   (v128.const i16x8 16129 16129 16129 16129 16129 16129 16129 16129))
(assert_return (invoke "i16x8.extmul_high_i8x16_u" (v128.const i8x16 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128)
                                                   (v128.const i8x16 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128))
                                                   (v128.const i16x8 16384 16384 16384 16384 16384 16384 16384 16384))
(assert_return (invoke "i16x8.extmul_high_i8x16_u" (v128.const i8x16 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128)
                                                   (v128.const i8x16 -127 -127 -127 -127 -127 -127 -127 -127 -127 -127 -127 -127 -127 -127 -127 -127))
                                                   (v128.const i16x8 16512 16512 16512 16512 16512 16512 16512 16512))
(assert_return (invoke "i16x8.extmul_high_i8x16_u" (v128.const i8x16 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255)
                                                   (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
                                                   (v128.const i16x8 0 0 0 0 0 0 0 0))
(assert_return (invoke "i16x8.extmul_high_i8x16_u" (v128.const i8x16 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255)
                                                   (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1))
                                                   (v128.const i16x8 255 255 255 255 255 255 255 255))
(assert_return (invoke "i16x8.extmul_high_i8x16_u" (v128.const i8x16 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255)
                                                   (v128.const i8x16 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1))
                                                   (v128.const i16x8 -511 -511 -511 -511 -511 -511 -511 -511))
(assert_return (invoke "i16x8.extmul_high_i8x16_u" (v128.const i8x16 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255)
                                                   (v128.const i8x16 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127))
                                                   (v128.const i16x8 32385 32385 32385 32385 32385 32385 32385 32385))
(assert_return (invoke "i16x8.extmul_high_i8x16_u" (v128.const i8x16 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255)
                                                   (v128.const i8x16 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128))
                                                   (v128.const i16x8 32640 32640 32640 32640 32640 32640 32640 32640))
(assert_return (invoke "i16x8.extmul_high_i8x16_u" (v128.const i8x16 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255)
                                                   (v128.const i8x16 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255))
                                                   (v128.const i16x8 -511 -511 -511 -511 -511 -511 -511 -511))

;; type check
(assert_invalid (module (func (result v128) (i16x8.extmul_low_i8x16_s (i32.const 0) (f32.const 0.0)))) "type mismatch")
(assert_invalid (module (func (result v128) (i16x8.extmul_high_i8x16_s (i32.const 0) (f32.const 0.0)))) "type mismatch")
(assert_invalid (module (func (result v128) (i16x8.extmul_low_i8x16_u (i32.const 0) (f32.const 0.0)))) "type mismatch")
(assert_invalid (module (func (result v128) (i16x8.extmul_high_i8x16_u (i32.const 0) (f32.const 0.0)))) "type mismatch")

;; Test operation with empty argument

(assert_invalid
  (module
    (func $i16x8.extmul_low_i8x16_s-1st-arg-empty (result v128)
      (i16x8.extmul_low_i8x16_s (v128.const i16x8 0 0 0 0 0 0 0 0))
    )
  )
  "type mismatch"
)
(assert_invalid
  (module
    (func $i16x8.extmul_low_i8x16_s-arg-empty (result v128)
      (i16x8.extmul_low_i8x16_s)
    )
  )
  "type mismatch"
)
(assert_invalid
  (module
    (func $i16x8.extmul_high_i8x16_s-1st-arg-empty (result v128)
      (i16x8.extmul_high_i8x16_s (v128.const i16x8 0 0 0 0 0 0 0 0))
    )
  )
  "type mismatch"
)
(assert_invalid
  (module
    (func $i16x8.extmul_high_i8x16_s-arg-empty (result v128)
      (i16x8.extmul_high_i8x16_s)
    )
  )
  "type mismatch"
)
(assert_invalid
  (module
    (func $i16x8.extmul_low_i8x16_u-1st-arg-empty (result v128)
      (i16x8.extmul_low_i8x16_u (v128.const i16x8 0 0 0 0 0 0 0 0))
    )
  )
  "type mismatch"
)
(assert_invalid
  (module
    (func $i16x8.extmul_low_i8x16_u-arg-empty (result v128)
      (i16x8.extmul_low_i8x16_u)
    )
  )
  "type mismatch"
)
(assert_invalid
  (module
    (func $i16x8.extmul_high_i8x16_u-1st-arg-empty (result v128)
      (i16x8.extmul_high_i8x16_u (v128.const i16x8 0 0 0 0 0 0 0 0))
    )
  )
  "type mismatch"
)
(assert_invalid
  (module
    (func $i16x8.extmul_high_i8x16_u-arg-empty (result v128)
      (i16x8.extmul_high_i8x16_u)
    )
  )
  "type mismatch"
)

