
;; Test all the i64x2 comparison operators on major boundary values and all special values.

(module
  (func (export "eq") (param $x v128) (param $y v128) (result v128) (i64x2.eq (local.get $x) (local.get $y)))
  (func (export "ne") (param $x v128) (param $y v128) (result v128) (i64x2.ne (local.get $x) (local.get $y)))
  (func (export "lt_s") (param $x v128) (param $y v128) (result v128) (i64x2.lt_s (local.get $x) (local.get $y)))
  (func (export "le_s") (param $x v128) (param $y v128) (result v128) (i64x2.le_s (local.get $x) (local.get $y)))
  (func (export "gt_s") (param $x v128) (param $y v128) (result v128) (i64x2.gt_s (local.get $x) (local.get $y)))
  (func (export "ge_s") (param $x v128) (param $y v128) (result v128) (i64x2.ge_s (local.get $x) (local.get $y)))
)


;; eq

;; i64x2.eq  (i64x2) (i64x2)
(assert_return (invoke "eq" (v128.const i64x2 0xFFFFFFFFFFFFFFFF 0xFFFFFFFFFFFFFFFF)
                            (v128.const i64x2 0xFFFFFFFFFFFFFFFF 0xFFFFFFFFFFFFFFFF))
                            (v128.const i64x2 -1 -1))
(assert_return (invoke "eq" (v128.const i64x2 0x0000000000000000 0x0000000000000000)
                            (v128.const i64x2 0x0000000000000000 0x0000000000000000))
                            (v128.const i64x2 -1 -1))
(assert_return (invoke "eq" (v128.const i64x2 0xF0F0F0F0F0F0F0F0 0xF0F0F0F0F0F0F0F0)
                            (v128.const i64x2 0xF0F0F0F0F0F0F0F0 0xF0F0F0F0F0F0F0F0))
                            (v128.const i64x2 -1 -1))
(assert_return (invoke "eq" (v128.const i64x2 0x0F0F0F0F0F0F0F0F 0x0F0F0F0F0F0F0F0F)
                            (v128.const i64x2 0x0F0F0F0F0F0F0F0F 0x0F0F0F0F0F0F0F0F))
                            (v128.const i64x2 -1 -1))
(assert_return (invoke "eq" (v128.const i64x2 0xFFFFFFFFFFFFFFFF 0x0000000000000000)
                            (v128.const i64x2 0xFFFFFFFFFFFFFFFF 0x0000000000000000))
                            (v128.const i64x2 -1 -1))
(assert_return (invoke "eq" (v128.const i64x2 0x0000000000000000 0xFFFFFFFFFFFFFFFF)
                            (v128.const i64x2 0x0000000000000000 0xFFFFFFFFFFFFFFFF))
                            (v128.const i64x2 -1 -1))
(assert_return (invoke "eq" (v128.const i64x2 0x03020100 0x11100904)
                            (v128.const i64x2 0x03020100 0x11100904))
                            (v128.const i64x2 -1 -1))
(assert_return (invoke "eq" (v128.const i64x2 0xFFFFFFFFFFFFFFFF 0xFFFFFFFFFFFFFFFF)
                            (v128.const i64x2 0x0FFFFFFFFFFFFFFF 0x0FFFFFFFFFFFFFFF))
                            (v128.const i64x2 0 0))
(assert_return (invoke "eq" (v128.const i64x2 0x1 0x1)
                            (v128.const i64x2 0x2 0x2))
                            (v128.const i64x2 0 0))

;; ne

;; i64x2.ne  (i64x2) (i64x2)

;; hex vs hex
(assert_return (invoke "ne" (v128.const i64x2 0xFFFFFFFFFFFFFFFF 0xFFFFFFFFFFFFFFFF)
                            (v128.const i64x2 0xFFFFFFFFFFFFFFFF 0xFFFFFFFFFFFFFFFF))
                            (v128.const i64x2 0 0))
(assert_return (invoke "ne" (v128.const i64x2 0x0000000000000000 0x0000000000000000)
                            (v128.const i64x2 0x0000000000000000 0x0000000000000000))
                            (v128.const i64x2 0 0))
(assert_return (invoke "ne" (v128.const i64x2 0xF0F0F0F0F0F0F0F0 0xF0F0F0F0F0F0F0F0)
                            (v128.const i64x2 0xF0F0F0F0F0F0F0F0 0xF0F0F0F0F0F0F0F0))
                            (v128.const i64x2 0 0))
(assert_return (invoke "ne" (v128.const i64x2 0x0F0F0F0F0F0F0F0F 0x0F0F0F0F0F0F0F0F)
                            (v128.const i64x2 0x0F0F0F0F0F0F0F0F 0x0F0F0F0F0F0F0F0F))
                            (v128.const i64x2 0 0))
(assert_return (invoke "ne" (v128.const i64x2 0xFFFFFFFFFFFFFFFF 0x0000000000000000)
                            (v128.const i64x2 0xFFFFFFFFFFFFFFFF 0x0000000000000000))
                            (v128.const i64x2 0 0))
(assert_return (invoke "ne" (v128.const i64x2 0x0000000000000000 0xFFFFFFFFFFFFFFFF)
                            (v128.const i64x2 0x0000000000000000 0xFFFFFFFFFFFFFFFF))
                            (v128.const i64x2 0 0))
(assert_return (invoke "ne" (v128.const i64x2 0x03020100 0x11100904)
                            (v128.const i64x2 0x03020100 0x11100904))
                            (v128.const i64x2 0 0))

;; lt_s

;; i64x2.lt_s  (i64x2) (i64x2)

;; hex vs hex
(assert_return (invoke "lt_s" (v128.const i64x2 0xFFFFFFFFFFFFFFFF 0xFFFFFFFFFFFFFFFF)
                              (v128.const i64x2 0xFFFFFFFFFFFFFFFF 0xFFFFFFFFFFFFFFFF))
                              (v128.const i64x2 0 0))
(assert_return (invoke "lt_s" (v128.const i64x2 0x0000000000000000 0x0000000000000000)
                              (v128.const i64x2 0x0000000000000000 0x0000000000000000))
                              (v128.const i64x2 0 0))
(assert_return (invoke "lt_s" (v128.const i64x2 0xF0F0F0F0F0F0F0F0 0xF0F0F0F0F0F0F0F0)
                              (v128.const i64x2 0xF0F0F0F0F0F0F0F0 0xF0F0F0F0F0F0F0F0))
                              (v128.const i64x2 0 0))
(assert_return (invoke "lt_s" (v128.const i64x2 0x0F0F0F0F0F0F0F0F 0x0F0F0F0F0F0F0F0F)
                              (v128.const i64x2 0x0F0F0F0F0F0F0F0F 0x0F0F0F0F0F0F0F0F))
                              (v128.const i64x2 0 0))
(assert_return (invoke "lt_s" (v128.const i64x2 0xFFFFFFFFFFFFFFFF 0x0000000000000000)
                              (v128.const i64x2 0xFFFFFFFFFFFFFFFF 0x0000000000000000))
                              (v128.const i64x2 0 0))
(assert_return (invoke "lt_s" (v128.const i64x2 0x0000000000000000 0xFFFFFFFFFFFFFFFF)
                              (v128.const i64x2 0x0000000000000000 0xFFFFFFFFFFFFFFFF))
                              (v128.const i64x2 0 0))
(assert_return (invoke "lt_s" (v128.const i64x2 0x0302010011100904 0x1A0B0A12FFABAA1B)
                              (v128.const i64x2 0x0302010011100904 0x1A0B0A12FFABAA1B))
                              (v128.const i64x2 0 0))

;; hex vs dec
(assert_return (invoke "lt_s" (v128.const i64x2 0xFFFFFFFFFFFFFFFF 0xFFFFFFFFFFFFFFFF)
                              (v128.const i64x2 18446744073709551615 18446744073709551615))
                              (v128.const i64x2 0 0))
(assert_return (invoke "lt_s" (v128.const i64x2 0xFFFFFFFFFFFFFFFF 0xFFFFFFFFFFFFFFFF)
                              (v128.const i64x2 -1 -1))
                              (v128.const i64x2 0 0))
(assert_return (invoke "lt_s" (v128.const i64x2 0x8080808080808080 0x8080808080808080)
                              (v128.const i64x2 9259542123273814144 9259542123273814144))
                              (v128.const i64x2 0 0))
(assert_return (invoke "lt_s" (v128.const i64x2 0x8080808080808080 0x8080808080808080)
                              (v128.const i64x2 -9187201950435737472 -9187201950435737472))
                              (v128.const i64x2 0 0))
(assert_return (invoke "lt_s" (v128.const i64x2 0x8382818000FFFEFD 0x7F020100FFFEFD80)
                              (v128.const i64x2 -8970465120996032771 9151878496576798080))
                              (v128.const i64x2 0 0))

;; dec vs dec
(assert_return (invoke "lt_s" (v128.const i64x2 -1 -1)
                              (v128.const i64x2 -1 -1))
                              (v128.const i64x2 0 0))
(assert_return (invoke "lt_s" (v128.const i64x2 0 0)
                              (v128.const i64x2 0 0))
                              (v128.const i64x2 0 0))
(assert_return (invoke "lt_s" (v128.const i64x2 18446744073709551615 18446744073709551615)
                              (v128.const i64x2 18446744073709551615 18446744073709551615))
                              (v128.const i64x2 0 0))
(assert_return (invoke "lt_s" (v128.const i64x2 18446744073709551615 18446744073709551615)
                              (v128.const i64x2 -1 -1))
                              (v128.const i64x2 0 0))
(assert_return (invoke "lt_s" (v128.const i64x2 18446744073709551615 0)
                              (v128.const i64x2 18446744073709551615 0))
                              (v128.const i64x2 0 0))
(assert_return (invoke "lt_s" (v128.const i64x2 0 18446744073709551615)
                              (v128.const i64x2 0 18446744073709551615))
                              (v128.const i64x2 0 0))
(assert_return (invoke "lt_s" (v128.const i64x2 -9223372036854775807 18446744073709551615)
                              (v128.const i64x2 9223372036854775809 -1))
                              (v128.const i64x2 0 0))

;; hex vs float
(assert_return (invoke "lt_s" (v128.const i64x2 0xc060000000000000 0xc05fc00000000000)
                              (v128.const f64x2 -128.0 -127.0))
                              (v128.const i64x2 0 0))
(assert_return (invoke "lt_s" (v128.const i64x2 0x3ff0000000000000 0x405fc00000000000)
                              (v128.const f64x2 1.0 127.0))
                              (v128.const i64x2 0 0))

;; le_s

;; i64x2.le_s  (i64x2) (i64x2)

;; hex vs hex
(assert_return (invoke "le_s" (v128.const i64x2 0xFFFFFFFFFFFFFFFF 0xFFFFFFFFFFFFFFFF)
                              (v128.const i64x2 0xFFFFFFFFFFFFFFFF 0xFFFFFFFFFFFFFFFF))
                              (v128.const i64x2 -1 -1))
(assert_return (invoke "le_s" (v128.const i64x2 0x0000000000000000 0x0000000000000000)
                              (v128.const i64x2 0x0000000000000000 0x0000000000000000))
                              (v128.const i64x2 -1 -1))
(assert_return (invoke "le_s" (v128.const i64x2 0xF0F0F0F0F0F0F0F0 0xF0F0F0F0F0F0F0F0)
                              (v128.const i64x2 0xF0F0F0F0F0F0F0F0 0xF0F0F0F0F0F0F0F0))
                              (v128.const i64x2 -1 -1))
(assert_return (invoke "le_s" (v128.const i64x2 0x0F0F0F0F0F0F0F0F 0x0F0F0F0F0F0F0F0F)
                              (v128.const i64x2 0x0F0F0F0F0F0F0F0F 0x0F0F0F0F0F0F0F0F))
                              (v128.const i64x2 -1 -1))
(assert_return (invoke "le_s" (v128.const i64x2 0xFFFFFFFFFFFFFFFF 0x0000000000000000)
                              (v128.const i64x2 0xFFFFFFFFFFFFFFFF 0x0000000000000000))
                              (v128.const i64x2 -1 -1))
(assert_return (invoke "le_s" (v128.const i64x2 0x0000000000000000 0xFFFFFFFFFFFFFFFF)
                              (v128.const i64x2 0x0000000000000000 0xFFFFFFFFFFFFFFFF))
                              (v128.const i64x2 -1 -1))
(assert_return (invoke "le_s" (v128.const i64x2 0x0302010011100904 0x1A0B0A12FFABAA1B)
                              (v128.const i64x2 0x0302010011100904 0x1A0B0A12FFABAA1B))
                              (v128.const i64x2 -1 -1))

;; hex vs dec
(assert_return (invoke "le_s" (v128.const i64x2 0xFFFFFFFFFFFFFFFF 0xFFFFFFFFFFFFFFFF)
                              (v128.const i64x2 18446744073709551615 18446744073709551615))
                              (v128.const i64x2 -1 -1))
(assert_return (invoke "le_s" (v128.const i64x2 0xFFFFFFFFFFFFFFFF 0xFFFFFFFFFFFFFFFF)
                              (v128.const i64x2 -1 -1))
                              (v128.const i64x2 -1 -1))
(assert_return (invoke "le_s" (v128.const i64x2 0x8080808080808080 0x8080808080808080)
                              (v128.const i64x2 9259542123273814144 9259542123273814144))
                              (v128.const i64x2 -1 -1))
(assert_return (invoke "le_s" (v128.const i64x2 0x8080808080808080 0x8080808080808080)
                              (v128.const i64x2 -9187201950435737472 -9187201950435737472))
                              (v128.const i64x2 -1 -1))
(assert_return (invoke "le_s" (v128.const i64x2 0x8382818000FFFEFD 0x7F020100FFFEFD80)
                              (v128.const i64x2 -8970465120996032771 9151878496576798080))
                              (v128.const i64x2 -1 -1))

;; dec vs dec
(assert_return (invoke "le_s" (v128.const i64x2 -1 -1)
                              (v128.const i64x2 -1 -1))
                              (v128.const i64x2 -1 -1))
(assert_return (invoke "le_s" (v128.const i64x2 0 0)
                              (v128.const i64x2 0 0))
                              (v128.const i64x2 -1 -1))
(assert_return (invoke "le_s" (v128.const i64x2 18446744073709551615 18446744073709551615)
                              (v128.const i64x2 18446744073709551615 18446744073709551615))
                              (v128.const i64x2 -1 -1))
(assert_return (invoke "le_s" (v128.const i64x2 18446744073709551615 18446744073709551615)
                              (v128.const i64x2 -1 -1))
                              (v128.const i64x2 -1 -1))
(assert_return (invoke "le_s" (v128.const i64x2 18446744073709551615 0)
                              (v128.const i64x2 18446744073709551615 0))
                              (v128.const i64x2 -1 -1))
(assert_return (invoke "le_s" (v128.const i64x2 0 18446744073709551615)
                              (v128.const i64x2 0 18446744073709551615))
                              (v128.const i64x2 -1 -1))
(assert_return (invoke "le_s" (v128.const i64x2 -9223372036854775807 18446744073709551615)
                              (v128.const i64x2 9223372036854775809 -1))
                              (v128.const i64x2 -1 -1))

;; hex vs float
(assert_return (invoke "le_s" (v128.const i64x2 0xc060000000000000 0xc05fc00000000000)
                              (v128.const f64x2 -128.0 -127.0))
                              (v128.const i64x2 -1 -1))
(assert_return (invoke "le_s" (v128.const i64x2 0x3ff0000000000000 0x405fc00000000000)
                              (v128.const f64x2 1.0 127.0))
                              (v128.const i64x2 -1 -1))

;; gt_s

;; i64x2.gt_s  (i64x2) (i64x2)

;; hex vs hex
(assert_return (invoke "gt_s" (v128.const i64x2 0xFFFFFFFFFFFFFFFF 0xFFFFFFFFFFFFFFFF)
                              (v128.const i64x2 0xFFFFFFFFFFFFFFFF 0xFFFFFFFFFFFFFFFF))
                              (v128.const i64x2 0 0))
(assert_return (invoke "gt_s" (v128.const i64x2 0x0000000000000000 0x0000000000000000)
                              (v128.const i64x2 0x0000000000000000 0x0000000000000000))
                              (v128.const i64x2 0 0))
(assert_return (invoke "gt_s" (v128.const i64x2 0xF0F0F0F0F0F0F0F0 0xF0F0F0F0F0F0F0F0)
                              (v128.const i64x2 0xF0F0F0F0F0F0F0F0 0xF0F0F0F0F0F0F0F0))
                              (v128.const i64x2 0 0))
(assert_return (invoke "gt_s" (v128.const i64x2 0x0F0F0F0F0F0F0F0F 0x0F0F0F0F0F0F0F0F)
                              (v128.const i64x2 0x0F0F0F0F0F0F0F0F 0x0F0F0F0F0F0F0F0F))
                              (v128.const i64x2 0 0))
(assert_return (invoke "gt_s" (v128.const i64x2 0xFFFFFFFFFFFFFFFF 0x0000000000000000)
                              (v128.const i64x2 0xFFFFFFFFFFFFFFFF 0x0000000000000000))
                              (v128.const i64x2 0 0))
(assert_return (invoke "gt_s" (v128.const i64x2 0x0000000000000000 0xFFFFFFFFFFFFFFFF)
                              (v128.const i64x2 0x0000000000000000 0xFFFFFFFFFFFFFFFF))
                              (v128.const i64x2 0 0))
(assert_return (invoke "gt_s" (v128.const i64x2 0x0302010011100904 0x1A0B0A12FFABAA1B)
                              (v128.const i64x2 0x0302010011100904 0x1A0B0A12FFABAA1B))
                              (v128.const i64x2 0 0))

;; hex vs dec
(assert_return (invoke "gt_s" (v128.const i64x2 0xFFFFFFFFFFFFFFFF 0xFFFFFFFFFFFFFFFF)
                              (v128.const i64x2 18446744073709551615 18446744073709551615))
                              (v128.const i64x2 0 0))
(assert_return (invoke "gt_s" (v128.const i64x2 0xFFFFFFFFFFFFFFFF 0xFFFFFFFFFFFFFFFF)
                              (v128.const i64x2 -1 -1))
                              (v128.const i64x2 0 0))
(assert_return (invoke "gt_s" (v128.const i64x2 0x8080808080808080 0x8080808080808080)
                              (v128.const i64x2 9259542123273814144 9259542123273814144))
                              (v128.const i64x2 0 0))
(assert_return (invoke "gt_s" (v128.const i64x2 0x8080808080808080 0x8080808080808080)
                              (v128.const i64x2 -9187201950435737472 -9187201950435737472))
                              (v128.const i64x2 0 0))
(assert_return (invoke "gt_s" (v128.const i64x2 0x8382818000FFFEFD 0x7F020100FFFEFD80)
                              (v128.const i64x2 -8970465120996032771 9151878496576798080))
                              (v128.const i64x2 0 0))

;; dec vs dec
(assert_return (invoke "gt_s" (v128.const i64x2 -1 -1)
                              (v128.const i64x2 -1 -1))
                              (v128.const i64x2 0 0))
(assert_return (invoke "gt_s" (v128.const i64x2 0 0)
                              (v128.const i64x2 0 0))
                              (v128.const i64x2 0 0))
(assert_return (invoke "gt_s" (v128.const i64x2 18446744073709551615 18446744073709551615)
                              (v128.const i64x2 18446744073709551615 18446744073709551615))
                              (v128.const i64x2 0 0))
(assert_return (invoke "gt_s" (v128.const i64x2 18446744073709551615 18446744073709551615)
                              (v128.const i64x2 -1 -1))
                              (v128.const i64x2 0 0))
(assert_return (invoke "gt_s" (v128.const i64x2 18446744073709551615 0)
                              (v128.const i64x2 18446744073709551615 0))
                              (v128.const i64x2 0 0))
(assert_return (invoke "gt_s" (v128.const i64x2 0 18446744073709551615)
                              (v128.const i64x2 0 18446744073709551615))
                              (v128.const i64x2 0 0))
(assert_return (invoke "gt_s" (v128.const i64x2 -9223372036854775807 18446744073709551615)
                              (v128.const i64x2 9223372036854775809 -1))
                              (v128.const i64x2 0 0))

;; hex vs float
(assert_return (invoke "gt_s" (v128.const i64x2 0xc060000000000000 0xc05fc00000000000)
                              (v128.const f64x2 -128.0 -127.0))
                              (v128.const i64x2 0 0))
(assert_return (invoke "gt_s" (v128.const i64x2 0x3ff0000000000000 0x405fc00000000000)
                              (v128.const f64x2 1.0 127.0))
                              (v128.const i64x2 0 0))

;; ge_s

;; i64x2.ge_s  (i64x2) (i64x2)

;; hex vs hex
(assert_return (invoke "ge_s" (v128.const i64x2 0xFFFFFFFFFFFFFFFF 0xFFFFFFFFFFFFFFFF)
                              (v128.const i64x2 0xFFFFFFFFFFFFFFFF 0xFFFFFFFFFFFFFFFF))
                              (v128.const i64x2 -1 -1))
(assert_return (invoke "ge_s" (v128.const i64x2 0x0000000000000000 0x0000000000000000)
                              (v128.const i64x2 0x0000000000000000 0x0000000000000000))
                              (v128.const i64x2 -1 -1))
(assert_return (invoke "ge_s" (v128.const i64x2 0xF0F0F0F0F0F0F0F0 0xF0F0F0F0F0F0F0F0)
                              (v128.const i64x2 0xF0F0F0F0F0F0F0F0 0xF0F0F0F0F0F0F0F0))
                              (v128.const i64x2 -1 -1))
(assert_return (invoke "ge_s" (v128.const i64x2 0x0F0F0F0F0F0F0F0F 0x0F0F0F0F0F0F0F0F)
                              (v128.const i64x2 0x0F0F0F0F0F0F0F0F 0x0F0F0F0F0F0F0F0F))
                              (v128.const i64x2 -1 -1))
(assert_return (invoke "ge_s" (v128.const i64x2 0xFFFFFFFFFFFFFFFF 0x0000000000000000)
                              (v128.const i64x2 0xFFFFFFFFFFFFFFFF 0x0000000000000000))
                              (v128.const i64x2 -1 -1))
(assert_return (invoke "ge_s" (v128.const i64x2 0x0000000000000000 0xFFFFFFFFFFFFFFFF)
                              (v128.const i64x2 0x0000000000000000 0xFFFFFFFFFFFFFFFF))
                              (v128.const i64x2 -1 -1))
(assert_return (invoke "ge_s" (v128.const i64x2 0x0302010011100904 0x1A0B0A12FFABAA1B)
                              (v128.const i64x2 0x0302010011100904 0x1A0B0A12FFABAA1B))
                              (v128.const i64x2 -1 -1))

;; hex vs dec
(assert_return (invoke "ge_s" (v128.const i64x2 0xFFFFFFFFFFFFFFFF 0xFFFFFFFFFFFFFFFF)
                              (v128.const i64x2 18446744073709551615 18446744073709551615))
                              (v128.const i64x2 -1 -1))
(assert_return (invoke "ge_s" (v128.const i64x2 0xFFFFFFFFFFFFFFFF 0xFFFFFFFFFFFFFFFF)
                              (v128.const i64x2 -1 -1))
                              (v128.const i64x2 -1 -1))
(assert_return (invoke "ge_s" (v128.const i64x2 0x8080808080808080 0x8080808080808080)
                              (v128.const i64x2 9259542123273814144 9259542123273814144))
                              (v128.const i64x2 -1 -1))
(assert_return (invoke "ge_s" (v128.const i64x2 0x8080808080808080 0x8080808080808080)
                              (v128.const i64x2 -9187201950435737472 -9187201950435737472))
                              (v128.const i64x2 -1 -1))
(assert_return (invoke "ge_s" (v128.const i64x2 0x8382818000FFFEFD 0x7F020100FFFEFD80)
                              (v128.const i64x2 -8970465120996032771 9151878496576798080))
                              (v128.const i64x2 -1 -1))

;; dec vs dec
(assert_return (invoke "ge_s" (v128.const i64x2 -1 -1)
                              (v128.const i64x2 -1 -1))
                              (v128.const i64x2 -1 -1))
(assert_return (invoke "ge_s" (v128.const i64x2 0 0)
                              (v128.const i64x2 0 0))
                              (v128.const i64x2 -1 -1))
(assert_return (invoke "ge_s" (v128.const i64x2 18446744073709551615 18446744073709551615)
                              (v128.const i64x2 18446744073709551615 18446744073709551615))
                              (v128.const i64x2 -1 -1))
(assert_return (invoke "ge_s" (v128.const i64x2 18446744073709551615 18446744073709551615)
                              (v128.const i64x2 -1 -1))
                              (v128.const i64x2 -1 -1))
(assert_return (invoke "ge_s" (v128.const i64x2 18446744073709551615 0)
                              (v128.const i64x2 18446744073709551615 0))
                              (v128.const i64x2 -1 -1))
(assert_return (invoke "ge_s" (v128.const i64x2 0 18446744073709551615)
                              (v128.const i64x2 0 18446744073709551615))
                              (v128.const i64x2 -1 -1))
(assert_return (invoke "ge_s" (v128.const i64x2 -9223372036854775807 18446744073709551615)
                              (v128.const i64x2 9223372036854775809 -1))
                              (v128.const i64x2 -1 -1))

;; hex vs float
(assert_return (invoke "ge_s" (v128.const i64x2 0xc060000000000000 0xc05fc00000000000)
                              (v128.const f64x2 -128.0 -127.0))
                              (v128.const i64x2 -1 -1))
(assert_return (invoke "ge_s" (v128.const i64x2 0x3ff0000000000000 0x405fc00000000000)
                              (v128.const f64x2 1.0 127.0))
                              (v128.const i64x2 -1 -1))

;; Type check

(assert_invalid (module (func (result v128) (i64x2.eq (i32.const 0) (f32.const 0)))) "type mismatch")
(assert_invalid (module (func (result v128) (i64x2.ne (i32.const 0) (f32.const 0)))) "type mismatch")
(assert_invalid (module (func (result v128) (i64x2.ge_s (i32.const 0) (f32.const 0)))) "type mismatch")
(assert_invalid (module (func (result v128) (i64x2.gt_s (i32.const 0) (f32.const 0)))) "type mismatch")
(assert_invalid (module (func (result v128) (i64x2.le_s (i32.const 0) (f32.const 0)))) "type mismatch")
(assert_invalid (module (func (result v128) (i64x2.lt_s (i32.const 0) (f32.const 0)))) "type mismatch")

;; Test operation with empty argument

(assert_invalid
  (module
    (func $i64x2.eq-1st-arg-empty (result v128)
      (i64x2.eq (v128.const i64x2 0 0))
    )
  )
  "type mismatch"
)
(assert_invalid
  (module
    (func $i64x2.eq-arg-empty (result v128)
      (i64x2.eq)
    )
  )
  "type mismatch"
)
(assert_invalid
  (module
    (func $i64x2.ne-1st-arg-empty (result v128)
      (i64x2.ne (v128.const i64x2 0 0))
    )
  )
  "type mismatch"
)
(assert_invalid
  (module
    (func $i64x2.ne-arg-empty (result v128)
      (i64x2.ne)
    )
  )
  "type mismatch"
)