#! /bin/sh

wasmsign2 show -i z.wasm

wasmsign2 keygen -k secret.key -K public.key

wasmsign2 keygen -k secret.key2 -K public.key2

wasmsign2 -v sign -i z.wasm -o z2.wasm -k secret.key

wasmsign2 verify -K public.key -i z.wasm

wasmsign2 verify -K public.key -i z2.wasm

wasmsign2 sign -k secret.key2 -i z2.wasm -o z2.wasm

wasmsign2 verify -K public.key2 -i z2.wasm
wasmsign2 verify -K public.key -i z2.wasm

wasmsign2 sign --help

wasmsign2 detach -S signature -i z2.wasm -o z3.wasm

ls -l z*.wasm
ls -l signature

wasmsign2 attach -S signature -i z3.wasm -o z4.wasm

ls -l z4.wasm z2.wasm

rm z2.wasm z3.wasm z4.wasm

wasmsign2 show -i z.wasm

wasmsign2 help

wasmsign2 show -i z.wasm

wasmsign2 split -i z.wasm -o z2.wasm -s '^[.]debug'

wasmsign2 split -i z2.wasm -o z2.wasm -s '#'

wasmsign2 sign -i z2.wasm -o z3.wasm -k secret.key
wasmsign2 -v sign -i z2.wasm -o z3.wasm -k secret.key

wasmsign2 verify -i z3.wasm -K public.key -s '#'
wasmsign2 verify -i z3.wasm -K public.key -s '.debug'
wasmsign2 verify -i z3.wasm -K public.key -s 'producers'
wasmsign2 verify -i z3.wasm -K public.key -s 'producers|name'

echo different key formats, openssl in PEM and DER

wasmsign2 sign -i z.wasm -o z2.wasm --ssh -k ~/.ssh/id_ed25519

wasmsign2 verify -i z2.wasm --from-github jedisct1

wasmsign2-rules -i z2.wasm -r rules.yaml

wasmsign2 sign -i z2.wasm -o z2.wasm -k secret.key

wasmsign2-rules -i z2.wasm -r rules.yaml

mkdir o
zig init-exe
zig build -Dtarget=wasm32-wasi
mv zig-out/bin/o.wasm /tmp

wasmtime run o.wasm

wasmtime run --public-keys public.key,public.key2 o.wasm

wasmsign2 sign -i o.wasm -o o.wasm -k secret.key

wasmtime run --public-keys public.key,public.key2 o.wasm

echo https://github.com/wasm-signatures/wasmsign2
echo https://github.com/WebAssembly/tool-conventions/blob/main/Signatures.md

