#include <stdint.h>
#include <string.h>
#include <emmintrin.h>
#include <sodium.h>

typedef uint32_t guest_ptr_t;
typedef uint32_t guest_size_t;

guest_size_t
builtin_strlen(const struct sbx_vmctx *ctx, guest_ptr_t str_off)
{
    char * const heap = SBX_HEAP(ctx);
    const size_t heap_size_bytes = SBX_CURRENT_HEAP_SIZE(ctx);
    size_t       left;
    uint64_t     t;    
    guest_ptr_t  str_save = str_off;
    
    TRAPIF((size_t) str_off > heap_size_bytes);    
    left = heap_size_bytes - (size_t) str_off;
    
    while (left >= 8U) {
        memcpy(&t, &str_base[str_off], 8);
        if ((t & 0xffULL) == (uint64_t) 0U) {
            return str_off - str_save;
        }
        if ((t & 0xff00ULL) == (uint64_t) 0U) {
            return str_off - str_save + 1U;
        }
        if ((t & 0xff0000ULL) == (uint64_t) 0U) {
            return str_off - str_save + 2U;
        }
        if ((t & 0xff000000ULL) == (uint64_t) 0U) {
            return str_off - str_save + 3U;
        }
        if ((t & 0xff00000000ULL) == (uint64_t) 0U) {
            return str_off - str_save + 4U;
        }
        if ((t & 0xff0000000000ULL) == (uint64_t) 0U) {
            return str_off - str_save + 5U;
        }
        if ((t & 0xff000000000000ULL) == (uint64_t) 0U) {
            return str_off - str_save + 6U;
        }
        if ((t & 0xff00000000000000ULL) == (uint64_t) 0U) {
            return str_off - str_save + 7U;
        }
        str_off += 8U;
        left -= 8U;
    }
    while (left > 0) {
        if (str_base[str_off] == 0) {
            return str_off - str_save;
        }
        str_off++;
        left--;
    }
    TRAP();
}

#define Z "ehrioqvwyeriquwebruweibweiorwerveerwer"

int main(void)
{
    char *str;
    if (sodium_init() != 0) {
        return 1;
    }
    str = sodium_malloc(sizeof Z + 0);
    memcpy(str, Z, sizeof Z);
    size_t len = builtin_strlen(str, 0, sizeof Z +0);
    printf("%zu vs %zu\n", len, strlen(str));
    
    return 0;
}
