use borsh::{BorshDeserialize, BorshSerialize};
use wasmium_utilities::{Arbitrator, Keeper};

/// Maximum number is `64` signers due to limitations of Solana stack size.

#[derive(Debug, Clone, PartialEq, Eq, PartialOrd, Ord, BorshSerialize, BorshDeserialize)]
pub struct WasmiumVault<const K: usize, const A: usize> {
    keepers: [Keeper; K],
    arbitrator: [Arbitrator; A],
    keeper_threshold: u8,
    arbitrator_threshold: u8,
}
/*/
impl<const K: usize, const A: usize> WasmiumVault<K, A> {
    pub fn add_keeper(&mut self, keeper: Ed25519PublicKey) -> &mut Self {
        self.keepers[0] = keeper;

        self
    }
}
*/
