use borsh::{BorshDeserialize, BorshSerialize};
use wasmium_utilities::Ed25519PublicKeyArray;

#[derive(Debug, PartialEq, Eq, PartialOrd, Ord, Clone, BorshSerialize, BorshDeserialize)]
pub enum KeeperInstruction {
    VaultUpgrade(Ed25519PublicKeyArray),
    Transact(Ed25519PublicKeyArray),
    Transfer(Ed25519PublicKeyArray),
    /// Maximum addresses to transfer, a limitation due to stack size of Solana
    TransferMany([Ed25519PublicKeyArray; 32]),
    AddKeeper {
        new_threshold: u8,
        keeper_address: Ed25519PublicKeyArray,
    },
    RevokeKeeper {
        new_threshold: u8,
        keeper_address: Ed25519PublicKeyArray,
    },
    AddArbitrator {
        new_threshold: u8,
        keeper_address: Ed25519PublicKeyArray,
    },
    RevokeArbitrator {
        new_threshold: u8,
        keeper_address: Ed25519PublicKeyArray,
    },
}
