# Contributing to Inkwell

Hello there! Thank you for taking interest in Inkwell!

## Found a Bug?

* Please ensure the bug was not already reported by searching our [issue tracker](https://github.com/TheDan64/inkwell/issues).
* If you're unable to find an open issue relating to the problem, please file an [issue](https://github.com/TheDan64/inkwell/issues/new).

<!--- * Please use the issue template to create the issue --->

## Want to Submit a Pull Request?

* Please ensure your PR follows these guidelines:

### Required

* My code follows the code style of this project
* I have added documentation and doc tests to any new functions or types
* I have updated documentation and doc tests to any modified functions or types as applicable
* I have added tests to cover my changes
* All new and existing tests passed
* I am basing my changes off master, instead of one of the llvm version branches (they're deprecated and no longer necessary)

### Desired

* I have ran `cargo clippy` and updated portions of code pertaining to my changes
* I will keep my code reasonably up to date via rebasing over merging whenever possible (This helps avoid unnecessary merge commits)

## Got Questions?

Please attempt to ask your question at our [Gitter Chat Room](https://gitter.im/inkwell-rs/Lobby). If no one gets back to you in a day or so, feel free to open up an issue.

Thanks!!

Inkwell Team
