# `wasmedge-sys` 说明

## `-sys`库设计原则

一般而言，`-sys`库应该只保留 `unsafe` 的 C 接口绑定，不应该有多余的安全抽象。

但是，对于最终我们要构建的 `wasmedge-rs`这样的纯 Rust SDK 而言，不应该使用太多的 C 绑定接口。所以，出于这样的考虑，`wasmedge-sys`库使用了一层薄的 Rust 包装，只暴露合适的接口，供上层 `wasmedge-rs` 来抽象更易于使用的纯 Rust SDK。

`-sys` 库暴露的接口，应该是稳定的。即， 当 C 接口改变时，只需改变 `-sys`库，而无需改变上层的 SDK 。

## 库接口说明

- 错误处理： 统一返回 `ErrReport` 结构，在上层`wasmedge-rs` SDK 中再进一步做 Rust 风格的错误处理。
- 将基本类型纳入 `-sys` 库，比如字符串/Value 等，上层 SDK 只需要使用即可。
- 配置/模块加载/创建VM/启动VM计算返回结果，这些放到 `-sys` 库中，作为 SDK 的基础接口。
- 基础接口，涉及创建或初始化，使用了基本的「封装」，不对下游开放修改，以保证基础接口的稳定性。
- Dosc 目录下记录对应的 `C-API` 头文件和对应的 Rust 绑定接口，作为文档。
