// Copyright Claudio Mattera 2022.
//
// Distributed under the MIT License or the Apache 2.0 License at your option.
// See the accompanying files License-MIT.txt and License-Apache-2.0.txt, or
// online at
// https://opensource.org/licenses/MIT
// https://opensource.org/licenses/Apache-2.0

//! Collection of libraries for WASM-4 fantasy console
//!
//! This is a convenience crate that re-exports all `wasm4fun-*` crates.
//! See the documentation of individual crates for more information.

#![no_std]

pub use wasm4fun_core as core;
pub use wasm4fun_fmt as fmt;
pub use wasm4fun_graphics as graphics;
pub use wasm4fun_input as input;
pub use wasm4fun_log as log;
pub use wasm4fun_logo as logo;
pub use wasm4fun_panichandler as panichandler;
pub use wasm4fun_random as random;
pub use wasm4fun_sound as sound;
pub use wasm4fun_storage as storage;
pub use wasm4fun_time as time;
