// Copyright Claudio Mattera 2022.
//
// Distributed under the MIT License or the Apache 2.0 License at your option.
// See the accompanying files License-MIT.txt and License-Apache-2.0.txt, or
// online at
// https://opensource.org/licenses/MIT
// https://opensource.org/licenses/Apache-2.0

//! Panic handler for WASM-4 fantasy console

#![no_std]

#[cfg(target_family = "wasm")]
use core::arch::wasm32;

#[cfg(target_family = "wasm")]
use core::panic::PanicInfo;

#[cfg(target_family = "wasm")]
use wasm4fun_core::trace;

#[cfg(target_family = "wasm")]
/// Print panic message to the debug console and abort
#[panic_handler]
pub fn panic_handler(_panic_info: &PanicInfo<'_>) -> ! {
    trace("panic error");

    #[cfg(debug_assertions)]
    if let Some(cause) = _panic_info.payload().downcast_ref::<&str>() {
        trace(cause);
    }

    wasm32::unreachable()
}
