// Copyright Claudio Mattera 2022.
//
// Distributed under the MIT License or the Apache 2.0 License at your option.
// See the accompanying files License-MIT.txt and License-Apache-2.0.txt, or
// online at
// https://opensource.org/licenses/MIT
// https://opensource.org/licenses/Apache-2.0

use wasm4fun_graphics::{draw_rect, set_drawing_colors, SCREEN_SIZE};
// use wasm4fun_sound::Tone;

use crate::assets::LOGO_SPRITE;

const LOGO_WIDTH: i32 = LOGO_SPRITE.width() as i32 - 4;

const LOGO_X: i32 = (SCREEN_SIZE as i32 - LOGO_WIDTH) / 2;
const LOGO_Y: i32 = 60;

const FORWARED_INTERVAL: i32 = 10;
const FORWARD_SPEED: i32 = 2;
const BACKWARD_SPEED: i32 = 6;

pub fn draw_logo(frame: u64) {
    let frame = frame as i32;

    draw_background();

    if frame < LOGO_WIDTH {
        draw_logo_forward(frame * FORWARD_SPEED)
    } else {
        let frame = frame - LOGO_WIDTH;
        draw_logo_backward(frame * BACKWARD_SPEED)
    }
}

fn draw_background() {
    set_drawing_colors(0x44);
    draw_rect(0, 0, SCREEN_SIZE, SCREEN_SIZE);
}

fn draw_logo_forward(frame: i32) {
    let mut src_x: i32 = frame - FORWARED_INTERVAL;
    let interval: i32 = if src_x < 0 {
        FORWARED_INTERVAL + src_x
    } else if FORWARED_INTERVAL > LOGO_WIDTH - src_x {
        LOGO_WIDTH - src_x
    } else {
        FORWARED_INTERVAL
    };

    if src_x < 0 {
        src_x = 0;
    }

    // Draw shine
    set_drawing_colors(0x10);
    LOGO_SPRITE
        .clip(src_x as u32, 0, interval as u32, 16)
        .blit(src_x + LOGO_X, LOGO_Y);
}

fn draw_logo_backward(frame: i32) {
    let mut src_x: i32 = LOGO_WIDTH - frame;
    let mut interval: i32 = frame;

    if src_x < 0 {
        src_x = 0;
        interval = LOGO_WIDTH;
    }

    // Draw shine
    set_drawing_colors(0x20);
    LOGO_SPRITE
        .clip(src_x as u32, 0, interval as u32, 16)
        .blit(src_x + LOGO_X, LOGO_Y);
}
