Wasm4fun
====

Rust libraries for WASM-4 fantasy console

Home page: <https://wasm4fun.neocities.org/>

Repository: <https://gitlab.com/claudiomattera/wasm4fun/>


This repository contains a set of libraries/crates for developing games in [Rust] for the [WASM-4] fantasy console.

[Rust]: https://www.rust-lang.org/
[WASM-4]: https://wasm4.org/


The WASM-4 fantasy console has the following hardware:

-   Display: 160×160 screen using a customizable 4-colours palette.

    This means that at any time there can only be 4 different colours on the screen, but at any time the game can switch to a different set of colours.

-   Memory: 64 KiB.

-   Cartridge size: 64 KiB.

    An entire game cannot exceed the cartridge size.
    This limits the number and complexity of game resources, such a graphical sprites, and the complexity of game logic (convoluted implementation results in larger binary size).

-   Disk storage: 1 KiB.

    The game can write and read up to 1 KiB of data, for instance for saving progress or high scores.


WASM-4 engine exposes a small set of primitives and memory mapping, and expects games to expose two callback functions.
This approach allows to easily support several programming languages, but has the drawback that the programming interface is rather low level and simplistic.
The purpose of these libraries is to wrap WASM-4 primitives and expose a much richer, more idiomatic and safer API.


Architecture
----

This library is divided in several independent crates, each implementing specific functionalities.
For instance, `wasm4fun-input` implements functions and data types for reading the console input, whether it is mouse or gamepad, and `wasm4fun-storage` implements functions to save or load data from the storage system.

Some crates depend on other crates.
For instance, `wasm4fun-core`, which exports the bare WASM-4 interface, is used in most crates, and so is `wasm4fun-log`, which exports a `debug!()` macro to write formatted text to the output console.

The top-level `wasm4fun` crate re-exports all sub-crates, but it is possible to ignore it and explicitly depend on some of the sub-crates, in order to trim the dependency tree.


Design Choices
----

These libraries do not use any dynamic allocation, and therefore do not use any part of Rust standard library.
In technical terms, they do not use anything from `std::` module, but only from `core::`.

Dynamic allocation makes development much easier, but it has one major drawback on WASM-4: it results in a significant larger cartridge size, since the cartridge must contain the allocator itself.
Due to the 64 KiB cartridge size constraint, this might force to use smaller game resource, such as sprites, or to avoid some of the complex libraries.

On the other hand, while dynamic allocation brings many advantages in other environments, it is not so necessary on Rust on WASM-4.
Many crates exist to implement data structures and algorithms on the stack.
For instance, the [tinyvec] crate offers "dynamic" vectors backed by arrays in the stack.

Finally, avoiding dynamic allocation fits well with the general minimalistic philosophy of WASM-4:

> The idea is that by removing excess and focusing on the essential, it becomes easier to start *and finish* developing a game.

[tinyvec]: https://lib.rs/crates/tinyvec


Documentation and Examples
----

Documentation is available on <https://docs.rs/wasm4fun/>.

Several examples are available inside directory [`examples`](./examples/).
They can be run with the command `cargo make run-example EXAMPLE_NAME` (executable `w4` from WASM-4 must be in path).


License
----

Copyright Claudio Mattera 2022


You are free to copy, modify, and distribute this application with attribution under the terms of either

 * Apache License, Version 2.0
   ([`LICENSE-Apache-2.0.txt`](./LICENSE-Apache-2.0.txt) or https://opensource.org/licenses/Apache-2.0)
 * MIT license
   ([`LICENSE-MIT.txt`](./LICENSE-MIT.txt) or https://opensource.org/licenses/MIT)

at your option.
