/// An enum representing all the keys of a keyboard (normally)
#[derive(Debug, PartialEq)]
#[allow(missing_docs)]
pub enum Key {
    Unknow = 0,
    BackSpace = 8,
    Tab = 9,
    Enter = 13,
    Shift = 16,
    Ctrl = 17,
    Alt = 18,
    Pause = 19,
    CapsLock = 20,
    Escape = 27,
    PageUp = 33,
    PageDown = 34,
    End = 35,
    Home = 36,
    LeftArrow = 37,
    UpArrow = 38,
    RightArrow = 39,
    DownArrow = 40,
    Insert = 45,
    Delete = 46,
    Zero = 48,
    One = 49,
    Two = 50,
    Three = 51,
    Four = 52,
    Five = 53,
    Six = 54,
    Seven = 55,
    Eight = 56,
    Nine = 57,
    A = 65,
    B = 66,
    C = 67,
    D = 68,
    E = 69,
    F = 70,
    G = 71,
    H = 72,
    I = 73,
    J = 74,
    K = 75,
    L = 76,
    M = 77,
    N = 78,
    O = 79,
    P = 80,
    Q = 81,
    R = 82,
    S = 83,
    T = 84,
    U = 85,
    V = 86,
    W = 87,
    X = 88,
    Y = 89,
    Z = 90,
    LeftWindowKey = 91,
    RightWindowKey = 92,
    SelectKey = 93,
    Numpad0 = 96,
    Numpad1 = 97,
    Numpad2 = 98,
    Numpad3 = 99,
    Numpad4 = 100,
    Numpad5 = 101,
    Numpad6 = 102,
    Numpad7 = 103,
    Numpad8 = 104,
    Numpad9 = 105,
    Multiply = 106,
    Add = 107,
    Subtract = 109,
    DecimalPoint = 110,
    Divide = 111,
    F1 = 112,
    F2 = 113,
    F3 = 114,
    F4 = 115,
    F5 = 116,
    F6 = 117,
    F7 = 118,
    F8 = 119,
    F9 = 120,
    F10 = 121,
    F11 = 122,
    F12 = 123,
    NumLock = 144,
    ScrollLock = 145,
    SemiColon = 186,
    EqualSign = 187,
    Comma = 188,
    Dash = 189,
    Period = 190,
    ForwardSlash = 191,
    GraveAccent = 192,
    OpenBracket = 219,
    BackSlash = 220,
    CloseBraket = 221,
    SingleQuote = 222,
}

impl From<u32> for Key {
    fn from(key_code: u32) -> Self {
        match key_code {
            8 => Key::BackSpace,
            9 => Key::Tab,
            13 => Key::Enter,
            16 => Key::Shift,
            17 => Key::Ctrl,
            18 => Key::Alt,
            19 => Key::Pause,
            20 => Key::CapsLock,
            27 => Key::Escape,
            33 => Key::PageUp,
            34 => Key::PageDown,
            35 => Key::End,
            36 => Key::Home,
            37 => Key::LeftArrow,
            38 => Key::UpArrow,
            39 => Key::RightArrow,
            40 => Key::DownArrow,
            45 => Key::Insert,
            46 => Key::Delete,
            48 => Key::Zero,
            49 => Key::One,
            50 => Key::Two,
            51 => Key::Three,
            52 => Key::Four,
            53 => Key::Five,
            54 => Key::Six,
            55 => Key::Seven,
            56 => Key::Eight,
            57 => Key::Nine,
            65 => Key::A,
            66 => Key::B,
            67 => Key::C,
            68 => Key::D,
            69 => Key::E,
            70 => Key::F,
            71 => Key::G,
            72 => Key::H,
            73 => Key::I,
            74 => Key::J,
            75 => Key::K,
            76 => Key::L,
            77 => Key::M,
            78 => Key::N,
            79 => Key::O,
            80 => Key::P,
            81 => Key::Q,
            82 => Key::R,
            83 => Key::S,
            84 => Key::T,
            85 => Key::U,
            86 => Key::V,
            87 => Key::W,
            88 => Key::X,
            89 => Key::Y,
            90 => Key::Z,
            91 => Key::LeftWindowKey,
            92 => Key::RightWindowKey,
            93 => Key::SelectKey,
            96 => Key::Numpad0,
            97 => Key::Numpad1,
            98 => Key::Numpad2,
            99 => Key::Numpad3,
            100 => Key::Numpad4,
            101 => Key::Numpad5,
            102 => Key::Numpad6,
            103 => Key::Numpad7,
            104 => Key::Numpad8,
            105 => Key::Numpad9,
            106 => Key::Multiply,
            107 => Key::Add,
            109 => Key::Subtract,
            110 => Key::DecimalPoint,
            111 => Key::Divide,
            112 => Key::F1,
            113 => Key::F2,
            114 => Key::F3,
            115 => Key::F4,
            116 => Key::F5,
            117 => Key::F6,
            118 => Key::F7,
            119 => Key::F8,
            120 => Key::F9,
            121 => Key::F10,
            122 => Key::F11,
            123 => Key::F12,
            144 => Key::NumLock,
            145 => Key::ScrollLock,
            186 => Key::SemiColon,
            187 => Key::EqualSign,
            188 => Key::Comma,
            189 => Key::Dash,
            190 => Key::Period,
            191 => Key::ForwardSlash,
            192 => Key::GraveAccent,
            219 => Key::OpenBracket,
            220 => Key::BackSlash,
            221 => Key::CloseBraket,
            222 => Key::SingleQuote,
            _ => Key::Unknow
        }
    }
}

#[derive(Debug)]
/// A keyboard event
pub enum KeyboardEvent {
    /// A key has been pressed
    Down(Key),
    /// A key has been released
    Up(Key)
}
