//! embedded-wasm (ewasm) C library I2C driver rust wrapper

/// I2C driver context object, see [wasme/i2c.h](https://github.com/ryankurte/embedded-wasm/blob/main/lib/inc/wasme/i2c.h)
const DRV_I2C: wasme_i2c_drv_t = wasme_i2c_drv_t{
    init: Some(i2c_init),
    deinit: Some(i2c_deinit),
    write: Some(i2c_write),
    read: Some(i2c_read),
    write_read: Some(i2c_write_read),
};

extern "C" fn i2c_init(ctx: *mut c_void, dev: u32, baud: u32, sda: i32, scl: i32) -> i32 {
    let ctx: &mut MockCtx = unsafe { &mut *(ctx as *mut MockCtx) };
    match I2c::init(ctx, dev, baud, sda, scl) {
        Ok(i) => i,
        // TODO: not sure how to manage this yet
        Err(e) => panic!("{:?}", e),
    }
}

extern "C" fn i2c_deinit(ctx: *mut c_void, handle: i32) -> i32 {
    let ctx: &mut MockCtx = unsafe { &mut *(ctx as *mut MockCtx) };
    match I2c::deinit(ctx, handle) {
        Ok(_) => 0,
        // TODO: not sure how to manage this yet
        Err(e) => panic!("{:?}", e),
    }
}

extern "C" fn i2c_read(ctx: *mut c_void, handle: i32, address: u16, data_in: *mut u8, length_in: u32) -> i32 {
    let ctx: &mut MockCtx = unsafe { &mut *(ctx as *mut MockCtx) };
    let buff = unsafe{ slice::from_raw_parts_mut(data_in, length_in as usize) };

    match I2c::read(ctx, handle, address, buff) {
        Ok(_) => 0,
        // TODO: not sure how to manage this yet
        Err(e) => panic!("{:?}", e),
    }
}

extern "C" fn i2c_write(ctx: *mut c_void, handle: i32, address: u16, data_out: *mut u8, length_out: u32) -> i32 {
    let ctx: &mut MockCtx = unsafe { &mut *(ctx as *mut MockCtx) };
    let data = unsafe{ slice::from_raw_parts_mut(data_out, length_out as usize) };

    match I2c::write(ctx, handle, address, data) {
        Ok(_) => 0,
        // TODO: not sure how to manage this yet
        Err(e) => panic!("{:?}", e),
    }
}

extern "C" fn i2c_write_read(ctx: *mut c_void, handle: i32, address: u16, data_out: *mut u8, length_out: u32, data_in: *mut u8, length_in: u32) -> i32 {
    let ctx: &mut MockCtx = unsafe { &mut *(ctx as *mut MockCtx) };
    let data = unsafe{ slice::from_raw_parts_mut(data_out, length_out as usize) };
    let buff = unsafe{ slice::from_raw_parts_mut(data_in, length_in as usize) };

    match I2c::write_read(ctx, handle, address, data, buff) {
        Ok(_) => 0,
        // TODO: not sure how to manage this yet
        Err(e) => panic!("{:?}", e),
    }
}
