

use structopt::StructOpt;
use strum_macros::{Display, EnumVariantNames, EnumString};

pub mod gpio;
pub mod dev;

pub mod mock;
pub mod linux;
pub mod api;


/// Runtime mode
#[derive(Clone, PartialEq, Debug, StructOpt)]
#[derive(Display, EnumVariantNames, EnumString)]
#[strum(serialize_all = "snake_case")]
pub enum Mode {
    Mock,
    Linux,
}

#[derive(Clone, PartialEq, Debug, StructOpt)]
#[derive(Display, EnumVariantNames, EnumString)]
#[strum(serialize_all = "snake_case")]
pub enum Runtime {
    Wasmtime,
    Wasm3,
}

#[cfg(feature="rt-wasmtime")]
pub fn run<M, B>(manager: M, bind: B, bin: &str) -> anyhow::Result<()> 
where
    M: 'static,
    B: Fn(&mut wasmtime::Linker<M>) -> anyhow::Result<()>,
{
    use wasmtime::*;

    // Create new engine and linker
    let engine = Engine::default();
    let mut linker = Linker::new(&engine);

    // Create store for variables / instances / etc.
    let mut store = Store::new(&engine, manager);

    // Bind APIs
    bind(&mut linker)?;

    // Load module from file
    let module = Module::from_file(&engine, bin)?;

    // Bind module and run default fn
    linker.module(&mut store, "", &module)?;
    linker
        .get_default(&mut store, "")?
        .typed::<(), (), _>(&store)?
        .call(&mut store, ())?;

    Ok(())
}

#[cfg(feature="rt-wasm3")]
mod wasm3;

#[derive(Clone, PartialEq, Debug)]
pub struct Config {
    
}
