
use crate::api::{types, gpio::Gpio, Error};

pub struct GpioCtx {}

impl Gpio for GpioCtx {
    /// Initialise the provided GPIO pin in input or output mode
    fn init(&mut self, port: u32, pin: u32, mode: types::Mode) -> Result<i32, Error> {
        println!("GPIO init port: {} pin: {} mode: {:?}", port, pin, mode);
        Ok(10)
    }

    /// Deinitialise the specified GPIO pin
    fn deinit(&mut self, dev: i32) -> Result<(), Error> {
        println!("GPIO deinit handle: {}", dev);
        Ok(())
    }

    /// Write to a GPIO pin
    fn write(&mut self, dev: i32, value: types::Value) -> Result<(), Error> {
        println!("GPIO write handle: {} val: {:?}", dev, value);
        Ok(())
    }

    // Read from a GPIO pin
    fn read(&mut self, dev: i32) -> Result<types::Value, Error> {
        println!("GPIO read handle: {}", dev);
        Ok(types::Value::Low)
    }
}

impl crate::api::gpio::UserErrorConversion for GpioCtx {
    fn errno_from_error(&mut self, _e: Error) -> Result<crate::api::types::Errno, wiggle::Trap> {
        // TODO: convert errors here
        unimplemented!()
    }
}

