

use crate::api::{Error, types, device::Device};

pub struct DeviceCtx {

}


impl Device for DeviceCtx {
    fn spi<'a>(&mut self, spi: &types::HandleArray<'a>) -> Result<(), Error> {
        let spi_devs = spi.ptr.as_array(spi.len);
        let mut d1 = spi_devs.as_slice_mut().unwrap();

        println!("Resource req {:?}", spi);

        for i in 0..d1.len() {
            d1[i] = i as i32;
        }

        Ok(())
    }

    fn i2c<'a>(&mut self, i2c: &types::HandleArray<'a>) -> Result<(), Error> {
        let i2c_devs = i2c.ptr.as_array(i2c.len);
        let mut d1 = i2c_devs.as_slice_mut().unwrap();

        println!("Resource req {:?}", i2c);

        for i in 0..d1.len() {
            d1[i] = i as i32 + 10;
        }

        Ok(())
    }

    fn gpio_in<'a>(&mut self, gpio: &types::HandleArray<'a>) -> Result<(), Error> {
        let gpio_devs = gpio.ptr.as_array(gpio.len);
        let mut d1 = gpio_devs.as_slice_mut().unwrap();

        println!("Resource req {:?}", gpio);

        for i in 0..d1.len() {
            d1[i] = i as i32 + 20;
        }

        Ok(())
    }

    fn gpio_out<'a>(&mut self, gpio: &types::HandleArray<'a>) -> Result<(), Error> {
        let gpio_devs = gpio.ptr.as_array(gpio.len);
        let mut d1 = gpio_devs.as_slice_mut().unwrap();

        println!("Resource req {:?}", gpio);

        for i in 0..d1.len() {
            d1[i] = i as i32 + 30;
        }

        Ok(())
    }
}

impl crate::api::spi::UserErrorConversion for DeviceCtx {
    fn errno_from_error(&mut self, _e: Error) -> Result<crate::api::types::Errno, wiggle::Trap> {
        // TODO: convert errors here
        unimplemented!()
    }
}
