
use std::ops::{Deref, DerefMut};
use wiggle::GuestPtr;

// Load WITX interface specifications
// https://docs.rs/wiggle/0.28.0/wiggle/macro.from_witx.html
wiggle::from_witx!({
    witx: [
        "./spec/common.witx", 
        "./spec/spi.witx",
        "./spec/i2c.witx",
        "./spec/gpio.witx",
        "./spec/device.witx",
    ],
    errors: { errno => Error },
});

mod i2c_api;
mod spi_api;

pub use i2c_api::I2c;
pub use spi_api::Spi;

// Error enum must correspond to witx spec
#[derive(Clone, PartialEq, Debug)]
pub enum Error {
    InvalidArg(String),
    Unexpected,
}

impl wiggle::GuestErrorType for types::Errno {
    fn success() -> Self {
        types::Errno::Ok
    }
}

