
#include "wasm_embedded/i2c.h"

static int32_t i2c_init_cxx(void *ctx, uint32_t dev, uint32_t baud, int32_t sda, int32_t scl)
{
    I2cDriver *drv = (I2cDriver *)ctx;
    return drv->init(dev, baud, sda, scl);
}

static int32_t i2c_deinit_cxx(void *ctx, int32_t handle)
{
    I2cDriver *drv = (I2cDriver *)ctx;
    return drv->deinit(handle);
}

static int32_t i2c_write_cxx(void *ctx, int32_t handle, uint16_t address, uint8_t *data_out, uint32_t length_out)
{
    I2cDriver *drv = (I2cDriver *)ctx;
    return drv->write(handle, address, data_out, length_out);
}

static int32_t i2c_read_cxx(void *ctx, int32_t handle, uint16_t address, uint8_t *data_in, uint32_t length_in)
{
    I2cDriver *drv = (I2cDriver *)ctx;
    return drv->read(handle, address, data_in, length_in);
}

static int32_t i2c_write_read_cxx(void *ctx, int32_t handle, uint16_t address,
                              uint8_t *data_out, uint32_t length_out,
                              uint8_t *data_in, uint32_t length_in)
{
    I2cDriver *drv = (I2cDriver *)ctx;
    return drv->write_read(handle, address, data_out, length_out, data_in, length_in);
}

const wasme_i2c_drv_t wasme_i2c_drv_cxx = {
    .init = i2c_init_cxx,
    .deinit = i2c_deinit_cxx,
    .write = i2c_write_cxx,
    .read = i2c_read_cxx,
    .write_read = i2c_write_read_cxx,
};
