
use std::env;
use std::path::PathBuf;

fn main() {
    println!("cargo:rerun-if-changed=src/");
    println!("cargo:rerun-if-changed=inc/");
    println!("cargo:rerun-if-changed=build.rs");

    // Setup binding generation
    let bindings = bindgen::Builder::default()
        .header("inc/wasm_embedded/core.h")
        .header("inc/wasm_embedded/i2c.h")
        .whitelist_type("wasme.*")
        .whitelist_type("i2c.*")
        .whitelist_function("WASME.*")
        .generate()
        .expect("Unable to generate bindings");

    // Write the bindings to the $OUT_DIR/bindings.rs file.
    let out_path = PathBuf::from(env::var("OUT_DIR").unwrap());
    bindings
        .write_to_file(out_path.join("bindings.rs"))
        .expect("Couldn't write bindings!");

    // Build library
    let dst = cmake::build("./");
    println!("cargo:rustc-link-search=native={}", dst.display());
    println!("cargo:rustc-link-lib=static=wasme");
    println!("cargo:rustc-link-lib=static=m3");
}
