
use wasm_embedded_hal::i2c::I2c;
use embedded_hal::blocking::i2c::*;


fn main() {
    println!("Opening I2c device");

    let mut s = I2c::init(0, 4_000_000, -1, -1).unwrap();
    let addr = 0x0a;

    println!("Write data");
    s.try_write(addr, &[0xaa, 0xbb, 0xcc]).unwrap();

    println!("Read data");
    let mut b = [0u8; 4];
    s.try_read(addr, &mut b).unwrap();
    println!("RX data: {:02x?}", b);
}
