#![allow(unused_imports)]
mod body;
mod client;
mod client_builder;
mod error;
mod into_url;
mod mime;
mod multipart;
mod request_builder;
mod response;

pub(crate) use body::*;
pub(crate) use client::*;
pub(crate) use client_builder::*;
pub(crate) use error::*;
pub(crate) use into_url::*;
pub(crate) use mime::*;
pub(crate) use multipart::*;
pub(crate) use request_builder::*;

pub use ::http;
pub use ::http::header;
pub use body::Body;
pub use client::Client;
pub use client_builder::ClientBuilder;
pub use mime::Mime;
pub use multipart::Form;
pub use request_builder::RequestBuilder;
pub use response::*;

pub const WAPM_NAME: &'static str = "os";
