// This file is automatically generated, DO NOT EDIT
//
// To regenerate this file run the `crates/witx-bindgen` command

use core::fmt;
use core::mem::MaybeUninit;
pub type Size = usize;
pub type Filesize = u64;
pub type Timestamp = u64;
#[repr(transparent)]
#[derive(Copy, Clone, Hash, Eq, PartialEq, Ord, PartialOrd)]
pub struct Clockid(u32);
/// The clock measuring real time. Time value zero corresponds with
/// 1970-01-01T00:00:00Z.
pub const CLOCKID_REALTIME: Clockid = Clockid(0);
/// The store-wide monotonic clock, which is defined as a clock measuring
/// real time, whose value cannot be adjusted and which cannot have negative
/// clock jumps. The epoch of this clock is undefined. The absolute time
/// value of this clock therefore has no meaning.
pub const CLOCKID_MONOTONIC: Clockid = Clockid(1);
/// The CPU-time clock associated with the current process.
pub const CLOCKID_PROCESS_CPUTIME_ID: Clockid = Clockid(2);
/// The CPU-time clock associated with the current thread.
pub const CLOCKID_THREAD_CPUTIME_ID: Clockid = Clockid(3);
impl Clockid {
    pub const fn raw(&self) -> u32 {
        self.0
    }

    pub fn name(&self) -> &'static str {
        match self.0 {
            0 => "REALTIME",
            1 => "MONOTONIC",
            2 => "PROCESS_CPUTIME_ID",
            3 => "THREAD_CPUTIME_ID",
            _ => unsafe { core::hint::unreachable_unchecked() },
        }
    }
    pub fn message(&self) -> &'static str {
        match self.0 {
            0 => {
                "The clock measuring real time. Time value zero corresponds with
1970-01-01T00:00:00Z."
            }
            1 => {
                "The store-wide monotonic clock, which is defined as a clock measuring
real time, whose value cannot be adjusted and which cannot have negative
clock jumps. The epoch of this clock is undefined. The absolute time
value of this clock therefore has no meaning."
            }
            2 => "The CPU-time clock associated with the current process.",
            3 => "The CPU-time clock associated with the current thread.",
            _ => unsafe { core::hint::unreachable_unchecked() },
        }
    }
}
impl fmt::Debug for Clockid {
    fn fmt(&self, f: &mut fmt::Formatter<'_>) -> fmt::Result {
        f.debug_struct("Clockid")
            .field("code", &self.0)
            .field("name", &self.name())
            .field("message", &self.message())
            .finish()
    }
}

#[repr(transparent)]
#[derive(Copy, Clone, Hash, Eq, PartialEq, Ord, PartialOrd)]
pub struct Errno(u16);
/// No error occurred. System call completed successfully.
pub const ERRNO_SUCCESS: Errno = Errno(0);
/// Argument list too long.
pub const ERRNO_2BIG: Errno = Errno(1);
/// Permission denied.
pub const ERRNO_ACCES: Errno = Errno(2);
/// Address in use.
pub const ERRNO_ADDRINUSE: Errno = Errno(3);
/// Address not available.
pub const ERRNO_ADDRNOTAVAIL: Errno = Errno(4);
/// Address family not supported.
pub const ERRNO_AFNOSUPPORT: Errno = Errno(5);
/// Resource unavailable, or operation would block.
pub const ERRNO_AGAIN: Errno = Errno(6);
/// Connection already in progress.
pub const ERRNO_ALREADY: Errno = Errno(7);
/// Bad file descriptor.
pub const ERRNO_BADF: Errno = Errno(8);
/// Bad message.
pub const ERRNO_BADMSG: Errno = Errno(9);
/// Device or resource busy.
pub const ERRNO_BUSY: Errno = Errno(10);
/// Operation canceled.
pub const ERRNO_CANCELED: Errno = Errno(11);
/// No child processes.
pub const ERRNO_CHILD: Errno = Errno(12);
/// Connection aborted.
pub const ERRNO_CONNABORTED: Errno = Errno(13);
/// Connection refused.
pub const ERRNO_CONNREFUSED: Errno = Errno(14);
/// Connection reset.
pub const ERRNO_CONNRESET: Errno = Errno(15);
/// Resource deadlock would occur.
pub const ERRNO_DEADLK: Errno = Errno(16);
/// Destination address required.
pub const ERRNO_DESTADDRREQ: Errno = Errno(17);
/// Mathematics argument out of domain of function.
pub const ERRNO_DOM: Errno = Errno(18);
/// Reserved.
pub const ERRNO_DQUOT: Errno = Errno(19);
/// File exists.
pub const ERRNO_EXIST: Errno = Errno(20);
/// Bad address.
pub const ERRNO_FAULT: Errno = Errno(21);
/// File too large.
pub const ERRNO_FBIG: Errno = Errno(22);
/// Host is unreachable.
pub const ERRNO_HOSTUNREACH: Errno = Errno(23);
/// Identifier removed.
pub const ERRNO_IDRM: Errno = Errno(24);
/// Illegal byte sequence.
pub const ERRNO_ILSEQ: Errno = Errno(25);
/// Operation in progress.
pub const ERRNO_INPROGRESS: Errno = Errno(26);
/// Interrupted function.
pub const ERRNO_INTR: Errno = Errno(27);
/// Invalid argument.
pub const ERRNO_INVAL: Errno = Errno(28);
/// I/O error.
pub const ERRNO_IO: Errno = Errno(29);
/// Socket is connected.
pub const ERRNO_ISCONN: Errno = Errno(30);
/// Is a directory.
pub const ERRNO_ISDIR: Errno = Errno(31);
/// Too many levels of symbolic links.
pub const ERRNO_LOOP: Errno = Errno(32);
/// File descriptor value too large.
pub const ERRNO_MFILE: Errno = Errno(33);
/// Too many links.
pub const ERRNO_MLINK: Errno = Errno(34);
/// Message too large.
pub const ERRNO_MSGSIZE: Errno = Errno(35);
/// Reserved.
pub const ERRNO_MULTIHOP: Errno = Errno(36);
/// Filename too long.
pub const ERRNO_NAMETOOLONG: Errno = Errno(37);
/// Network is down.
pub const ERRNO_NETDOWN: Errno = Errno(38);
/// Connection aborted by network.
pub const ERRNO_NETRESET: Errno = Errno(39);
/// Network unreachable.
pub const ERRNO_NETUNREACH: Errno = Errno(40);
/// Too many files open in system.
pub const ERRNO_NFILE: Errno = Errno(41);
/// No buffer space available.
pub const ERRNO_NOBUFS: Errno = Errno(42);
/// No such device.
pub const ERRNO_NODEV: Errno = Errno(43);
/// No such file or directory.
pub const ERRNO_NOENT: Errno = Errno(44);
/// Executable file format error.
pub const ERRNO_NOEXEC: Errno = Errno(45);
/// No locks available.
pub const ERRNO_NOLCK: Errno = Errno(46);
/// Reserved.
pub const ERRNO_NOLINK: Errno = Errno(47);
/// Not enough space.
pub const ERRNO_NOMEM: Errno = Errno(48);
/// No message of the desired type.
pub const ERRNO_NOMSG: Errno = Errno(49);
/// Protocol not available.
pub const ERRNO_NOPROTOOPT: Errno = Errno(50);
/// No space left on device.
pub const ERRNO_NOSPC: Errno = Errno(51);
/// Function not supported.
pub const ERRNO_NOSYS: Errno = Errno(52);
/// The socket is not connected.
pub const ERRNO_NOTCONN: Errno = Errno(53);
/// Not a directory or a symbolic link to a directory.
pub const ERRNO_NOTDIR: Errno = Errno(54);
/// Directory not empty.
pub const ERRNO_NOTEMPTY: Errno = Errno(55);
/// State not recoverable.
pub const ERRNO_NOTRECOVERABLE: Errno = Errno(56);
/// Not a socket.
pub const ERRNO_NOTSOCK: Errno = Errno(57);
/// Not supported, or operation not supported on socket.
pub const ERRNO_NOTSUP: Errno = Errno(58);
/// Inappropriate I/O control operation.
pub const ERRNO_NOTTY: Errno = Errno(59);
/// No such device or address.
pub const ERRNO_NXIO: Errno = Errno(60);
/// Value too large to be stored in data type.
pub const ERRNO_OVERFLOW: Errno = Errno(61);
/// Previous owner died.
pub const ERRNO_OWNERDEAD: Errno = Errno(62);
/// Operation not permitted.
pub const ERRNO_PERM: Errno = Errno(63);
/// Broken pipe.
pub const ERRNO_PIPE: Errno = Errno(64);
/// Protocol error.
pub const ERRNO_PROTO: Errno = Errno(65);
/// Protocol not supported.
pub const ERRNO_PROTONOSUPPORT: Errno = Errno(66);
/// Protocol wrong type for socket.
pub const ERRNO_PROTOTYPE: Errno = Errno(67);
/// Result too large.
pub const ERRNO_RANGE: Errno = Errno(68);
/// Read-only file system.
pub const ERRNO_ROFS: Errno = Errno(69);
/// Invalid seek.
pub const ERRNO_SPIPE: Errno = Errno(70);
/// No such process.
pub const ERRNO_SRCH: Errno = Errno(71);
/// Reserved.
pub const ERRNO_STALE: Errno = Errno(72);
/// Connection timed out.
pub const ERRNO_TIMEDOUT: Errno = Errno(73);
/// Text file busy.
pub const ERRNO_TXTBSY: Errno = Errno(74);
/// Cross-device link.
pub const ERRNO_XDEV: Errno = Errno(75);
/// Extension: Capabilities insufficient.
pub const ERRNO_NOTCAPABLE: Errno = Errno(76);
impl Errno {
    pub const fn raw(&self) -> u16 {
        self.0
    }

    pub fn name(&self) -> &'static str {
        match self.0 {
            0 => "SUCCESS",
            1 => "2BIG",
            2 => "ACCES",
            3 => "ADDRINUSE",
            4 => "ADDRNOTAVAIL",
            5 => "AFNOSUPPORT",
            6 => "AGAIN",
            7 => "ALREADY",
            8 => "BADF",
            9 => "BADMSG",
            10 => "BUSY",
            11 => "CANCELED",
            12 => "CHILD",
            13 => "CONNABORTED",
            14 => "CONNREFUSED",
            15 => "CONNRESET",
            16 => "DEADLK",
            17 => "DESTADDRREQ",
            18 => "DOM",
            19 => "DQUOT",
            20 => "EXIST",
            21 => "FAULT",
            22 => "FBIG",
            23 => "HOSTUNREACH",
            24 => "IDRM",
            25 => "ILSEQ",
            26 => "INPROGRESS",
            27 => "INTR",
            28 => "INVAL",
            29 => "IO",
            30 => "ISCONN",
            31 => "ISDIR",
            32 => "LOOP",
            33 => "MFILE",
            34 => "MLINK",
            35 => "MSGSIZE",
            36 => "MULTIHOP",
            37 => "NAMETOOLONG",
            38 => "NETDOWN",
            39 => "NETRESET",
            40 => "NETUNREACH",
            41 => "NFILE",
            42 => "NOBUFS",
            43 => "NODEV",
            44 => "NOENT",
            45 => "NOEXEC",
            46 => "NOLCK",
            47 => "NOLINK",
            48 => "NOMEM",
            49 => "NOMSG",
            50 => "NOPROTOOPT",
            51 => "NOSPC",
            52 => "NOSYS",
            53 => "NOTCONN",
            54 => "NOTDIR",
            55 => "NOTEMPTY",
            56 => "NOTRECOVERABLE",
            57 => "NOTSOCK",
            58 => "NOTSUP",
            59 => "NOTTY",
            60 => "NXIO",
            61 => "OVERFLOW",
            62 => "OWNERDEAD",
            63 => "PERM",
            64 => "PIPE",
            65 => "PROTO",
            66 => "PROTONOSUPPORT",
            67 => "PROTOTYPE",
            68 => "RANGE",
            69 => "ROFS",
            70 => "SPIPE",
            71 => "SRCH",
            72 => "STALE",
            73 => "TIMEDOUT",
            74 => "TXTBSY",
            75 => "XDEV",
            76 => "NOTCAPABLE",
            _ => unsafe { core::hint::unreachable_unchecked() },
        }
    }
    pub fn message(&self) -> &'static str {
        match self.0 {
            0 => "No error occurred. System call completed successfully.",
            1 => "Argument list too long.",
            2 => "Permission denied.",
            3 => "Address in use.",
            4 => "Address not available.",
            5 => "Address family not supported.",
            6 => "Resource unavailable, or operation would block.",
            7 => "Connection already in progress.",
            8 => "Bad file descriptor.",
            9 => "Bad message.",
            10 => "Device or resource busy.",
            11 => "Operation canceled.",
            12 => "No child processes.",
            13 => "Connection aborted.",
            14 => "Connection refused.",
            15 => "Connection reset.",
            16 => "Resource deadlock would occur.",
            17 => "Destination address required.",
            18 => "Mathematics argument out of domain of function.",
            19 => "Reserved.",
            20 => "File exists.",
            21 => "Bad address.",
            22 => "File too large.",
            23 => "Host is unreachable.",
            24 => "Identifier removed.",
            25 => "Illegal byte sequence.",
            26 => "Operation in progress.",
            27 => "Interrupted function.",
            28 => "Invalid argument.",
            29 => "I/O error.",
            30 => "Socket is connected.",
            31 => "Is a directory.",
            32 => "Too many levels of symbolic links.",
            33 => "File descriptor value too large.",
            34 => "Too many links.",
            35 => "Message too large.",
            36 => "Reserved.",
            37 => "Filename too long.",
            38 => "Network is down.",
            39 => "Connection aborted by network.",
            40 => "Network unreachable.",
            41 => "Too many files open in system.",
            42 => "No buffer space available.",
            43 => "No such device.",
            44 => "No such file or directory.",
            45 => "Executable file format error.",
            46 => "No locks available.",
            47 => "Reserved.",
            48 => "Not enough space.",
            49 => "No message of the desired type.",
            50 => "Protocol not available.",
            51 => "No space left on device.",
            52 => "Function not supported.",
            53 => "The socket is not connected.",
            54 => "Not a directory or a symbolic link to a directory.",
            55 => "Directory not empty.",
            56 => "State not recoverable.",
            57 => "Not a socket.",
            58 => "Not supported, or operation not supported on socket.",
            59 => "Inappropriate I/O control operation.",
            60 => "No such device or address.",
            61 => "Value too large to be stored in data type.",
            62 => "Previous owner died.",
            63 => "Operation not permitted.",
            64 => "Broken pipe.",
            65 => "Protocol error.",
            66 => "Protocol not supported.",
            67 => "Protocol wrong type for socket.",
            68 => "Result too large.",
            69 => "Read-only file system.",
            70 => "Invalid seek.",
            71 => "No such process.",
            72 => "Reserved.",
            73 => "Connection timed out.",
            74 => "Text file busy.",
            75 => "Cross-device link.",
            76 => "Extension: Capabilities insufficient.",
            _ => unsafe { core::hint::unreachable_unchecked() },
        }
    }
}
impl fmt::Debug for Errno {
    fn fmt(&self, f: &mut fmt::Formatter<'_>) -> fmt::Result {
        f.debug_struct("Errno")
            .field("code", &self.0)
            .field("name", &self.name())
            .field("message", &self.message())
            .finish()
    }
}
impl fmt::Display for Errno {
    fn fmt(&self, f: &mut fmt::Formatter<'_>) -> fmt::Result {
        write!(f, "{} (error {})", self.name(), self.0)
    }
}

#[cfg(feature = "std")]
extern crate std;
#[cfg(feature = "std")]
impl std::error::Error for Errno {}

pub type Rights = u64;
/// The right to invoke `fd_datasync`.
/// If `path_open` is set, includes the right to invoke
/// `path_open` with `fdflags::dsync`.
pub const RIGHTS_FD_DATASYNC: Rights = 1 << 0;
/// The right to invoke `fd_read` and `sock_recv`.
/// If `rights::fd_seek` is set, includes the right to invoke `fd_pread`.
pub const RIGHTS_FD_READ: Rights = 1 << 1;
/// The right to invoke `fd_seek`. This flag implies `rights::fd_tell`.
pub const RIGHTS_FD_SEEK: Rights = 1 << 2;
/// The right to invoke `fd_fdstat_set_flags`.
pub const RIGHTS_FD_FDSTAT_SET_FLAGS: Rights = 1 << 3;
/// The right to invoke `fd_sync`.
/// If `path_open` is set, includes the right to invoke
/// `path_open` with `fdflags::rsync` and `fdflags::dsync`.
pub const RIGHTS_FD_SYNC: Rights = 1 << 4;
/// The right to invoke `fd_seek` in such a way that the file offset
/// remains unaltered (i.e., `whence::cur` with offset zero), or to
/// invoke `fd_tell`.
pub const RIGHTS_FD_TELL: Rights = 1 << 5;
/// The right to invoke `fd_write` and `sock_send`.
/// If `rights::fd_seek` is set, includes the right to invoke `fd_pwrite`.
pub const RIGHTS_FD_WRITE: Rights = 1 << 6;
/// The right to invoke `fd_advise`.
pub const RIGHTS_FD_ADVISE: Rights = 1 << 7;
/// The right to invoke `fd_allocate`.
pub const RIGHTS_FD_ALLOCATE: Rights = 1 << 8;
/// The right to invoke `path_create_directory`.
pub const RIGHTS_PATH_CREATE_DIRECTORY: Rights = 1 << 9;
/// If `path_open` is set, the right to invoke `path_open` with `oflags::creat`.
pub const RIGHTS_PATH_CREATE_FILE: Rights = 1 << 10;
/// The right to invoke `path_link` with the file descriptor as the
/// source directory.
pub const RIGHTS_PATH_LINK_SOURCE: Rights = 1 << 11;
/// The right to invoke `path_link` with the file descriptor as the
/// target directory.
pub const RIGHTS_PATH_LINK_TARGET: Rights = 1 << 12;
/// The right to invoke `path_open`.
pub const RIGHTS_PATH_OPEN: Rights = 1 << 13;
/// The right to invoke `fd_readdir`.
pub const RIGHTS_FD_READDIR: Rights = 1 << 14;
/// The right to invoke `path_readlink`.
pub const RIGHTS_PATH_READLINK: Rights = 1 << 15;
/// The right to invoke `path_rename` with the file descriptor as the source directory.
pub const RIGHTS_PATH_RENAME_SOURCE: Rights = 1 << 16;
/// The right to invoke `path_rename` with the file descriptor as the target directory.
pub const RIGHTS_PATH_RENAME_TARGET: Rights = 1 << 17;
/// The right to invoke `path_filestat_get`.
pub const RIGHTS_PATH_FILESTAT_GET: Rights = 1 << 18;
/// The right to change a file's size (there is no `path_filestat_set_size`).
/// If `path_open` is set, includes the right to invoke `path_open` with `oflags::trunc`.
pub const RIGHTS_PATH_FILESTAT_SET_SIZE: Rights = 1 << 19;
/// The right to invoke `path_filestat_set_times`.
pub const RIGHTS_PATH_FILESTAT_SET_TIMES: Rights = 1 << 20;
/// The right to invoke `fd_filestat_get`.
pub const RIGHTS_FD_FILESTAT_GET: Rights = 1 << 21;
/// The right to invoke `fd_filestat_set_size`.
pub const RIGHTS_FD_FILESTAT_SET_SIZE: Rights = 1 << 22;
/// The right to invoke `fd_filestat_set_times`.
pub const RIGHTS_FD_FILESTAT_SET_TIMES: Rights = 1 << 23;
/// The right to invoke `path_symlink`.
pub const RIGHTS_PATH_SYMLINK: Rights = 1 << 24;
/// The right to invoke `path_remove_directory`.
pub const RIGHTS_PATH_REMOVE_DIRECTORY: Rights = 1 << 25;
/// The right to invoke `path_unlink_file`.
pub const RIGHTS_PATH_UNLINK_FILE: Rights = 1 << 26;
/// If `rights::fd_read` is set, includes the right to invoke `poll_oneoff` to subscribe to `eventtype::fd_read`.
/// If `rights::fd_write` is set, includes the right to invoke `poll_oneoff` to subscribe to `eventtype::fd_write`.
pub const RIGHTS_POLL_FD_READWRITE: Rights = 1 << 27;
/// The right to invoke `sock_shutdown`.
pub const RIGHTS_SOCK_SHUTDOWN: Rights = 1 << 28;
/// Connect to an address
pub const RIGHTS_SOCK_CONNECT: Rights = 1 << 29;
/// Listen for incoming connection on an address
pub const RIGHTS_SOCK_LISTEN: Rights = 1 << 30;
/// Bind an address to a socket
pub const RIGHTS_SOCK_BIND: Rights = 1 << 31;
/// Accept incoming connection
pub const RIGHTS_SOCK_ACCEPT: Rights = 1 << 32;
/// Receive data on a socket
pub const RIGHTS_SOCK_RECV: Rights = 1 << 33;
/// Send data on a socket
pub const RIGHTS_SOCK_SEND: Rights = 1 << 34;
/// Retrieve locally bound address on a socket
pub const RIGHTS_SOCK_ADDR_LOCAL: Rights = 1 << 35;
/// Retrieve remote address on a socket
pub const RIGHTS_SOCK_ADDR_REMOTE: Rights = 1 << 36;
/// Receive datagram on a socket
pub const RIGHTS_SOCK_RECV_FROM: Rights = 1 << 37;
/// Send datagram on a socket
pub const RIGHTS_SOCK_SEND_TO: Rights = 1 << 38;

pub type BufArray<'a> = &'a [u8];
#[repr(transparent)]
#[derive(Copy, Clone, Hash, Eq, PartialEq, Ord, PartialOrd)]
pub struct Option(u8);
pub const OPTION_NONE: Option = Option(0);
pub const OPTION_SOME: Option = Option(1);
impl Option {
    pub const fn raw(&self) -> u8 {
        self.0
    }

    pub fn name(&self) -> &'static str {
        match self.0 {
            0 => "NONE",
            1 => "SOME",
            _ => unsafe { core::hint::unreachable_unchecked() },
        }
    }
    pub fn message(&self) -> &'static str {
        match self.0 {
            0 => "",
            1 => "",
            _ => unsafe { core::hint::unreachable_unchecked() },
        }
    }
}
impl fmt::Debug for Option {
    fn fmt(&self, f: &mut fmt::Formatter<'_>) -> fmt::Result {
        f.debug_struct("Option")
            .field("code", &self.0)
            .field("name", &self.name())
            .field("message", &self.message())
            .finish()
    }
}

#[repr(C)]
#[derive(Copy, Clone)]
pub union OptionTimestampU {
    pub none: u8,
    pub some: Timestamp,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct OptionTimestamp {
    pub tag: u8,
    pub u: OptionTimestampU,
}

pub type Fd = u32;
pub type Pid = u32;
pub type Tid = u32;
pub type Bid = u32;
#[repr(C)]
#[derive(Copy, Clone)]
pub union OptionBidU {
    pub none: u8,
    pub some: Bid,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct OptionBid {
    pub tag: u8,
    pub u: OptionBidU,
}

pub type Cid = u32;
#[repr(C)]
#[derive(Copy, Clone)]
pub union OptionCidU {
    pub none: u8,
    pub some: Cid,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct OptionCid {
    pub tag: u8,
    pub u: OptionCidU,
}

#[repr(transparent)]
#[derive(Copy, Clone, Hash, Eq, PartialEq, Ord, PartialOrd)]
pub struct Bool(u8);
pub const BOOL_FALSE: Bool = Bool(0);
pub const BOOL_TRUE: Bool = Bool(1);
impl Bool {
    pub const fn raw(&self) -> u8 {
        self.0
    }

    pub fn name(&self) -> &'static str {
        match self.0 {
            0 => "FALSE",
            1 => "TRUE",
            _ => unsafe { core::hint::unreachable_unchecked() },
        }
    }
    pub fn message(&self) -> &'static str {
        match self.0 {
            0 => "",
            1 => "",
            _ => unsafe { core::hint::unreachable_unchecked() },
        }
    }
}
impl fmt::Debug for Bool {
    fn fmt(&self, f: &mut fmt::Formatter<'_>) -> fmt::Result {
        f.debug_struct("Bool")
            .field("code", &self.0)
            .field("name", &self.name())
            .field("message", &self.message())
            .finish()
    }
}

#[repr(C)]
#[derive(Copy, Clone, Debug)]
pub struct Iovec {
    /// The address of the buffer to be filled.
    pub buf: *mut u8,
    /// The length of the buffer to be filled.
    pub buf_len: Size,
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
pub struct Ciovec {
    /// The address of the buffer to be written.
    pub buf: *const u8,
    /// The length of the buffer to be written.
    pub buf_len: Size,
}
pub type IovecArray<'a> = &'a [Iovec];
pub type CiovecArray<'a> = &'a [Ciovec];
pub type Filedelta = i64;
#[repr(transparent)]
#[derive(Copy, Clone, Hash, Eq, PartialEq, Ord, PartialOrd)]
pub struct Whence(u8);
/// Seek relative to start-of-file.
pub const WHENCE_SET: Whence = Whence(0);
/// Seek relative to current position.
pub const WHENCE_CUR: Whence = Whence(1);
/// Seek relative to end-of-file.
pub const WHENCE_END: Whence = Whence(2);
impl Whence {
    pub const fn raw(&self) -> u8 {
        self.0
    }

    pub fn name(&self) -> &'static str {
        match self.0 {
            0 => "SET",
            1 => "CUR",
            2 => "END",
            _ => unsafe { core::hint::unreachable_unchecked() },
        }
    }
    pub fn message(&self) -> &'static str {
        match self.0 {
            0 => "Seek relative to start-of-file.",
            1 => "Seek relative to current position.",
            2 => "Seek relative to end-of-file.",
            _ => unsafe { core::hint::unreachable_unchecked() },
        }
    }
}
impl fmt::Debug for Whence {
    fn fmt(&self, f: &mut fmt::Formatter<'_>) -> fmt::Result {
        f.debug_struct("Whence")
            .field("code", &self.0)
            .field("name", &self.name())
            .field("message", &self.message())
            .finish()
    }
}

pub type Dircookie = u64;
pub type Dirnamlen = u32;
pub type Inode = u64;
#[repr(transparent)]
#[derive(Copy, Clone, Hash, Eq, PartialEq, Ord, PartialOrd)]
pub struct Filetype(u8);
/// The type of the file descriptor or file is unknown or is different from any of the other types specified.
pub const FILETYPE_UNKNOWN: Filetype = Filetype(0);
/// The file descriptor or file refers to a block device inode.
pub const FILETYPE_BLOCK_DEVICE: Filetype = Filetype(1);
/// The file descriptor or file refers to a character device inode.
pub const FILETYPE_CHARACTER_DEVICE: Filetype = Filetype(2);
/// The file descriptor or file refers to a directory inode.
pub const FILETYPE_DIRECTORY: Filetype = Filetype(3);
/// The file descriptor or file refers to a regular file inode.
pub const FILETYPE_REGULAR_FILE: Filetype = Filetype(4);
/// The file descriptor or file refers to a datagram socket.
pub const FILETYPE_SOCKET_DGRAM: Filetype = Filetype(5);
/// The file descriptor or file refers to a byte-stream socket.
pub const FILETYPE_SOCKET_STREAM: Filetype = Filetype(6);
/// The file refers to a symbolic link inode.
pub const FILETYPE_SYMBOLIC_LINK: Filetype = Filetype(7);
impl Filetype {
    pub const fn raw(&self) -> u8 {
        self.0
    }

    pub fn name(&self) -> &'static str {
        match self.0 {
            0 => "UNKNOWN",
            1 => "BLOCK_DEVICE",
            2 => "CHARACTER_DEVICE",
            3 => "DIRECTORY",
            4 => "REGULAR_FILE",
            5 => "SOCKET_DGRAM",
            6 => "SOCKET_STREAM",
            7 => "SYMBOLIC_LINK",
            _ => unsafe { core::hint::unreachable_unchecked() },
        }
    }
    pub fn message(&self) -> &'static str {
        match self.0 {0 => "The type of the file descriptor or file is unknown or is different from any of the other types specified.",1 => "The file descriptor or file refers to a block device inode.",2 => "The file descriptor or file refers to a character device inode.",3 => "The file descriptor or file refers to a directory inode.",4 => "The file descriptor or file refers to a regular file inode.",5 => "The file descriptor or file refers to a datagram socket.",6 => "The file descriptor or file refers to a byte-stream socket.",7 => "The file refers to a symbolic link inode.",_ => unsafe { core::hint::unreachable_unchecked() },}
    }
}
impl fmt::Debug for Filetype {
    fn fmt(&self, f: &mut fmt::Formatter<'_>) -> fmt::Result {
        f.debug_struct("Filetype")
            .field("code", &self.0)
            .field("name", &self.name())
            .field("message", &self.message())
            .finish()
    }
}

#[repr(C)]
#[derive(Copy, Clone, Debug)]
pub struct Dirent {
    /// The offset of the next directory entry stored in this directory.
    pub d_next: Dircookie,
    /// The serial number of the file referred to by this directory entry.
    pub d_ino: Inode,
    /// The length of the name of the directory entry.
    pub d_namlen: Dirnamlen,
    /// The type of the file referred to by this directory entry.
    pub d_type: Filetype,
}
#[repr(transparent)]
#[derive(Copy, Clone, Hash, Eq, PartialEq, Ord, PartialOrd)]
pub struct Advice(u8);
/// The application has no advice to give on its behavior with respect to the specified data.
pub const ADVICE_NORMAL: Advice = Advice(0);
/// The application expects to access the specified data sequentially from lower offsets to higher offsets.
pub const ADVICE_SEQUENTIAL: Advice = Advice(1);
/// The application expects to access the specified data in a random order.
pub const ADVICE_RANDOM: Advice = Advice(2);
/// The application expects to access the specified data in the near future.
pub const ADVICE_WILLNEED: Advice = Advice(3);
/// The application expects that it will not access the specified data in the near future.
pub const ADVICE_DONTNEED: Advice = Advice(4);
/// The application expects to access the specified data once and then not reuse it thereafter.
pub const ADVICE_NOREUSE: Advice = Advice(5);
impl Advice {
    pub const fn raw(&self) -> u8 {
        self.0
    }

    pub fn name(&self) -> &'static str {
        match self.0 {
            0 => "NORMAL",
            1 => "SEQUENTIAL",
            2 => "RANDOM",
            3 => "WILLNEED",
            4 => "DONTNEED",
            5 => "NOREUSE",
            _ => unsafe { core::hint::unreachable_unchecked() },
        }
    }
    pub fn message(&self) -> &'static str {
        match self.0 {0 => "The application has no advice to give on its behavior with respect to the specified data.",1 => "The application expects to access the specified data sequentially from lower offsets to higher offsets.",2 => "The application expects to access the specified data in a random order.",3 => "The application expects to access the specified data in the near future.",4 => "The application expects that it will not access the specified data in the near future.",5 => "The application expects to access the specified data once and then not reuse it thereafter.",_ => unsafe { core::hint::unreachable_unchecked() },}
    }
}
impl fmt::Debug for Advice {
    fn fmt(&self, f: &mut fmt::Formatter<'_>) -> fmt::Result {
        f.debug_struct("Advice")
            .field("code", &self.0)
            .field("name", &self.name())
            .field("message", &self.message())
            .finish()
    }
}

pub type Fdflags = u16;
/// Append mode: Data written to the file is always appended to the file's end.
pub const FDFLAGS_APPEND: Fdflags = 1 << 0;
/// Write according to synchronized I/O data integrity completion. Only the data stored in the file is synchronized.
pub const FDFLAGS_DSYNC: Fdflags = 1 << 1;
/// Non-blocking mode.
pub const FDFLAGS_NONBLOCK: Fdflags = 1 << 2;
/// Synchronized read I/O operations.
pub const FDFLAGS_RSYNC: Fdflags = 1 << 3;
/// Write according to synchronized I/O file integrity completion. In
/// addition to synchronizing the data stored in the file, the implementation
/// may also synchronously update the file's metadata.
pub const FDFLAGS_SYNC: Fdflags = 1 << 4;

#[repr(C)]
#[derive(Copy, Clone, Debug)]
pub struct Fdstat {
    /// File type.
    pub fs_filetype: Filetype,
    /// File descriptor flags.
    pub fs_flags: Fdflags,
    /// Rights that apply to this file descriptor.
    pub fs_rights_base: Rights,
    /// Maximum set of rights that may be installed on new file descriptors that
    /// are created through this file descriptor, e.g., through `path_open`.
    pub fs_rights_inheriting: Rights,
}
pub type Device = u64;
pub type Fstflags = u16;
/// Adjust the last data access timestamp to the value stored in `filestat::atim`.
pub const FSTFLAGS_ATIM: Fstflags = 1 << 0;
/// Adjust the last data access timestamp to the time of clock `clockid::realtime`.
pub const FSTFLAGS_ATIM_NOW: Fstflags = 1 << 1;
/// Adjust the last data modification timestamp to the value stored in `filestat::mtim`.
pub const FSTFLAGS_MTIM: Fstflags = 1 << 2;
/// Adjust the last data modification timestamp to the time of clock `clockid::realtime`.
pub const FSTFLAGS_MTIM_NOW: Fstflags = 1 << 3;

pub type Lookupflags = u32;
/// As long as the resolved path corresponds to a symbolic link, it is expanded.
pub const LOOKUPFLAGS_SYMLINK_FOLLOW: Lookupflags = 1 << 0;

pub type Oflags = u16;
/// Create file if it does not exist.
pub const OFLAGS_CREAT: Oflags = 1 << 0;
/// Fail if not a directory.
pub const OFLAGS_DIRECTORY: Oflags = 1 << 1;
/// Fail if file already exists.
pub const OFLAGS_EXCL: Oflags = 1 << 2;
/// Truncate file to size 0.
pub const OFLAGS_TRUNC: Oflags = 1 << 3;

pub type Linkcount = u64;
#[repr(C)]
#[derive(Copy, Clone, Debug)]
pub struct Filestat {
    /// Device ID of device containing the file.
    pub dev: Device,
    /// File serial number.
    pub ino: Inode,
    /// File type.
    pub filetype: Filetype,
    /// Number of hard links to the file.
    pub nlink: Linkcount,
    /// For regular files, the file size in bytes. For symbolic links, the length in bytes of the pathname contained in the symbolic link.
    pub size: Filesize,
    /// Last data access timestamp.
    pub atim: Timestamp,
    /// Last data modification timestamp.
    pub mtim: Timestamp,
    /// Last file status change timestamp.
    pub ctim: Timestamp,
}
pub type Userdata = u64;
#[repr(transparent)]
#[derive(Copy, Clone, Hash, Eq, PartialEq, Ord, PartialOrd)]
pub struct Eventtype(u8);
/// The time value of clock `subscription_clock::id` has
/// reached timestamp `subscription_clock::timeout`.
pub const EVENTTYPE_CLOCK: Eventtype = Eventtype(0);
/// File descriptor `subscription_fd_readwrite::file_descriptor` has data
/// available for reading. This event always triggers for regular files.
pub const EVENTTYPE_FD_READ: Eventtype = Eventtype(1);
/// File descriptor `subscription_fd_readwrite::file_descriptor` has capacity
/// available for writing. This event always triggers for regular files.
pub const EVENTTYPE_FD_WRITE: Eventtype = Eventtype(2);
impl Eventtype {
    pub const fn raw(&self) -> u8 {
        self.0
    }

    pub fn name(&self) -> &'static str {
        match self.0 {
            0 => "CLOCK",
            1 => "FD_READ",
            2 => "FD_WRITE",
            _ => unsafe { core::hint::unreachable_unchecked() },
        }
    }
    pub fn message(&self) -> &'static str {
        match self.0 {
            0 => {
                "The time value of clock `subscription_clock::id` has
reached timestamp `subscription_clock::timeout`."
            }
            1 => {
                "File descriptor `subscription_fd_readwrite::file_descriptor` has data
available for reading. This event always triggers for regular files."
            }
            2 => {
                "File descriptor `subscription_fd_readwrite::file_descriptor` has capacity
available for writing. This event always triggers for regular files."
            }
            _ => unsafe { core::hint::unreachable_unchecked() },
        }
    }
}
impl fmt::Debug for Eventtype {
    fn fmt(&self, f: &mut fmt::Formatter<'_>) -> fmt::Result {
        f.debug_struct("Eventtype")
            .field("code", &self.0)
            .field("name", &self.name())
            .field("message", &self.message())
            .finish()
    }
}

pub type Eventrwflags = u16;
/// The peer of this socket has closed or disconnected.
pub const EVENTRWFLAGS_FD_READWRITE_HANGUP: Eventrwflags = 1 << 0;

#[repr(C)]
#[derive(Copy, Clone, Debug)]
pub struct EventFdReadwrite {
    /// The number of bytes available for reading or writing.
    pub nbytes: Filesize,
    /// The state of the file descriptor.
    pub flags: Eventrwflags,
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
pub struct Event {
    /// User-provided value that got attached to `subscription::userdata`.
    pub userdata: Userdata,
    /// If non-zero, an error that occurred while processing the subscription request.
    pub error: Errno,
    /// The type of event that occured
    pub type_: Eventtype,
    /// The contents of the event, if it is an `eventtype::fd_read` or
    /// `eventtype::fd_write`. `eventtype::clock` events ignore this field.
    pub fd_readwrite: EventFdReadwrite,
}
pub type Subclockflags = u16;
/// If set, treat the timestamp provided in
/// `subscription_clock::timeout` as an absolute timestamp of clock
/// `subscription_clock::id`. If clear, treat the timestamp
/// provided in `subscription_clock::timeout` relative to the
/// current time value of clock `subscription_clock::id`.
pub const SUBCLOCKFLAGS_SUBSCRIPTION_CLOCK_ABSTIME: Subclockflags = 1 << 0;

#[repr(C)]
#[derive(Copy, Clone, Debug)]
pub struct SubscriptionClock {
    /// The clock against which to compare the timestamp.
    pub id: Clockid,
    /// The absolute or relative timestamp.
    pub timeout: Timestamp,
    /// The amount of time that the implementation may wait additionally
    /// to coalesce with other events.
    pub precision: Timestamp,
    /// Flags specifying whether the timeout is absolute or relative
    pub flags: Subclockflags,
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
pub struct SubscriptionFdReadwrite {
    /// The file descriptor on which to wait for it to become ready for reading or writing.
    pub file_descriptor: Fd,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union SubscriptionUU {
    pub clock: SubscriptionClock,
    pub fd_read: SubscriptionFdReadwrite,
    pub fd_write: SubscriptionFdReadwrite,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct SubscriptionU {
    pub tag: u8,
    pub u: SubscriptionUU,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct Subscription {
    /// User-provided value that is attached to the subscription in the
    /// implementation and returned through `event::userdata`.
    pub userdata: Userdata,
    /// The type of the event to which to subscribe, and its contents
    pub u: SubscriptionU,
}
pub type Exitcode = u32;
#[repr(C)]
#[derive(Copy, Clone, Debug)]
pub struct Rect {
    /// Number of columns
    pub cols: u32,
    /// Number of rows
    pub rows: u32,
    /// Width of the screen in pixels
    pub width: u32,
    /// Height of the screen in pixels
    pub height: u32,
}
#[repr(transparent)]
#[derive(Copy, Clone, Hash, Eq, PartialEq, Ord, PartialOrd)]
pub struct BusError(u32);
/// operation successful
pub const BUS_ERROR_SUCCESS: BusError = BusError(0);
/// there was an error while serializing the request or response.
pub const BUS_ERROR_SERIALIZATION: BusError = BusError(1);
/// there was an error while deserializing the request or response.
pub const BUS_ERROR_DESERIALIZATION: BusError = BusError(2);
/// the specified WAPM module does not exist.
pub const BUS_ERROR_INVALID_WAPM: BusError = BusError(3);
/// failed to fetch the WAPM module.
pub const BUS_ERROR_FETCH_WAPM: BusError = BusError(4);
/// failed to compile the WAPM module.
pub const BUS_ERROR_COMPILE_ERROR: BusError = BusError(5);
/// the ABI is invalid for cross module calls.
pub const BUS_ERROR_INVALID_ABI: BusError = BusError(6);
/// the request has been aborted.
pub const BUS_ERROR_ABORTED: BusError = BusError(7);
/// the handle is not valid.
pub const BUS_ERROR_INVALID_HANDLE: BusError = BusError(8);
pub const BUS_ERROR_INVALID_TOPIC: BusError = BusError(9);
/// some mandatory callbacks were not registered.
pub const BUS_ERROR_MISSING_CALLBACK: BusError = BusError(10);
/// this operation is not supported on this platform.
pub const BUS_ERROR_UNSUPPORTED: BusError = BusError(11);
/// invalid input was supplied in the call resulting in a bad request.
pub const BUS_ERROR_BAD_REQUEST: BusError = BusError(12);
/// access denied
pub const BUS_ERROR_ACCESS_DENIED: BusError = BusError(13);
/// an internal failure has occured
pub const BUS_ERROR_INTERNAL_FAILURE: BusError = BusError(14);
/// memory allocation has failed
pub const BUS_ERROR_MEMORY_ALLOCATION_FAILED: BusError = BusError(15);
/// bus invocation has failed
pub const BUS_ERROR_BUS_INVOCATION_FAILED: BusError = BusError(16);
/// result already consumed
pub const BUS_ERROR_ALREADY_CONSUMED: BusError = BusError(17);
/// memory access violation
pub const BUS_ERROR_MEMORY_ACCESS_VIOLATION: BusError = BusError(18);
/// unknown error
pub const BUS_ERROR_UNKNOWN_ERROR: BusError = BusError(19);
impl BusError {
    pub const fn raw(&self) -> u32 {
        self.0
    }

    pub fn name(&self) -> &'static str {
        match self.0 {
            0 => "SUCCESS",
            1 => "SERIALIZATION",
            2 => "DESERIALIZATION",
            3 => "INVALID_WAPM",
            4 => "FETCH_WAPM",
            5 => "COMPILE_ERROR",
            6 => "INVALID_ABI",
            7 => "ABORTED",
            8 => "INVALID_HANDLE",
            9 => "INVALID_TOPIC",
            10 => "MISSING_CALLBACK",
            11 => "UNSUPPORTED",
            12 => "BAD_REQUEST",
            13 => "ACCESS_DENIED",
            14 => "INTERNAL_FAILURE",
            15 => "MEMORY_ALLOCATION_FAILED",
            16 => "BUS_INVOCATION_FAILED",
            17 => "ALREADY_CONSUMED",
            18 => "MEMORY_ACCESS_VIOLATION",
            19 => "UNKNOWN_ERROR",
            _ => unsafe { core::hint::unreachable_unchecked() },
        }
    }
    pub fn message(&self) -> &'static str {
        match self.0 {
            0 => "operation successful",
            1 => "there was an error while serializing the request or response.",
            2 => "there was an error while deserializing the request or response.",
            3 => "the specified WAPM module does not exist.",
            4 => "failed to fetch the WAPM module.",
            5 => "failed to compile the WAPM module.",
            6 => "the ABI is invalid for cross module calls.",
            7 => "the request has been aborted.",
            8 => "the handle is not valid.",
            9 => "",
            10 => "some mandatory callbacks were not registered.",
            11 => "this operation is not supported on this platform.",
            12 => "invalid input was supplied in the call resulting in a bad request.",
            13 => "access denied",
            14 => "an internal failure has occured",
            15 => "memory allocation has failed",
            16 => "bus invocation has failed",
            17 => "result already consumed",
            18 => "memory access violation",
            19 => "unknown error",
            _ => unsafe { core::hint::unreachable_unchecked() },
        }
    }
}
impl fmt::Debug for BusError {
    fn fmt(&self, f: &mut fmt::Formatter<'_>) -> fmt::Result {
        f.debug_struct("BusError")
            .field("code", &self.0)
            .field("name", &self.name())
            .field("message", &self.message())
            .finish()
    }
}

#[repr(C)]
#[derive(Copy, Clone, Debug)]
pub struct PipeHandles {
    /// File handle for data on one side of the pipe
    pub pipe: Fd,
    /// File handle for data on the other side of hte pipe
    pub other: Fd,
}
#[repr(transparent)]
#[derive(Copy, Clone, Hash, Eq, PartialEq, Ord, PartialOrd)]
pub struct StdioMode(u8);
/// The stdio will be piped
pub const STDIO_MODE_PIPED: StdioMode = StdioMode(0);
/// The stdio will inherit from its parent
pub const STDIO_MODE_INHERIT: StdioMode = StdioMode(1);
/// The stdio will be dumped to null
pub const STDIO_MODE_NULL: StdioMode = StdioMode(2);
/// The stdio will be written to the log file
pub const STDIO_MODE_LOG: StdioMode = StdioMode(3);
impl StdioMode {
    pub const fn raw(&self) -> u8 {
        self.0
    }

    pub fn name(&self) -> &'static str {
        match self.0 {
            0 => "PIPED",
            1 => "INHERIT",
            2 => "NULL",
            3 => "LOG",
            _ => unsafe { core::hint::unreachable_unchecked() },
        }
    }
    pub fn message(&self) -> &'static str {
        match self.0 {
            0 => "The stdio will be piped",
            1 => "The stdio will inherit from its parent",
            2 => "The stdio will be dumped to null",
            3 => "The stdio will be written to the log file",
            _ => unsafe { core::hint::unreachable_unchecked() },
        }
    }
}
impl fmt::Debug for StdioMode {
    fn fmt(&self, f: &mut fmt::Formatter<'_>) -> fmt::Result {
        f.debug_struct("StdioMode")
            .field("code", &self.0)
            .field("name", &self.name())
            .field("message", &self.message())
            .finish()
    }
}

#[repr(C)]
#[derive(Copy, Clone, Debug)]
pub struct BusHandles {
    /// Handle of the bus process
    pub handle: Bid,
    /// File handle for STDIN
    pub stdin: Fd,
    /// File handle for STDOUT
    pub stdout: Fd,
    /// File handle for STDERR
    pub stderr: Fd,
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
pub struct BusEventExit {
    /// Exit code of the bus process that has exited
    pub rval: Exitcode,
}
#[repr(transparent)]
#[derive(Copy, Clone, Hash, Eq, PartialEq, Ord, PartialOrd)]
pub struct BusDataType(u8);
/// The bus process has been invoked by a caller
pub const BUS_DATA_TYPE_CALL: BusDataType = BusDataType(0);
/// Callback with some out-of-band data to the caller
pub const BUS_DATA_TYPE_CALLBACK: BusDataType = BusDataType(1);
/// Call within the bus process has returned
pub const BUS_DATA_TYPE_REPLY: BusDataType = BusDataType(2);
impl BusDataType {
    pub const fn raw(&self) -> u8 {
        self.0
    }

    pub fn name(&self) -> &'static str {
        match self.0 {
            0 => "CALL",
            1 => "CALLBACK",
            2 => "REPLY",
            _ => unsafe { core::hint::unreachable_unchecked() },
        }
    }
    pub fn message(&self) -> &'static str {
        match self.0 {
            0 => "The bus process has been invoked by a caller",
            1 => "Callback with some out-of-band data to the caller",
            2 => "Call within the bus process has returned",
            _ => unsafe { core::hint::unreachable_unchecked() },
        }
    }
}
impl fmt::Debug for BusDataType {
    fn fmt(&self, f: &mut fmt::Formatter<'_>) -> fmt::Result {
        f.debug_struct("BusDataType")
            .field("code", &self.0)
            .field("name", &self.name())
            .field("message", &self.message())
            .finish()
    }
}

#[repr(C)]
#[derive(Copy, Clone, Debug)]
pub struct BusEventData {
    /// Type of event data that is held here
    pub ty: BusDataType,
    /// Handle of the call that has made a callback
    pub cid: Cid,
    /// The topic that describes the event that happened
    pub topic_len: Size,
    /// The buffer where event data is stored
    pub buf_len: Size,
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
pub struct BusEventFault {
    /// Handle of the call where this event occurs for
    pub cid: Cid,
    /// Fault that was raised against this call
    pub fault: BusError,
}
#[repr(transparent)]
#[derive(Copy, Clone, Hash, Eq, PartialEq, Ord, PartialOrd)]
pub struct BusEventType(u8);
/// The bus process has exited
pub const BUS_EVENT_TYPE_EXIT: BusEventType = BusEventType(0);
/// The bus data recevied for a specific event
pub const BUS_EVENT_TYPE_DATA: BusEventType = BusEventType(1);
/// Fault has occured on one of the calls
pub const BUS_EVENT_TYPE_FAULT: BusEventType = BusEventType(2);
impl BusEventType {
    pub const fn raw(&self) -> u8 {
        self.0
    }

    pub fn name(&self) -> &'static str {
        match self.0 {
            0 => "EXIT",
            1 => "DATA",
            2 => "FAULT",
            _ => unsafe { core::hint::unreachable_unchecked() },
        }
    }
    pub fn message(&self) -> &'static str {
        match self.0 {
            0 => "The bus process has exited",
            1 => "The bus data recevied for a specific event",
            2 => "Fault has occured on one of the calls",
            _ => unsafe { core::hint::unreachable_unchecked() },
        }
    }
}
impl fmt::Debug for BusEventType {
    fn fmt(&self, f: &mut fmt::Formatter<'_>) -> fmt::Result {
        f.debug_struct("BusEventType")
            .field("code", &self.0)
            .field("name", &self.name())
            .field("message", &self.message())
            .finish()
    }
}

#[repr(C)]
#[derive(Copy, Clone)]
pub union BusEventU {
    pub exit: BusEventExit,
    pub data: BusEventData,
    pub fault: BusEventFault,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct BusEvent {
    pub tag: u8,
    pub u: BusEventU,
}

pub type BusEventArray<'a> = &'a [BusEvent];
#[repr(transparent)]
#[derive(Copy, Clone, Hash, Eq, PartialEq, Ord, PartialOrd)]
pub struct Signal(u8);
/// No signal. Note that POSIX has special semantics for `kill(pid, 0)`,
/// so this value is reserved.
pub const SIGNAL_NONE: Signal = Signal(0);
/// Hangup.
/// Action: Terminates the process.
pub const SIGNAL_HUP: Signal = Signal(1);
/// Terminate interrupt signal.
/// Action: Terminates the process.
pub const SIGNAL_INT: Signal = Signal(2);
/// Terminal quit signal.
/// Action: Terminates the process.
pub const SIGNAL_QUIT: Signal = Signal(3);
/// Illegal instruction.
/// Action: Terminates the process.
pub const SIGNAL_ILL: Signal = Signal(4);
/// Trace/breakpoint trap.
/// Action: Terminates the process.
pub const SIGNAL_TRAP: Signal = Signal(5);
/// Process abort signal.
/// Action: Terminates the process.
pub const SIGNAL_ABRT: Signal = Signal(6);
/// Access to an undefined portion of a memory object.
/// Action: Terminates the process.
pub const SIGNAL_BUS: Signal = Signal(7);
/// Erroneous arithmetic operation.
/// Action: Terminates the process.
pub const SIGNAL_FPE: Signal = Signal(8);
/// Kill.
/// Action: Terminates the process.
pub const SIGNAL_KILL: Signal = Signal(9);
/// User-defined signal 1.
/// Action: Terminates the process.
pub const SIGNAL_USR1: Signal = Signal(10);
/// Invalid memory reference.
/// Action: Terminates the process.
pub const SIGNAL_SEGV: Signal = Signal(11);
/// User-defined signal 2.
/// Action: Terminates the process.
pub const SIGNAL_USR2: Signal = Signal(12);
/// Write on a pipe with no one to read it.
/// Action: Ignored.
pub const SIGNAL_PIPE: Signal = Signal(13);
/// Alarm clock.
/// Action: Terminates the process.
pub const SIGNAL_ALRM: Signal = Signal(14);
/// Termination signal.
/// Action: Terminates the process.
pub const SIGNAL_TERM: Signal = Signal(15);
/// Child process terminated, stopped, or continued.
/// Action: Ignored.
pub const SIGNAL_CHLD: Signal = Signal(16);
/// Continue executing, if stopped.
/// Action: Continues executing, if stopped.
pub const SIGNAL_CONT: Signal = Signal(17);
/// Stop executing.
/// Action: Stops executing.
pub const SIGNAL_STOP: Signal = Signal(18);
/// Terminal stop signal.
/// Action: Stops executing.
pub const SIGNAL_TSTP: Signal = Signal(19);
/// Background process attempting read.
/// Action: Stops executing.
pub const SIGNAL_TTIN: Signal = Signal(20);
/// Background process attempting write.
/// Action: Stops executing.
pub const SIGNAL_TTOU: Signal = Signal(21);
/// High bandwidth data is available at a socket.
/// Action: Ignored.
pub const SIGNAL_URG: Signal = Signal(22);
/// CPU time limit exceeded.
/// Action: Terminates the process.
pub const SIGNAL_XCPU: Signal = Signal(23);
/// File size limit exceeded.
/// Action: Terminates the process.
pub const SIGNAL_XFSZ: Signal = Signal(24);
/// Virtual timer expired.
/// Action: Terminates the process.
pub const SIGNAL_VTALRM: Signal = Signal(25);
/// Profiling timer expired.
/// Action: Terminates the process.
pub const SIGNAL_PROF: Signal = Signal(26);
/// Window changed.
/// Action: Ignored.
pub const SIGNAL_WINCH: Signal = Signal(27);
/// I/O possible.
/// Action: Terminates the process.
pub const SIGNAL_POLL: Signal = Signal(28);
/// Power failure.
/// Action: Terminates the process.
pub const SIGNAL_PWR: Signal = Signal(29);
/// Bad system call.
/// Action: Terminates the process.
pub const SIGNAL_SYS: Signal = Signal(30);
impl Signal {
    pub const fn raw(&self) -> u8 {
        self.0
    }

    pub fn name(&self) -> &'static str {
        match self.0 {
            0 => "NONE",
            1 => "HUP",
            2 => "INT",
            3 => "QUIT",
            4 => "ILL",
            5 => "TRAP",
            6 => "ABRT",
            7 => "BUS",
            8 => "FPE",
            9 => "KILL",
            10 => "USR1",
            11 => "SEGV",
            12 => "USR2",
            13 => "PIPE",
            14 => "ALRM",
            15 => "TERM",
            16 => "CHLD",
            17 => "CONT",
            18 => "STOP",
            19 => "TSTP",
            20 => "TTIN",
            21 => "TTOU",
            22 => "URG",
            23 => "XCPU",
            24 => "XFSZ",
            25 => "VTALRM",
            26 => "PROF",
            27 => "WINCH",
            28 => "POLL",
            29 => "PWR",
            30 => "SYS",
            _ => unsafe { core::hint::unreachable_unchecked() },
        }
    }
    pub fn message(&self) -> &'static str {
        match self.0 {
            0 => {
                "No signal. Note that POSIX has special semantics for `kill(pid, 0)`,
so this value is reserved."
            }
            1 => {
                "Hangup.
Action: Terminates the process."
            }
            2 => {
                "Terminate interrupt signal.
Action: Terminates the process."
            }
            3 => {
                "Terminal quit signal.
Action: Terminates the process."
            }
            4 => {
                "Illegal instruction.
Action: Terminates the process."
            }
            5 => {
                "Trace/breakpoint trap.
Action: Terminates the process."
            }
            6 => {
                "Process abort signal.
Action: Terminates the process."
            }
            7 => {
                "Access to an undefined portion of a memory object.
Action: Terminates the process."
            }
            8 => {
                "Erroneous arithmetic operation.
Action: Terminates the process."
            }
            9 => {
                "Kill.
Action: Terminates the process."
            }
            10 => {
                "User-defined signal 1.
Action: Terminates the process."
            }
            11 => {
                "Invalid memory reference.
Action: Terminates the process."
            }
            12 => {
                "User-defined signal 2.
Action: Terminates the process."
            }
            13 => {
                "Write on a pipe with no one to read it.
Action: Ignored."
            }
            14 => {
                "Alarm clock.
Action: Terminates the process."
            }
            15 => {
                "Termination signal.
Action: Terminates the process."
            }
            16 => {
                "Child process terminated, stopped, or continued.
Action: Ignored."
            }
            17 => {
                "Continue executing, if stopped.
Action: Continues executing, if stopped."
            }
            18 => {
                "Stop executing.
Action: Stops executing."
            }
            19 => {
                "Terminal stop signal.
Action: Stops executing."
            }
            20 => {
                "Background process attempting read.
Action: Stops executing."
            }
            21 => {
                "Background process attempting write.
Action: Stops executing."
            }
            22 => {
                "High bandwidth data is available at a socket.
Action: Ignored."
            }
            23 => {
                "CPU time limit exceeded.
Action: Terminates the process."
            }
            24 => {
                "File size limit exceeded.
Action: Terminates the process."
            }
            25 => {
                "Virtual timer expired.
Action: Terminates the process."
            }
            26 => {
                "Profiling timer expired.
Action: Terminates the process."
            }
            27 => {
                "Window changed.
Action: Ignored."
            }
            28 => {
                "I/O possible.
Action: Terminates the process."
            }
            29 => {
                "Power failure.
Action: Terminates the process."
            }
            30 => {
                "Bad system call.
Action: Terminates the process."
            }
            _ => unsafe { core::hint::unreachable_unchecked() },
        }
    }
}
impl fmt::Debug for Signal {
    fn fmt(&self, f: &mut fmt::Formatter<'_>) -> fmt::Result {
        f.debug_struct("Signal")
            .field("code", &self.0)
            .field("name", &self.name())
            .field("message", &self.message())
            .finish()
    }
}

pub type Riflags = u16;
/// Returns the message without removing it from the socket's receive queue.
pub const RIFLAGS_RECV_PEEK: Riflags = 1 << 0;
/// On byte-stream sockets, block until the full amount of data can be returned.
pub const RIFLAGS_RECV_WAITALL: Riflags = 1 << 1;

pub type Roflags = u16;
/// Returned by `sock_recv`: Message data has been truncated.
pub const ROFLAGS_RECV_DATA_TRUNCATED: Roflags = 1 << 0;

#[repr(transparent)]
#[derive(Copy, Clone, Hash, Eq, PartialEq, Ord, PartialOrd)]
pub struct SockType(u8);
/// The file descriptor or file refers to a datagram socket.
pub const SOCK_TYPE_SOCKET_DGRAM: SockType = SockType(0);
/// The file descriptor or file refers to a byte-stream socket.
pub const SOCK_TYPE_SOCKET_STREAM: SockType = SockType(1);
impl SockType {
    pub const fn raw(&self) -> u8 {
        self.0
    }

    pub fn name(&self) -> &'static str {
        match self.0 {
            0 => "SOCKET_DGRAM",
            1 => "SOCKET_STREAM",
            _ => unsafe { core::hint::unreachable_unchecked() },
        }
    }
    pub fn message(&self) -> &'static str {
        match self.0 {
            0 => "The file descriptor or file refers to a datagram socket.",
            1 => "The file descriptor or file refers to a byte-stream socket.",
            _ => unsafe { core::hint::unreachable_unchecked() },
        }
    }
}
impl fmt::Debug for SockType {
    fn fmt(&self, f: &mut fmt::Formatter<'_>) -> fmt::Result {
        f.debug_struct("SockType")
            .field("code", &self.0)
            .field("name", &self.name())
            .field("message", &self.message())
            .finish()
    }
}

#[repr(transparent)]
#[derive(Copy, Clone, Hash, Eq, PartialEq, Ord, PartialOrd)]
pub struct SockStatus(u8);
/// The socket is still opening
pub const SOCK_STATUS_OPENING: SockStatus = SockStatus(0);
/// The socket has fully opened
pub const SOCK_STATUS_OPENED: SockStatus = SockStatus(1);
/// The socket has closed
pub const SOCK_STATUS_CLOSED: SockStatus = SockStatus(2);
/// The socket has failed
pub const SOCK_STATUS_FAILED: SockStatus = SockStatus(3);
impl SockStatus {
    pub const fn raw(&self) -> u8 {
        self.0
    }

    pub fn name(&self) -> &'static str {
        match self.0 {
            0 => "OPENING",
            1 => "OPENED",
            2 => "CLOSED",
            3 => "FAILED",
            _ => unsafe { core::hint::unreachable_unchecked() },
        }
    }
    pub fn message(&self) -> &'static str {
        match self.0 {
            0 => "The socket is still opening",
            1 => "The socket has fully opened",
            2 => "The socket has closed",
            3 => "The socket has failed",
            _ => unsafe { core::hint::unreachable_unchecked() },
        }
    }
}
impl fmt::Debug for SockStatus {
    fn fmt(&self, f: &mut fmt::Formatter<'_>) -> fmt::Result {
        f.debug_struct("SockStatus")
            .field("code", &self.0)
            .field("name", &self.name())
            .field("message", &self.message())
            .finish()
    }
}

#[repr(transparent)]
#[derive(Copy, Clone, Hash, Eq, PartialEq, Ord, PartialOrd)]
pub struct SockOption(u8);
/// Reuse Port
pub const SOCK_OPTION_REUSE_PORT: SockOption = SockOption(0);
/// Reuse Address
pub const SOCK_OPTION_REUSE_ADDR: SockOption = SockOption(1);
/// No delay
pub const SOCK_OPTION_NODELAY: SockOption = SockOption(2);
/// Only accept IPv6
pub const SOCK_OPTION_ONLY_V6: SockOption = SockOption(3);
/// Broadcast
pub const SOCK_OPTION_BROADCAST: SockOption = SockOption(4);
/// Multicast Loop IPv4
pub const SOCK_OPTION_MULTICAST_LOOP_V4: SockOption = SockOption(5);
/// Multicast Loop IPv6
pub const SOCK_OPTION_MULTICAST_LOOP_V6: SockOption = SockOption(6);
impl SockOption {
    pub const fn raw(&self) -> u8 {
        self.0
    }

    pub fn name(&self) -> &'static str {
        match self.0 {
            0 => "REUSE_PORT",
            1 => "REUSE_ADDR",
            2 => "NODELAY",
            3 => "ONLY_V6",
            4 => "BROADCAST",
            5 => "MULTICAST_LOOP_V4",
            6 => "MULTICAST_LOOP_V6",
            _ => unsafe { core::hint::unreachable_unchecked() },
        }
    }
    pub fn message(&self) -> &'static str {
        match self.0 {
            0 => "Reuse Port",
            1 => "Reuse Address",
            2 => "No delay",
            3 => "Only accept IPv6",
            4 => "Broadcast",
            5 => "Multicast Loop IPv4",
            6 => "Multicast Loop IPv6",
            _ => unsafe { core::hint::unreachable_unchecked() },
        }
    }
}
impl fmt::Debug for SockOption {
    fn fmt(&self, f: &mut fmt::Formatter<'_>) -> fmt::Result {
        f.debug_struct("SockOption")
            .field("code", &self.0)
            .field("name", &self.name())
            .field("message", &self.message())
            .finish()
    }
}

pub type StreamSecurity = u8;
/// Unencrypted
pub const STREAM_SECURITY_UNENCRYPTED: StreamSecurity = 1 << 0;
/// Any encryption
pub const STREAM_SECURITY_ANY_ENCRYPTION: StreamSecurity = 1 << 1;
/// Classic encryption
pub const STREAM_SECURITY_CLASSIC_ENCRYPTION: StreamSecurity = 1 << 2;
/// Double encryption
pub const STREAM_SECURITY_DOUBLE_ENCRYPTION: StreamSecurity = 1 << 3;

#[repr(C)]
#[derive(Copy, Clone, Debug)]
pub struct HardwareAddress {
    pub n0: u8,
    pub n1: u8,
    pub n2: u8,
    pub h0: u8,
    pub h1: u8,
    pub h2: u8,
}
pub type IpPort = u16;
#[repr(transparent)]
#[derive(Copy, Clone, Hash, Eq, PartialEq, Ord, PartialOrd)]
pub struct AddressFamily(u8);
/// IP v4
pub const ADDRESS_FAMILY_INET4: AddressFamily = AddressFamily(0);
/// IP v6
pub const ADDRESS_FAMILY_INET6: AddressFamily = AddressFamily(1);
impl AddressFamily {
    pub const fn raw(&self) -> u8 {
        self.0
    }

    pub fn name(&self) -> &'static str {
        match self.0 {
            0 => "INET4",
            1 => "INET6",
            _ => unsafe { core::hint::unreachable_unchecked() },
        }
    }
    pub fn message(&self) -> &'static str {
        match self.0 {
            0 => "IP v4",
            1 => "IP v6",
            _ => unsafe { core::hint::unreachable_unchecked() },
        }
    }
}
impl fmt::Debug for AddressFamily {
    fn fmt(&self, f: &mut fmt::Formatter<'_>) -> fmt::Result {
        f.debug_struct("AddressFamily")
            .field("code", &self.0)
            .field("name", &self.name())
            .field("message", &self.message())
            .finish()
    }
}

#[repr(C)]
#[derive(Copy, Clone, Debug)]
pub struct AddrIp4 {
    pub n0: u8,
    pub n1: u8,
    pub h0: u8,
    pub h1: u8,
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
pub struct AddrIp4Port {
    pub addr: AddrIp4,
    pub port: IpPort,
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
pub struct AddrIp4Cidr {
    pub addr: AddrIp4,
    pub prefix: u8,
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
pub struct AddrIp6 {
    pub n0: u16,
    pub n1: u16,
    pub n2: u16,
    pub n3: u16,
    pub h0: u16,
    pub h1: u16,
    pub h2: u16,
    pub h3: u16,
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
pub struct AddrIp6Port {
    pub addr: AddrIp6,
    pub port: IpPort,
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
pub struct AddrIp6Cidr {
    pub addr: AddrIp6,
    pub prefix: u8,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union AddrIpU {
    pub inet4: AddrIp4,
    pub inet6: AddrIp6,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct AddrIp {
    pub tag: u8,
    pub u: AddrIpU,
}

pub type AddrIpArray<'a> = &'a [AddrIp];
#[repr(C)]
#[derive(Copy, Clone)]
pub union AddrPortU {
    pub inet4: AddrIp4Port,
    pub inet6: AddrIp6Port,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct AddrPort {
    pub tag: u8,
    pub u: AddrPortU,
}

pub type AddrPortArray<'a> = &'a [AddrPort];
#[repr(C)]
#[derive(Copy, Clone)]
pub union AddrCidrU {
    pub inet4: AddrIp4Cidr,
    pub inet6: AddrIp6Cidr,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct AddrCidr {
    pub tag: u8,
    pub u: AddrCidrU,
}

pub type AddrCidrArray<'a> = &'a [AddrCidr];
#[repr(C)]
#[derive(Copy, Clone)]
pub struct Route {
    pub cidr: AddrCidr,
    pub via_router: AddrIp,
    pub preferred_until: OptionTimestamp,
    pub expires_at: OptionTimestamp,
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
pub struct HttpHeaderSizes {
    /// Header name length
    pub key_len: Size,
    /// Header value length
    pub val_len: Size,
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
pub struct HttpHandles {
    /// File handle used to write the request data
    pub request: Fd,
    /// File handle used to receive the response data
    pub response: Fd,
    /// File handle used to read the response headers
    /// (entries are separated by line feeds)
    pub headers: Fd,
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
pub struct HttpStatus {
    pub ok: Bool,
    pub redirected: Bool,
    /// Size of the response
    pub size: Size,
    /// HTTP status code for this response
    pub status: u16,
}
pub type Siflags = u16;
pub type Sdflags = u8;
/// Disables further receive operations.
pub const SDFLAGS_RD: Sdflags = 1 << 0;
/// Disables further send operations.
pub const SDFLAGS_WR: Sdflags = 1 << 1;

pub type TimeoutType = u8;
/// Read operation timeout
pub const TIMEOUT_TYPE_READ: TimeoutType = 1 << 0;
/// Write operation timeout
pub const TIMEOUT_TYPE_WRITE: TimeoutType = 1 << 1;
/// Connections to other sockets
pub const TIMEOUT_TYPE_CONNECT: TimeoutType = 1 << 2;
/// Accept connection timeout
pub const TIMEOUT_TYPE_ACCEPT: TimeoutType = 1 << 3;

#[repr(transparent)]
#[derive(Copy, Clone, Hash, Eq, PartialEq, Ord, PartialOrd)]
pub struct Preopentype(u8);
/// A pre-opened directory.
pub const PREOPENTYPE_DIR: Preopentype = Preopentype(0);
impl Preopentype {
    pub const fn raw(&self) -> u8 {
        self.0
    }

    pub fn name(&self) -> &'static str {
        match self.0 {
            0 => "DIR",
            _ => unsafe { core::hint::unreachable_unchecked() },
        }
    }
    pub fn message(&self) -> &'static str {
        match self.0 {
            0 => "A pre-opened directory.",
            _ => unsafe { core::hint::unreachable_unchecked() },
        }
    }
}
impl fmt::Debug for Preopentype {
    fn fmt(&self, f: &mut fmt::Formatter<'_>) -> fmt::Result {
        f.debug_struct("Preopentype")
            .field("code", &self.0)
            .field("name", &self.name())
            .field("message", &self.message())
            .finish()
    }
}

#[repr(C)]
#[derive(Copy, Clone, Debug)]
pub struct PrestatDir {
    /// The length of the directory name for use with `fd_prestat_dir_name`.
    pub pr_name_len: Size,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union PrestatU {
    pub dir: PrestatDir,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct Prestat {
    pub tag: u8,
    pub u: PrestatU,
}

/// Read command-line argument data.
/// The size of the array should match that returned by `args_sizes_get`.
/// Each argument is expected to be `\0` terminated.
pub unsafe fn args_get(argv: *mut *mut u8, argv_buf: *mut u8) -> Result<(), Errno> {
    let ret = wasix_snapshot_preview1::args_get(argv as i32, argv_buf as i32);
    match ret {
        0 => Ok(()),
        _ => Err(Errno(ret as u16)),
    }
}

/// Return command-line argument data sizes.
///
/// ## Return
///
/// Returns the number of arguments and the size of the argument string
/// data, or an error.
pub unsafe fn args_sizes_get() -> Result<(Size, Size), Errno> {
    let mut rp0 = MaybeUninit::<Size>::uninit();
    let mut rp1 = MaybeUninit::<Size>::uninit();
    let ret =
        wasix_snapshot_preview1::args_sizes_get(rp0.as_mut_ptr() as i32, rp1.as_mut_ptr() as i32);
    match ret {
        0 => Ok((
            core::ptr::read(rp0.as_mut_ptr() as i32 as *const Size),
            core::ptr::read(rp1.as_mut_ptr() as i32 as *const Size),
        )),
        _ => Err(Errno(ret as u16)),
    }
}

/// Read environment variable data.
/// The sizes of the buffers should match that returned by `environ_sizes_get`.
/// Key/value pairs are expected to be joined with `=`s, and terminated with `\0`s.
pub unsafe fn environ_get(environ: *mut *mut u8, environ_buf: *mut u8) -> Result<(), Errno> {
    let ret = wasix_snapshot_preview1::environ_get(environ as i32, environ_buf as i32);
    match ret {
        0 => Ok(()),
        _ => Err(Errno(ret as u16)),
    }
}

/// Return environment variable data sizes.
///
/// ## Return
///
/// Returns the number of environment variable arguments and the size of the
/// environment variable data.
pub unsafe fn environ_sizes_get() -> Result<(Size, Size), Errno> {
    let mut rp0 = MaybeUninit::<Size>::uninit();
    let mut rp1 = MaybeUninit::<Size>::uninit();
    let ret = wasix_snapshot_preview1::environ_sizes_get(
        rp0.as_mut_ptr() as i32,
        rp1.as_mut_ptr() as i32,
    );
    match ret {
        0 => Ok((
            core::ptr::read(rp0.as_mut_ptr() as i32 as *const Size),
            core::ptr::read(rp1.as_mut_ptr() as i32 as *const Size),
        )),
        _ => Err(Errno(ret as u16)),
    }
}

/// Return the resolution of a clock.
/// Implementations are required to provide a non-zero value for supported clocks. For unsupported clocks,
/// return `errno::inval`.
/// Note: This is similar to `clock_getres` in POSIX.
///
/// ## Parameters
///
/// * `id` - The clock for which to return the resolution.
///
/// ## Return
///
/// The resolution of the clock, or an error if one happened.
pub unsafe fn clock_res_get(id: Clockid) -> Result<Timestamp, Errno> {
    let mut rp0 = MaybeUninit::<Timestamp>::uninit();
    let ret = wasix_snapshot_preview1::clock_res_get(id.0 as i32, rp0.as_mut_ptr() as i32);
    match ret {
        0 => Ok(core::ptr::read(rp0.as_mut_ptr() as i32 as *const Timestamp)),
        _ => Err(Errno(ret as u16)),
    }
}

/// Return the time value of a clock.
/// Note: This is similar to `clock_gettime` in POSIX.
///
/// ## Parameters
///
/// * `id` - The clock for which to return the time.
/// * `precision` - The maximum lag (exclusive) that the returned time value may have, compared to its actual value.
///
/// ## Return
///
/// The time value of the clock.
pub unsafe fn clock_time_get(id: Clockid, precision: Timestamp) -> Result<Timestamp, Errno> {
    let mut rp0 = MaybeUninit::<Timestamp>::uninit();
    let ret = wasix_snapshot_preview1::clock_time_get(
        id.0 as i32,
        precision as i64,
        rp0.as_mut_ptr() as i32,
    );
    match ret {
        0 => Ok(core::ptr::read(rp0.as_mut_ptr() as i32 as *const Timestamp)),
        _ => Err(Errno(ret as u16)),
    }
}

/// Provide file advisory information on a file descriptor.
/// Note: This is similar to `posix_fadvise` in POSIX.
///
/// ## Parameters
///
/// * `offset` - The offset within the file to which the advisory applies.
/// * `len` - The length of the region to which the advisory applies.
/// * `advice` - The advice.
pub unsafe fn fd_advise(
    fd: Fd,
    offset: Filesize,
    len: Filesize,
    advice: Advice,
) -> Result<(), Errno> {
    let ret =
        wasix_snapshot_preview1::fd_advise(fd as i32, offset as i64, len as i64, advice.0 as i32);
    match ret {
        0 => Ok(()),
        _ => Err(Errno(ret as u16)),
    }
}

/// Force the allocation of space in a file.
/// Note: This is similar to `posix_fallocate` in POSIX.
///
/// ## Parameters
///
/// * `offset` - The offset at which to start the allocation.
/// * `len` - The length of the area that is allocated.
pub unsafe fn fd_allocate(fd: Fd, offset: Filesize, len: Filesize) -> Result<(), Errno> {
    let ret = wasix_snapshot_preview1::fd_allocate(fd as i32, offset as i64, len as i64);
    match ret {
        0 => Ok(()),
        _ => Err(Errno(ret as u16)),
    }
}

/// Close a file descriptor.
/// Note: This is similar to `close` in POSIX.
pub unsafe fn fd_close(fd: Fd) -> Result<(), Errno> {
    let ret = wasix_snapshot_preview1::fd_close(fd as i32);
    match ret {
        0 => Ok(()),
        _ => Err(Errno(ret as u16)),
    }
}

/// Synchronize the data of a file to disk.
/// Note: This is similar to `fdatasync` in POSIX.
pub unsafe fn fd_datasync(fd: Fd) -> Result<(), Errno> {
    let ret = wasix_snapshot_preview1::fd_datasync(fd as i32);
    match ret {
        0 => Ok(()),
        _ => Err(Errno(ret as u16)),
    }
}

/// Get the attributes of a file descriptor.
/// Note: This returns similar flags to `fsync(fd, F_GETFL)` in POSIX, as well as additional fields.
///
/// ## Return
///
/// The buffer where the file descriptor's attributes are stored.
pub unsafe fn fd_fdstat_get(fd: Fd) -> Result<Fdstat, Errno> {
    let mut rp0 = MaybeUninit::<Fdstat>::uninit();
    let ret = wasix_snapshot_preview1::fd_fdstat_get(fd as i32, rp0.as_mut_ptr() as i32);
    match ret {
        0 => Ok(core::ptr::read(rp0.as_mut_ptr() as i32 as *const Fdstat)),
        _ => Err(Errno(ret as u16)),
    }
}

/// Adjust the flags associated with a file descriptor.
/// Note: This is similar to `fcntl(fd, F_SETFL, flags)` in POSIX.
///
/// ## Parameters
///
/// * `flags` - The desired values of the file descriptor flags.
pub unsafe fn fd_fdstat_set_flags(fd: Fd, flags: Fdflags) -> Result<(), Errno> {
    let ret = wasix_snapshot_preview1::fd_fdstat_set_flags(fd as i32, flags as i32);
    match ret {
        0 => Ok(()),
        _ => Err(Errno(ret as u16)),
    }
}

/// Adjust the rights associated with a file descriptor.
/// This can only be used to remove rights, and returns `errno::notcapable` if called in a way that would attempt to add rights
///
/// ## Parameters
///
/// * `fs_rights_base` - The desired rights of the file descriptor.
pub unsafe fn fd_fdstat_set_rights(
    fd: Fd,
    fs_rights_base: Rights,
    fs_rights_inheriting: Rights,
) -> Result<(), Errno> {
    let ret = wasix_snapshot_preview1::fd_fdstat_set_rights(
        fd as i32,
        fs_rights_base as i64,
        fs_rights_inheriting as i64,
    );
    match ret {
        0 => Ok(()),
        _ => Err(Errno(ret as u16)),
    }
}

/// Return the attributes of an open file.
///
/// ## Return
///
/// The buffer where the file's attributes are stored.
pub unsafe fn fd_filestat_get(fd: Fd) -> Result<Filestat, Errno> {
    let mut rp0 = MaybeUninit::<Filestat>::uninit();
    let ret = wasix_snapshot_preview1::fd_filestat_get(fd as i32, rp0.as_mut_ptr() as i32);
    match ret {
        0 => Ok(core::ptr::read(rp0.as_mut_ptr() as i32 as *const Filestat)),
        _ => Err(Errno(ret as u16)),
    }
}

/// Adjust the size of an open file. If this increases the file's size, the extra bytes are filled with zeros.
/// Note: This is similar to `ftruncate` in POSIX.
///
/// ## Parameters
///
/// * `size` - The desired file size.
pub unsafe fn fd_filestat_set_size(fd: Fd, size: Filesize) -> Result<(), Errno> {
    let ret = wasix_snapshot_preview1::fd_filestat_set_size(fd as i32, size as i64);
    match ret {
        0 => Ok(()),
        _ => Err(Errno(ret as u16)),
    }
}

/// Adjust the timestamps of an open file or directory.
/// Note: This is similar to `futimens` in POSIX.
///
/// ## Parameters
///
/// * `atim` - The desired values of the data access timestamp.
/// * `mtim` - The desired values of the data modification timestamp.
/// * `fst_flags` - A bitmask indicating which timestamps to adjust.
pub unsafe fn fd_filestat_set_times(
    fd: Fd,
    atim: Timestamp,
    mtim: Timestamp,
    fst_flags: Fstflags,
) -> Result<(), Errno> {
    let ret = wasix_snapshot_preview1::fd_filestat_set_times(
        fd as i32,
        atim as i64,
        mtim as i64,
        fst_flags as i32,
    );
    match ret {
        0 => Ok(()),
        _ => Err(Errno(ret as u16)),
    }
}

/// Read from a file descriptor, without using and updating the file descriptor's offset.
/// Note: This is similar to `preadv` in POSIX.
///
/// ## Parameters
///
/// * `iovs` - List of scatter/gather vectors in which to store data.
/// * `offset` - The offset within the file at which to read.
///
/// ## Return
///
/// The number of bytes read.
pub unsafe fn fd_pread(fd: Fd, iovs: IovecArray<'_>, offset: Filesize) -> Result<Size, Errno> {
    let mut rp0 = MaybeUninit::<Size>::uninit();
    let ret = wasix_snapshot_preview1::fd_pread(
        fd as i32,
        iovs.as_ptr() as i32,
        iovs.len() as i32,
        offset as i64,
        rp0.as_mut_ptr() as i32,
    );
    match ret {
        0 => Ok(core::ptr::read(rp0.as_mut_ptr() as i32 as *const Size)),
        _ => Err(Errno(ret as u16)),
    }
}

/// Return a description of the given preopened file descriptor.
///
/// ## Return
///
/// The buffer where the description is stored.
pub unsafe fn fd_prestat_get(fd: Fd) -> Result<Prestat, Errno> {
    let mut rp0 = MaybeUninit::<Prestat>::uninit();
    let ret = wasix_snapshot_preview1::fd_prestat_get(fd as i32, rp0.as_mut_ptr() as i32);
    match ret {
        0 => Ok(core::ptr::read(rp0.as_mut_ptr() as i32 as *const Prestat)),
        _ => Err(Errno(ret as u16)),
    }
}

/// Return a description of the given preopened file descriptor.
///
/// ## Parameters
///
/// * `path` - A buffer into which to write the preopened directory name.
pub unsafe fn fd_prestat_dir_name(fd: Fd, path: *mut u8, path_len: Size) -> Result<(), Errno> {
    let ret = wasix_snapshot_preview1::fd_prestat_dir_name(fd as i32, path as i32, path_len as i32);
    match ret {
        0 => Ok(()),
        _ => Err(Errno(ret as u16)),
    }
}

/// Write to a file descriptor, without using and updating the file descriptor's offset.
/// Note: This is similar to `pwritev` in POSIX.
///
/// ## Parameters
///
/// * `iovs` - List of scatter/gather vectors from which to retrieve data.
/// * `offset` - The offset within the file at which to write.
///
/// ## Return
///
/// The number of bytes written.
pub unsafe fn fd_pwrite(fd: Fd, iovs: CiovecArray<'_>, offset: Filesize) -> Result<Size, Errno> {
    let mut rp0 = MaybeUninit::<Size>::uninit();
    let ret = wasix_snapshot_preview1::fd_pwrite(
        fd as i32,
        iovs.as_ptr() as i32,
        iovs.len() as i32,
        offset as i64,
        rp0.as_mut_ptr() as i32,
    );
    match ret {
        0 => Ok(core::ptr::read(rp0.as_mut_ptr() as i32 as *const Size)),
        _ => Err(Errno(ret as u16)),
    }
}

/// Read from a file descriptor.
/// Note: This is similar to `readv` in POSIX.
///
/// ## Parameters
///
/// * `iovs` - List of scatter/gather vectors to which to store data.
///
/// ## Return
///
/// The number of bytes read.
pub unsafe fn fd_read(fd: Fd, iovs: IovecArray<'_>) -> Result<Size, Errno> {
    let mut rp0 = MaybeUninit::<Size>::uninit();
    let ret = wasix_snapshot_preview1::fd_read(
        fd as i32,
        iovs.as_ptr() as i32,
        iovs.len() as i32,
        rp0.as_mut_ptr() as i32,
    );
    match ret {
        0 => Ok(core::ptr::read(rp0.as_mut_ptr() as i32 as *const Size)),
        _ => Err(Errno(ret as u16)),
    }
}

/// Read directory entries from a directory.
/// When successful, the contents of the output buffer consist of a sequence of
/// directory entries. Each directory entry consists of a `dirent` object,
/// followed by `dirent::d_namlen` bytes holding the name of the directory
/// entry.
/// This function fills the output buffer as much as possible, potentially
/// truncating the last directory entry. This allows the caller to grow its
/// read buffer size in case it's too small to fit a single large directory
/// entry, or skip the oversized directory entry.
///
/// ## Parameters
///
/// * `buf` - The buffer where directory entries are stored
/// * `cookie` - The location within the directory to start reading
///
/// ## Return
///
/// The number of bytes stored in the read buffer. If less than the size of the read buffer, the end of the directory has been reached.
pub unsafe fn fd_readdir(
    fd: Fd,
    buf: *mut u8,
    buf_len: Size,
    cookie: Dircookie,
) -> Result<Size, Errno> {
    let mut rp0 = MaybeUninit::<Size>::uninit();
    let ret = wasix_snapshot_preview1::fd_readdir(
        fd as i32,
        buf as i32,
        buf_len as i32,
        cookie as i64,
        rp0.as_mut_ptr() as i32,
    );
    match ret {
        0 => Ok(core::ptr::read(rp0.as_mut_ptr() as i32 as *const Size)),
        _ => Err(Errno(ret as u16)),
    }
}

/// Atomically replace a file descriptor by renumbering another file descriptor.
/// Due to the strong focus on thread safety, this environment does not provide
/// a mechanism to duplicate or renumber a file descriptor to an arbitrary
/// number, like `dup2()`. This would be prone to race conditions, as an actual
/// file descriptor with the same number could be allocated by a different
/// thread at the same time.
/// This function provides a way to atomically renumber file descriptors, which
/// would disappear if `dup2()` were to be removed entirely.
///
/// ## Parameters
///
/// * `to` - The file descriptor to overwrite.
pub unsafe fn fd_renumber(fd: Fd, to: Fd) -> Result<(), Errno> {
    let ret = wasix_snapshot_preview1::fd_renumber(fd as i32, to as i32);
    match ret {
        0 => Ok(()),
        _ => Err(Errno(ret as u16)),
    }
}

/// Atomically duplicate a file handle.
pub unsafe fn fd_dup(fd: Fd) -> Result<Fd, Errno> {
    let mut rp0 = MaybeUninit::<Fd>::uninit();
    let ret = wasix_snapshot_preview1::fd_dup(fd as i32, rp0.as_mut_ptr() as i32);
    match ret {
        0 => Ok(core::ptr::read(rp0.as_mut_ptr() as i32 as *const Fd)),
        _ => Err(Errno(ret as u16)),
    }
}

/// Move the offset of a file descriptor.
/// Note: This is similar to `lseek` in POSIX.
///
/// ## Parameters
///
/// * `offset` - The number of bytes to move.
/// * `whence` - The base from which the offset is relative.
///
/// ## Return
///
/// The new offset of the file descriptor, relative to the start of the file.
pub unsafe fn fd_seek(fd: Fd, offset: Filedelta, whence: Whence) -> Result<Filesize, Errno> {
    let mut rp0 = MaybeUninit::<Filesize>::uninit();
    let ret = wasix_snapshot_preview1::fd_seek(
        fd as i32,
        offset,
        whence.0 as i32,
        rp0.as_mut_ptr() as i32,
    );
    match ret {
        0 => Ok(core::ptr::read(rp0.as_mut_ptr() as i32 as *const Filesize)),
        _ => Err(Errno(ret as u16)),
    }
}

/// Synchronize the data and metadata of a file to disk.
/// Note: This is similar to `fsync` in POSIX.
pub unsafe fn fd_sync(fd: Fd) -> Result<(), Errno> {
    let ret = wasix_snapshot_preview1::fd_sync(fd as i32);
    match ret {
        0 => Ok(()),
        _ => Err(Errno(ret as u16)),
    }
}

/// Return the current offset of a file descriptor.
/// Note: This is similar to `lseek(fd, 0, SEEK_CUR)` in POSIX.
///
/// ## Return
///
/// The current offset of the file descriptor, relative to the start of the file.
pub unsafe fn fd_tell(fd: Fd) -> Result<Filesize, Errno> {
    let mut rp0 = MaybeUninit::<Filesize>::uninit();
    let ret = wasix_snapshot_preview1::fd_tell(fd as i32, rp0.as_mut_ptr() as i32);
    match ret {
        0 => Ok(core::ptr::read(rp0.as_mut_ptr() as i32 as *const Filesize)),
        _ => Err(Errno(ret as u16)),
    }
}

/// Write to a file descriptor.
/// Note: This is similar to `writev` in POSIX.
///
/// ## Parameters
///
/// * `iovs` - List of scatter/gather vectors from which to retrieve data.
pub unsafe fn fd_write(fd: Fd, iovs: CiovecArray<'_>) -> Result<Size, Errno> {
    let mut rp0 = MaybeUninit::<Size>::uninit();
    let ret = wasix_snapshot_preview1::fd_write(
        fd as i32,
        iovs.as_ptr() as i32,
        iovs.len() as i32,
        rp0.as_mut_ptr() as i32,
    );
    match ret {
        0 => Ok(core::ptr::read(rp0.as_mut_ptr() as i32 as *const Size)),
        _ => Err(Errno(ret as u16)),
    }
}

/// Opens a pipe with two file handles
///
/// Pipes are bidirectional meaning
pub unsafe fn pipe() -> Result<PipeHandles, Errno> {
    let mut rp0 = MaybeUninit::<PipeHandles>::uninit();
    let ret = wasix_snapshot_preview1::pipe(rp0.as_mut_ptr() as i32);
    match ret {
        0 => Ok(core::ptr::read(
            rp0.as_mut_ptr() as i32 as *const PipeHandles
        )),
        _ => Err(Errno(ret as u16)),
    }
}

/// Create a directory.
/// Note: This is similar to `mkdirat` in POSIX.
///
/// ## Parameters
///
/// * `path` - The path at which to create the directory.
pub unsafe fn path_create_directory(fd: Fd, path: &str) -> Result<(), Errno> {
    let ret = wasix_snapshot_preview1::path_create_directory(
        fd as i32,
        path.as_ptr() as i32,
        path.len() as i32,
    );
    match ret {
        0 => Ok(()),
        _ => Err(Errno(ret as u16)),
    }
}

/// Return the attributes of a file or directory.
/// Note: This is similar to `stat` in POSIX.
///
/// ## Parameters
///
/// * `flags` - Flags determining the method of how the path is resolved.
/// * `path` - The path of the file or directory to inspect.
///
/// ## Return
///
/// The buffer where the file's attributes are stored.
pub unsafe fn path_filestat_get(fd: Fd, flags: Lookupflags, path: &str) -> Result<Filestat, Errno> {
    let mut rp0 = MaybeUninit::<Filestat>::uninit();
    let ret = wasix_snapshot_preview1::path_filestat_get(
        fd as i32,
        flags as i32,
        path.as_ptr() as i32,
        path.len() as i32,
        rp0.as_mut_ptr() as i32,
    );
    match ret {
        0 => Ok(core::ptr::read(rp0.as_mut_ptr() as i32 as *const Filestat)),
        _ => Err(Errno(ret as u16)),
    }
}

/// Adjust the timestamps of a file or directory.
/// Note: This is similar to `utimensat` in POSIX.
///
/// ## Parameters
///
/// * `flags` - Flags determining the method of how the path is resolved.
/// * `path` - The path of the file or directory to operate on.
/// * `atim` - The desired values of the data access timestamp.
/// * `mtim` - The desired values of the data modification timestamp.
/// * `fst_flags` - A bitmask indicating which timestamps to adjust.
pub unsafe fn path_filestat_set_times(
    fd: Fd,
    flags: Lookupflags,
    path: &str,
    atim: Timestamp,
    mtim: Timestamp,
    fst_flags: Fstflags,
) -> Result<(), Errno> {
    let ret = wasix_snapshot_preview1::path_filestat_set_times(
        fd as i32,
        flags as i32,
        path.as_ptr() as i32,
        path.len() as i32,
        atim as i64,
        mtim as i64,
        fst_flags as i32,
    );
    match ret {
        0 => Ok(()),
        _ => Err(Errno(ret as u16)),
    }
}

/// Create a hard link.
/// Note: This is similar to `linkat` in POSIX.
///
/// ## Parameters
///
/// * `old_flags` - Flags determining the method of how the path is resolved.
/// * `old_path` - The source path from which to link.
/// * `new_fd` - The working directory at which the resolution of the new path starts.
/// * `new_path` - The destination path at which to create the hard link.
pub unsafe fn path_link(
    old_fd: Fd,
    old_flags: Lookupflags,
    old_path: &str,
    new_fd: Fd,
    new_path: &str,
) -> Result<(), Errno> {
    let ret = wasix_snapshot_preview1::path_link(
        old_fd as i32,
        old_flags as i32,
        old_path.as_ptr() as i32,
        old_path.len() as i32,
        new_fd as i32,
        new_path.as_ptr() as i32,
        new_path.len() as i32,
    );
    match ret {
        0 => Ok(()),
        _ => Err(Errno(ret as u16)),
    }
}

/// Open a file or directory.
/// The returned file descriptor is not guaranteed to be the lowest-numbered
/// file descriptor not currently open; it is randomized to prevent
/// applications from depending on making assumptions about indexes, since this
/// is error-prone in multi-threaded contexts. The returned file descriptor is
/// guaranteed to be less than 2**31.
/// Note: This is similar to `openat` in POSIX.
///
/// ## Parameters
///
/// * `dirflags` - Flags determining the method of how the path is resolved.
/// * `path` - The relative path of the file or directory to open, relative to the
///   `path_open::fd` directory.
/// * `oflags` - The method by which to open the file.
/// * `fs_rights_base` - The initial rights of the newly created file descriptor. The
///   implementation is allowed to return a file descriptor with fewer rights
///   than specified, if and only if those rights do not apply to the type of
///   file being opened.
///   The *base* rights are rights that will apply to operations using the file
///   descriptor itself, while the *inheriting* rights are rights that apply to
///   file descriptors derived from it.
///
/// ## Return
///
/// The file descriptor of the file that has been opened.
pub unsafe fn path_open(
    fd: Fd,
    dirflags: Lookupflags,
    path: &str,
    oflags: Oflags,
    fs_rights_base: Rights,
    fs_rights_inheriting: Rights,
    fdflags: Fdflags,
) -> Result<Fd, Errno> {
    let mut rp0 = MaybeUninit::<Fd>::uninit();
    let ret = wasix_snapshot_preview1::path_open(
        fd as i32,
        dirflags as i32,
        path.as_ptr() as i32,
        path.len() as i32,
        oflags as i32,
        fs_rights_base as i64,
        fs_rights_inheriting as i64,
        fdflags as i32,
        rp0.as_mut_ptr() as i32,
    );
    match ret {
        0 => Ok(core::ptr::read(rp0.as_mut_ptr() as i32 as *const Fd)),
        _ => Err(Errno(ret as u16)),
    }
}

/// Read the contents of a symbolic link.
/// Note: This is similar to `readlinkat` in POSIX.
///
/// ## Parameters
///
/// * `path` - The path of the symbolic link from which to read.
/// * `buf` - The buffer to which to write the contents of the symbolic link.
///
/// ## Return
///
/// The number of bytes placed in the buffer.
pub unsafe fn path_readlink(
    fd: Fd,
    path: &str,
    buf: *mut u8,
    buf_len: Size,
) -> Result<Size, Errno> {
    let mut rp0 = MaybeUninit::<Size>::uninit();
    let ret = wasix_snapshot_preview1::path_readlink(
        fd as i32,
        path.as_ptr() as i32,
        path.len() as i32,
        buf as i32,
        buf_len as i32,
        rp0.as_mut_ptr() as i32,
    );
    match ret {
        0 => Ok(core::ptr::read(rp0.as_mut_ptr() as i32 as *const Size)),
        _ => Err(Errno(ret as u16)),
    }
}

/// Remove a directory.
/// Return `errno::notempty` if the directory is not empty.
/// Note: This is similar to `unlinkat(fd, path, AT_REMOVEDIR)` in POSIX.
///
/// ## Parameters
///
/// * `path` - The path to a directory to remove.
pub unsafe fn path_remove_directory(fd: Fd, path: &str) -> Result<(), Errno> {
    let ret = wasix_snapshot_preview1::path_remove_directory(
        fd as i32,
        path.as_ptr() as i32,
        path.len() as i32,
    );
    match ret {
        0 => Ok(()),
        _ => Err(Errno(ret as u16)),
    }
}

/// Rename a file or directory.
/// Note: This is similar to `renameat` in POSIX.
///
/// ## Parameters
///
/// * `old_path` - The source path of the file or directory to rename.
/// * `new_fd` - The working directory at which the resolution of the new path starts.
/// * `new_path` - The destination path to which to rename the file or directory.
pub unsafe fn path_rename(fd: Fd, old_path: &str, new_fd: Fd, new_path: &str) -> Result<(), Errno> {
    let ret = wasix_snapshot_preview1::path_rename(
        fd as i32,
        old_path.as_ptr() as i32,
        old_path.len() as i32,
        new_fd as i32,
        new_path.as_ptr() as i32,
        new_path.len() as i32,
    );
    match ret {
        0 => Ok(()),
        _ => Err(Errno(ret as u16)),
    }
}

/// Create a symbolic link.
/// Note: This is similar to `symlinkat` in POSIX.
///
/// ## Parameters
///
/// * `old_path` - The contents of the symbolic link.
/// * `new_path` - The destination path at which to create the symbolic link.
pub unsafe fn path_symlink(old_path: &str, fd: Fd, new_path: &str) -> Result<(), Errno> {
    let ret = wasix_snapshot_preview1::path_symlink(
        old_path.as_ptr() as i32,
        old_path.len() as i32,
        fd as i32,
        new_path.as_ptr() as i32,
        new_path.len() as i32,
    );
    match ret {
        0 => Ok(()),
        _ => Err(Errno(ret as u16)),
    }
}

/// Unlink a file.
/// Return `errno::isdir` if the path refers to a directory.
/// Note: This is similar to `unlinkat(fd, path, 0)` in POSIX.
///
/// ## Parameters
///
/// * `path` - The path to a file to unlink.
pub unsafe fn path_unlink_file(fd: Fd, path: &str) -> Result<(), Errno> {
    let ret = wasix_snapshot_preview1::path_unlink_file(
        fd as i32,
        path.as_ptr() as i32,
        path.len() as i32,
    );
    match ret {
        0 => Ok(()),
        _ => Err(Errno(ret as u16)),
    }
}

/// Concurrently poll for the occurrence of a set of events.
///
/// ## Parameters
///
/// * `in_` - The events to which to subscribe.
/// * `out` - The events that have occurred.
/// * `nsubscriptions` - Both the number of subscriptions and events.
///
/// ## Return
///
/// The number of events stored.
pub unsafe fn poll_oneoff(
    in_: *const Subscription,
    out: *mut Event,
    nsubscriptions: Size,
) -> Result<Size, Errno> {
    let mut rp0 = MaybeUninit::<Size>::uninit();
    let ret = wasix_snapshot_preview1::poll_oneoff(
        in_ as i32,
        out as i32,
        nsubscriptions as i32,
        rp0.as_mut_ptr() as i32,
    );
    match ret {
        0 => Ok(core::ptr::read(rp0.as_mut_ptr() as i32 as *const Size)),
        _ => Err(Errno(ret as u16)),
    }
}

/// Terminate the process normally. An exit code of 0 indicates successful
/// termination of the program. The meanings of other values is dependent on
/// the environment.
///
/// ## Parameters
///
/// * `rval` - The exit code returned by the process.
pub unsafe fn proc_exit(rval: Exitcode) {
    wasix_snapshot_preview1::proc_exit(rval as i32);
}

/// Send a signal to the process of the calling thread.
/// Note: This is similar to `raise` in POSIX.
///
/// ## Parameters
///
/// * `sig` - The signal condition to trigger.
pub unsafe fn proc_raise(sig: Signal) -> Result<(), Errno> {
    let ret = wasix_snapshot_preview1::proc_raise(sig.0 as i32);
    match ret {
        0 => Ok(()),
        _ => Err(Errno(ret as u16)),
    }
}

/// Temporarily yield execution of the calling thread.
/// Note: This is similar to `sched_yield` in POSIX.
pub unsafe fn sched_yield() -> Result<(), Errno> {
    let ret = wasix_snapshot_preview1::sched_yield();
    match ret {
        0 => Ok(()),
        _ => Err(Errno(ret as u16)),
    }
}

/// Write high-quality random data into a buffer.
/// This function blocks when the implementation is unable to immediately
/// provide sufficient high-quality random data.
/// This function may execute slowly, so when large mounts of random data are
/// required, it's advisable to use this function to seed a pseudo-random
/// number generator, rather than to provide the random data directly.
///
/// ## Parameters
///
/// * `buf` - The buffer to fill with random data.
pub unsafe fn random_get(buf: *mut u8, buf_len: Size) -> Result<(), Errno> {
    let ret = wasix_snapshot_preview1::random_get(buf as i32, buf_len as i32);
    match ret {
        0 => Ok(()),
        _ => Err(Errno(ret as u16)),
    }
}

/// Opens the STDIN from TTY
pub unsafe fn tty_stdin() -> Result<Fd, Errno> {
    let mut rp0 = MaybeUninit::<Fd>::uninit();
    let ret = wasix_snapshot_preview1::tty_stdin(rp0.as_mut_ptr() as i32);
    match ret {
        0 => Ok(core::ptr::read(rp0.as_mut_ptr() as i32 as *const Fd)),
        _ => Err(Errno(ret as u16)),
    }
}

/// Opens the STDOUT from TTY
pub unsafe fn tty_stdout() -> Result<Fd, Errno> {
    let mut rp0 = MaybeUninit::<Fd>::uninit();
    let ret = wasix_snapshot_preview1::tty_stdout(rp0.as_mut_ptr() as i32);
    match ret {
        0 => Ok(core::ptr::read(rp0.as_mut_ptr() as i32 as *const Fd)),
        _ => Err(Errno(ret as u16)),
    }
}

/// Opens the STDERR from TTY
pub unsafe fn tty_stderr() -> Result<Fd, Errno> {
    let mut rp0 = MaybeUninit::<Fd>::uninit();
    let ret = wasix_snapshot_preview1::tty_stderr(rp0.as_mut_ptr() as i32);
    match ret {
        0 => Ok(core::ptr::read(rp0.as_mut_ptr() as i32 as *const Fd)),
        _ => Err(Errno(ret as u16)),
    }
}

/// Retrieves the rect of the TTY display
///
/// ## Parameters
///
/// * `rect` - The rect which will be filled by this call
pub unsafe fn tty_rect(rect: *mut Rect) -> Result<(), Errno> {
    let ret = wasix_snapshot_preview1::tty_rect(rect as i32);
    match ret {
        0 => Ok(()),
        _ => Err(Errno(ret as u16)),
    }
}

/// Returns the current working directory
///
/// ## Parameters
///
/// * `path` - The buffer where current directory is stored
///
/// ## Return
///
/// Number of bytes returned in the path buffer
pub unsafe fn getcwd(path: *mut u8, path_len: Size) -> Result<Size, Errno> {
    let mut rp0 = MaybeUninit::<Size>::uninit();
    let ret =
        wasix_snapshot_preview1::getcwd(path as i32, path_len as i32, rp0.as_mut_ptr() as i32);
    match ret {
        0 => Ok(core::ptr::read(rp0.as_mut_ptr() as i32 as *const Size)),
        _ => Err(Errno(ret as u16)),
    }
}

/// Sets the current working directory
///
/// ## Parameters
///
/// * `path` - Path to change the current working directory to
pub unsafe fn chdir(path: &str) -> Result<(), Errno> {
    let ret = wasix_snapshot_preview1::chdir(path.as_ptr() as i32, path.len() as i32);
    match ret {
        0 => Ok(()),
        _ => Err(Errno(ret as u16)),
    }
}

/// Creates a new thread by spawning that shares the same
/// memory address space, file handles and main event loops.
/// The function referenced by the fork call must be
/// exported by the web assembly process.
///
/// ## Parameters
///
/// * `name` - Name of the function that will be invoked as a new thread
/// * `user_data` - User data that will be supplied to the function when its called
/// * `reactor` - Indicates if the function will operate as a reactor or
///   as a normal thread. Reactors will be repeatable called
///   whenever IO work is available to be processed.
///
/// ## Return
///
/// Returns the thread index of the newly created thread
/// (indices always start from zero)
pub unsafe fn thread_spawn(name: &str, user_data: u64, reactor: Bool) -> Result<Tid, Errno> {
    let mut rp0 = MaybeUninit::<Tid>::uninit();
    let ret = wasix_snapshot_preview1::thread_spawn(
        name.as_ptr() as i32,
        name.len() as i32,
        user_data as i64,
        reactor.0 as i32,
        rp0.as_mut_ptr() as i32,
    );
    match ret {
        0 => Ok(core::ptr::read(rp0.as_mut_ptr() as i32 as *const Tid)),
        _ => Err(Errno(ret as u16)),
    }
}

/// Sends the current thread to sleep for a period of time
///
/// ## Parameters
///
/// * `duration` - Amount of time that the thread should sleep
pub unsafe fn thread_sleep(duration: Timestamp) -> Result<(), Errno> {
    let ret = wasix_snapshot_preview1::thread_sleep(duration as i64);
    match ret {
        0 => Ok(()),
        _ => Err(Errno(ret as u16)),
    }
}

/// Returns the index of the current thread
/// (threads indices are sequencial from zero)
pub unsafe fn thread_id() -> Result<Tid, Errno> {
    let mut rp0 = MaybeUninit::<Tid>::uninit();
    let ret = wasix_snapshot_preview1::thread_id(rp0.as_mut_ptr() as i32);
    match ret {
        0 => Ok(core::ptr::read(rp0.as_mut_ptr() as i32 as *const Tid)),
        _ => Err(Errno(ret as u16)),
    }
}

/// Joins this thread with another thread, blocking this
/// one until the other finishes
///
/// ## Parameters
///
/// * `tid` - Handle of the thread to wait on
pub unsafe fn thread_join(tid: Tid) -> Result<(), Errno> {
    let ret = wasix_snapshot_preview1::thread_join(tid as i32);
    match ret {
        0 => Ok(()),
        _ => Err(Errno(ret as u16)),
    }
}

/// Returns the available parallelism which is normally the
/// number of available cores that can run concurrently
pub unsafe fn thread_parallelism() -> Result<Size, Errno> {
    let mut rp0 = MaybeUninit::<Size>::uninit();
    let ret = wasix_snapshot_preview1::thread_parallelism(rp0.as_mut_ptr() as i32);
    match ret {
        0 => Ok(core::ptr::read(rp0.as_mut_ptr() as i32 as *const Size)),
        _ => Err(Errno(ret as u16)),
    }
}

/// Returns the handle of the current process
pub unsafe fn getpid() -> Result<Pid, Errno> {
    let mut rp0 = MaybeUninit::<Pid>::uninit();
    let ret = wasix_snapshot_preview1::getpid(rp0.as_mut_ptr() as i32);
    match ret {
        0 => Ok(core::ptr::read(rp0.as_mut_ptr() as i32 as *const Pid)),
        _ => Err(Errno(ret as u16)),
    }
}

/// Terminates the current running thread, if this is the last thread then
/// the process will also exit with the specified exit code. An exit code
/// of 0 indicates successful termination of the thread. The meanings of
/// other values is dependent on the environment.
///
/// ## Parameters
///
/// * `rval` - The exit code returned by the process.
pub unsafe fn thread_exit(rval: Exitcode) {
    wasix_snapshot_preview1::thread_exit(rval as i32);
}

/// Spawns a new bus process for a particular web WebAssembly
/// binary that is referenced by its process name.
///
/// ## Parameters
///
/// * `name` - Name of the process to be spawned
/// * `chroot` - Indicates if the process will chroot or not
/// * `args` - List of the arguments to pass the process
///   (entries are separated by line feeds)
/// * `preopen` - List of the preopens for this process
///   (entries are separated by line feeds)
/// * `stdin` - How will stdin be handled
/// * `stdout` - How will stdout be handled
/// * `stderr` - How will stderr be handled
/// * `working_dir` - Working directory where this process should run
///   (passing '.' will use the current directory)
///
/// ## Return
///
/// Returns a bus process id that can be used to invoke calls
pub unsafe fn bus_spawn_local(
    name: &str,
    chroot: Bool,
    args: &str,
    preopen: &str,
    stdin: StdioMode,
    stdout: StdioMode,
    stderr: StdioMode,
    working_dir: &str,
) -> Result<BusHandles, BusError> {
    let mut rp0 = MaybeUninit::<BusHandles>::uninit();
    let ret = wasix_snapshot_preview1::bus_spawn_local(
        name.as_ptr() as i32,
        name.len() as i32,
        chroot.0 as i32,
        args.as_ptr() as i32,
        args.len() as i32,
        preopen.as_ptr() as i32,
        preopen.len() as i32,
        stdin.0 as i32,
        stdout.0 as i32,
        stderr.0 as i32,
        working_dir.as_ptr() as i32,
        working_dir.len() as i32,
        rp0.as_mut_ptr() as i32,
    );
    match ret {
        0 => Ok(core::ptr::read(rp0.as_mut_ptr() as i32 as *const BusHandles)),
        _ => Err(BusError(ret as u32)),
    }
}

/// Spawns a new bus process for a particular web WebAssembly
/// binary that is referenced by its process name on a remote instance
///
/// ## Parameters
///
/// * `name` - Name of the process to be spawned
/// * `chroot` - Indicates if the process will chroot or not
/// * `args` - List of the arguments to pass the process
///   (entries are separated by line feeds)
/// * `preopen` - List of the preopens for this process
///   (entries are separated by line feeds)
/// * `working_dir` - Working directory where this process should run
///   (passing '.' will use the current directory)
/// * `stdin` - How will stdin be handled
/// * `stdout` - How will stdout be handled
/// * `stderr` - How will stderr be handled
/// * `instance` - Instance identifier where this process will be spawned
/// * `token` - Acceess token used to authenticate with the instance
///
/// ## Return
///
/// Returns a bus process id that can be used to invoke calls
pub unsafe fn bus_spawn_remote(
    name: &str,
    chroot: Bool,
    args: &str,
    preopen: &str,
    working_dir: &str,
    stdin: StdioMode,
    stdout: StdioMode,
    stderr: StdioMode,
    instance: &str,
    token: &str,
) -> Result<BusHandles, BusError> {
    let mut rp0 = MaybeUninit::<BusHandles>::uninit();
    let ret = wasix_snapshot_preview1::bus_spawn_remote(
        name.as_ptr() as i32,
        name.len() as i32,
        chroot.0 as i32,
        args.as_ptr() as i32,
        args.len() as i32,
        preopen.as_ptr() as i32,
        preopen.len() as i32,
        working_dir.as_ptr() as i32,
        working_dir.len() as i32,
        stdin.0 as i32,
        stdout.0 as i32,
        stderr.0 as i32,
        instance.as_ptr() as i32,
        instance.len() as i32,
        token.as_ptr() as i32,
        token.len() as i32,
        rp0.as_mut_ptr() as i32,
    );
    match ret {
        0 => Ok(core::ptr::read(rp0.as_mut_ptr() as i32 as *const BusHandles)),
        _ => Err(BusError(ret as u32)),
    }
}

/// Closes a bus process and releases all associated resources
///
/// ## Parameters
///
/// * `bid` - Handle of the bus process handle to be closed
pub unsafe fn bus_close(bid: Bid) -> Result<(), BusError> {
    let ret = wasix_snapshot_preview1::bus_close(bid as i32);
    match ret {
        0 => Ok(()),
        _ => Err(BusError(ret as u32)),
    }
}

/// Invokes a call within a running bus process.
///
/// ## Parameters
///
/// * `bid` - Handle of the bus process to invoke the call within
/// * `parent` - Optional parent bus call that this is related to
/// * `keep_alive` - Causes the call handle to remain open even when A
///   reply is received. It is then the  callers responsibility
///   to invoke 'bus_drop' when they are finished with the call
/// * `topic` - Topic that describes the type of call to made
/// * `buf` - The buffer where data to be transmitted is stored
pub unsafe fn bus_invoke(
    bid: Bid,
    parent: OptionCid,
    keep_alive: Bool,
    topic: &str,
    buf: BufArray<'_>,
) -> Result<Cid, BusError> {
    let mut rp0 = MaybeUninit::<Cid>::uninit();
    let ret = wasix_snapshot_preview1::bus_invoke(
        bid as i32,
        &parent as *const _ as i32,
        keep_alive.0 as i32,
        topic.as_ptr() as i32,
        topic.len() as i32,
        buf.as_ptr() as i32,
        buf.len() as i32,
        rp0.as_mut_ptr() as i32,
    );
    match ret {
        0 => Ok(core::ptr::read(rp0.as_mut_ptr() as i32 as *const Cid)),
        _ => Err(BusError(ret as u32)),
    }
}

/// Causes a fault on a particular call that was made
/// to this process from another process; where 'bid'
/// is the callering process context.
///
/// ## Parameters
///
/// * `cid` - Handle of the call to raise a fault on
/// * `fault` - Fault to be raised on the bus
pub unsafe fn bus_fault(cid: Cid, fault: BusError) -> Result<(), BusError> {
    let ret = wasix_snapshot_preview1::bus_fault(cid as i32, fault.0 as i32);
    match ret {
        0 => Ok(()),
        _ => Err(BusError(ret as u32)),
    }
}

/// Closes a bus call based on its bus call handle
///
/// ## Parameters
///
/// * `cid` - Handle of the bus call handle to be dropped
pub unsafe fn bus_drop(cid: Cid) -> Result<(), BusError> {
    let ret = wasix_snapshot_preview1::bus_drop(cid as i32);
    match ret {
        0 => Ok(()),
        _ => Err(BusError(ret as u32)),
    }
}

/// Replies to a call that was made to this process
/// from another process; where 'cid' is the call context.
/// This will may also drop the handle and release any
/// associated resources (if keepalive is not set)
///
/// ## Parameters
///
/// * `cid` - Handle of the call to send a reply on
/// * `buf` - The buffer where data to be transmitted is stored
pub unsafe fn bus_reply(cid: Cid, buf: BufArray<'_>) -> Result<(), BusError> {
    let ret = wasix_snapshot_preview1::bus_reply(cid as i32, buf.as_ptr() as i32, buf.len() as i32);
    match ret {
        0 => Ok(()),
        _ => Err(BusError(ret as u32)),
    }
}

/// Invokes a callback within the calling process against
/// a particular bus call represented by 'cid'.
///
/// ## Parameters
///
/// * `cid` - Handle of the call where a callback will be send
/// * `topic` - Topic that describes the type of callback
/// * `buf` - The buffer where data to be transmitted is stored
pub unsafe fn bus_callback(cid: Cid, topic: &str, buf: BufArray<'_>) -> Result<(), BusError> {
    let ret = wasix_snapshot_preview1::bus_callback(
        cid as i32,
        topic.as_ptr() as i32,
        topic.len() as i32,
        buf.as_ptr() as i32,
        buf.len() as i32,
    );
    match ret {
        0 => Ok(()),
        _ => Err(BusError(ret as u32)),
    }
}

/// Tells the operating system that this process is
/// now listening for bus calls on a particular topic
///
/// ## Parameters
///
/// * `parent` - Optional parent bus call that this is related to
/// * `topic` - Topic that describes the process will listen forcalls on
pub unsafe fn bus_listen(parent: OptionCid, topic: &str) -> Result<(), BusError> {
    let ret = wasix_snapshot_preview1::bus_listen(
        &parent as *const _ as i32,
        topic.as_ptr() as i32,
        topic.len() as i32,
    );
    match ret {
        0 => Ok(()),
        _ => Err(BusError(ret as u32)),
    }
}

/// Polls for any outstanding events from a particular
/// bus process by its handle
///
/// ## Parameters
///
/// * `bid` - Handle of the bus process to poll for new events
///   (if no process is supplied then it polls for the current process)
/// * `timeout` - Timeout before the poll returns, if one passed 0
///   as the timeout then this call is non blocking.
/// * `events` - An events buffer that will hold any received bus events
///
/// ## Return
///
/// Returns the number of events that have occured
pub unsafe fn bus_poll(
    bid: OptionBid,
    timeout: Timestamp,
    events: *mut BusEvent,
    nevents: Size,
) -> Result<Size, BusError> {
    let mut rp0 = MaybeUninit::<Size>::uninit();
    let ret = wasix_snapshot_preview1::bus_poll(
        &bid as *const _ as i32,
        timeout as i64,
        events as i32,
        nevents as i32,
        rp0.as_mut_ptr() as i32,
    );
    match ret {
        0 => Ok(core::ptr::read(rp0.as_mut_ptr() as i32 as *const Size)),
        _ => Err(BusError(ret as u32)),
    }
}

/// Receives the next event data from the bus
///
/// ## Parameters
///
/// * `bid` - Handle of the bus process to poll for new events
///   (if no process is supplied then it polls for the current process)
/// * `ty` - Type of event data that is held here
/// * `cid` - Handle of the call this data is related to
/// * `topic` - The topic that describes the event that happened
/// * `buf` - The buffer where event data is stored
///
/// ## Return
///
/// Returns the number of events that have occured
pub unsafe fn bus_poll_data(
    bid: OptionBid,
    ty: *mut BusDataType,
    cid: *mut Cid,
    topic: *mut u8,
    topic_len: Size,
    buf: *mut u8,
    buf_len: Size,
) -> Result<(), BusError> {
    let ret = wasix_snapshot_preview1::bus_poll_data(
        &bid as *const _ as i32,
        ty as i32,
        cid as i32,
        topic as i32,
        topic_len as i32,
        buf as i32,
        buf_len as i32,
    );
    match ret {
        0 => Ok(()),
        _ => Err(BusError(ret as u32)),
    }
}

/// Connects to a websocket at a particular network URL
///
/// ## Parameters
///
/// * `url` - URL of the web socket destination to connect to
///
/// ## Return
///
/// Returns a socket handle which is used to send and receive data
pub unsafe fn ws_connect(url: &str) -> Result<Fd, Errno> {
    let mut rp0 = MaybeUninit::<Fd>::uninit();
    let ret = wasix_snapshot_preview1::ws_connect(
        url.as_ptr() as i32,
        url.len() as i32,
        rp0.as_mut_ptr() as i32,
    );
    match ret {
        0 => Ok(core::ptr::read(rp0.as_mut_ptr() as i32 as *const Fd)),
        _ => Err(Errno(ret as u16)),
    }
}

/// Makes a HTTP request to a remote web resource and
/// returns a socket handles that are used to send and receive data
///
/// ## Parameters
///
/// * `url` - URL of the HTTP resource to connect to
/// * `method` - HTTP method to be invoked
/// * `headers` - HTTP headers to attach to the request
///   (headers seperated by lines)
/// * `gzip` - Should the request body be compressed
///
/// ## Return
///
/// The body of the response can be streamed from the returned
/// file handle
pub unsafe fn http_request(
    url: &str,
    method: &str,
    headers: &str,
    gzip: Bool,
) -> Result<HttpHandles, Errno> {
    let mut rp0 = MaybeUninit::<HttpHandles>::uninit();
    let ret = wasix_snapshot_preview1::http_request(
        url.as_ptr() as i32,
        url.len() as i32,
        method.as_ptr() as i32,
        method.len() as i32,
        headers.as_ptr() as i32,
        headers.len() as i32,
        gzip.0 as i32,
        rp0.as_mut_ptr() as i32,
    );
    match ret {
        0 => Ok(core::ptr::read(
            rp0.as_mut_ptr() as i32 as *const HttpHandles
        )),
        _ => Err(Errno(ret as u16)),
    }
}

/// Retrieves the status of a HTTP request
///
/// ## Parameters
///
/// * `fd` - Handle of the HTTP request
/// * `status` - Pointer to a buffer that will be filled with the current
///   status of this HTTP request
/// * `status_text` - Buffer that will hold the status text
///
/// ## Return
///
/// Returns the number of bytes held in the status text field
pub unsafe fn http_status(
    fd: Fd,
    status: *mut HttpStatus,
    status_text: *mut u8,
    status_text_len: Size,
) -> Result<Size, Errno> {
    let mut rp0 = MaybeUninit::<Size>::uninit();
    let ret = wasix_snapshot_preview1::http_status(
        fd as i32,
        status as i32,
        status_text as i32,
        status_text_len as i32,
        rp0.as_mut_ptr() as i32,
    );
    match ret {
        0 => Ok(core::ptr::read(rp0.as_mut_ptr() as i32 as *const Size)),
        _ => Err(Errno(ret as u16)),
    }
}

/// Securely connects to a particular remote network
///
/// ## Parameters
///
/// * `network` - Fully qualified identifier for the network
/// * `token` - Access token used to authenticate with the network
/// * `security` - Level of encryption to encapsulate the network connection with
pub unsafe fn port_connect(
    network: &str,
    token: &str,
    security: StreamSecurity,
) -> Result<(), Errno> {
    let ret = wasix_snapshot_preview1::port_connect(
        network.as_ptr() as i32,
        network.len() as i32,
        token.as_ptr() as i32,
        token.len() as i32,
        security as i32,
    );
    match ret {
        0 => Ok(()),
        _ => Err(Errno(ret as u16)),
    }
}

/// Disconnects from a remote network
pub unsafe fn port_disconnect() -> Result<(), Errno> {
    let ret = wasix_snapshot_preview1::port_disconnect();
    match ret {
        0 => Ok(()),
        _ => Err(Errno(ret as u16)),
    }
}

/// Acquires a set of IP addresses using DHCP
pub unsafe fn port_dhcp_acquire() -> Result<(), Errno> {
    let ret = wasix_snapshot_preview1::port_dhcp_acquire();
    match ret {
        0 => Ok(()),
        _ => Err(Errno(ret as u16)),
    }
}

/// Adds another static IP address to the local port
///
/// ## Parameters
///
/// * `ip` - IP address to be added
pub unsafe fn port_ip_add(ip: AddrIp) -> Result<(), Errno> {
    let ret = wasix_snapshot_preview1::port_ip_add(&ip as *const _ as i32);
    match ret {
        0 => Ok(()),
        _ => Err(Errno(ret as u16)),
    }
}

/// Removes an IP address from the local port
///
/// ## Parameters
///
/// * `ip` - IP address to be removed
pub unsafe fn port_ip_remove(ip: AddrIp) -> Result<(), Errno> {
    let ret = wasix_snapshot_preview1::port_ip_remove(&ip as *const _ as i32);
    match ret {
        0 => Ok(()),
        _ => Err(Errno(ret as u16)),
    }
}

/// Clears all the IP addresses on the local port
pub unsafe fn port_ip_clear() -> Result<(), Errno> {
    let ret = wasix_snapshot_preview1::port_ip_clear();
    match ret {
        0 => Ok(()),
        _ => Err(Errno(ret as u16)),
    }
}

/// Returns the MAC address of the local port
pub unsafe fn port_mac() -> Result<HardwareAddress, Errno> {
    let mut rp0 = MaybeUninit::<HardwareAddress>::uninit();
    let ret = wasix_snapshot_preview1::port_mac(rp0.as_mut_ptr() as i32);
    match ret {
        0 => Ok(core::ptr::read(
            rp0.as_mut_ptr() as i32 as *const HardwareAddress
        )),
        _ => Err(Errno(ret as u16)),
    }
}

/// Returns a list of all the IP addresses owned by the local port
/// This function fills the output buffer as much as possible.
///
/// ## Parameters
///
/// * `ips` - The buffer where IP addresses will be stored
///
/// ## Return
///
/// The number of IP addresses returned.
pub unsafe fn port_ip_list(ips: *mut AddrCidr, nips: Size) -> Result<Size, Errno> {
    let mut rp0 = MaybeUninit::<Size>::uninit();
    let ret =
        wasix_snapshot_preview1::port_ip_list(ips as i32, nips as i32, rp0.as_mut_ptr() as i32);
    match ret {
        0 => Ok(core::ptr::read(rp0.as_mut_ptr() as i32 as *const Size)),
        _ => Err(Errno(ret as u16)),
    }
}

/// Adds a default gateway to the port
///
/// ## Parameters
///
/// * `ip` - IP address of the default gateway
pub unsafe fn port_gateway_set(ip: AddrIp) -> Result<(), Errno> {
    let ret = wasix_snapshot_preview1::port_gateway_set(&ip as *const _ as i32);
    match ret {
        0 => Ok(()),
        _ => Err(Errno(ret as u16)),
    }
}

/// Adds a new route to the local port
pub unsafe fn port_route_add(
    cidr: AddrCidr,
    via_router: AddrIp,
    preferred_until: OptionTimestamp,
    expires_at: OptionTimestamp,
) -> Result<(), Errno> {
    let ret = wasix_snapshot_preview1::port_route_add(
        &cidr as *const _ as i32,
        &via_router as *const _ as i32,
        &preferred_until as *const _ as i32,
        &expires_at as *const _ as i32,
    );
    match ret {
        0 => Ok(()),
        _ => Err(Errno(ret as u16)),
    }
}

/// Removes an existing route from the local port
pub unsafe fn port_route_remove(cidr: AddrCidr) -> Result<(), Errno> {
    let ret = wasix_snapshot_preview1::port_route_remove(&cidr as *const _ as i32);
    match ret {
        0 => Ok(()),
        _ => Err(Errno(ret as u16)),
    }
}

/// Clears all the routes in the local port
pub unsafe fn port_route_clear(cidr: AddrCidr) -> Result<(), Errno> {
    let ret = wasix_snapshot_preview1::port_route_clear(&cidr as *const _ as i32);
    match ret {
        0 => Ok(()),
        _ => Err(Errno(ret as u16)),
    }
}

/// Returns a list of all the routes owned by the local port
/// This function fills the output buffer as much as possible.
///
/// ## Parameters
///
/// * `ips` - The buffer where routes will be stored
///
/// ## Return
///
/// The number of routes returned.
pub unsafe fn port_route_list(ips: *mut Route, nips: Size) -> Result<Size, Errno> {
    let mut rp0 = MaybeUninit::<Size>::uninit();
    let ret =
        wasix_snapshot_preview1::port_route_list(ips as i32, nips as i32, rp0.as_mut_ptr() as i32);
    match ret {
        0 => Ok(core::ptr::read(rp0.as_mut_ptr() as i32 as *const Size)),
        _ => Err(Errno(ret as u16)),
    }
}

/// Shut down socket send and receive channels.
/// Note: This is similar to `shutdown` in POSIX.
///
/// ## Parameters
///
/// * `how` - Which channels on the socket to shut down.
pub unsafe fn sock_shutdown(fd: Fd, how: Sdflags) -> Result<(), Errno> {
    let ret = wasix_snapshot_preview1::sock_shutdown(fd as i32, how as i32);
    match ret {
        0 => Ok(()),
        _ => Err(Errno(ret as u16)),
    }
}

/// Returns the current status of a socket
pub unsafe fn sock_status(fd: Fd) -> Result<SockStatus, Errno> {
    let mut rp0 = MaybeUninit::<SockStatus>::uninit();
    let ret = wasix_snapshot_preview1::sock_status(fd as i32, rp0.as_mut_ptr() as i32);
    match ret {
        0 => Ok(core::ptr::read(rp0.as_mut_ptr() as i32 as *const SockStatus)),
        _ => Err(Errno(ret as u16)),
    }
}

/// Returns the local address to which the socket is bound.
///
/// Note: This is similar to `getsockname` in POSIX
///
/// When successful, the contents of the output buffer consist of an IP address,
/// either IP4 or IP6.
///
/// ## Parameters
///
/// * `fd` - Socket that the address is bound to
pub unsafe fn sock_addr_local(fd: Fd) -> Result<AddrIp, Errno> {
    let mut rp0 = MaybeUninit::<AddrIp>::uninit();
    let ret = wasix_snapshot_preview1::sock_addr_local(fd as i32, rp0.as_mut_ptr() as i32);
    match ret {
        0 => Ok(core::ptr::read(rp0.as_mut_ptr() as i32 as *const AddrIp)),
        _ => Err(Errno(ret as u16)),
    }
}

/// Returns the remote address to which the socket is connected to.
///
/// Note: This is similar to `getpeername` in POSIX
///
/// When successful, the contents of the output buffer consist of an IP address,
/// either IP4 or IP6.
///
/// ## Parameters
///
/// * `fd` - Socket that the address is bound to
pub unsafe fn sock_addr_remote(fd: Fd) -> Result<AddrIp, Errno> {
    let mut rp0 = MaybeUninit::<AddrIp>::uninit();
    let ret = wasix_snapshot_preview1::sock_addr_remote(fd as i32, rp0.as_mut_ptr() as i32);
    match ret {
        0 => Ok(core::ptr::read(rp0.as_mut_ptr() as i32 as *const AddrIp)),
        _ => Err(Errno(ret as u16)),
    }
}

/// Create an endpoint for communication.
///
/// creates an endpoint for communication and returns a file descriptor
/// tor that refers to that endpoint. The file descriptor returned by a successful
/// call will be the lowest-numbered file descriptor not currently open
/// for the process.
///
/// Note: This is similar to `socket` in POSIX using PF_INET
///
/// ## Parameters
///
/// * `af` - Address family
/// * `socktype` - Socket type, either datagram or stream
///
/// ## Return
///
/// The file descriptor of the socket that has been opened.
pub unsafe fn sock_open(af: AddressFamily, socktype: SockType) -> Result<Fd, Errno> {
    let mut rp0 = MaybeUninit::<Fd>::uninit();
    let ret =
        wasix_snapshot_preview1::sock_open(af.0 as i32, socktype.0 as i32, rp0.as_mut_ptr() as i32);
    match ret {
        0 => Ok(core::ptr::read(rp0.as_mut_ptr() as i32 as *const Fd)),
        _ => Err(Errno(ret as u16)),
    }
}

/// Sets a particular socket setting
/// Note: This is similar to `setsockopt` in POSIX for SO_REUSEADDR
///
/// ## Parameters
///
/// * `fd` - Socket descriptor
/// * `sockopt` - Socket option to be set
/// * `reuse` - Value to set the option to
pub unsafe fn sock_set_opt(fd: Fd, sockopt: SockOption, reuse: Bool) -> Result<(), Errno> {
    let ret = wasix_snapshot_preview1::sock_set_opt(fd as i32, sockopt.0 as i32, reuse.0 as i32);
    match ret {
        0 => Ok(()),
        _ => Err(Errno(ret as u16)),
    }
}

/// Retrieve status of particular socket seting
/// Note: This is similar to `getsockopt` in POSIX for SO_REUSEADDR
///
/// ## Parameters
///
/// * `fd` - Socket descriptor
/// * `sockopt` - Socket option to be retrieved
pub unsafe fn sock_get_opt(fd: Fd, sockopt: SockOption) -> Result<Bool, Errno> {
    let mut rp0 = MaybeUninit::<Bool>::uninit();
    let ret =
        wasix_snapshot_preview1::sock_get_opt(fd as i32, sockopt.0 as i32, rp0.as_mut_ptr() as i32);
    match ret {
        0 => Ok(core::ptr::read(rp0.as_mut_ptr() as i32 as *const Bool)),
        _ => Err(Errno(ret as u16)),
    }
}

/// Sets how long the socket will linger
///
/// ## Parameters
///
/// * `fd` - Socket descriptor
/// * `reuse` - Value to set the linger to
pub unsafe fn sock_set_linger(fd: Fd, reuse: OptionTimestamp) -> Result<(), Errno> {
    let ret = wasix_snapshot_preview1::sock_set_linger(fd as i32, &reuse as *const _ as i32);
    match ret {
        0 => Ok(()),
        _ => Err(Errno(ret as u16)),
    }
}

/// Retrieve how long the socket will linger for
///
/// ## Parameters
///
/// * `fd` - Socket descriptor
pub unsafe fn sock_get_linger(fd: Fd) -> Result<OptionTimestamp, Errno> {
    let mut rp0 = MaybeUninit::<OptionTimestamp>::uninit();
    let ret = wasix_snapshot_preview1::sock_get_linger(fd as i32, rp0.as_mut_ptr() as i32);
    match ret {
        0 => Ok(core::ptr::read(
            rp0.as_mut_ptr() as i32 as *const OptionTimestamp
        )),
        _ => Err(Errno(ret as u16)),
    }
}

/// Sets one of the timeouts on the socket
///
/// ## Parameters
///
/// * `fd` - Socket descriptor
/// * `ty` - Type of timeout to be changed
/// * `reuse` - Value to set the timeout to
pub unsafe fn sock_set_timeout(
    fd: Fd,
    ty: TimeoutType,
    reuse: OptionTimestamp,
) -> Result<(), Errno> {
    let ret =
        wasix_snapshot_preview1::sock_set_timeout(fd as i32, ty as i32, &reuse as *const _ as i32);
    match ret {
        0 => Ok(()),
        _ => Err(Errno(ret as u16)),
    }
}

/// Retrieve one of the timeouts on the socket
///
/// ## Parameters
///
/// * `fd` - Socket descriptor
/// * `ty` - Type of timeout to be retrieved
pub unsafe fn sock_get_timeout(fd: Fd, ty: TimeoutType) -> Result<OptionTimestamp, Errno> {
    let mut rp0 = MaybeUninit::<OptionTimestamp>::uninit();
    let ret =
        wasix_snapshot_preview1::sock_get_timeout(fd as i32, ty as i32, rp0.as_mut_ptr() as i32);
    match ret {
        0 => Ok(core::ptr::read(
            rp0.as_mut_ptr() as i32 as *const OptionTimestamp
        )),
        _ => Err(Errno(ret as u16)),
    }
}

/// Set TTL for this socket
///
/// ## Parameters
///
/// * `fd` - Socket descriptor
/// * `ttl` - Time to live
pub unsafe fn sock_set_ttl(fd: Fd, ttl: Size) -> Result<(), Errno> {
    let ret = wasix_snapshot_preview1::sock_set_ttl(fd as i32, ttl as i32);
    match ret {
        0 => Ok(()),
        _ => Err(Errno(ret as u16)),
    }
}

/// Retrieve the TTL for this socket
///
/// ## Parameters
///
/// * `fd` - Socket descriptor
pub unsafe fn sock_get_ttl(fd: Fd) -> Result<Size, Errno> {
    let mut rp0 = MaybeUninit::<Size>::uninit();
    let ret = wasix_snapshot_preview1::sock_get_ttl(fd as i32, rp0.as_mut_ptr() as i32);
    match ret {
        0 => Ok(core::ptr::read(rp0.as_mut_ptr() as i32 as *const Size)),
        _ => Err(Errno(ret as u16)),
    }
}

/// Set TTL for IPv4 multicast for this socket
///
/// ## Parameters
///
/// * `fd` - Socket descriptor
/// * `ttl` - Time to live
pub unsafe fn sock_set_multicast_ttl_v4(fd: Fd, ttl: Size) -> Result<(), Errno> {
    let ret = wasix_snapshot_preview1::sock_set_multicast_ttl_v4(fd as i32, ttl as i32);
    match ret {
        0 => Ok(()),
        _ => Err(Errno(ret as u16)),
    }
}

/// Retrieve the TTL for IPv4 multicast for this socket
///
/// ## Parameters
///
/// * `fd` - Socket descriptor
pub unsafe fn sock_get_multicast_ttl_v4(fd: Fd) -> Result<Size, Errno> {
    let mut rp0 = MaybeUninit::<Size>::uninit();
    let ret =
        wasix_snapshot_preview1::sock_get_multicast_ttl_v4(fd as i32, rp0.as_mut_ptr() as i32);
    match ret {
        0 => Ok(core::ptr::read(rp0.as_mut_ptr() as i32 as *const Size)),
        _ => Err(Errno(ret as u16)),
    }
}

/// Joins a particular multicast IPv4 group
///
/// ## Parameters
///
/// * `fd` - Socket descriptor
/// * `multiaddr` - Multicast group to joined
/// * `interface` - Interface that will join
pub unsafe fn sock_join_multicast_v4(
    fd: Fd,
    multiaddr: AddrIp4,
    interface: AddrIp4,
) -> Result<(), Errno> {
    let ret = wasix_snapshot_preview1::sock_join_multicast_v4(
        fd as i32,
        &multiaddr as *const _ as i32,
        &interface as *const _ as i32,
    );
    match ret {
        0 => Ok(()),
        _ => Err(Errno(ret as u16)),
    }
}

/// Leaves a particular multicast IPv4 group
///
/// ## Parameters
///
/// * `fd` - Socket descriptor
/// * `multiaddr` - Multicast group to leave
/// * `interface` - Interface that will left
pub unsafe fn sock_leave_multicast_v4(
    fd: Fd,
    multiaddr: AddrIp4,
    interface: AddrIp4,
) -> Result<(), Errno> {
    let ret = wasix_snapshot_preview1::sock_leave_multicast_v4(
        fd as i32,
        &multiaddr as *const _ as i32,
        &interface as *const _ as i32,
    );
    match ret {
        0 => Ok(()),
        _ => Err(Errno(ret as u16)),
    }
}

/// Joins a particular multicast IPv6 group
///
/// ## Parameters
///
/// * `fd` - Socket descriptor
/// * `multiaddr` - Multicast group to joined
/// * `interface` - Interface that will join
pub unsafe fn sock_join_multicast_v6(
    fd: Fd,
    multiaddr: AddrIp6,
    interface: u32,
) -> Result<(), Errno> {
    let ret = wasix_snapshot_preview1::sock_join_multicast_v6(
        fd as i32,
        &multiaddr as *const _ as i32,
        interface as i32,
    );
    match ret {
        0 => Ok(()),
        _ => Err(Errno(ret as u16)),
    }
}

/// Leaves a particular multicast IPv6 group
///
/// ## Parameters
///
/// * `fd` - Socket descriptor
/// * `multiaddr` - Multicast group to leave
/// * `interface` - Interface that will left
pub unsafe fn sock_leave_multicast_v6(
    fd: Fd,
    multiaddr: AddrIp6,
    interface: u32,
) -> Result<(), Errno> {
    let ret = wasix_snapshot_preview1::sock_leave_multicast_v6(
        fd as i32,
        &multiaddr as *const _ as i32,
        interface as i32,
    );
    match ret {
        0 => Ok(()),
        _ => Err(Errno(ret as u16)),
    }
}

/// Set size of receive buffer
/// Note: This is similar to `setsockopt` in POSIX for SO_RCVBUF
///
/// ## Parameters
///
/// * `fd` - Socket descriptor
/// * `size` - Buffer size
pub unsafe fn sock_set_recv_buf_size(fd: Fd, size: Size) -> Result<(), Errno> {
    let ret = wasix_snapshot_preview1::sock_set_recv_buf_size(fd as i32, size as i32);
    match ret {
        0 => Ok(()),
        _ => Err(Errno(ret as u16)),
    }
}

/// Retrieve the size of the receive buffer
/// Note: This is similar to `getsockopt` in POSIX for SO_RCVBUF
///
/// ## Parameters
///
/// * `fd` - Socket descriptor
pub unsafe fn sock_get_recv_buf_size(fd: Fd) -> Result<Size, Errno> {
    let mut rp0 = MaybeUninit::<Size>::uninit();
    let ret = wasix_snapshot_preview1::sock_get_recv_buf_size(fd as i32, rp0.as_mut_ptr() as i32);
    match ret {
        0 => Ok(core::ptr::read(rp0.as_mut_ptr() as i32 as *const Size)),
        _ => Err(Errno(ret as u16)),
    }
}

/// Set size of send buffer
/// Note: This is similar to `setsockopt` in POSIX for SO_SNDBUF
///
/// ## Parameters
///
/// * `fd` - Socket descriptor
/// * `size` - Buffer size
pub unsafe fn sock_set_send_buf_size(fd: Fd, size: Size) -> Result<(), Errno> {
    let ret = wasix_snapshot_preview1::sock_set_send_buf_size(fd as i32, size as i32);
    match ret {
        0 => Ok(()),
        _ => Err(Errno(ret as u16)),
    }
}

/// Retrieve the size of the send buffer
/// Note: This is similar to `getsockopt` in POSIX for SO_SNDBUF
///
/// ## Parameters
///
/// * `fd` - Socket descriptor
pub unsafe fn sock_get_send_buf_size(fd: Fd) -> Result<Size, Errno> {
    let mut rp0 = MaybeUninit::<Size>::uninit();
    let ret = wasix_snapshot_preview1::sock_get_send_buf_size(fd as i32, rp0.as_mut_ptr() as i32);
    match ret {
        0 => Ok(core::ptr::read(rp0.as_mut_ptr() as i32 as *const Size)),
        _ => Err(Errno(ret as u16)),
    }
}

/// Bind a socket
/// Note: This is similar to `bind` in POSIX using PF_INET
///
/// ## Parameters
///
/// * `fd` - File descriptor of the socket to be bind
/// * `addr` - Address to bind the socket to
pub unsafe fn sock_bind(fd: Fd, addr: AddrPort) -> Result<(), Errno> {
    let ret = wasix_snapshot_preview1::sock_bind(fd as i32, &addr as *const _ as i32);
    match ret {
        0 => Ok(()),
        _ => Err(Errno(ret as u16)),
    }
}

/// Listen for connections on a socket
///
/// Polling the socket handle will wait until a connection
/// attempt is made
///
/// Note: This is similar to `listen`
///
/// ## Parameters
///
/// * `fd` - File descriptor of the socket to be bind
/// * `backlog` - Maximum size of the queue for pending connections
pub unsafe fn sock_listen(fd: Fd, backlog: Size) -> Result<(), Errno> {
    let ret = wasix_snapshot_preview1::sock_listen(fd as i32, backlog as i32);
    match ret {
        0 => Ok(()),
        _ => Err(Errno(ret as u16)),
    }
}

/// Accept a new incoming connection.
/// Note: This is similar to `accept` in POSIX.
///
/// ## Parameters
///
/// * `fd` - The listening socket.
/// * `flags` - The desired values of the file descriptor flags.
///
/// ## Return
///
/// New socket connection
pub unsafe fn sock_accept(fd: Fd, flags: Fdflags) -> Result<(Fd, AddrPort), Errno> {
    let mut rp0 = MaybeUninit::<Fd>::uninit();
    let mut rp1 = MaybeUninit::<AddrPort>::uninit();
    let ret = wasix_snapshot_preview1::sock_accept(
        fd as i32,
        flags as i32,
        rp0.as_mut_ptr() as i32,
        rp1.as_mut_ptr() as i32,
    );
    match ret {
        0 => Ok((
            core::ptr::read(rp0.as_mut_ptr() as i32 as *const Fd),
            core::ptr::read(rp1.as_mut_ptr() as i32 as *const AddrPort),
        )),
        _ => Err(Errno(ret as u16)),
    }
}

/// Initiate a connection on a socket to the specified address
///
/// Polling the socket handle will wait for data to arrive or for
/// the socket status to change which can be queried via 'sock_status'
///
/// Note: This is similar to `connect` in POSIX
///
/// ## Parameters
///
/// * `fd` - Socket descriptor
/// * `addr` - Address of the socket to connect to
pub unsafe fn sock_connect(fd: Fd, addr: AddrPort) -> Result<(), Errno> {
    let ret = wasix_snapshot_preview1::sock_connect(fd as i32, &addr as *const _ as i32);
    match ret {
        0 => Ok(()),
        _ => Err(Errno(ret as u16)),
    }
}

/// Receive a message from a socket.
/// Note: This is similar to `recv` in POSIX, though it also supports reading
/// the data into multiple buffers in the manner of `readv`.
///
/// ## Parameters
///
/// * `ri_data` - List of scatter/gather vectors to which to store data.
/// * `ri_flags` - Message flags.
///
/// ## Return
///
/// Number of bytes stored in ri_data and message flags.
pub unsafe fn sock_recv(
    fd: Fd,
    ri_data: IovecArray<'_>,
    ri_flags: Riflags,
) -> Result<(Size, Roflags), Errno> {
    let mut rp0 = MaybeUninit::<Size>::uninit();
    let mut rp1 = MaybeUninit::<Roflags>::uninit();
    let ret = wasix_snapshot_preview1::sock_recv(
        fd as i32,
        ri_data.as_ptr() as i32,
        ri_data.len() as i32,
        ri_flags as i32,
        rp0.as_mut_ptr() as i32,
        rp1.as_mut_ptr() as i32,
    );
    match ret {
        0 => Ok((
            core::ptr::read(rp0.as_mut_ptr() as i32 as *const Size),
            core::ptr::read(rp1.as_mut_ptr() as i32 as *const Roflags),
        )),
        _ => Err(Errno(ret as u16)),
    }
}

/// Receive a message and its peer address from a socket.
/// Note: This is similar to `recvfrom` in POSIX, though it also supports reading
/// the data into multiple buffers in the manner of `readv`.
///
/// ## Parameters
///
/// * `ri_data` - List of scatter/gather vectors to which to store data.
/// * `ri_flags` - Message flags.
///
/// ## Return
///
/// Number of bytes stored in ri_data and message flags.
pub unsafe fn sock_recv_from(
    fd: Fd,
    ri_data: IovecArray<'_>,
    ri_flags: Riflags,
) -> Result<(Size, Roflags, AddrPort), Errno> {
    let mut rp0 = MaybeUninit::<Size>::uninit();
    let mut rp1 = MaybeUninit::<Roflags>::uninit();
    let mut rp2 = MaybeUninit::<AddrPort>::uninit();
    let ret = wasix_snapshot_preview1::sock_recv_from(
        fd as i32,
        ri_data.as_ptr() as i32,
        ri_data.len() as i32,
        ri_flags as i32,
        rp0.as_mut_ptr() as i32,
        rp1.as_mut_ptr() as i32,
        rp2.as_mut_ptr() as i32,
    );
    match ret {
        0 => Ok((
            core::ptr::read(rp0.as_mut_ptr() as i32 as *const Size),
            core::ptr::read(rp1.as_mut_ptr() as i32 as *const Roflags),
            core::ptr::read(rp2.as_mut_ptr() as i32 as *const AddrPort),
        )),
        _ => Err(Errno(ret as u16)),
    }
}

/// Send a message on a socket.
/// Note: This is similar to `send` in POSIX, though it also supports writing
/// the data from multiple buffers in the manner of `writev`.
///
/// ## Parameters
///
/// * `si_data` - List of scatter/gather vectors to which to retrieve data
/// * `si_flags` - Message flags.
///
/// ## Return
///
/// Number of bytes transmitted.
pub unsafe fn sock_send(
    fd: Fd,
    si_data: CiovecArray<'_>,
    si_flags: Siflags,
) -> Result<Size, Errno> {
    let mut rp0 = MaybeUninit::<Size>::uninit();
    let ret = wasix_snapshot_preview1::sock_send(
        fd as i32,
        si_data.as_ptr() as i32,
        si_data.len() as i32,
        si_flags as i32,
        rp0.as_mut_ptr() as i32,
    );
    match ret {
        0 => Ok(core::ptr::read(rp0.as_mut_ptr() as i32 as *const Size)),
        _ => Err(Errno(ret as u16)),
    }
}

/// Send a message on a socket to a specific address.
/// Note: This is similar to `sendto` in POSIX, though it also supports writing
/// the data from multiple buffers in the manner of `writev`.
///
/// ## Parameters
///
/// * `si_data` - List of scatter/gather vectors to which to retrieve data
/// * `si_flags` - Message flags.
/// * `addr` - Address of the socket to send message to
///
/// ## Return
///
/// Number of bytes transmitted.
pub unsafe fn sock_send_to(
    fd: Fd,
    si_data: CiovecArray<'_>,
    si_flags: Siflags,
    addr: AddrPort,
) -> Result<Size, Errno> {
    let mut rp0 = MaybeUninit::<Size>::uninit();
    let ret = wasix_snapshot_preview1::sock_send_to(
        fd as i32,
        si_data.as_ptr() as i32,
        si_data.len() as i32,
        si_flags as i32,
        &addr as *const _ as i32,
        rp0.as_mut_ptr() as i32,
    );
    match ret {
        0 => Ok(core::ptr::read(rp0.as_mut_ptr() as i32 as *const Size)),
        _ => Err(Errno(ret as u16)),
    }
}

/// Resolves a hostname and a port to one or more IP addresses.
///
/// Note: This is similar to `getaddrinfo` in POSIX
///
/// When successful, the contents of the output buffer consist of a sequence of
/// IPv4 and/or IPv6 addresses. Each address entry consists of a addr_t object.
/// This function fills the output buffer as much as possible.
///
/// ## Parameters
///
/// * `host` - Host to resolve
/// * `port` - Port hint (zero if no hint is supplied)
/// * `ips` - The buffer where IP addresses will be stored
///
/// ## Return
///
/// The number of IP addresses returned during the DNS resolution.
pub unsafe fn resolve(host: &str, port: u16, ips: *mut AddrIp, nips: Size) -> Result<Size, Errno> {
    let mut rp0 = MaybeUninit::<Size>::uninit();
    let ret = wasix_snapshot_preview1::resolve(
        host.as_ptr() as i32,
        host.len() as i32,
        port as i32,
        ips as i32,
        nips as i32,
        rp0.as_mut_ptr() as i32,
    );
    match ret {
        0 => Ok(core::ptr::read(rp0.as_mut_ptr() as i32 as *const Size)),
        _ => Err(Errno(ret as u16)),
    }
}

pub mod wasix_snapshot_preview1 {
    #[link(wasm_import_module = "wasix_snapshot_preview1")]
    extern "C" {
        /// Read command-line argument data.
        /// The size of the array should match that returned by `args_sizes_get`.
        /// Each argument is expected to be `\0` terminated.
        pub fn args_get(arg0: i32, arg1: i32) -> i32;
        /// Return command-line argument data sizes.
        pub fn args_sizes_get(arg0: i32, arg1: i32) -> i32;
        /// Read environment variable data.
        /// The sizes of the buffers should match that returned by `environ_sizes_get`.
        /// Key/value pairs are expected to be joined with `=`s, and terminated with `\0`s.
        pub fn environ_get(arg0: i32, arg1: i32) -> i32;
        /// Return environment variable data sizes.
        pub fn environ_sizes_get(arg0: i32, arg1: i32) -> i32;
        /// Return the resolution of a clock.
        /// Implementations are required to provide a non-zero value for supported clocks. For unsupported clocks,
        /// return `errno::inval`.
        /// Note: This is similar to `clock_getres` in POSIX.
        pub fn clock_res_get(arg0: i32, arg1: i32) -> i32;
        /// Return the time value of a clock.
        /// Note: This is similar to `clock_gettime` in POSIX.
        pub fn clock_time_get(arg0: i32, arg1: i64, arg2: i32) -> i32;
        /// Provide file advisory information on a file descriptor.
        /// Note: This is similar to `posix_fadvise` in POSIX.
        pub fn fd_advise(arg0: i32, arg1: i64, arg2: i64, arg3: i32) -> i32;
        /// Force the allocation of space in a file.
        /// Note: This is similar to `posix_fallocate` in POSIX.
        pub fn fd_allocate(arg0: i32, arg1: i64, arg2: i64) -> i32;
        /// Close a file descriptor.
        /// Note: This is similar to `close` in POSIX.
        pub fn fd_close(arg0: i32) -> i32;
        /// Synchronize the data of a file to disk.
        /// Note: This is similar to `fdatasync` in POSIX.
        pub fn fd_datasync(arg0: i32) -> i32;
        /// Get the attributes of a file descriptor.
        /// Note: This returns similar flags to `fsync(fd, F_GETFL)` in POSIX, as well as additional fields.
        pub fn fd_fdstat_get(arg0: i32, arg1: i32) -> i32;
        /// Adjust the flags associated with a file descriptor.
        /// Note: This is similar to `fcntl(fd, F_SETFL, flags)` in POSIX.
        pub fn fd_fdstat_set_flags(arg0: i32, arg1: i32) -> i32;
        /// Adjust the rights associated with a file descriptor.
        /// This can only be used to remove rights, and returns `errno::notcapable` if called in a way that would attempt to add rights
        pub fn fd_fdstat_set_rights(arg0: i32, arg1: i64, arg2: i64) -> i32;
        /// Return the attributes of an open file.
        pub fn fd_filestat_get(arg0: i32, arg1: i32) -> i32;
        /// Adjust the size of an open file. If this increases the file's size, the extra bytes are filled with zeros.
        /// Note: This is similar to `ftruncate` in POSIX.
        pub fn fd_filestat_set_size(arg0: i32, arg1: i64) -> i32;
        /// Adjust the timestamps of an open file or directory.
        /// Note: This is similar to `futimens` in POSIX.
        pub fn fd_filestat_set_times(arg0: i32, arg1: i64, arg2: i64, arg3: i32) -> i32;
        /// Read from a file descriptor, without using and updating the file descriptor's offset.
        /// Note: This is similar to `preadv` in POSIX.
        pub fn fd_pread(arg0: i32, arg1: i32, arg2: i32, arg3: i64, arg4: i32) -> i32;
        /// Return a description of the given preopened file descriptor.
        pub fn fd_prestat_get(arg0: i32, arg1: i32) -> i32;
        /// Return a description of the given preopened file descriptor.
        pub fn fd_prestat_dir_name(arg0: i32, arg1: i32, arg2: i32) -> i32;
        /// Write to a file descriptor, without using and updating the file descriptor's offset.
        /// Note: This is similar to `pwritev` in POSIX.
        pub fn fd_pwrite(arg0: i32, arg1: i32, arg2: i32, arg3: i64, arg4: i32) -> i32;
        /// Read from a file descriptor.
        /// Note: This is similar to `readv` in POSIX.
        pub fn fd_read(arg0: i32, arg1: i32, arg2: i32, arg3: i32) -> i32;
        /// Read directory entries from a directory.
        /// When successful, the contents of the output buffer consist of a sequence of
        /// directory entries. Each directory entry consists of a `dirent` object,
        /// followed by `dirent::d_namlen` bytes holding the name of the directory
        /// entry.
        /// This function fills the output buffer as much as possible, potentially
        /// truncating the last directory entry. This allows the caller to grow its
        /// read buffer size in case it's too small to fit a single large directory
        /// entry, or skip the oversized directory entry.
        pub fn fd_readdir(arg0: i32, arg1: i32, arg2: i32, arg3: i64, arg4: i32) -> i32;
        /// Atomically replace a file descriptor by renumbering another file descriptor.
        /// Due to the strong focus on thread safety, this environment does not provide
        /// a mechanism to duplicate or renumber a file descriptor to an arbitrary
        /// number, like `dup2()`. This would be prone to race conditions, as an actual
        /// file descriptor with the same number could be allocated by a different
        /// thread at the same time.
        /// This function provides a way to atomically renumber file descriptors, which
        /// would disappear if `dup2()` were to be removed entirely.
        pub fn fd_renumber(arg0: i32, arg1: i32) -> i32;
        /// Atomically duplicate a file handle.
        pub fn fd_dup(arg0: i32, arg1: i32) -> i32;
        /// Move the offset of a file descriptor.
        /// Note: This is similar to `lseek` in POSIX.
        pub fn fd_seek(arg0: i32, arg1: i64, arg2: i32, arg3: i32) -> i32;
        /// Synchronize the data and metadata of a file to disk.
        /// Note: This is similar to `fsync` in POSIX.
        pub fn fd_sync(arg0: i32) -> i32;
        /// Return the current offset of a file descriptor.
        /// Note: This is similar to `lseek(fd, 0, SEEK_CUR)` in POSIX.
        pub fn fd_tell(arg0: i32, arg1: i32) -> i32;
        /// Write to a file descriptor.
        /// Note: This is similar to `writev` in POSIX.
        pub fn fd_write(arg0: i32, arg1: i32, arg2: i32, arg3: i32) -> i32;
        /// Opens a pipe with two file handles
        ///
        /// Pipes are bidirectional meaning
        pub fn pipe(arg0: i32) -> i32;
        /// Create a directory.
        /// Note: This is similar to `mkdirat` in POSIX.
        pub fn path_create_directory(arg0: i32, arg1: i32, arg2: i32) -> i32;
        /// Return the attributes of a file or directory.
        /// Note: This is similar to `stat` in POSIX.
        pub fn path_filestat_get(arg0: i32, arg1: i32, arg2: i32, arg3: i32, arg4: i32) -> i32;
        /// Adjust the timestamps of a file or directory.
        /// Note: This is similar to `utimensat` in POSIX.
        pub fn path_filestat_set_times(
            arg0: i32,
            arg1: i32,
            arg2: i32,
            arg3: i32,
            arg4: i64,
            arg5: i64,
            arg6: i32,
        ) -> i32;
        /// Create a hard link.
        /// Note: This is similar to `linkat` in POSIX.
        pub fn path_link(
            arg0: i32,
            arg1: i32,
            arg2: i32,
            arg3: i32,
            arg4: i32,
            arg5: i32,
            arg6: i32,
        ) -> i32;
        /// Open a file or directory.
        /// The returned file descriptor is not guaranteed to be the lowest-numbered
        /// file descriptor not currently open; it is randomized to prevent
        /// applications from depending on making assumptions about indexes, since this
        /// is error-prone in multi-threaded contexts. The returned file descriptor is
        /// guaranteed to be less than 2**31.
        /// Note: This is similar to `openat` in POSIX.
        pub fn path_open(
            arg0: i32,
            arg1: i32,
            arg2: i32,
            arg3: i32,
            arg4: i32,
            arg5: i64,
            arg6: i64,
            arg7: i32,
            arg8: i32,
        ) -> i32;
        /// Read the contents of a symbolic link.
        /// Note: This is similar to `readlinkat` in POSIX.
        pub fn path_readlink(
            arg0: i32,
            arg1: i32,
            arg2: i32,
            arg3: i32,
            arg4: i32,
            arg5: i32,
        ) -> i32;
        /// Remove a directory.
        /// Return `errno::notempty` if the directory is not empty.
        /// Note: This is similar to `unlinkat(fd, path, AT_REMOVEDIR)` in POSIX.
        pub fn path_remove_directory(arg0: i32, arg1: i32, arg2: i32) -> i32;
        /// Rename a file or directory.
        /// Note: This is similar to `renameat` in POSIX.
        pub fn path_rename(arg0: i32, arg1: i32, arg2: i32, arg3: i32, arg4: i32, arg5: i32)
            -> i32;
        /// Create a symbolic link.
        /// Note: This is similar to `symlinkat` in POSIX.
        pub fn path_symlink(arg0: i32, arg1: i32, arg2: i32, arg3: i32, arg4: i32) -> i32;
        /// Unlink a file.
        /// Return `errno::isdir` if the path refers to a directory.
        /// Note: This is similar to `unlinkat(fd, path, 0)` in POSIX.
        pub fn path_unlink_file(arg0: i32, arg1: i32, arg2: i32) -> i32;
        /// Concurrently poll for the occurrence of a set of events.
        pub fn poll_oneoff(arg0: i32, arg1: i32, arg2: i32, arg3: i32) -> i32;
        /// Terminate the process normally. An exit code of 0 indicates successful
        /// termination of the program. The meanings of other values is dependent on
        /// the environment.
        pub fn proc_exit(arg0: i32) -> !;
        /// Send a signal to the process of the calling thread.
        /// Note: This is similar to `raise` in POSIX.
        pub fn proc_raise(arg0: i32) -> i32;
        /// Temporarily yield execution of the calling thread.
        /// Note: This is similar to `sched_yield` in POSIX.
        pub fn sched_yield() -> i32;
        /// Write high-quality random data into a buffer.
        /// This function blocks when the implementation is unable to immediately
        /// provide sufficient high-quality random data.
        /// This function may execute slowly, so when large mounts of random data are
        /// required, it's advisable to use this function to seed a pseudo-random
        /// number generator, rather than to provide the random data directly.
        pub fn random_get(arg0: i32, arg1: i32) -> i32;
        /// Opens the STDIN from TTY
        pub fn tty_stdin(arg0: i32) -> i32;
        /// Opens the STDOUT from TTY
        pub fn tty_stdout(arg0: i32) -> i32;
        /// Opens the STDERR from TTY
        pub fn tty_stderr(arg0: i32) -> i32;
        /// Retrieves the rect of the TTY display
        pub fn tty_rect(arg0: i32) -> i32;
        /// Returns the current working directory
        pub fn getcwd(arg0: i32, arg1: i32, arg2: i32) -> i32;
        /// Sets the current working directory
        pub fn chdir(arg0: i32, arg1: i32) -> i32;
        /// Creates a new thread by spawning that shares the same
        /// memory address space, file handles and main event loops.
        /// The function referenced by the fork call must be
        /// exported by the web assembly process.
        pub fn thread_spawn(arg0: i32, arg1: i32, arg2: i64, arg3: i32, arg4: i32) -> i32;
        /// Sends the current thread to sleep for a period of time
        pub fn thread_sleep(arg0: i64) -> i32;
        /// Returns the index of the current thread
        /// (threads indices are sequencial from zero)
        pub fn thread_id(arg0: i32) -> i32;
        /// Joins this thread with another thread, blocking this
        /// one until the other finishes
        pub fn thread_join(arg0: i32) -> i32;
        /// Returns the available parallelism which is normally the
        /// number of available cores that can run concurrently
        pub fn thread_parallelism(arg0: i32) -> i32;
        /// Returns the handle of the current process
        pub fn getpid(arg0: i32) -> i32;
        /// Terminates the current running thread, if this is the last thread then
        /// the process will also exit with the specified exit code. An exit code
        /// of 0 indicates successful termination of the thread. The meanings of
        /// other values is dependent on the environment.
        pub fn thread_exit(arg0: i32) -> !;
        /// Spawns a new bus process for a particular web WebAssembly
        /// binary that is referenced by its process name.
        pub fn bus_spawn_local(
            arg0: i32,
            arg1: i32,
            arg2: i32,
            arg3: i32,
            arg4: i32,
            arg5: i32,
            arg6: i32,
            arg7: i32,
            arg8: i32,
            arg9: i32,
            arg10: i32,
            arg11: i32,
            arg12: i32,
        ) -> i32;
        /// Spawns a new bus process for a particular web WebAssembly
        /// binary that is referenced by its process name on a remote instance
        pub fn bus_spawn_remote(
            arg0: i32,
            arg1: i32,
            arg2: i32,
            arg3: i32,
            arg4: i32,
            arg5: i32,
            arg6: i32,
            arg7: i32,
            arg8: i32,
            arg9: i32,
            arg10: i32,
            arg11: i32,
            arg12: i32,
            arg13: i32,
            arg14: i32,
            arg15: i32,
            arg16: i32,
        ) -> i32;
        /// Closes a bus process and releases all associated resources
        pub fn bus_close(arg0: i32) -> i32;
        /// Invokes a call within a running bus process.
        pub fn bus_invoke(
            arg0: i32,
            arg1: i32,
            arg2: i32,
            arg3: i32,
            arg4: i32,
            arg5: i32,
            arg6: i32,
            arg7: i32,
        ) -> i32;
        /// Causes a fault on a particular call that was made
        /// to this process from another process; where 'bid'
        /// is the callering process context.
        pub fn bus_fault(arg0: i32, arg1: i32) -> i32;
        /// Closes a bus call based on its bus call handle
        pub fn bus_drop(arg0: i32) -> i32;
        /// Replies to a call that was made to this process
        /// from another process; where 'cid' is the call context.
        /// This will may also drop the handle and release any
        /// associated resources (if keepalive is not set)
        pub fn bus_reply(arg0: i32, arg1: i32, arg2: i32) -> i32;
        /// Invokes a callback within the calling process against
        /// a particular bus call represented by 'cid'.
        pub fn bus_callback(arg0: i32, arg1: i32, arg2: i32, arg3: i32, arg4: i32) -> i32;
        /// Tells the operating system that this process is
        /// now listening for bus calls on a particular topic
        pub fn bus_listen(arg0: i32, arg1: i32, arg2: i32) -> i32;
        /// Polls for any outstanding events from a particular
        /// bus process by its handle
        pub fn bus_poll(arg0: i32, arg1: i64, arg2: i32, arg3: i32, arg4: i32) -> i32;
        /// Receives the next event data from the bus
        pub fn bus_poll_data(
            arg0: i32,
            arg1: i32,
            arg2: i32,
            arg3: i32,
            arg4: i32,
            arg5: i32,
            arg6: i32,
        ) -> i32;
        /// Connects to a websocket at a particular network URL
        pub fn ws_connect(arg0: i32, arg1: i32, arg2: i32) -> i32;
        /// Makes a HTTP request to a remote web resource and
        /// returns a socket handles that are used to send and receive data
        pub fn http_request(
            arg0: i32,
            arg1: i32,
            arg2: i32,
            arg3: i32,
            arg4: i32,
            arg5: i32,
            arg6: i32,
            arg7: i32,
        ) -> i32;
        /// Retrieves the status of a HTTP request
        pub fn http_status(arg0: i32, arg1: i32, arg2: i32, arg3: i32, arg4: i32) -> i32;
        /// Securely connects to a particular remote network
        pub fn port_connect(arg0: i32, arg1: i32, arg2: i32, arg3: i32, arg4: i32) -> i32;
        /// Disconnects from a remote network
        pub fn port_disconnect() -> i32;
        /// Acquires a set of IP addresses using DHCP
        pub fn port_dhcp_acquire() -> i32;
        /// Adds another static IP address to the local port
        pub fn port_ip_add(arg0: i32) -> i32;
        /// Removes an IP address from the local port
        pub fn port_ip_remove(arg0: i32) -> i32;
        /// Clears all the IP addresses on the local port
        pub fn port_ip_clear() -> i32;
        /// Returns the MAC address of the local port
        pub fn port_mac(arg0: i32) -> i32;
        /// Returns a list of all the IP addresses owned by the local port
        /// This function fills the output buffer as much as possible.
        pub fn port_ip_list(arg0: i32, arg1: i32, arg2: i32) -> i32;
        /// Adds a default gateway to the port
        pub fn port_gateway_set(arg0: i32) -> i32;
        /// Adds a new route to the local port
        pub fn port_route_add(arg0: i32, arg1: i32, arg2: i32, arg3: i32) -> i32;
        /// Removes an existing route from the local port
        pub fn port_route_remove(arg0: i32) -> i32;
        /// Clears all the routes in the local port
        pub fn port_route_clear(arg0: i32) -> i32;
        /// Returns a list of all the routes owned by the local port
        /// This function fills the output buffer as much as possible.
        pub fn port_route_list(arg0: i32, arg1: i32, arg2: i32) -> i32;
        /// Shut down socket send and receive channels.
        /// Note: This is similar to `shutdown` in POSIX.
        pub fn sock_shutdown(arg0: i32, arg1: i32) -> i32;
        /// Returns the current status of a socket
        pub fn sock_status(arg0: i32, arg1: i32) -> i32;
        /// Returns the local address to which the socket is bound.
        ///
        /// Note: This is similar to `getsockname` in POSIX
        ///
        /// When successful, the contents of the output buffer consist of an IP address,
        /// either IP4 or IP6.
        pub fn sock_addr_local(arg0: i32, arg1: i32) -> i32;
        /// Returns the remote address to which the socket is connected to.
        ///
        /// Note: This is similar to `getpeername` in POSIX
        ///
        /// When successful, the contents of the output buffer consist of an IP address,
        /// either IP4 or IP6.
        pub fn sock_addr_remote(arg0: i32, arg1: i32) -> i32;
        /// Create an endpoint for communication.
        ///
        /// creates an endpoint for communication and returns a file descriptor
        /// tor that refers to that endpoint. The file descriptor returned by a successful
        /// call will be the lowest-numbered file descriptor not currently open
        /// for the process.
        ///
        /// Note: This is similar to `socket` in POSIX using PF_INET
        pub fn sock_open(arg0: i32, arg1: i32, arg2: i32) -> i32;
        /// Sets a particular socket setting
        /// Note: This is similar to `setsockopt` in POSIX for SO_REUSEADDR
        pub fn sock_set_opt(arg0: i32, arg1: i32, arg2: i32) -> i32;
        /// Retrieve status of particular socket seting
        /// Note: This is similar to `getsockopt` in POSIX for SO_REUSEADDR
        pub fn sock_get_opt(arg0: i32, arg1: i32, arg2: i32) -> i32;
        /// Sets how long the socket will linger
        pub fn sock_set_linger(arg0: i32, arg1: i32) -> i32;
        /// Retrieve how long the socket will linger for
        pub fn sock_get_linger(arg0: i32, arg1: i32) -> i32;
        /// Sets one of the timeouts on the socket
        pub fn sock_set_timeout(arg0: i32, arg1: i32, arg2: i32) -> i32;
        /// Retrieve one of the timeouts on the socket
        pub fn sock_get_timeout(arg0: i32, arg1: i32, arg2: i32) -> i32;
        /// Set TTL for this socket
        pub fn sock_set_ttl(arg0: i32, arg1: i32) -> i32;
        /// Retrieve the TTL for this socket
        pub fn sock_get_ttl(arg0: i32, arg1: i32) -> i32;
        /// Set TTL for IPv4 multicast for this socket
        pub fn sock_set_multicast_ttl_v4(arg0: i32, arg1: i32) -> i32;
        /// Retrieve the TTL for IPv4 multicast for this socket
        pub fn sock_get_multicast_ttl_v4(arg0: i32, arg1: i32) -> i32;
        /// Joins a particular multicast IPv4 group
        pub fn sock_join_multicast_v4(arg0: i32, arg1: i32, arg2: i32) -> i32;
        /// Leaves a particular multicast IPv4 group
        pub fn sock_leave_multicast_v4(arg0: i32, arg1: i32, arg2: i32) -> i32;
        /// Joins a particular multicast IPv6 group
        pub fn sock_join_multicast_v6(arg0: i32, arg1: i32, arg2: i32) -> i32;
        /// Leaves a particular multicast IPv6 group
        pub fn sock_leave_multicast_v6(arg0: i32, arg1: i32, arg2: i32) -> i32;
        /// Set size of receive buffer
        /// Note: This is similar to `setsockopt` in POSIX for SO_RCVBUF
        pub fn sock_set_recv_buf_size(arg0: i32, arg1: i32) -> i32;
        /// Retrieve the size of the receive buffer
        /// Note: This is similar to `getsockopt` in POSIX for SO_RCVBUF
        pub fn sock_get_recv_buf_size(arg0: i32, arg1: i32) -> i32;
        /// Set size of send buffer
        /// Note: This is similar to `setsockopt` in POSIX for SO_SNDBUF
        pub fn sock_set_send_buf_size(arg0: i32, arg1: i32) -> i32;
        /// Retrieve the size of the send buffer
        /// Note: This is similar to `getsockopt` in POSIX for SO_SNDBUF
        pub fn sock_get_send_buf_size(arg0: i32, arg1: i32) -> i32;
        /// Bind a socket
        /// Note: This is similar to `bind` in POSIX using PF_INET
        pub fn sock_bind(arg0: i32, arg1: i32) -> i32;
        /// Listen for connections on a socket
        ///
        /// Polling the socket handle will wait until a connection
        /// attempt is made
        ///
        /// Note: This is similar to `listen`
        pub fn sock_listen(arg0: i32, arg1: i32) -> i32;
        /// Accept a new incoming connection.
        /// Note: This is similar to `accept` in POSIX.
        pub fn sock_accept(arg0: i32, arg1: i32, arg2: i32, arg3: i32) -> i32;
        /// Initiate a connection on a socket to the specified address
        ///
        /// Polling the socket handle will wait for data to arrive or for
        /// the socket status to change which can be queried via 'sock_status'
        ///
        /// Note: This is similar to `connect` in POSIX
        pub fn sock_connect(arg0: i32, arg1: i32) -> i32;
        /// Receive a message from a socket.
        /// Note: This is similar to `recv` in POSIX, though it also supports reading
        /// the data into multiple buffers in the manner of `readv`.
        pub fn sock_recv(arg0: i32, arg1: i32, arg2: i32, arg3: i32, arg4: i32, arg5: i32) -> i32;
        /// Receive a message and its peer address from a socket.
        /// Note: This is similar to `recvfrom` in POSIX, though it also supports reading
        /// the data into multiple buffers in the manner of `readv`.
        pub fn sock_recv_from(
            arg0: i32,
            arg1: i32,
            arg2: i32,
            arg3: i32,
            arg4: i32,
            arg5: i32,
            arg6: i32,
        ) -> i32;
        /// Send a message on a socket.
        /// Note: This is similar to `send` in POSIX, though it also supports writing
        /// the data from multiple buffers in the manner of `writev`.
        pub fn sock_send(arg0: i32, arg1: i32, arg2: i32, arg3: i32, arg4: i32) -> i32;
        /// Send a message on a socket to a specific address.
        /// Note: This is similar to `sendto` in POSIX, though it also supports writing
        /// the data from multiple buffers in the manner of `writev`.
        pub fn sock_send_to(
            arg0: i32,
            arg1: i32,
            arg2: i32,
            arg3: i32,
            arg4: i32,
            arg5: i32,
        ) -> i32;
        /// Resolves a hostname and a port to one or more IP addresses.
        ///
        /// Note: This is similar to `getaddrinfo` in POSIX
        ///
        /// When successful, the contents of the output buffer consist of a sequence of
        /// IPv4 and/or IPv6 addresses. Each address entry consists of a addr_t object.
        /// This function fills the output buffer as much as possible.
        pub fn resolve(arg0: i32, arg1: i32, arg2: i32, arg3: i32, arg4: i32, arg5: i32) -> i32;
    }
}
