[![Latest Release](https://img.shields.io/github/v/release/wasmcloud/wash?color=success&include_prereleases)](https://github.com/wasmCloud/wash/releases)
[![Rust Build](https://img.shields.io/github/workflow/status/wasmcloud/wash/Rust/main)](https://github.com/wasmCloud/wash/actions/workflows/rust.yml)
[![Rust Version](https://img.shields.io/badge/rustc-1.60.0-orange.svg)](https://blog.rust-lang.org/2022/04/07/Rust-1.60.0.html) 
[![Contributors](https://img.shields.io/github/contributors/wasmcloud/wash)](https://github.com/wasmCloud/wash/graphs/contributors)
[![Good first issues](https://img.shields.io/github/issues/wasmcloud/wash/good%20first%20issue?label=good%20first%20issues)](https://github.com/wasmCloud/wash/issues?q=is%3Aopen+is%3Aissue+label%3A%22good+first+issue%22)
[![wash-cli](https://img.shields.io/crates/v/wash-cli)](https://crates.io/crates/wash-cli) 
```
                                     _                 _    _____ _          _ _ 
                                ____| |               | |  / ____| |        | | |
 __      ____ _ ___ _ __ ___  / ____| | ___  _   _  __| | | (___ | |__   ___| | |
 \ \ /\ / / _` / __| '_ ` _ \| |    | |/ _ \| | | |/ _` |  \___ \| '_ \ / _ \ | |
  \ V  V / (_| \__ \ | | | | | |____| | (_) | |_| | (_| |  ____) | | | |  __/ | |
   \_/\_/ \__,_|___/_| |_| |_|\_____|_|\___/ \__,_|\__,_| |_____/|_| |_|\___|_|_|
```
## Why wash
`wash` is a bundle of command line tools that, together, form a comprehensive CLI for [wasmCloud](https://wasmcloud.dev) development. Everything from generating signing keys to a fully interactive REPL environment is contained within the subcommands of `wash`. Our goal with `wash` is to encapsulate our tools into a single binary to make developing WebAssembly with wasmCloud painless and simple.

## Installing wash
### Cargo
```
cargo install wash-cli
```
### Linux (deb/rpm + apt)
```
# Debian / Ubuntu (deb)
curl -s https://packagecloud.io/install/repositories/wasmcloud/core/script.deb.sh | sudo bash
# Fedora (rpm)
curl -s https://packagecloud.io/install/repositories/wasmcloud/core/script.rpm.sh | sudo bash

sudo apt install wasmcloud wash
```
### Linux (snap)
```
sudo snap install wash --edge --devmode
```
### MacOS (brew)
```
brew tap wasmcloud/wasmcloud
brew install wasmcloud wash
```
### NixOS
```
nix run github:wasmCloud/wash
```

## Using wash
`wash` has multiple subcommands, each specializing in one specific area of the wasmCloud development process.
### call
Invoke a wasmCloud actor directly with a specified payload. This allows you to test actor handlers without the need to manage capabilities and link definitions for a rapid development feedback loop.  
### claims
Generate JWTs for actors, capability providers, accounts and operators. Sign actor modules with claims including capability IDs, expiration, and keys to verify identity. Inspect actor modules to view their claims.
### ctl
Interact directly with a wasmCloud [control-interface](https://github.com/wasmCloud/control-interface), allowing you to imperatively schedule actors, providers and modify configurations of a wasmCloud host. Can be used to interact with local and remote control-interfaces.
### drain
Manage contents of the local wasmCloud cache. wasmCloud manages a local cache that will avoid redundant fetching of content when possible. `drain` allows you to manually clear that cache to ensure you're always pulling the latest versions of actors and providers that are hosted in remote OCI registries.
### gen
Generate code from [smithy](https://awslabs.github.io/smithy/index.html) files using [weld codegen](https://github.com/wasmCloud/weld/tree/main/codegen). This is the primary method of generating actor and capability provider code from .smithy interfaces. Currently has first class support for Rust actors and providers, along with autogenerated HTML documentation.
### keys
Generate ed25519 keys for securely signing and identifying wasmCloud entities (actors, providers, hosts). Read more about our decision to use ed25519 keys in our [ADR](https://wasmcloud.github.io/adr/0005-security-nkeys.html).
### lint
Perform lint checks on .smithy models, outputting warnings for best practices with interfaces.
### new
Create new wasmCloud projects from predefined [templates](https://github.com/wasmCloud/project-templates). This command is a one-stop-shop for creating new actors, providers, and interfaces for all aspects of your application.
### par
Create, modify and inspect [provider archives](https://github.com/wasmCloud/wasmCloud/tree/main/crates/provider-archive), a TAR format that contains a signed JWT and OS/Architecture specific binaries for native capability providers.
### reg
Push and Pull actors and capability providers to/from OCI compliant registries. Used extensively in our own CI/CD and in local development, where a local registry is used to store your development artifacts.
### validate
Perform validation checks on .smithy models, ensuring that your interfaces are valid and usable for codegen and development.

## Contributing to wash
If you have any feature suggestions, find any bugs, or otherwise have a question, please submit an issue [here](https://github.com/wasmcloud/wash/issues/new/choose). Forking & submitting Pull Requests are welcome, and the [good first issue](https://github.com/wasmcloud/wash/issues?q=is%3Aopen+is%3Aissue+label%3A%22good+first+issue%22) label is a great way to find a place to start if you're looking to contribute.
