Object.assign(window.search, {"doc_urls":["warpgrapher/intro.html#warpgrapher","warpgrapher/quickstart.html#quickstart","warpgrapher/quickstart.html#source","warpgrapher/quickstart.html#database","warpgrapher/quickstart.html#run","warpgrapher/databases.html#databases","warpgrapher/databases.html#azure-cosmos-db","warpgrapher/databases.html#gremlin-based-database","warpgrapher/databases.html#neo4j","warpgrapher/config.html#warpgrapher-config","warpgrapher/config.html#text-config","warpgrapher/config.html#programmatic-config","api/intro.html#warpgrapher-crud-api","api/node_read.html#node-read","api/node_read.html#return-all-nodes","api/node_read.html#return-nodes-with-matching-props","api/node_read.html#return-nodes-with-relationships-to-other-nodes-with-matching-props","api/node_create.html#node-create","api/node_create.html#create-node-with-no-relationships","api/node_create.html#create-node-with-relationship-to-a-new-node","api/node_create.html#create-node-with-relationship-to-an-existing-node","api/node_update.html#node-update","api/node_update.html#update-props-on-node-with-matching-props","api/node_update.html#update-props-on-node-with-a-relationship-to-a-node-containing-matching-props","api/node_update.html#update-node-to-add-multi-node-relationships","api/node_delete.html#node-delete","api/node_delete.html#delete-node-with-matching-props","api/rel_read.html#relationship-read","api/rel_read.html#find-relationships-by-src-node","api/rel_read.html#find-relationships-by-dst-node","api/rel_read.html#find-relationships-by-rel-props","api/rel_create.html#relationship-create","api/rel_create.html#create-relationship-between-pair-of-existing-nodes","api/rel_create.html#create-relationship-between-from-existing-node-to-new-node","api/rel_update.html#relationship-update","api/rel_update.html#update-relationships-props","api/rel_delete.html#relationship-delete","api/rel_delete.html#delete-relationships","engine/intro.html#engine-features","engine/endpoints_static.html#static-endpoints","engine/endpoints_static.html#version","engine/endpoints_defined.html#defined-endpoints","engine/endpoints_defined.html#usage","engine/dynamic_props.html#dynamic-props","engine/dynamic_props.html#usage","engine/dynamic_rels.html#dynamic-relationships","engine/dynamic_rels.html#usage","engine/context_request.html#request-context","engine/context_request.html#usage","engine/context_request.html#full-example"],"index":{"documentStore":{"docInfo":{"0":{"body":71,"breadcrumbs":1,"title":1},"1":{"body":22,"breadcrumbs":2,"title":1},"10":{"body":30,"breadcrumbs":3,"title":2},"11":{"body":48,"breadcrumbs":3,"title":2},"12":{"body":48,"breadcrumbs":3,"title":3},"13":{"body":12,"breadcrumbs":4,"title":2},"14":{"body":8,"breadcrumbs":4,"title":2},"15":{"body":12,"breadcrumbs":6,"title":4},"16":{"body":17,"breadcrumbs":8,"title":6},"17":{"body":13,"breadcrumbs":4,"title":2},"18":{"body":27,"breadcrumbs":5,"title":3},"19":{"body":23,"breadcrumbs":7,"title":5},"2":{"body":112,"breadcrumbs":2,"title":1},"20":{"body":23,"breadcrumbs":7,"title":5},"21":{"body":19,"breadcrumbs":4,"title":2},"22":{"body":17,"breadcrumbs":7,"title":5},"23":{"body":22,"breadcrumbs":10,"title":8},"24":{"body":38,"breadcrumbs":8,"title":6},"25":{"body":4,"breadcrumbs":4,"title":2},"26":{"body":14,"breadcrumbs":6,"title":4},"27":{"body":12,"breadcrumbs":4,"title":2},"28":{"body":8,"breadcrumbs":6,"title":4},"29":{"body":8,"breadcrumbs":6,"title":4},"3":{"body":25,"breadcrumbs":2,"title":1},"30":{"body":4,"breadcrumbs":6,"title":4},"31":{"body":12,"breadcrumbs":4,"title":2},"32":{"body":11,"breadcrumbs":8,"title":6},"33":{"body":11,"breadcrumbs":9,"title":7},"34":{"body":3,"breadcrumbs":4,"title":2},"35":{"body":6,"breadcrumbs":5,"title":3},"36":{"body":2,"breadcrumbs":4,"title":2},"37":{"body":11,"breadcrumbs":4,"title":2},"38":{"body":0,"breadcrumbs":2,"title":2},"39":{"body":15,"breadcrumbs":4,"title":2},"4":{"body":2,"breadcrumbs":2,"title":1},"40":{"body":33,"breadcrumbs":3,"title":1},"41":{"body":13,"breadcrumbs":4,"title":2},"42":{"body":143,"breadcrumbs":3,"title":1},"43":{"body":36,"breadcrumbs":4,"title":2},"44":{"body":59,"breadcrumbs":3,"title":1},"45":{"body":17,"breadcrumbs":4,"title":2},"46":{"body":91,"breadcrumbs":3,"title":1},"47":{"body":10,"breadcrumbs":4,"title":2},"48":{"body":77,"breadcrumbs":3,"title":1},"49":{"body":2,"breadcrumbs":4,"title":2},"5":{"body":38,"breadcrumbs":2,"title":1},"6":{"body":103,"breadcrumbs":4,"title":3},"7":{"body":137,"breadcrumbs":4,"title":3},"8":{"body":40,"breadcrumbs":2,"title":1},"9":{"body":19,"breadcrumbs":3,"title":2}},"docs":{"0":{"body":"Warpgrapher is framework for developing graph-based API services. Describe the data model for which you want to run a web service. Wargrapher automatically generates a GraphQL schema from the data model, as well as a set of resolvers for basic reate, read, update, and delete (CRUD) operations on that data. If you need more more sophisticated, custom queries and endpoints, you can supply your own custom resolvers. Warpgrapher will automatically generate the GraphQL configuration and invoke your custom resolvers when appropriate. The project is currently in development. Prior to reaching v1.0.0: Minor versions represent breaking changes. Patch versions represent fixes and features. There are no deprecation warnings between releases.","breadcrumbs":"Warpgrapher","id":"0","title":"Warpgrapher"},"1":{"body":"This guide will walk you through creating a brand new project using the Warpgrapher engine served over HTTP using actix-web. The back-end graph database in this example is Neo4J.","breadcrumbs":"Warpgrapher » Quickstart","id":"1","title":"Quickstart"},"10":{"body":"version: 1\nmodel: # User - name: User props: - name: username type: String - name: email type: String # Team - name: Team props: - name: teamname type: String rels: - name: members nodes: [User] list: true","breadcrumbs":"Warpgrapher » Text Config","id":"10","title":"Text Config"},"11":{"body":"use warpgrapher::engine::config::{Config, Property, Relationship, Type}; let config = Config::new( 1, vec![ // User Type::new( \"User\".to_string(), vec![ Property::new( \"username\".to_string(), \"String\".to_string(), false, false, None, None, ), Property::new( \"email\".to_string(), \"String\".to_string(), false, false, None, None, ), ], Vec::new(), EndpointsFilter::all(), ), // Team Type::new( \"Team\".to_string(), vec![Property::new( \"teamname\".to_string(), \"String\".to_string(), false, false, None, None, )], vec![Relationship::new( \"members\".to_string(), true, vec![\"User\".to_string()], Vec::new(), EndpointsFilter::default(), None, )], EndpointsFilter::all(), ), ], vec![],\n);","breadcrumbs":"Warpgrapher » Programmatic Config","id":"11","title":"Programmatic Config"},"12":{"body":"One of the primary features of Warpgrapher is the auto-generation of CRUD operations for all Types. This includes basic and advanced queries that support nested operations and graph traversals. Warpgrapher automatically creates a set of CRUD (Create, Read, Update, Delete) operations for each Type and each rel in a Type. This page describes the format of those automatically generated GraphQL operations. For for more details on general GraphQL syntax, see: https://graphql.org/learn/.","breadcrumbs":"Warpgrapher CRUD API","id":"12","title":"Warpgrapher CRUD API"},"13":{"body":"Read All Nodes Read nodes with matching props Return nodes with relationships to other nodes with matching props","breadcrumbs":"CRUD API » Node Read","id":"13","title":"Node Read"},"14":{"body":"To return all Project nodes: query { Project { id name status }\n}","breadcrumbs":"CRUD API » Return all nodes","id":"14","title":"Return all nodes"},"15":{"body":"To return all Project nodes with status == \"ACTIVE\": query { Project( input: { status: \"ACTIVE\" } ) { id name }\n}","breadcrumbs":"CRUD API » Return nodes with matching props","id":"15","title":"Return nodes with matching props"},"16":{"body":"To returns all Project nodes containing an owner relationship to a User node with name=\"Halsey\": query { Project( input: { owner: { dst: { User: { name: \"Halsey\" } } } } ) { ... }\n}","breadcrumbs":"CRUD API » Return nodes with relationships to other nodes with matching props","id":"16","title":"Return nodes with relationships to other nodes with matching props"},"17":{"body":"Create node with no relationships Create node with relationship to a NEW node Create node with relationship to an EXISTING node","breadcrumbs":"CRUD API » Node Create","id":"17","title":"Node Create"},"18":{"body":"To create a new Project node by itself: mutation { ProjectCreate( input: { name: \"Project 1\", status: \"ACTIVE\" } ) { id name }\n} Output: { \"data\": { \"ProjectCreate\": { \"id\": \"a55e1dae-a87f-4ca1-8724-b967a678b942\", \"name\": \"Project 1\" } }\n}","breadcrumbs":"CRUD API » Create node with no relationships","id":"18","title":"Create node with no relationships"},"19":{"body":"To create a new Project node with an owner relationship to a new User node: mutation { ProjectCreate( input: { name: \"Project 2\", status: \"ACTIVE\", owner: { dst: { User: { NEW: { name: \"Smith\" } } } } } ) { ... }\n}","breadcrumbs":"CRUD API » Create node with relationship to a NEW node","id":"19","title":"Create node with relationship to a NEW node"},"2":{"body":"cargo.toml [dependencies]\nwarpgrapher = { version = \"0.8.4\", features = [\"neo4j\"] } src/main.rs use std::collections::HashMap;\nuse std::convert::TryFrom;\nuse warpgrapher::engine::config::Configuration;\nuse warpgrapher::engine::context::RequestContext;\nuse warpgrapher::engine::database::neo4j::Neo4jEndpoint;\nuse warpgrapher::engine::database::DatabaseEndpoint;\nuse warpgrapher::Engine; static CONFIG: &str = \"\nversion: 1\nmodel: - name: User props: - name: email type: String\n\"; #[derive(Clone, Debug)]\nstruct AppRequestContext {} impl RequestContext for AppRequestContext { type DBEndpointType = Neo4jEndpoint; fn new() -> AppRequestContext { AppRequestContext {} }\n} #[tokio::main]\nasync fn main() { // parse warpgrapher config let config = Configuration::try_from(CONFIG.to_string()).expect(\"Failed to parse CONFIG\"); // define database endpoint let db = Neo4jEndpoint::from_env() .expect(\"Failed to parse neo4j endpoint from environment\") .pool() .await .expect(\"Failed to create neo4j database pool\"); // create warpgrapher engine let engine: Engine<AppRequestContext> = Engine::new(config, db) .build() .expect(\"Failed to build engine\"); // execute graphql mutation to create new user let query = \" mutation { UserCreate(input: { email: \\\"a@b.com\\\" }) { id email } } \" .to_string(); let metadata = HashMap::new(); let result = engine.execute(query, None, metadata).await.unwrap(); // display result println!(\"result: {:#?}\", result);\n}","breadcrumbs":"Warpgrapher » Source","id":"2","title":"Source"},"20":{"body":"To create a new Project node with an owner relationship to an existing User node: mutation { ProjectCreate( input: { name: \"Project 3\", status: \"ACTIVE\", owner: { dst: { User: { EXISTING: { name: \"Oneill\" } } } } } ) { ... }\n}","breadcrumbs":"CRUD API » Create node with relationship to an EXISTING node","id":"20","title":"Create node with relationship to an EXISTING node"},"21":{"body":"Update props on node with matching props Update props on node with a relationship to a node containing matching props Update node to add (multi-node) relationships","breadcrumbs":"CRUD API » Node Update","id":"21","title":"Node Update"},"22":{"body":"To update the status of the Project node with name == \"Project 2\": mutation { ProjectUpdate( input: { MATCH: { name: \"Project 2\" }, SET: { status: \"INACTIVE\" } } ) { ... }\n}","breadcrumbs":"CRUD API » Update props on node with matching props","id":"22","title":"Update props on node with matching props"},"23":{"body":"To update the status of any Project nodes containing an owner relationship to the User with name == \"Smith\": mutation { ProjectUpdate( input: { MATCH: { owner: { dst: { User: { name: \"Smith\" } } } }, SET: { status: \"INACTIVE\" } } ) { ... }\n}","breadcrumbs":"CRUD API » Update props on node with a relationship to a node containing matching props","id":"23","title":"Update props on node with a relationship to a node containing matching props"},"24":{"body":"To update a specific Project node to add several issue relationships to new Feature and Bug nodes, call ProjectUpdate with: mutation { ProjectUpdate( input: { MATCH: { id: \"<ID>\" }, SET: { issues: [ { ADD: { dst: { Feature: { NEW: { name: \"Add login page\" } } } } }, { ADD: { dst: { Bug: { NEW: { name: \"Fix auth bug\" } } } } } ] } } ) { ... }\n}","breadcrumbs":"CRUD API » Update node to add (multi-node) relationships","id":"24","title":"Update node to add (multi-node) relationships"},"25":{"body":"Delete node with matching props","breadcrumbs":"CRUD API » Node Delete","id":"25","title":"Node Delete"},"26":{"body":"To delete Project nodes with status \"INACTIVE\", call ProjectDelete with: mutation { ProjectDelete( input: { MATCH: { status: \"INACTIVE\" }, DELETE: { } } ) { ... }\n}","breadcrumbs":"CRUD API » Delete node with matching props","id":"26","title":"Delete node with matching props"},"27":{"body":"Find relationships by src node Find relationships by dst node Find relationships by rel props","breadcrumbs":"CRUD API » Relationship Read","id":"27","title":"Relationship Read"},"28":{"body":"query { ProjectIssues(input: { src: { Project: { name: \"Project 0\" } } }) { id }\n}","breadcrumbs":"CRUD API » Find relationships by src node","id":"28","title":"Find relationships by src node"},"29":{"body":"query { ProjectIssues(input: { dst: { Feature: { name: \"Add new button\" } } }) {...}\n}","breadcrumbs":"CRUD API » Find relationships by dst node","id":"29","title":"Find relationships by dst node"},"3":{"body":"Configure database settings: export WG_NEO4J_HOST=127.0.0.1\nexport WG_NEO4J_PORT=7687\nexport WG_NEO4J_USER=neo4j\nexport WG_NEO4J_PASS=*MY-DB-PASSWORD* Start a 4.1 Neo4j database: docker run --rm -p 7687:7687 -e NEO4J_AUTH=\"${WG_NEO4J_USER}/${WG_NEO4J_PASS}\" neo4j:4.1","breadcrumbs":"Warpgrapher » Database","id":"3","title":"Database"},"30":{"body":"query { ProjectOwner(input: { props: { since: \"2015\" } }) {...}\n}","breadcrumbs":"CRUD API » Find relationships by rel props","id":"30","title":"Find relationships by rel props"},"31":{"body":"Create relationship between pair of existing nodes Create relationship from existing node to new node","breadcrumbs":"CRUD API » Relationship Create","id":"31","title":"Relationship Create"},"32":{"body":"mutation { ProjectOwnerCreate(input: { MATCH: { name: \"Project0\" }, CREATE: { dst: { User: { EXISTING: { name: \"Jane\" } } } } }) {...}\n}","breadcrumbs":"CRUD API » Create relationship between pair of existing nodes","id":"32","title":"Create relationship between pair of existing nodes"},"33":{"body":"mutation { ProjectOwnerCreate(input: { MATCH: { name: \"Project0\" }, CREATE: { dst: { User: { NEW: { name: \"Joe\" } } } } }) {...}\n}","breadcrumbs":"CRUD API » Create relationship between from existing node to new node","id":"33","title":"Create relationship between from existing node to new node"},"34":{"body":"Update relationship props","breadcrumbs":"CRUD API » Relationship Update","id":"34","title":"Relationship Update"},"35":{"body":"mutation { ProjectOwnerUpdate(input: { MATCH: { props: { sin } } }) { id }\n}","breadcrumbs":"CRUD API » Update relationships props","id":"35","title":"Update relationships props"},"36":{"body":"Delete relationships","breadcrumbs":"CRUD API » Relationship Delete","id":"36","title":"Relationship Delete"},"37":{"body":"mutation { ProjectOwnerDelete(input: { MATCH: { src: { Project: { name: \"Project0\" } } } })\n} Output: { \"data\": { \"ProjectOwnerDelete\": 1 }\n}","breadcrumbs":"CRUD API » Delete relationships","id":"37","title":"Delete relationships"},"38":{"body":"","breadcrumbs":"Engine Features","id":"38","title":"Engine Features"},"39":{"body":"Warpgrapher includes built-in static endpoints that provide useful information or functionality. Built-in static endpoints names are preceded by _.","breadcrumbs":"Engine Features » Static Endpoints","id":"39","title":"Static Endpoints"},"4":{"body":"cargo run","breadcrumbs":"Warpgrapher » Run","id":"4","title":"Run"},"40":{"body":"If the Engine is built with an explicit version: let mut server: Engine<()> = Engine::new(config, db) .with_version(\"0.1.0\".to_string()) .build(); the version value can be accessed via the _version endpoint: query { _version\n} { \"data\": { \"_version\": \"0.1.0\" }\n} If the server is not configured with an explicit version, the _version endpoint will return null: { \"data\": { \"_version\": null }\n}","breadcrumbs":"Engine Features » Version","id":"40","title":"Version"},"41":{"body":"In addition to the CRUD endpoints auto-generated for each type, Warpgrapher provides the ability to define additional endpoints.","breadcrumbs":"Engine Features » Defined Endpoints","id":"41","title":"Defined Endpoints"},"42":{"body":"1. Add Endpoints to Config The following config specified no types in the model section (so no CRUD endpoints will be generated), but defines several endpoints of varying inputs and outputs. version: 1\nmodel: # Team - name: Team props: - name: name type: String - name: size type: Int endpoints: # GetAppName - name: GetAppName class: Query input: null output: type: String # GetLargetTeam - name: GetLargestTeam class: Query input: null output: type: Team 2. Implement endpoint resolver logic use std::collections::HashMap;\nuse warpgrapher::engine::resolvers::{ResolverFacade, ExecutionResult};\nuse warpgrapher::value::Value; // resolver that returns a Scalar (String)\nfn resolve_getappname( context: ResolverFacade<()>\n) -> ExecutionResult { facade.resolve_scalar(\"MyAppName\")\n} // resolver that returns a Node (Team)\nfn resolve_getlargestteam( facade: ResolverFacade<()>\n) -> ExecutionResult { // query database to get team ... let mut hm = HashMap::new(); hm.insert(\"name\".to_string(), Value::String(\"Blue Team\".to_string())); hm.insert(\"size\".to_string(), Value::Int64(5)); let largest_team_node = facade.create_node((\"Team\", &hm); context.resolve_node(&larget_team_node)\n} 3. Add resolvers when building Engine use warpgrapher::Engine; let mut resolvers = Resolvers<()>::new();\nresolvers.insert(\"GetAppName\".to_string, Box::new(resolve_getappname));\nresolvers.insert(\"GetLargestTeam\".to_string, Box::new(resolve_getlargestteam)); let engine = Engine<()>::new(config, db) .with_resolvers(resolvers) .build(); 4. Call Defined Endpoints query { GetAppName\n} { \"data\": { \"GetAppName\": \"MyAppName\" }\n} query { GetLargestTeam { id name size }\n} { \"data\": { \"GetLargestTeam\": { \"id\": \"123456789012345670\", \"name\": \"Blue Team\", \"size\": 5 } }\n}","breadcrumbs":"Engine Features » Usage","id":"42","title":"Usage"},"43":{"body":"When Warpgrapher auto-generates a CRUD endpoint, the values of Node and Relationship properties are retreived from the database and returned in a query. In some cases, however, it may be necessary to perform real-time computations to derive the value of a prop. We call these type of properties \"dynamic properties\", and Warpgrapher provides a mechanism to execute custom logic to resolve the value of the prop.","breadcrumbs":"Engine Features » Dynamic Props","id":"43","title":"Dynamic Props"},"44":{"body":"1. Mark a properties as dynamic by setting the resolver field model: - name: Project props: - name: name type: String - name: points type: Int resolver: resolve_project_points\n\"; 2. Define custom logic that resolve the prop value Box::pin(async move { // compute value let points = 5; facade.resolve_scalar(points) })\n} 3. Add prop resolver when building Engine let mut resolvers = Resolvers::<AppRequestContext>::new(); resolvers.insert( \"resolve_project_points\".to_string(), Box::new(resolve_project_points), ); // create warpgrapher engine let engine: Engine<AppRequestContext> = Engine::new(config, db) .with_resolvers(resolvers) .build() .expect(\"Failed to build engine\");","breadcrumbs":"Engine Features » Usage","id":"44","title":"Usage"},"45":{"body":"Dynamic relationships are similiar to Dynamic Props. Instead of returning values contained in the database, Dynamic relationships allows values to be computed at request time.","breadcrumbs":"Engine Features » Dynamic Relationships","id":"45","title":"Dynamic Relationships"},"46":{"body":"1. Mark rel as dynamic by setting the resolver field model: - name: User props: - name: name type: String - name: Project props: - name: name type: String rels: - name: top_contributor nodes: [User] resolver: resolve_project_top_contributor\n\"; 2. Define custom logic that resolve the prop value facade: ResolverFacade<AppRequestContext>,\n) -> BoxFuture<ExecutionResult> { Box::pin(async move { // create dynamic dst node let mut top_contributor_props = HashMap::<String, Value>::new(); top_contributor_props.insert( \"id\".to_string(), Value::from(Uuid::new_v4().to_hyphenated().to_string()), ); top_contributor_props.insert(\"name\".to_string(), Value::from(\"user0\".to_string())); let top_contributor = facade.node(\"User\", top_contributor_props); // create dynamic rel let rel_id = \"1234567890\".to_string(); let top_contributor_rel = facade.create_rel_with_dst_node(Value::from(rel_id), None, top_contributor)?; facade.resolve_rel(&top_contributor_rel).await })\n} 3. Add the custom relationship resolver to the engine let mut resolvers = Resolvers::<AppRequestContext>::new(); resolvers.insert( \"resolve_project_top_contributor\".to_string(), Box::new(resolve_project_top_contributor), ); // create warpgrapher engine let engine: Engine<AppRequestContext> = Engine::new(config, db) .with_resolvers(resolvers) .build() .expect(\"Failed to build engine\");","breadcrumbs":"Engine Features » Usage","id":"46","title":"Usage"},"47":{"body":"The Request Context feature enables the creation of mutable state through the lifecycle of a request .","breadcrumbs":"Engine Features » Request Context","id":"47","title":"Request Context"},"48":{"body":"1. Define RequestContext struct Define a struct that contains mutable information to be available for the lifetime of a request. The request context must implement Clone, Debug, Sync, Send, and Warpgrapher RequestContext. request_id: String,\n} impl RequestContext for AppRequestContext { type DBEndpointType = Neo4jEndpoint; fn new() -> AppRequestContext { // generate random request id let request_id = \"1234\".to_string(); AppRequestContext { request_id } }\n} fn resolve_echo_request(facade: ResolverFacade<AppRequestContext>) -> BoxFuture<ExecutionResult> { Box::pin(async move { 2. Create Engine with RequestContext type parameter The RequestContext is specified in the second type paramter of Engine. .with_resolvers(resolvers) .build() .expect(\"Failed to build engine\"); 3. Access Context inside resolver Box::pin(async move { let request_context = facade.request_context().unwrap(); let request_id = request_context.request_id.clone(); facade.resolve_scalar(format!(\"echo! (request_id: {})\", request_id)) })\n}","breadcrumbs":"Engine Features » Usage","id":"48","title":"Usage"},"49":{"body":"View on Github .","breadcrumbs":"Engine Features » Full Example","id":"49","title":"Full Example"},"5":{"body":"Warppgrapher supports using either of two database back-ends for graph data: Azure Cosmos DB Gremlin-based Databases (e.g. Apache Tinkerpop and AWS Neptune) Neo4J Using each of the databases requires correctly selecting a crate feature and setting up appropriate environment variables to allow Warpgrapher to connect with the database.","breadcrumbs":"Warpgrapher » Databases","id":"5","title":"Databases"},"6":{"body":"Add Warpgrapher to your project config: cargo.toml [dependencies]\nwarpgrapher = { version = \"0.8.4\", features = [\"cosmos\"] } Then set up environment variables to contact your Cosmos DB: export WG_COSMOS_HOST=*MY-COSMOS-DB*.gremlin.cosmos.azure.com\nexport WG_COSMOS_PORT=443\nexport WG_COSMOS_USER=/dbs/*MY-COSMOS-DB*/colls/*MY-COSMOS-COLLECTION*\nexport WG_COSMOS_PASS=*MY-COSMOS-KEY* Note that when setting up your Cosmos database, you must configure it to offer a Gremlin graph API. Note also that you must set your partition key to be named partitionKey. Be advised that Gremlin traversals are not executed atomically within Cosmos DB. A traversal may fail part way through if, for example, one reaches the read unit capacity limit. See this article for details. The workaround proposed in the article helps, but even idempotent queries do not guarantee atomicity. Warpgrapher does not use idempotent queries with automated retries to overcome this shortcoming of Cosmos DB, so note that if using Cosmos, there is a risk that a failed query could leave partially applied results behind.","breadcrumbs":"Warpgrapher » Azure Cosmos DB","id":"6","title":"Azure Cosmos DB"},"7":{"body":"Add Warpgrapher to your project config: cargo.toml [dependencies]\nwarpgrapher = { version = \"0.8.4\", features = [\"gremlin\"] } Then set up environment variables to contact your Gremlin-based DB: export WG_GREMLIN_HOST=localhost\nexport WG_GREMLIN_PORT=8182\nexport WG_GREMLIN_USER=stephen\nexport WG_GREMLIN_PASS=password\nexport WG_GREMLIN_CERT=true\nexport WG_GREMLIN_UUID=true The WG_GREMLIN_CERT environment variable is true if Warpgrapher should ignore the validity of certificates. This may be necessary in a development or test environment, but should always be set to false in production. The WG_GREMLIN_UUID environment variable is set to true if Wargrapher is connecting to a back-end, like Apache Tinkerpop, that uses a UUID type for the identifier of a node or vertex. If the back-end uses a String type that contains a string representation of an identifier, such as Cosmos DB, then set this evironment variable to false. If you do not already have a Gremlin-based database running, you can run one using Docker: docker build -t gremlin -f tests/fixtures/gremlin/Dockerfile tests/fixtures/gremlin\ndocker run --rm -p 8182:8182 gremlin:latest To use an interactive gremlin console to manually inspect test instances, run docker build -t gremlin-console -f tests/fixtures/gremlin-console/Dockerfile tests/fixtures/gremlin-console\ndocker run -i --net=host --rm gremlin-console:latest In the console, connect to the remote graph: :remote connect tinkerpop.server conf/remote.yaml\n:remote console","breadcrumbs":"Warpgrapher » Gremlin-Based Database","id":"7","title":"Gremlin-Based Database"},"8":{"body":"Add Warpgrapher to your project config: [dependencies]\nwarpgrapher = { version = \"0.8.4\", features = [\"neo4j\"] } Then set up environment variables to contact your Neo4J DB: export WG_NEO4J_HOST=127.0.0.1\nexport WG_NEO4J_PORT=7687\nexport WG_NEO4J_USER=neo4j\nexport WG_NEO4J_PASS=*MY-DB-PASSWORD* If you do not already have a Neo4J database running, you can run one using Docker: docker run -e NEO4JAUTH=\"${WG_NEO4J_USER}:${WG_NEO4J_PASS}\" neo4j:4.1","breadcrumbs":"Warpgrapher » Neo4J","id":"8","title":"Neo4J"},"9":{"body":"In the Quickstart we demonstrated how to initialize a Config from a configurationf file read from file at run time. A Warpgrapher Config can also be generated programatically. The resulting configs from all the examples below are equivalent.","breadcrumbs":"Warpgrapher » Warpgrapher Config","id":"9","title":"Warpgrapher Config"}},"length":50,"save":true},"fields":["title","body","breadcrumbs"],"index":{"body":{"root":{"0":{".":{"1":{".":{"0":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"8":{".":{"4":{"df":4,"docs":{"2":{"tf":1.0},"6":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"28":{"tf":1.0}}},"1":{"2":{"3":{"4":{"\"":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"48":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"5":{"6":{"7":{"8":{"9":{"0":{"\"":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"46":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"1":{"2":{"3":{"4":{"5":{"6":{"7":{"0":{"df":1,"docs":{"42":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":9,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"18":{"tf":1.4142135623730951},"2":{"tf":1.0},"37":{"tf":1.0},"42":{"tf":1.4142135623730951},"44":{"tf":1.0},"46":{"tf":1.0},"48":{"tf":1.0}}},"2":{"0":{"1":{"5":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":6,"docs":{"19":{"tf":1.0},"22":{"tf":1.4142135623730951},"42":{"tf":1.0},"44":{"tf":1.0},"46":{"tf":1.0},"48":{"tf":1.0}}},"3":{"df":5,"docs":{"20":{"tf":1.0},"42":{"tf":1.0},"44":{"tf":1.0},"46":{"tf":1.0},"48":{"tf":1.0}}},"4":{".":{"1":{"df":1,"docs":{"3":{"tf":1.0}}},"df":0,"docs":{}},"c":{"a":{"1":{"df":1,"docs":{"18":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"42":{"tf":1.0}}},"5":{"df":2,"docs":{"42":{"tf":1.0},"44":{"tf":1.0}}},"7":{"6":{"8":{"7":{":":{"7":{"6":{"8":{"7":{"df":1,"docs":{"3":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"8":{"1":{"8":{"2":{":":{"8":{"1":{"8":{"2":{"df":1,"docs":{"7":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"7":{"2":{"4":{"df":1,"docs":{"18":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"_":{"df":1,"docs":{"39":{"tf":1.0}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"40":{"tf":2.23606797749979}}}}}}}}}},"a":{"5":{"5":{"df":0,"docs":{},"e":{"1":{"d":{"a":{"df":1,"docs":{"18":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"8":{"7":{"df":0,"docs":{},"f":{"df":1,"docs":{"18":{"tf":1.0}}}},"df":0,"docs":{}},"@":{"b":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"2":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"41":{"tf":1.0}}}}},"c":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"40":{"tf":1.0},"48":{"tf":1.0}}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":4,"docs":{"15":{"tf":1.4142135623730951},"18":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0}}},"x":{"df":1,"docs":{"1":{"tf":1.0}}}}}},"d":{"d":{"df":9,"docs":{"21":{"tf":1.0},"24":{"tf":2.23606797749979},"29":{"tf":1.0},"42":{"tf":1.4142135623730951},"44":{"tf":1.0},"46":{"tf":1.0},"6":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0}},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"41":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"12":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"6":{"tf":1.0}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":2,"docs":{"45":{"tf":1.0},"5":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":0,"docs":{},"i":{"df":2,"docs":{"7":{"tf":1.0},"8":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"w":{"a":{"df":0,"docs":{},"y":{"df":1,"docs":{"7":{"tf":1.0}}}},"df":0,"docs":{}}},"p":{"a":{"c":{"df":0,"docs":{},"h":{"df":2,"docs":{"5":{"tf":1.0},"7":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"i":{"df":3,"docs":{"0":{"tf":1.0},"12":{"tf":1.0},"6":{"tf":1.0}}},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"6":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":2,"docs":{"2":{"tf":2.0},"48":{"tf":1.7320508075688772}}}}}}}}},"df":0,"docs":{}}}}}}},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"0":{"tf":1.0},"5":{"tf":1.0}}}}}}}}},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"l":{"df":1,"docs":{"6":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"2":{"tf":1.0}}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"6":{"tf":1.4142135623730951}}}}},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"24":{"tf":1.0}}},"o":{"df":3,"docs":{"12":{"tf":1.0},"41":{"tf":1.0},"43":{"tf":1.0}},"m":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"0":{"tf":1.4142135623730951},"12":{"tf":1.4142135623730951}}}},"df":1,"docs":{"6":{"tf":1.0}}}}}},"v":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"48":{"tf":1.0}}}}},"df":0,"docs":{}},"w":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"2":{"tf":1.0}}}}},"df":1,"docs":{"5":{"tf":1.0}}},"z":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":2,"docs":{"5":{"tf":1.0},"6":{"tf":1.0}}}}}},"b":{"9":{"6":{"7":{"a":{"6":{"7":{"8":{"b":{"9":{"4":{"2":{"df":1,"docs":{"18":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"a":{"c":{"df":0,"docs":{},"k":{"df":3,"docs":{"1":{"tf":1.0},"5":{"tf":1.0},"7":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":3,"docs":{"0":{"tf":1.0},"5":{"tf":1.0},"7":{"tf":1.7320508075688772}}},"i":{"c":{"df":2,"docs":{"0":{"tf":1.0},"12":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"6":{"tf":1.0}}},"df":0,"docs":{}}}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"9":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":4,"docs":{"0":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":1.0}}}}}}}},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":1,"docs":{"42":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"x":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"(":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"42":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"42":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"44":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"46":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}}},"p":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"(":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"n":{"c":{"df":3,"docs":{"44":{"tf":1.0},"46":{"tf":1.0},"48":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"<":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":2,"docs":{"46":{"tf":1.0},"48":{"tf":1.0}}}}}}}}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}}}},"r":{"a":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"1":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"k":{"df":1,"docs":{"0":{"tf":1.0}}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"g":{"df":1,"docs":{"24":{"tf":1.7320508075688772}}},"i":{"df":0,"docs":{},"l":{"d":{"df":7,"docs":{"2":{"tf":1.4142135623730951},"40":{"tf":1.0},"42":{"tf":1.4142135623730951},"44":{"tf":1.7320508075688772},"46":{"tf":1.4142135623730951},"48":{"tf":1.4142135623730951},"7":{"tf":1.4142135623730951}}},"df":0,"docs":{},"t":{"df":2,"docs":{"39":{"tf":1.4142135623730951},"40":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"29":{"tf":1.0}}}}}}}},"c":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":4,"docs":{"24":{"tf":1.0},"26":{"tf":1.0},"42":{"tf":1.0},"43":{"tf":1.0}}}},"p":{"a":{"c":{"df":1,"docs":{"6":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":3,"docs":{"2":{"tf":1.0},"6":{"tf":1.0},"7":{"tf":1.0}}}}}}},"df":1,"docs":{"4":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"e":{"df":1,"docs":{"43":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":1,"docs":{"7":{"tf":1.0}}}}}}},"h":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"0":{"tf":1.0}}}}},"df":0,"docs":{}},"l":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"42":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":1,"docs":{"48":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"6":{"tf":1.0}}}},"df":0,"docs":{}}}},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":3,"docs":{"43":{"tf":1.0},"44":{"tf":1.0},"45":{"tf":1.0}}}}}},"n":{"df":0,"docs":{},"f":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"y":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"7":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"11":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":8,"docs":{"10":{"tf":1.0},"11":{"tf":1.4142135623730951},"2":{"tf":2.0},"42":{"tf":1.4142135623730951},"6":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":2.0}},"u":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{":":{":":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"(":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"(":{")":{")":{".":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"(":{"\"":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"2":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{},"f":{"df":1,"docs":{"9":{"tf":1.0}}}}}}}},"df":4,"docs":{"0":{"tf":1.0},"3":{"tf":1.0},"40":{"tf":1.0},"6":{"tf":1.0}}}}}}},"n":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"5":{"tf":1.0},"7":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"7":{"tf":2.23606797749979}},"e":{"/":{"d":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"7":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},":":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"7":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"t":{"a":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"6":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":6,"docs":{"16":{"tf":1.0},"21":{"tf":1.0},"23":{"tf":1.4142135623730951},"45":{"tf":1.0},"48":{"tf":1.0},"7":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{"(":{"&":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"42":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}}}},"df":3,"docs":{"42":{"tf":1.0},"47":{"tf":1.4142135623730951},"48":{"tf":1.4142135623730951}}}}}}},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"5":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":3,"docs":{"5":{"tf":1.0},"6":{"tf":3.3166247903554},"7":{"tf":1.0}}}}}},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"5":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":13,"docs":{"1":{"tf":1.0},"12":{"tf":1.4142135623730951},"17":{"tf":2.0},"18":{"tf":1.4142135623730951},"19":{"tf":1.4142135623730951},"2":{"tf":1.7320508075688772},"20":{"tf":1.4142135623730951},"31":{"tf":1.7320508075688772},"32":{"tf":1.4142135623730951},"33":{"tf":1.4142135623730951},"44":{"tf":1.0},"46":{"tf":1.7320508075688772},"48":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"47":{"tf":1.0}}}}}}},"df":0,"docs":{}},"u":{"d":{"df":5,"docs":{"0":{"tf":1.0},"12":{"tf":1.7320508075688772},"41":{"tf":1.0},"42":{"tf":1.0},"43":{"tf":1.0}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"0":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":4,"docs":{"0":{"tf":1.7320508075688772},"43":{"tf":1.0},"44":{"tf":1.0},"46":{"tf":1.4142135623730951}}}}}}}},"d":{"a":{"df":0,"docs":{},"t":{"a":{"b":{"a":{"df":0,"docs":{},"s":{"df":10,"docs":{"1":{"tf":1.0},"2":{"tf":1.4142135623730951},"3":{"tf":1.7320508075688772},"42":{"tf":1.0},"43":{"tf":1.0},"45":{"tf":1.0},"5":{"tf":2.23606797749979},"6":{"tf":1.0},"7":{"tf":1.4142135623730951},"8":{"tf":1.0}}}},"df":0,"docs":{}},"df":6,"docs":{"0":{"tf":1.7320508075688772},"18":{"tf":1.0},"37":{"tf":1.0},"40":{"tf":1.4142135623730951},"42":{"tf":1.4142135623730951},"5":{"tf":1.0}}},"df":0,"docs":{}}},"b":{"*":{".":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{".":{"a":{"df":0,"docs":{},"z":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"6":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"/":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"/":{"*":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":1,"docs":{"6":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":10,"docs":{"2":{"tf":1.4142135623730951},"3":{"tf":1.0},"40":{"tf":1.0},"42":{"tf":1.0},"44":{"tf":1.0},"46":{"tf":1.0},"5":{"tf":1.0},"6":{"tf":2.0},"7":{"tf":1.4142135623730951},"8":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":2,"docs":{"2":{"tf":1.0},"48":{"tf":1.0}}}}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":2,"docs":{"2":{"tf":1.0},"48":{"tf":1.0}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":6,"docs":{"2":{"tf":1.0},"41":{"tf":1.4142135623730951},"42":{"tf":1.4142135623730951},"44":{"tf":1.0},"46":{"tf":1.0},"48":{"tf":1.4142135623730951}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":6,"docs":{"0":{"tf":1.0},"12":{"tf":1.0},"25":{"tf":1.4142135623730951},"26":{"tf":1.7320508075688772},"36":{"tf":1.4142135623730951},"37":{"tf":1.0}}}}},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"9":{"tf":1.0}}}}}}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":4,"docs":{"2":{"tf":1.0},"6":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"e":{"c":{"df":1,"docs":{"0":{"tf":1.0}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"43":{"tf":1.0}},"e":{"(":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"2":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":2,"docs":{"0":{"tf":1.0},"12":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":2,"docs":{"12":{"tf":1.0},"6":{"tf":1.0}}}}},"df":0,"docs":{}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":2,"docs":{"0":{"tf":1.4142135623730951},"7":{"tf":1.0}}}}}}}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"y":{"df":1,"docs":{"2":{"tf":1.0}}}},"df":0,"docs":{}}}}},"o":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"3":{"tf":1.0},"7":{"tf":2.23606797749979},"8":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"t":{"df":10,"docs":{"16":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.4142135623730951},"27":{"tf":1.0},"29":{"tf":1.4142135623730951},"32":{"tf":1.0},"33":{"tf":1.0},"46":{"tf":1.0}}}},"y":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":4,"docs":{"43":{"tf":1.4142135623730951},"44":{"tf":1.0},"45":{"tf":2.0},"46":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"g":{"df":1,"docs":{"5":{"tf":1.0}}}},"a":{"c":{"df":0,"docs":{},"h":{"df":3,"docs":{"12":{"tf":1.4142135623730951},"41":{"tf":1.0},"5":{"tf":1.0}}}},"df":0,"docs":{}},"df":2,"docs":{"3":{"tf":1.0},"8":{"tf":1.0}},"m":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"\"":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"11":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":2,"docs":{"10":{"tf":1.0},"2":{"tf":1.7320508075688772}}}}},"df":0,"docs":{}},"n":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"47":{"tf":1.0}}}},"df":0,"docs":{}},"d":{"df":3,"docs":{"1":{"tf":1.0},"5":{"tf":1.0},"7":{"tf":1.4142135623730951}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":7,"docs":{"0":{"tf":1.0},"2":{"tf":1.4142135623730951},"39":{"tf":1.7320508075688772},"40":{"tf":1.4142135623730951},"41":{"tf":1.7320508075688772},"42":{"tf":2.449489742783178},"43":{"tf":1.0}},"s":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{":":{":":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"11":{"tf":1.4142135623730951}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"11":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}}}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":8,"docs":{"1":{"tf":1.0},"2":{"tf":1.7320508075688772},"38":{"tf":1.0},"40":{"tf":1.4142135623730951},"42":{"tf":1.4142135623730951},"44":{"tf":2.0},"46":{"tf":2.0},"48":{"tf":1.7320508075688772}},"e":{".":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"2":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"(":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":4,"docs":{"2":{"tf":1.0},"40":{"tf":1.0},"44":{"tf":1.0},"46":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"<":{"(":{")":{">":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"(":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":1,"docs":{"42":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":3,"docs":{"2":{"tf":1.0},"44":{"tf":1.0},"46":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":5,"docs":{"2":{"tf":1.0},"5":{"tf":1.0},"6":{"tf":1.0},"7":{"tf":2.0},"8":{"tf":1.0}}}}}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"9":{"tf":1.0}}}},"df":0,"docs":{}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"6":{"tf":1.0}}}},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"7":{"tf":1.0}}}}}}},"x":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":4,"docs":{"1":{"tf":1.0},"49":{"tf":1.0},"6":{"tf":1.0},"9":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":3,"docs":{"2":{"tf":1.0},"43":{"tf":1.0},"6":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"42":{"tf":1.7320508075688772}}}}}}}}}}}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":5,"docs":{"17":{"tf":1.0},"20":{"tf":1.7320508075688772},"31":{"tf":1.4142135623730951},"32":{"tf":1.4142135623730951},"33":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"(":{"\"":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":4,"docs":{"2":{"tf":1.7320508075688772},"44":{"tf":1.0},"46":{"tf":1.0},"48":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"40":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":4,"docs":{"3":{"tf":2.0},"6":{"tf":2.0},"7":{"tf":2.449489742783178},"8":{"tf":2.0}}}}}}}},"f":{"a":{"c":{"a":{"d":{"df":2,"docs":{"42":{"tf":1.0},"46":{"tf":1.0}},"e":{".":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{"(":{"(":{"\"":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"42":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"_":{"d":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"(":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"46":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{"(":{"\"":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"46":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"(":{")":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"48":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"(":{"&":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{")":{".":{"a":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"46":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"s":{"c":{"a":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"(":{"\"":{"df":0,"docs":{},"m":{"df":0,"docs":{},"y":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"42":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"!":{"(":{"\"":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":1,"docs":{"48":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"44":{"tf":1.0}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"6":{"tf":1.4142135623730951}}}},"l":{"df":0,"docs":{},"s":{"df":2,"docs":{"11":{"tf":2.449489742783178},"7":{"tf":1.4142135623730951}}}}},"df":1,"docs":{"7":{"tf":1.4142135623730951}},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":11,"docs":{"0":{"tf":1.0},"12":{"tf":1.0},"2":{"tf":1.0},"24":{"tf":1.4142135623730951},"29":{"tf":1.0},"38":{"tf":1.0},"47":{"tf":1.0},"5":{"tf":1.0},"6":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0}}}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"df":2,"docs":{"44":{"tf":1.0},"46":{"tf":1.0}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"e":{"df":1,"docs":{"9":{"tf":1.4142135623730951}}}},"n":{"d":{"df":4,"docs":{"27":{"tf":1.7320508075688772},"28":{"tf":1.0},"29":{"tf":1.0},"30":{"tf":1.0}}},"df":0,"docs":{}},"x":{"df":2,"docs":{"0":{"tf":1.0},"24":{"tf":1.0}}}},"n":{"df":3,"docs":{"2":{"tf":1.4142135623730951},"42":{"tf":1.4142135623730951},"48":{"tf":1.4142135623730951}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"42":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"12":{"tf":1.0}}}},"df":0,"docs":{}}}},"r":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":1,"docs":{"0":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"49":{"tf":1.0}}}},"n":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"39":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":7,"docs":{"0":{"tf":1.4142135623730951},"12":{"tf":1.7320508075688772},"41":{"tf":1.0},"42":{"tf":1.0},"43":{"tf":1.0},"48":{"tf":1.0},"9":{"tf":1.0}}}}},"t":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"42":{"tf":2.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"42":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"42":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"u":{"b":{"df":1,"docs":{"49":{"tf":1.0}}},"df":0,"docs":{}}}}},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":6,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"12":{"tf":1.0},"5":{"tf":1.0},"6":{"tf":1.0},"7":{"tf":1.0}},"q":{"df":0,"docs":{},"l":{"df":3,"docs":{"0":{"tf":1.4142135623730951},"12":{"tf":1.4142135623730951},"2":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{":":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"7":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":3,"docs":{"5":{"tf":1.0},"6":{"tf":1.4142135623730951},"7":{"tf":2.8284271247461903}}}}}}}},"u":{"a":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"6":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"1":{"tf":1.0}}},"df":0,"docs":{}}}},"h":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":1,"docs":{"16":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"p":{":":{":":{"<":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"46":{"tf":1.0}}}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":2,"docs":{"2":{"tf":1.0},"42":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"p":{"df":1,"docs":{"6":{"tf":1.0}}}}},"m":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"(":{"\"":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"\"":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"42":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"z":{"df":0,"docs":{},"e":{"\"":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"42":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":1,"docs":{"42":{"tf":1.4142135623730951}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"p":{"df":1,"docs":{"1":{"tf":1.0}},"s":{":":{"/":{"/":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"q":{"df":0,"docs":{},"l":{".":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"/":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"12":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"i":{"d":{"\"":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"46":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":9,"docs":{"14":{"tf":1.0},"15":{"tf":1.0},"18":{"tf":1.4142135623730951},"2":{"tf":1.0},"24":{"tf":1.4142135623730951},"28":{"tf":1.0},"35":{"tf":1.0},"42":{"tf":1.4142135623730951},"48":{"tf":1.0}},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"6":{"tf":1.4142135623730951}}}}}},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"7":{"tf":1.4142135623730951}}}}}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"7":{"tf":1.0}}}}}},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":2,"docs":{"2":{"tf":1.0},"48":{"tf":1.0}},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"42":{"tf":1.0},"48":{"tf":1.0}}}}}}}}}},"n":{"a":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"22":{"tf":1.0},"23":{"tf":1.0},"26":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"d":{"df":2,"docs":{"12":{"tf":1.0},"39":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":2,"docs":{"39":{"tf":1.0},"48":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"9":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":10,"docs":{"15":{"tf":1.0},"16":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0},"22":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.0},"26":{"tf":1.0},"42":{"tf":1.7320508075688772}}}}},"s":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"48":{"tf":1.0}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"7":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"a":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"7":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"a":{"d":{"df":1,"docs":{"45":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"t":{"df":2,"docs":{"42":{"tf":1.0},"44":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"7":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"v":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":1,"docs":{"0":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":1,"docs":{"24":{"tf":1.4142135623730951}}}}},"t":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"18":{"tf":1.0}}}}}}}},"j":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":1,"docs":{"32":{"tf":1.0}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"e":{"df":1,"docs":{"33":{"tf":1.0}}}}},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":1,"docs":{"6":{"tf":1.4142135623730951}}}}},"l":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"42":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"v":{"df":1,"docs":{"6":{"tf":1.0}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"y":{"c":{"df":0,"docs":{},"l":{"df":1,"docs":{"47":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"48":{"tf":1.0}}}}}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"6":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"10":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"c":{"df":4,"docs":{"42":{"tf":1.0},"43":{"tf":1.0},"44":{"tf":1.0},"46":{"tf":1.0}}},"df":0,"docs":{},"n":{"df":1,"docs":{"24":{"tf":1.0}}}}}}},"m":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"2":{"tf":1.0}}}},"n":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"7":{"tf":1.0}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"k":{"df":2,"docs":{"44":{"tf":1.0},"46":{"tf":1.0}}}},"t":{"c":{"df":0,"docs":{},"h":{"df":13,"docs":{"13":{"tf":1.4142135623730951},"15":{"tf":1.0},"16":{"tf":1.0},"21":{"tf":1.4142135623730951},"22":{"tf":1.4142135623730951},"23":{"tf":1.4142135623730951},"24":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.4142135623730951},"32":{"tf":1.0},"33":{"tf":1.0},"35":{"tf":1.0},"37":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"43":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"10":{"tf":1.0}},"s":{"\"":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"11":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"t":{"a":{"d":{"a":{"df":0,"docs":{},"t":{"a":{")":{".":{"a":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"2":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"2":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"0":{"tf":1.0}}}}}},"o":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":6,"docs":{"0":{"tf":1.4142135623730951},"10":{"tf":1.0},"2":{"tf":1.0},"42":{"tf":1.4142135623730951},"44":{"tf":1.0},"46":{"tf":1.0}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":2,"docs":{"0":{"tf":1.4142135623730951},"12":{"tf":1.0}}}},"v":{"df":0,"docs":{},"e":{"df":3,"docs":{"44":{"tf":1.0},"46":{"tf":1.0},"48":{"tf":1.4142135623730951}}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":2,"docs":{"21":{"tf":1.0},"24":{"tf":1.0}}}}},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":2,"docs":{"47":{"tf":1.0},"48":{"tf":1.0}}}},"df":0,"docs":{},"t":{"df":12,"docs":{"18":{"tf":1.0},"19":{"tf":1.0},"2":{"tf":1.4142135623730951},"20":{"tf":1.0},"22":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.0},"26":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":1.0},"35":{"tf":1.0},"37":{"tf":1.0}}}},"df":4,"docs":{"40":{"tf":1.0},"42":{"tf":1.4142135623730951},"44":{"tf":1.0},"46":{"tf":1.4142135623730951}}}},"y":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"42":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"=":{"\"":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":1,"docs":{"16":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":21,"docs":{"10":{"tf":2.449489742783178},"14":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":1.0},"18":{"tf":1.7320508075688772},"19":{"tf":1.4142135623730951},"2":{"tf":1.4142135623730951},"20":{"tf":1.4142135623730951},"22":{"tf":1.4142135623730951},"23":{"tf":1.4142135623730951},"24":{"tf":1.4142135623730951},"28":{"tf":1.0},"29":{"tf":1.0},"32":{"tf":1.4142135623730951},"33":{"tf":1.4142135623730951},"37":{"tf":1.0},"39":{"tf":1.0},"42":{"tf":2.8284271247461903},"44":{"tf":2.0},"46":{"tf":2.6457513110645907},"6":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"43":{"tf":1.0},"7":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"d":{"df":1,"docs":{"0":{"tf":1.0}}},"df":0,"docs":{}},"o":{"4":{"df":0,"docs":{},"j":{":":{"4":{".":{"1":{"df":2,"docs":{"3":{"tf":1.0},"8":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"_":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"=":{"\"":{"$":{"df":0,"docs":{},"{":{"df":0,"docs":{},"w":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"o":{"4":{"df":0,"docs":{},"j":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"}":{"/":{"$":{"df":0,"docs":{},"{":{"df":0,"docs":{},"w":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"o":{"4":{"df":0,"docs":{},"j":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"3":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"=":{"\"":{"$":{"df":0,"docs":{},"{":{"df":0,"docs":{},"w":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"o":{"4":{"df":0,"docs":{},"j":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"}":{":":{"$":{"df":0,"docs":{},"{":{"df":0,"docs":{},"w":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"o":{"4":{"df":0,"docs":{},"j":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"8":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":5,"docs":{"1":{"tf":1.0},"2":{"tf":1.7320508075688772},"3":{"tf":1.0},"5":{"tf":1.0},"8":{"tf":2.0}},"e":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"v":{"df":1,"docs":{"2":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":2,"docs":{"2":{"tf":1.0},"48":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":1,"docs":{"5":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"12":{"tf":1.0}}}},"t":{"=":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"7":{"tf":1.0}}}}}}},"df":0,"docs":{}},"w":{"df":11,"docs":{"1":{"tf":1.0},"17":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":2.0},"2":{"tf":1.4142135623730951},"20":{"tf":1.0},"24":{"tf":1.7320508075688772},"29":{"tf":1.0},"31":{"tf":1.0},"33":{"tf":1.4142135623730951},"48":{"tf":1.0}}}},"o":{"d":{"df":0,"docs":{},"e":{"df":25,"docs":{"10":{"tf":1.0},"13":{"tf":2.23606797749979},"14":{"tf":1.4142135623730951},"15":{"tf":1.4142135623730951},"16":{"tf":2.0},"17":{"tf":2.449489742783178},"18":{"tf":1.4142135623730951},"19":{"tf":2.0},"20":{"tf":2.0},"21":{"tf":2.449489742783178},"22":{"tf":1.4142135623730951},"23":{"tf":1.7320508075688772},"24":{"tf":2.0},"25":{"tf":1.4142135623730951},"26":{"tf":1.4142135623730951},"27":{"tf":1.4142135623730951},"28":{"tf":1.0},"29":{"tf":1.0},"31":{"tf":1.7320508075688772},"32":{"tf":1.0},"33":{"tf":1.4142135623730951},"42":{"tf":1.0},"43":{"tf":1.0},"46":{"tf":1.4142135623730951},"7":{"tf":1.0}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":3,"docs":{"11":{"tf":2.6457513110645907},"2":{"tf":1.0},"46":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"6":{"tf":1.7320508075688772}}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":2,"docs":{"40":{"tf":1.4142135623730951},"42":{"tf":1.4142135623730951}}}}}},"o":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"6":{"tf":1.0}}}}}},"n":{"df":4,"docs":{"12":{"tf":1.0},"6":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0}},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"20":{"tf":1.0}}}}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"0":{"tf":1.0},"12":{"tf":2.0}}}}},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":3,"docs":{"18":{"tf":1.0},"37":{"tf":1.0},"42":{"tf":1.7320508075688772}}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"6":{"tf":1.0}}}}},"df":1,"docs":{"1":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":4,"docs":{"16":{"tf":1.4142135623730951},"19":{"tf":1.4142135623730951},"20":{"tf":1.4142135623730951},"23":{"tf":1.4142135623730951}}}}}}},"p":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":2,"docs":{"12":{"tf":1.0},"24":{"tf":1.0}}}},"i":{"df":0,"docs":{},"r":{"df":2,"docs":{"31":{"tf":1.0},"32":{"tf":1.0}}}},"r":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"48":{"tf":1.0}}}},"t":{"df":1,"docs":{"48":{"tf":1.0}}}}},"df":0,"docs":{},"s":{"df":1,"docs":{"2":{"tf":1.7320508075688772}}},"t":{"df":1,"docs":{"6":{"tf":1.0}},"i":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"6":{"tf":1.0}}}},"df":0,"docs":{},"t":{"df":1,"docs":{"6":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":1,"docs":{"6":{"tf":1.0}}}}}}}}}}}},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"df":2,"docs":{"3":{"tf":1.0},"8":{"tf":1.0}}},"df":0,"docs":{}}}}}},"t":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"0":{"tf":1.0}}}},"df":0,"docs":{}}},"df":2,"docs":{"3":{"tf":1.0},"7":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":1,"docs":{"43":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"44":{"tf":1.4142135623730951}}}}},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"2":{"tf":1.4142135623730951}}}}},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"e":{"d":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"12":{"tf":1.0}}}}},"df":0,"docs":{}},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"n":{"!":{"(":{"\"":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"2":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"0":{"tf":1.0}}}}},"o":{"d":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"7":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"9":{"tf":1.0}}}},"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"11":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"0":{"df":3,"docs":{"32":{"tf":1.0},"33":{"tf":1.0},"37":{"tf":1.0}}},"c":{"df":0,"docs":{},"r":{"df":3,"docs":{"18":{"tf":1.4142135623730951},"19":{"tf":1.0},"20":{"tf":1.0}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"26":{"tf":1.4142135623730951}}}}}}},"df":19,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"14":{"tf":1.4142135623730951},"15":{"tf":1.4142135623730951},"16":{"tf":1.4142135623730951},"18":{"tf":1.7320508075688772},"19":{"tf":1.4142135623730951},"20":{"tf":1.4142135623730951},"22":{"tf":1.7320508075688772},"23":{"tf":1.0},"24":{"tf":1.0},"26":{"tf":1.0},"28":{"tf":1.4142135623730951},"37":{"tf":1.0},"44":{"tf":1.0},"46":{"tf":1.0},"6":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"(":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"28":{"tf":1.0},"29":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}}}}},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"30":{"tf":1.0}}}}}}}},"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"32":{"tf":1.0},"33":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"37":{"tf":1.0}},"e":{"(":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"37":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"d":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"35":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"u":{"df":0,"docs":{},"p":{"d":{"df":3,"docs":{"22":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"p":{"df":19,"docs":{"10":{"tf":1.4142135623730951},"13":{"tf":1.4142135623730951},"15":{"tf":1.0},"16":{"tf":1.0},"2":{"tf":1.0},"21":{"tf":2.0},"22":{"tf":1.4142135623730951},"23":{"tf":1.4142135623730951},"25":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.0},"30":{"tf":1.4142135623730951},"34":{"tf":1.0},"35":{"tf":1.4142135623730951},"42":{"tf":1.0},"43":{"tf":1.7320508075688772},"44":{"tf":1.7320508075688772},"45":{"tf":1.0},"46":{"tf":1.7320508075688772}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":3,"docs":{"11":{"tf":1.0},"43":{"tf":1.7320508075688772},"44":{"tf":1.0}}},"y":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"11":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"o":{"df":0,"docs":{},"s":{"df":1,"docs":{"6":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"i":{"d":{"df":3,"docs":{"39":{"tf":1.0},"41":{"tf":1.0},"43":{"tf":1.0}}},"df":0,"docs":{}}}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":13,"docs":{"0":{"tf":1.0},"12":{"tf":1.0},"14":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":1.0},"2":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"30":{"tf":1.0},"40":{"tf":1.0},"42":{"tf":2.23606797749979},"43":{"tf":1.0},"6":{"tf":1.7320508075688772}}}}},"i":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":2,"docs":{"1":{"tf":1.0},"9":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"r":{"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"48":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"a":{"c":{"df":0,"docs":{},"h":{"df":2,"docs":{"0":{"tf":1.0},"6":{"tf":1.0}}}},"d":{"df":6,"docs":{"0":{"tf":1.0},"12":{"tf":1.0},"13":{"tf":1.7320508075688772},"27":{"tf":1.0},"6":{"tf":1.0},"9":{"tf":1.0}}},"df":0,"docs":{},"l":{"df":1,"docs":{"43":{"tf":1.0}}},"t":{"df":1,"docs":{"0":{"tf":1.0}}}},"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"46":{"tf":1.0}}},"df":0,"docs":{}}},"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":24,"docs":{"11":{"tf":1.0},"13":{"tf":1.0},"16":{"tf":1.4142135623730951},"17":{"tf":1.7320508075688772},"18":{"tf":1.0},"19":{"tf":1.4142135623730951},"20":{"tf":1.4142135623730951},"21":{"tf":1.4142135623730951},"23":{"tf":1.4142135623730951},"24":{"tf":1.4142135623730951},"27":{"tf":2.0},"28":{"tf":1.0},"29":{"tf":1.0},"30":{"tf":1.0},"31":{"tf":1.7320508075688772},"32":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.4142135623730951},"35":{"tf":1.0},"36":{"tf":1.4142135623730951},"37":{"tf":1.0},"43":{"tf":1.0},"45":{"tf":1.7320508075688772},"46":{"tf":1.0}}}}}}}}}}},"df":5,"docs":{"10":{"tf":1.0},"12":{"tf":1.0},"27":{"tf":1.0},"30":{"tf":1.0},"46":{"tf":1.7320508075688772}},"e":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"0":{"tf":1.0}}}},"df":0,"docs":{}}},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"7":{"tf":1.7320508075688772}}}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":1,"docs":{"0":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"7":{"tf":1.0}}}}}}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"i":{"d":{".":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"48":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}}},"df":1,"docs":{"48":{"tf":1.0}}}}}}}}},"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"48":{"tf":2.449489742783178}}},"df":0,"docs":{}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":2,"docs":{"2":{"tf":1.0},"48":{"tf":2.23606797749979}}}}}}}}},"df":3,"docs":{"45":{"tf":1.0},"47":{"tf":1.7320508075688772},"48":{"tf":1.7320508075688772}}}}},"i":{"df":0,"docs":{},"r":{"df":1,"docs":{"5":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"df":6,"docs":{"0":{"tf":1.7320508075688772},"42":{"tf":2.23606797749979},"43":{"tf":1.0},"44":{"tf":2.23606797749979},"46":{"tf":2.23606797749979},"48":{"tf":1.0}},"e":{"_":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"f":{"a":{"c":{"a":{"d":{"df":1,"docs":{"48":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"42":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"42":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"44":{"tf":1.0}},"s":{"\"":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"44":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"\"":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"46":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":1,"docs":{"46":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"f":{"a":{"c":{"a":{"d":{"df":1,"docs":{"42":{"tf":1.4142135623730951}},"e":{"<":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":2,"docs":{"46":{"tf":1.0},"48":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"s":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"(":{"\"":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"\"":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"42":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"m":{"\"":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"42":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":2,"docs":{"44":{"tf":1.0},"46":{"tf":1.0}}}}}}}}},":":{":":{"<":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{">":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":2,"docs":{"44":{"tf":1.0},"46":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"<":{"(":{")":{">":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"42":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":3,"docs":{"2":{"tf":1.7320508075688772},"6":{"tf":1.0},"9":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"43":{"tf":1.0}}}}},"i":{"df":1,"docs":{"6":{"tf":1.0}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":8,"docs":{"13":{"tf":1.0},"14":{"tf":1.4142135623730951},"15":{"tf":1.4142135623730951},"16":{"tf":1.4142135623730951},"40":{"tf":1.0},"42":{"tf":1.4142135623730951},"43":{"tf":1.0},"45":{"tf":1.0}}}}}}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"k":{"df":1,"docs":{"6":{"tf":1.0}}}}},"m":{"df":2,"docs":{"3":{"tf":1.0},"7":{"tf":1.4142135623730951}}},"u":{"df":0,"docs":{},"n":{"df":6,"docs":{"0":{"tf":1.0},"3":{"tf":1.0},"4":{"tf":1.4142135623730951},"7":{"tf":2.23606797749979},"8":{"tf":1.7320508075688772},"9":{"tf":1.0}}}}},"s":{"c":{"a":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"42":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"a":{"df":1,"docs":{"0":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"48":{"tf":1.0}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"42":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"df":2,"docs":{"12":{"tf":1.0},"6":{"tf":1.0}}},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"5":{"tf":1.0}}}},"df":0,"docs":{}}},"n":{"d":{"df":1,"docs":{"48":{"tf":1.0}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"v":{"df":1,"docs":{"1":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"40":{"tf":1.4142135623730951}}}},"i":{"c":{"df":1,"docs":{"0":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"t":{"df":12,"docs":{"0":{"tf":1.0},"12":{"tf":1.0},"22":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.0},"3":{"tf":1.0},"44":{"tf":1.0},"46":{"tf":1.0},"5":{"tf":1.0},"6":{"tf":1.7320508075688772},"7":{"tf":2.0},"8":{"tf":1.0}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"24":{"tf":1.0},"42":{"tf":1.0}}}}}},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"6":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"45":{"tf":1.0}}}},"df":0,"docs":{}}}}},"n":{"df":1,"docs":{"35":{"tf":1.0}}},"z":{"df":0,"docs":{},"e":{"df":1,"docs":{"42":{"tf":1.7320508075688772}}}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":2,"docs":{"19":{"tf":1.0},"23":{"tf":1.4142135623730951}}}}}},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"0":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"r":{"c":{"df":1,"docs":{"2":{"tf":1.0}}},"df":0,"docs":{}}}},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":1,"docs":{"24":{"tf":1.0}},"i":{"df":2,"docs":{"42":{"tf":1.0},"48":{"tf":1.0}}}}}},"df":0,"docs":{}}},"r":{"c":{"/":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"2":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":3,"docs":{"27":{"tf":1.0},"28":{"tf":1.4142135623730951},"37":{"tf":1.0}}},"df":0,"docs":{}},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"3":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"47":{"tf":1.0}}},"i":{"c":{"df":2,"docs":{"2":{"tf":1.0},"39":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"u":{"df":8,"docs":{"14":{"tf":1.0},"15":{"tf":1.4142135623730951},"18":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0},"22":{"tf":1.4142135623730951},"23":{"tf":1.4142135623730951},"26":{"tf":1.4142135623730951}}}}},"d":{":":{":":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{":":{":":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"p":{"df":2,"docs":{"2":{"tf":1.0},"42":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"n":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{":":{":":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"2":{"tf":1.0}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"r":{"df":1,"docs":{"2":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"\"":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"11":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":7,"docs":{"10":{"tf":1.7320508075688772},"2":{"tf":1.0},"42":{"tf":1.7320508075688772},"44":{"tf":1.0},"46":{"tf":1.4142135623730951},"48":{"tf":1.0},"7":{"tf":1.4142135623730951}}}}},"u":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"2":{"tf":1.0},"48":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}},"u":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"7":{"tf":1.0}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"0":{"tf":1.0}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":2,"docs":{"12":{"tf":1.0},"5":{"tf":1.0}}}}}}}},"y":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"48":{"tf":1.0}}},"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"x":{"df":1,"docs":{"12":{"tf":1.0}}}},"df":0,"docs":{}}}}},"t":{"df":1,"docs":{"7":{"tf":1.4142135623730951}},"e":{"a":{"df":0,"docs":{},"m":{"\"":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":2,"docs":{"11":{"tf":1.0},"42":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":3,"docs":{"10":{"tf":1.4142135623730951},"11":{"tf":1.0},"42":{"tf":2.449489742783178}},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"10":{"tf":1.0}},"e":{"\"":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"11":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"7":{"tf":1.4142135623730951}},"s":{"/":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"/":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"/":{"d":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"7":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":1,"docs":{"7":{"tf":1.7320508075688772}}}}}}}}}},"df":0,"docs":{}}}}}}}}}},"df":0,"docs":{}}}},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"10":{"tf":1.0}}}}},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":1,"docs":{"12":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":3,"docs":{"1":{"tf":1.0},"47":{"tf":1.0},"6":{"tf":1.0}}}}}}}},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":3,"docs":{"43":{"tf":1.0},"45":{"tf":1.0},"9":{"tf":1.0}}}},"n":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{"df":1,"docs":{"7":{"tf":1.0}}}}}}},"df":2,"docs":{"5":{"tf":1.0},"7":{"tf":1.0}}}}}}}}}},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"2":{"tf":1.0}}}}}},"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{":":{":":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"2":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"p":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":1,"docs":{"46":{"tf":1.4142135623730951}},"s":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"(":{"\"":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"\"":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"46":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":1,"docs":{"46":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"46":{"tf":1.0}}}}}},"df":1,"docs":{"46":{"tf":1.7320508075688772}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"r":{"a":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":2,"docs":{"12":{"tf":1.0},"6":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":3,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"7":{"tf":1.4142135623730951}}}}},"w":{"df":0,"docs":{},"o":{"df":1,"docs":{"5":{"tf":1.0}}}},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"11":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}},"df":11,"docs":{"10":{"tf":1.7320508075688772},"11":{"tf":1.0},"12":{"tf":1.7320508075688772},"2":{"tf":1.4142135623730951},"41":{"tf":1.0},"42":{"tf":2.23606797749979},"43":{"tf":1.0},"44":{"tf":1.4142135623730951},"46":{"tf":1.4142135623730951},"48":{"tf":1.7320508075688772},"7":{"tf":1.4142135623730951}}}}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"6":{"tf":1.0}}}}},"p":{"d":{"a":{"df":0,"docs":{},"t":{"df":8,"docs":{"0":{"tf":1.0},"12":{"tf":1.0},"21":{"tf":2.0},"22":{"tf":1.4142135623730951},"23":{"tf":1.4142135623730951},"24":{"tf":1.4142135623730951},"34":{"tf":1.4142135623730951},"35":{"tf":1.0}}}},"df":0,"docs":{}},"df":4,"docs":{"5":{"tf":1.0},"6":{"tf":1.4142135623730951},"7":{"tf":1.0},"8":{"tf":1.0}}},"s":{"a":{"df":0,"docs":{},"g":{"df":4,"docs":{"42":{"tf":1.0},"44":{"tf":1.0},"46":{"tf":1.0},"48":{"tf":1.0}}}},"df":9,"docs":{"1":{"tf":1.4142135623730951},"11":{"tf":1.0},"2":{"tf":2.6457513110645907},"39":{"tf":1.0},"42":{"tf":2.0},"5":{"tf":1.4142135623730951},"6":{"tf":1.4142135623730951},"7":{"tf":2.0},"8":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"\"":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"11":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"2":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":10,"docs":{"10":{"tf":1.7320508075688772},"11":{"tf":1.0},"16":{"tf":1.4142135623730951},"19":{"tf":1.4142135623730951},"2":{"tf":1.4142135623730951},"20":{"tf":1.4142135623730951},"23":{"tf":1.4142135623730951},"32":{"tf":1.0},"33":{"tf":1.0},"46":{"tf":1.4142135623730951}},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"10":{"tf":1.0}},"e":{"\"":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"11":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"u":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"7":{"tf":1.0}}},"df":0,"docs":{}}}},"v":{"1":{".":{"0":{".":{"0":{"df":1,"docs":{"0":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"7":{"tf":1.0}}},"df":0,"docs":{}},"u":{"df":5,"docs":{"40":{"tf":1.0},"43":{"tf":1.7320508075688772},"44":{"tf":1.4142135623730951},"45":{"tf":1.4142135623730951},"46":{"tf":1.0}},"e":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"(":{"\"":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"0":{"\"":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"46":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"u":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"d":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"_":{"df":0,"docs":{},"v":{"4":{"(":{")":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"h":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"d":{"(":{")":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"46":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"6":{"4":{"(":{"5":{"df":1,"docs":{"42":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"(":{"\"":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":1,"docs":{"42":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},">":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"46":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"i":{"a":{"b":{"df":0,"docs":{},"l":{"df":4,"docs":{"5":{"tf":1.0},"6":{"tf":1.0},"7":{"tf":2.0},"8":{"tf":1.0}}}},"df":0,"docs":{}},"df":1,"docs":{"42":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"c":{"!":{"[":{"\"":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"\"":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"11":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"11":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"11":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"11":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}},"df":1,"docs":{"11":{"tf":1.7320508075688772}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":8,"docs":{"0":{"tf":1.4142135623730951},"10":{"tf":1.0},"2":{"tf":1.4142135623730951},"40":{"tf":2.0},"42":{"tf":1.0},"6":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":1,"docs":{"7":{"tf":1.0}}}}}}},"i":{"a":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"49":{"tf":1.0}}}}}},"w":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"k":{"df":1,"docs":{"1":{"tf":1.0}}}},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"0":{"tf":1.0}}}},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":2,"docs":{"0":{"tf":1.0},"7":{"tf":1.0}}}}},"df":0,"docs":{}}},"n":{"df":1,"docs":{"0":{"tf":1.0}}},"p":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":15,"docs":{"0":{"tf":1.7320508075688772},"1":{"tf":1.0},"12":{"tf":1.7320508075688772},"2":{"tf":1.7320508075688772},"39":{"tf":1.0},"41":{"tf":1.0},"43":{"tf":1.4142135623730951},"44":{"tf":1.0},"46":{"tf":1.0},"48":{"tf":1.0},"5":{"tf":1.0},"6":{"tf":1.7320508075688772},"7":{"tf":1.7320508075688772},"8":{"tf":1.4142135623730951},"9":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{":":{":":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"2":{"tf":1.0},"42":{"tf":1.0}},"e":{":":{":":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{":":{":":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"2":{"tf":1.0}}}}}}}}}},"df":0,"docs":{},"{":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":1,"docs":{"11":{"tf":1.0}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{":":{":":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"2":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"d":{"a":{"df":0,"docs":{},"t":{"a":{"b":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{":":{":":{"d":{"a":{"df":0,"docs":{},"t":{"a":{"b":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"2":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"o":{"4":{"df":0,"docs":{},"j":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"o":{"4":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"2":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{":":{":":{"df":0,"docs":{},"{":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"f":{"a":{"c":{"a":{"d":{"df":1,"docs":{"42":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{":":{":":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":1,"docs":{"42":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":1,"docs":{"5":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"y":{"df":1,"docs":{"6":{"tf":1.0}}}},"df":0,"docs":{},"e":{"b":{"df":2,"docs":{"0":{"tf":1.0},"1":{"tf":1.0}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"0":{"tf":1.0}}}}},"g":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"=":{"*":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":1,"docs":{"6":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"p":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"=":{"*":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":1,"docs":{"6":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"=":{"4":{"4":{"3":{"df":1,"docs":{"6":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"=":{"/":{"d":{"b":{"df":0,"docs":{},"s":{"/":{"*":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":1,"docs":{"6":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"_":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"=":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":1,"docs":{"7":{"tf":1.0}}}}}},"df":1,"docs":{"7":{"tf":1.0}}}}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"=":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"7":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"p":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"=":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"7":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"=":{"8":{"1":{"8":{"2":{"df":1,"docs":{"7":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"=":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"7":{"tf":1.0}}}}}}}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"i":{"d":{"=":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":1,"docs":{"7":{"tf":1.0}}}}}},"df":1,"docs":{"7":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"o":{"4":{"df":0,"docs":{},"j":{"_":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"=":{"1":{"2":{"7":{".":{"0":{".":{"0":{".":{"1":{"df":2,"docs":{"3":{"tf":1.0},"8":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"p":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"=":{"*":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":2,"docs":{"3":{"tf":1.0},"8":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"=":{"7":{"6":{"8":{"7":{"df":2,"docs":{"3":{"tf":1.0},"8":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"=":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"o":{"4":{"df":0,"docs":{},"j":{"df":2,"docs":{"3":{"tf":1.0},"8":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"(":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"df":4,"docs":{"42":{"tf":1.0},"44":{"tf":1.0},"46":{"tf":1.0},"48":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}}}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"(":{"\"":{"0":{".":{"1":{".":{"0":{"\"":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"40":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"6":{"tf":1.0}}}}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"6":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}},"breadcrumbs":{"root":{"0":{".":{"1":{".":{"0":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"8":{".":{"4":{"df":4,"docs":{"2":{"tf":1.0},"6":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"28":{"tf":1.0}}},"1":{"2":{"3":{"4":{"\"":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"48":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"5":{"6":{"7":{"8":{"9":{"0":{"\"":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"46":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"1":{"2":{"3":{"4":{"5":{"6":{"7":{"0":{"df":1,"docs":{"42":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":9,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"18":{"tf":1.4142135623730951},"2":{"tf":1.0},"37":{"tf":1.0},"42":{"tf":1.4142135623730951},"44":{"tf":1.0},"46":{"tf":1.0},"48":{"tf":1.0}}},"2":{"0":{"1":{"5":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":6,"docs":{"19":{"tf":1.0},"22":{"tf":1.4142135623730951},"42":{"tf":1.0},"44":{"tf":1.0},"46":{"tf":1.0},"48":{"tf":1.0}}},"3":{"df":5,"docs":{"20":{"tf":1.0},"42":{"tf":1.0},"44":{"tf":1.0},"46":{"tf":1.0},"48":{"tf":1.0}}},"4":{".":{"1":{"df":1,"docs":{"3":{"tf":1.0}}},"df":0,"docs":{}},"c":{"a":{"1":{"df":1,"docs":{"18":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"42":{"tf":1.0}}},"5":{"df":2,"docs":{"42":{"tf":1.0},"44":{"tf":1.0}}},"7":{"6":{"8":{"7":{":":{"7":{"6":{"8":{"7":{"df":1,"docs":{"3":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"8":{"1":{"8":{"2":{":":{"8":{"1":{"8":{"2":{"df":1,"docs":{"7":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"7":{"2":{"4":{"df":1,"docs":{"18":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"_":{"df":1,"docs":{"39":{"tf":1.0}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"40":{"tf":2.23606797749979}}}}}}}}}},"a":{"5":{"5":{"df":0,"docs":{},"e":{"1":{"d":{"a":{"df":1,"docs":{"18":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"8":{"7":{"df":0,"docs":{},"f":{"df":1,"docs":{"18":{"tf":1.0}}}},"df":0,"docs":{}},"@":{"b":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"2":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"41":{"tf":1.0}}}}},"c":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"40":{"tf":1.0},"48":{"tf":1.0}}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":4,"docs":{"15":{"tf":1.4142135623730951},"18":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0}}},"x":{"df":1,"docs":{"1":{"tf":1.0}}}}}},"d":{"d":{"df":9,"docs":{"21":{"tf":1.0},"24":{"tf":2.449489742783178},"29":{"tf":1.0},"42":{"tf":1.4142135623730951},"44":{"tf":1.0},"46":{"tf":1.0},"6":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0}},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"41":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"12":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"6":{"tf":1.0}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":2,"docs":{"45":{"tf":1.0},"5":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":0,"docs":{},"i":{"df":2,"docs":{"7":{"tf":1.0},"8":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"w":{"a":{"df":0,"docs":{},"y":{"df":1,"docs":{"7":{"tf":1.0}}}},"df":0,"docs":{}}},"p":{"a":{"c":{"df":0,"docs":{},"h":{"df":2,"docs":{"5":{"tf":1.0},"7":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"i":{"df":28,"docs":{"0":{"tf":1.0},"12":{"tf":1.4142135623730951},"13":{"tf":1.0},"14":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":1.0},"22":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"30":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0},"6":{"tf":1.0}}},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"6":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":2,"docs":{"2":{"tf":2.0},"48":{"tf":1.7320508075688772}}}}}}}}},"df":0,"docs":{}}}}}}},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"0":{"tf":1.0},"5":{"tf":1.0}}}}}}}}},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"l":{"df":1,"docs":{"6":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"2":{"tf":1.0}}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"6":{"tf":1.4142135623730951}}}}},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"24":{"tf":1.0}}},"o":{"df":3,"docs":{"12":{"tf":1.0},"41":{"tf":1.0},"43":{"tf":1.0}},"m":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"0":{"tf":1.4142135623730951},"12":{"tf":1.4142135623730951}}}},"df":1,"docs":{"6":{"tf":1.0}}}}}},"v":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"48":{"tf":1.0}}}}},"df":0,"docs":{}},"w":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"2":{"tf":1.0}}}}},"df":1,"docs":{"5":{"tf":1.0}}},"z":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":2,"docs":{"5":{"tf":1.0},"6":{"tf":1.4142135623730951}}}}}},"b":{"9":{"6":{"7":{"a":{"6":{"7":{"8":{"b":{"9":{"4":{"2":{"df":1,"docs":{"18":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"a":{"c":{"df":0,"docs":{},"k":{"df":3,"docs":{"1":{"tf":1.0},"5":{"tf":1.0},"7":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":3,"docs":{"0":{"tf":1.0},"5":{"tf":1.0},"7":{"tf":2.0}}},"i":{"c":{"df":2,"docs":{"0":{"tf":1.0},"12":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"6":{"tf":1.0}}},"df":0,"docs":{}}}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"9":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":4,"docs":{"0":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":1.4142135623730951},"33":{"tf":1.4142135623730951}}}}}}}},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":1,"docs":{"42":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"x":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"(":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"42":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"42":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"44":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"46":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}}},"p":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"(":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"n":{"c":{"df":3,"docs":{"44":{"tf":1.0},"46":{"tf":1.0},"48":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"<":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":2,"docs":{"46":{"tf":1.0},"48":{"tf":1.0}}}}}}}}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}}}},"r":{"a":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"1":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"k":{"df":1,"docs":{"0":{"tf":1.0}}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"g":{"df":1,"docs":{"24":{"tf":1.7320508075688772}}},"i":{"df":0,"docs":{},"l":{"d":{"df":7,"docs":{"2":{"tf":1.4142135623730951},"40":{"tf":1.0},"42":{"tf":1.4142135623730951},"44":{"tf":1.7320508075688772},"46":{"tf":1.4142135623730951},"48":{"tf":1.4142135623730951},"7":{"tf":1.4142135623730951}}},"df":0,"docs":{},"t":{"df":2,"docs":{"39":{"tf":1.4142135623730951},"40":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"29":{"tf":1.0}}}}}}}},"c":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":4,"docs":{"24":{"tf":1.0},"26":{"tf":1.0},"42":{"tf":1.0},"43":{"tf":1.0}}}},"p":{"a":{"c":{"df":1,"docs":{"6":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":3,"docs":{"2":{"tf":1.0},"6":{"tf":1.0},"7":{"tf":1.0}}}}}}},"df":1,"docs":{"4":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"e":{"df":1,"docs":{"43":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":1,"docs":{"7":{"tf":1.0}}}}}}},"h":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"0":{"tf":1.0}}}}},"df":0,"docs":{}},"l":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"42":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":1,"docs":{"48":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"6":{"tf":1.0}}}},"df":0,"docs":{}}}},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":3,"docs":{"43":{"tf":1.0},"44":{"tf":1.0},"45":{"tf":1.0}}}}}},"n":{"df":0,"docs":{},"f":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"y":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"7":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"11":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":8,"docs":{"10":{"tf":1.4142135623730951},"11":{"tf":1.7320508075688772},"2":{"tf":2.0},"42":{"tf":1.4142135623730951},"6":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":2.23606797749979}},"u":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{":":{":":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"(":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"(":{")":{")":{".":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"(":{"\"":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"2":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{},"f":{"df":1,"docs":{"9":{"tf":1.0}}}}}}}},"df":4,"docs":{"0":{"tf":1.0},"3":{"tf":1.0},"40":{"tf":1.0},"6":{"tf":1.0}}}}}}},"n":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"5":{"tf":1.0},"7":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"7":{"tf":2.23606797749979}},"e":{"/":{"d":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"7":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},":":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"7":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"t":{"a":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"6":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":6,"docs":{"16":{"tf":1.0},"21":{"tf":1.0},"23":{"tf":1.7320508075688772},"45":{"tf":1.0},"48":{"tf":1.0},"7":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{"(":{"&":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"42":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}}}},"df":3,"docs":{"42":{"tf":1.0},"47":{"tf":1.7320508075688772},"48":{"tf":1.4142135623730951}}}}}}},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"5":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":3,"docs":{"5":{"tf":1.0},"6":{"tf":3.4641016151377544},"7":{"tf":1.0}}}}}},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"5":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":13,"docs":{"1":{"tf":1.0},"12":{"tf":1.4142135623730951},"17":{"tf":2.23606797749979},"18":{"tf":1.7320508075688772},"19":{"tf":1.7320508075688772},"2":{"tf":1.7320508075688772},"20":{"tf":1.7320508075688772},"31":{"tf":2.0},"32":{"tf":1.7320508075688772},"33":{"tf":1.7320508075688772},"44":{"tf":1.0},"46":{"tf":1.7320508075688772},"48":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"47":{"tf":1.0}}}}}}},"df":0,"docs":{}},"u":{"d":{"df":30,"docs":{"0":{"tf":1.0},"12":{"tf":2.0},"13":{"tf":1.0},"14":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":1.0},"22":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"30":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0},"41":{"tf":1.0},"42":{"tf":1.0},"43":{"tf":1.0}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"0":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":4,"docs":{"0":{"tf":1.7320508075688772},"43":{"tf":1.0},"44":{"tf":1.0},"46":{"tf":1.4142135623730951}}}}}}}},"d":{"a":{"df":0,"docs":{},"t":{"a":{"b":{"a":{"df":0,"docs":{},"s":{"df":10,"docs":{"1":{"tf":1.0},"2":{"tf":1.4142135623730951},"3":{"tf":2.0},"42":{"tf":1.0},"43":{"tf":1.0},"45":{"tf":1.0},"5":{"tf":2.449489742783178},"6":{"tf":1.0},"7":{"tf":1.7320508075688772},"8":{"tf":1.0}}}},"df":0,"docs":{}},"df":6,"docs":{"0":{"tf":1.7320508075688772},"18":{"tf":1.0},"37":{"tf":1.0},"40":{"tf":1.4142135623730951},"42":{"tf":1.4142135623730951},"5":{"tf":1.0}}},"df":0,"docs":{}}},"b":{"*":{".":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{".":{"a":{"df":0,"docs":{},"z":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"6":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"/":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"/":{"*":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":1,"docs":{"6":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":10,"docs":{"2":{"tf":1.4142135623730951},"3":{"tf":1.0},"40":{"tf":1.0},"42":{"tf":1.0},"44":{"tf":1.0},"46":{"tf":1.0},"5":{"tf":1.0},"6":{"tf":2.23606797749979},"7":{"tf":1.4142135623730951},"8":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":2,"docs":{"2":{"tf":1.0},"48":{"tf":1.0}}}}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":2,"docs":{"2":{"tf":1.0},"48":{"tf":1.0}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":6,"docs":{"2":{"tf":1.0},"41":{"tf":1.7320508075688772},"42":{"tf":1.4142135623730951},"44":{"tf":1.0},"46":{"tf":1.0},"48":{"tf":1.4142135623730951}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":6,"docs":{"0":{"tf":1.0},"12":{"tf":1.0},"25":{"tf":1.7320508075688772},"26":{"tf":2.0},"36":{"tf":1.7320508075688772},"37":{"tf":1.4142135623730951}}}}},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"9":{"tf":1.0}}}}}}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":4,"docs":{"2":{"tf":1.0},"6":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"e":{"c":{"df":1,"docs":{"0":{"tf":1.0}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"43":{"tf":1.0}},"e":{"(":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"2":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":2,"docs":{"0":{"tf":1.0},"12":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":2,"docs":{"12":{"tf":1.0},"6":{"tf":1.0}}}}},"df":0,"docs":{}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":2,"docs":{"0":{"tf":1.4142135623730951},"7":{"tf":1.0}}}}}}}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"y":{"df":1,"docs":{"2":{"tf":1.0}}}},"df":0,"docs":{}}}}},"o":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"3":{"tf":1.0},"7":{"tf":2.23606797749979},"8":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"t":{"df":10,"docs":{"16":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.4142135623730951},"27":{"tf":1.0},"29":{"tf":1.7320508075688772},"32":{"tf":1.0},"33":{"tf":1.0},"46":{"tf":1.0}}}},"y":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":4,"docs":{"43":{"tf":1.7320508075688772},"44":{"tf":1.0},"45":{"tf":2.23606797749979},"46":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"g":{"df":1,"docs":{"5":{"tf":1.0}}}},"a":{"c":{"df":0,"docs":{},"h":{"df":3,"docs":{"12":{"tf":1.4142135623730951},"41":{"tf":1.0},"5":{"tf":1.0}}}},"df":0,"docs":{}},"df":2,"docs":{"3":{"tf":1.0},"8":{"tf":1.0}},"m":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"\"":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"11":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":2,"docs":{"10":{"tf":1.0},"2":{"tf":1.7320508075688772}}}}},"df":0,"docs":{}},"n":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"47":{"tf":1.0}}}},"df":0,"docs":{}},"d":{"df":3,"docs":{"1":{"tf":1.0},"5":{"tf":1.0},"7":{"tf":1.4142135623730951}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":7,"docs":{"0":{"tf":1.0},"2":{"tf":1.4142135623730951},"39":{"tf":2.0},"40":{"tf":1.4142135623730951},"41":{"tf":2.0},"42":{"tf":2.449489742783178},"43":{"tf":1.0}},"s":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{":":{":":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"11":{"tf":1.4142135623730951}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"11":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}}}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":14,"docs":{"1":{"tf":1.0},"2":{"tf":1.7320508075688772},"38":{"tf":1.4142135623730951},"39":{"tf":1.0},"40":{"tf":1.7320508075688772},"41":{"tf":1.0},"42":{"tf":1.7320508075688772},"43":{"tf":1.0},"44":{"tf":2.23606797749979},"45":{"tf":1.0},"46":{"tf":2.23606797749979},"47":{"tf":1.0},"48":{"tf":2.0},"49":{"tf":1.0}},"e":{".":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"2":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"(":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":4,"docs":{"2":{"tf":1.0},"40":{"tf":1.0},"44":{"tf":1.0},"46":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"<":{"(":{")":{">":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"(":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":1,"docs":{"42":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":3,"docs":{"2":{"tf":1.0},"44":{"tf":1.0},"46":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":5,"docs":{"2":{"tf":1.0},"5":{"tf":1.0},"6":{"tf":1.0},"7":{"tf":2.0},"8":{"tf":1.0}}}}}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"9":{"tf":1.0}}}},"df":0,"docs":{}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"6":{"tf":1.0}}}},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"7":{"tf":1.0}}}}}}},"x":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":4,"docs":{"1":{"tf":1.0},"49":{"tf":1.4142135623730951},"6":{"tf":1.0},"9":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":3,"docs":{"2":{"tf":1.0},"43":{"tf":1.0},"6":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"42":{"tf":1.7320508075688772}}}}}}}}}}}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":5,"docs":{"17":{"tf":1.0},"20":{"tf":2.0},"31":{"tf":1.4142135623730951},"32":{"tf":1.7320508075688772},"33":{"tf":1.4142135623730951}}}}},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"(":{"\"":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":4,"docs":{"2":{"tf":1.7320508075688772},"44":{"tf":1.0},"46":{"tf":1.0},"48":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"40":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":4,"docs":{"3":{"tf":2.0},"6":{"tf":2.0},"7":{"tf":2.449489742783178},"8":{"tf":2.0}}}}}}}},"f":{"a":{"c":{"a":{"d":{"df":2,"docs":{"42":{"tf":1.0},"46":{"tf":1.0}},"e":{".":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{"(":{"(":{"\"":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"42":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"_":{"d":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"(":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"46":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{"(":{"\"":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"46":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"(":{")":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"48":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"(":{"&":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{")":{".":{"a":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"46":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"s":{"c":{"a":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"(":{"\"":{"df":0,"docs":{},"m":{"df":0,"docs":{},"y":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"42":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"!":{"(":{"\"":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":1,"docs":{"48":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"44":{"tf":1.0}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"6":{"tf":1.4142135623730951}}}},"l":{"df":0,"docs":{},"s":{"df":2,"docs":{"11":{"tf":2.449489742783178},"7":{"tf":1.4142135623730951}}}}},"df":1,"docs":{"7":{"tf":1.4142135623730951}},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":21,"docs":{"0":{"tf":1.0},"12":{"tf":1.0},"2":{"tf":1.0},"24":{"tf":1.4142135623730951},"29":{"tf":1.0},"38":{"tf":1.4142135623730951},"39":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.0},"42":{"tf":1.0},"43":{"tf":1.0},"44":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.4142135623730951},"48":{"tf":1.0},"49":{"tf":1.0},"5":{"tf":1.0},"6":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0}}}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"df":2,"docs":{"44":{"tf":1.0},"46":{"tf":1.0}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"e":{"df":1,"docs":{"9":{"tf":1.4142135623730951}}}},"n":{"d":{"df":4,"docs":{"27":{"tf":1.7320508075688772},"28":{"tf":1.4142135623730951},"29":{"tf":1.4142135623730951},"30":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"x":{"df":2,"docs":{"0":{"tf":1.0},"24":{"tf":1.0}}}},"n":{"df":3,"docs":{"2":{"tf":1.4142135623730951},"42":{"tf":1.4142135623730951},"48":{"tf":1.4142135623730951}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"42":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"12":{"tf":1.0}}}},"df":0,"docs":{}}}},"r":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":1,"docs":{"0":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"49":{"tf":1.4142135623730951}}}},"n":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"39":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":7,"docs":{"0":{"tf":1.4142135623730951},"12":{"tf":1.7320508075688772},"41":{"tf":1.0},"42":{"tf":1.0},"43":{"tf":1.0},"48":{"tf":1.0},"9":{"tf":1.0}}}}},"t":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"42":{"tf":2.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"42":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"42":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"u":{"b":{"df":1,"docs":{"49":{"tf":1.0}}},"df":0,"docs":{}}}}},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":6,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"12":{"tf":1.0},"5":{"tf":1.0},"6":{"tf":1.0},"7":{"tf":1.0}},"q":{"df":0,"docs":{},"l":{"df":3,"docs":{"0":{"tf":1.4142135623730951},"12":{"tf":1.4142135623730951},"2":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{":":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"7":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":3,"docs":{"5":{"tf":1.0},"6":{"tf":1.4142135623730951},"7":{"tf":3.0}}}}}}}},"u":{"a":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"6":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"1":{"tf":1.0}}},"df":0,"docs":{}}}},"h":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":1,"docs":{"16":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"p":{":":{":":{"<":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"46":{"tf":1.0}}}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":2,"docs":{"2":{"tf":1.0},"42":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"p":{"df":1,"docs":{"6":{"tf":1.0}}}}},"m":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"(":{"\"":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"\"":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"42":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"z":{"df":0,"docs":{},"e":{"\"":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"42":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":1,"docs":{"42":{"tf":1.4142135623730951}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"p":{"df":1,"docs":{"1":{"tf":1.0}},"s":{":":{"/":{"/":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"q":{"df":0,"docs":{},"l":{".":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"/":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"12":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"i":{"d":{"\"":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"46":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":9,"docs":{"14":{"tf":1.0},"15":{"tf":1.0},"18":{"tf":1.4142135623730951},"2":{"tf":1.0},"24":{"tf":1.4142135623730951},"28":{"tf":1.0},"35":{"tf":1.0},"42":{"tf":1.4142135623730951},"48":{"tf":1.0}},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"6":{"tf":1.4142135623730951}}}}}},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"7":{"tf":1.4142135623730951}}}}}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"7":{"tf":1.0}}}}}},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":2,"docs":{"2":{"tf":1.0},"48":{"tf":1.0}},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"42":{"tf":1.0},"48":{"tf":1.0}}}}}}}}}},"n":{"a":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"22":{"tf":1.0},"23":{"tf":1.0},"26":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"d":{"df":2,"docs":{"12":{"tf":1.0},"39":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":2,"docs":{"39":{"tf":1.0},"48":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"9":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":10,"docs":{"15":{"tf":1.0},"16":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0},"22":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.0},"26":{"tf":1.0},"42":{"tf":1.7320508075688772}}}}},"s":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"48":{"tf":1.0}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"7":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"a":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"7":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"a":{"d":{"df":1,"docs":{"45":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"t":{"df":2,"docs":{"42":{"tf":1.0},"44":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"7":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"v":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":1,"docs":{"0":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":1,"docs":{"24":{"tf":1.4142135623730951}}}}},"t":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"18":{"tf":1.0}}}}}}}},"j":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":1,"docs":{"32":{"tf":1.0}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"e":{"df":1,"docs":{"33":{"tf":1.0}}}}},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":1,"docs":{"6":{"tf":1.4142135623730951}}}}},"l":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"42":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"v":{"df":1,"docs":{"6":{"tf":1.0}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"y":{"c":{"df":0,"docs":{},"l":{"df":1,"docs":{"47":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"48":{"tf":1.0}}}}}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"6":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"10":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"c":{"df":4,"docs":{"42":{"tf":1.0},"43":{"tf":1.0},"44":{"tf":1.0},"46":{"tf":1.0}}},"df":0,"docs":{},"n":{"df":1,"docs":{"24":{"tf":1.0}}}}}}},"m":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"2":{"tf":1.0}}}},"n":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"7":{"tf":1.0}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"k":{"df":2,"docs":{"44":{"tf":1.0},"46":{"tf":1.0}}}},"t":{"c":{"df":0,"docs":{},"h":{"df":13,"docs":{"13":{"tf":1.4142135623730951},"15":{"tf":1.4142135623730951},"16":{"tf":1.4142135623730951},"21":{"tf":1.4142135623730951},"22":{"tf":1.7320508075688772},"23":{"tf":1.7320508075688772},"24":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.7320508075688772},"32":{"tf":1.0},"33":{"tf":1.0},"35":{"tf":1.0},"37":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"43":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"10":{"tf":1.0}},"s":{"\"":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"11":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"t":{"a":{"d":{"a":{"df":0,"docs":{},"t":{"a":{")":{".":{"a":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"2":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"2":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"0":{"tf":1.0}}}}}},"o":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":6,"docs":{"0":{"tf":1.4142135623730951},"10":{"tf":1.0},"2":{"tf":1.0},"42":{"tf":1.4142135623730951},"44":{"tf":1.0},"46":{"tf":1.0}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":2,"docs":{"0":{"tf":1.4142135623730951},"12":{"tf":1.0}}}},"v":{"df":0,"docs":{},"e":{"df":3,"docs":{"44":{"tf":1.0},"46":{"tf":1.0},"48":{"tf":1.4142135623730951}}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":2,"docs":{"21":{"tf":1.0},"24":{"tf":1.4142135623730951}}}}},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":2,"docs":{"47":{"tf":1.0},"48":{"tf":1.0}}}},"df":0,"docs":{},"t":{"df":12,"docs":{"18":{"tf":1.0},"19":{"tf":1.0},"2":{"tf":1.4142135623730951},"20":{"tf":1.0},"22":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.0},"26":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":1.0},"35":{"tf":1.0},"37":{"tf":1.0}}}},"df":4,"docs":{"40":{"tf":1.0},"42":{"tf":1.4142135623730951},"44":{"tf":1.0},"46":{"tf":1.4142135623730951}}}},"y":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"42":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"=":{"\"":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":1,"docs":{"16":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":21,"docs":{"10":{"tf":2.449489742783178},"14":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":1.0},"18":{"tf":1.7320508075688772},"19":{"tf":1.4142135623730951},"2":{"tf":1.4142135623730951},"20":{"tf":1.4142135623730951},"22":{"tf":1.4142135623730951},"23":{"tf":1.4142135623730951},"24":{"tf":1.4142135623730951},"28":{"tf":1.0},"29":{"tf":1.0},"32":{"tf":1.4142135623730951},"33":{"tf":1.4142135623730951},"37":{"tf":1.0},"39":{"tf":1.0},"42":{"tf":2.8284271247461903},"44":{"tf":2.0},"46":{"tf":2.6457513110645907},"6":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"43":{"tf":1.0},"7":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"d":{"df":1,"docs":{"0":{"tf":1.0}}},"df":0,"docs":{}},"o":{"4":{"df":0,"docs":{},"j":{":":{"4":{".":{"1":{"df":2,"docs":{"3":{"tf":1.0},"8":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"_":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"=":{"\"":{"$":{"df":0,"docs":{},"{":{"df":0,"docs":{},"w":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"o":{"4":{"df":0,"docs":{},"j":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"}":{"/":{"$":{"df":0,"docs":{},"{":{"df":0,"docs":{},"w":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"o":{"4":{"df":0,"docs":{},"j":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"3":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"=":{"\"":{"$":{"df":0,"docs":{},"{":{"df":0,"docs":{},"w":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"o":{"4":{"df":0,"docs":{},"j":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"}":{":":{"$":{"df":0,"docs":{},"{":{"df":0,"docs":{},"w":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"o":{"4":{"df":0,"docs":{},"j":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"8":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":5,"docs":{"1":{"tf":1.0},"2":{"tf":1.7320508075688772},"3":{"tf":1.0},"5":{"tf":1.0},"8":{"tf":2.23606797749979}},"e":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"v":{"df":1,"docs":{"2":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":2,"docs":{"2":{"tf":1.0},"48":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":1,"docs":{"5":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"12":{"tf":1.0}}}},"t":{"=":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"7":{"tf":1.0}}}}}}},"df":0,"docs":{}},"w":{"df":11,"docs":{"1":{"tf":1.0},"17":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":2.23606797749979},"2":{"tf":1.4142135623730951},"20":{"tf":1.0},"24":{"tf":1.7320508075688772},"29":{"tf":1.0},"31":{"tf":1.0},"33":{"tf":1.7320508075688772},"48":{"tf":1.0}}}},"o":{"d":{"df":0,"docs":{},"e":{"df":25,"docs":{"10":{"tf":1.0},"13":{"tf":2.449489742783178},"14":{"tf":1.7320508075688772},"15":{"tf":1.7320508075688772},"16":{"tf":2.449489742783178},"17":{"tf":2.6457513110645907},"18":{"tf":1.7320508075688772},"19":{"tf":2.449489742783178},"20":{"tf":2.449489742783178},"21":{"tf":2.6457513110645907},"22":{"tf":1.7320508075688772},"23":{"tf":2.23606797749979},"24":{"tf":2.449489742783178},"25":{"tf":1.7320508075688772},"26":{"tf":1.7320508075688772},"27":{"tf":1.4142135623730951},"28":{"tf":1.4142135623730951},"29":{"tf":1.4142135623730951},"31":{"tf":1.7320508075688772},"32":{"tf":1.4142135623730951},"33":{"tf":2.0},"42":{"tf":1.0},"43":{"tf":1.0},"46":{"tf":1.4142135623730951},"7":{"tf":1.0}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":3,"docs":{"11":{"tf":2.6457513110645907},"2":{"tf":1.0},"46":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"6":{"tf":1.7320508075688772}}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":2,"docs":{"40":{"tf":1.4142135623730951},"42":{"tf":1.4142135623730951}}}}}},"o":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"6":{"tf":1.0}}}}}},"n":{"df":4,"docs":{"12":{"tf":1.0},"6":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0}},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"20":{"tf":1.0}}}}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"0":{"tf":1.0},"12":{"tf":2.0}}}}},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":3,"docs":{"18":{"tf":1.0},"37":{"tf":1.0},"42":{"tf":1.7320508075688772}}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"6":{"tf":1.0}}}}},"df":1,"docs":{"1":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":4,"docs":{"16":{"tf":1.4142135623730951},"19":{"tf":1.4142135623730951},"20":{"tf":1.4142135623730951},"23":{"tf":1.4142135623730951}}}}}}},"p":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":2,"docs":{"12":{"tf":1.0},"24":{"tf":1.0}}}},"i":{"df":0,"docs":{},"r":{"df":2,"docs":{"31":{"tf":1.0},"32":{"tf":1.4142135623730951}}}},"r":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"48":{"tf":1.0}}}},"t":{"df":1,"docs":{"48":{"tf":1.0}}}}},"df":0,"docs":{},"s":{"df":1,"docs":{"2":{"tf":1.7320508075688772}}},"t":{"df":1,"docs":{"6":{"tf":1.0}},"i":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"6":{"tf":1.0}}}},"df":0,"docs":{},"t":{"df":1,"docs":{"6":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":1,"docs":{"6":{"tf":1.0}}}}}}}}}}}},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"df":2,"docs":{"3":{"tf":1.0},"8":{"tf":1.0}}},"df":0,"docs":{}}}}}},"t":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"0":{"tf":1.0}}}},"df":0,"docs":{}}},"df":2,"docs":{"3":{"tf":1.0},"7":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":1,"docs":{"43":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"44":{"tf":1.4142135623730951}}}}},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"2":{"tf":1.4142135623730951}}}}},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"e":{"d":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"12":{"tf":1.0}}}}},"df":0,"docs":{}},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"n":{"!":{"(":{"\"":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"2":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"0":{"tf":1.0}}}}},"o":{"d":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"7":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"9":{"tf":1.0}}}},"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"11":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"0":{"df":3,"docs":{"32":{"tf":1.0},"33":{"tf":1.0},"37":{"tf":1.0}}},"c":{"df":0,"docs":{},"r":{"df":3,"docs":{"18":{"tf":1.4142135623730951},"19":{"tf":1.0},"20":{"tf":1.0}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"26":{"tf":1.4142135623730951}}}}}}},"df":19,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"14":{"tf":1.4142135623730951},"15":{"tf":1.4142135623730951},"16":{"tf":1.4142135623730951},"18":{"tf":1.7320508075688772},"19":{"tf":1.4142135623730951},"20":{"tf":1.4142135623730951},"22":{"tf":1.7320508075688772},"23":{"tf":1.0},"24":{"tf":1.0},"26":{"tf":1.0},"28":{"tf":1.4142135623730951},"37":{"tf":1.0},"44":{"tf":1.0},"46":{"tf":1.0},"6":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"(":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"28":{"tf":1.0},"29":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}}}}},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"30":{"tf":1.0}}}}}}}},"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"32":{"tf":1.0},"33":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"37":{"tf":1.0}},"e":{"(":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"37":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"d":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"35":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"u":{"df":0,"docs":{},"p":{"d":{"df":3,"docs":{"22":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"p":{"df":19,"docs":{"10":{"tf":1.4142135623730951},"13":{"tf":1.4142135623730951},"15":{"tf":1.4142135623730951},"16":{"tf":1.4142135623730951},"2":{"tf":1.0},"21":{"tf":2.0},"22":{"tf":2.0},"23":{"tf":2.0},"25":{"tf":1.0},"26":{"tf":1.4142135623730951},"27":{"tf":1.0},"30":{"tf":1.7320508075688772},"34":{"tf":1.0},"35":{"tf":1.7320508075688772},"42":{"tf":1.0},"43":{"tf":2.0},"44":{"tf":1.7320508075688772},"45":{"tf":1.0},"46":{"tf":1.7320508075688772}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":3,"docs":{"11":{"tf":1.0},"43":{"tf":1.7320508075688772},"44":{"tf":1.0}}},"y":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"11":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"o":{"df":0,"docs":{},"s":{"df":1,"docs":{"6":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"i":{"d":{"df":3,"docs":{"39":{"tf":1.0},"41":{"tf":1.0},"43":{"tf":1.0}}},"df":0,"docs":{}}}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":13,"docs":{"0":{"tf":1.0},"12":{"tf":1.0},"14":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":1.0},"2":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"30":{"tf":1.0},"40":{"tf":1.0},"42":{"tf":2.23606797749979},"43":{"tf":1.0},"6":{"tf":1.7320508075688772}}}}},"i":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":2,"docs":{"1":{"tf":1.4142135623730951},"9":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"r":{"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"48":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"a":{"c":{"df":0,"docs":{},"h":{"df":2,"docs":{"0":{"tf":1.0},"6":{"tf":1.0}}}},"d":{"df":6,"docs":{"0":{"tf":1.0},"12":{"tf":1.0},"13":{"tf":2.0},"27":{"tf":1.4142135623730951},"6":{"tf":1.0},"9":{"tf":1.0}}},"df":0,"docs":{},"l":{"df":1,"docs":{"43":{"tf":1.0}}},"t":{"df":1,"docs":{"0":{"tf":1.0}}}},"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"46":{"tf":1.0}}},"df":0,"docs":{}}},"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":24,"docs":{"11":{"tf":1.0},"13":{"tf":1.0},"16":{"tf":1.7320508075688772},"17":{"tf":1.7320508075688772},"18":{"tf":1.4142135623730951},"19":{"tf":1.7320508075688772},"20":{"tf":1.7320508075688772},"21":{"tf":1.4142135623730951},"23":{"tf":1.7320508075688772},"24":{"tf":1.7320508075688772},"27":{"tf":2.23606797749979},"28":{"tf":1.4142135623730951},"29":{"tf":1.4142135623730951},"30":{"tf":1.4142135623730951},"31":{"tf":2.0},"32":{"tf":1.4142135623730951},"33":{"tf":1.4142135623730951},"34":{"tf":1.7320508075688772},"35":{"tf":1.4142135623730951},"36":{"tf":1.7320508075688772},"37":{"tf":1.4142135623730951},"43":{"tf":1.0},"45":{"tf":2.0},"46":{"tf":1.0}}}}}}}}}}},"df":5,"docs":{"10":{"tf":1.0},"12":{"tf":1.0},"27":{"tf":1.0},"30":{"tf":1.4142135623730951},"46":{"tf":1.7320508075688772}},"e":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"0":{"tf":1.0}}}},"df":0,"docs":{}}},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"7":{"tf":1.7320508075688772}}}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":1,"docs":{"0":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"7":{"tf":1.0}}}}}}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"i":{"d":{".":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"48":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}}},"df":1,"docs":{"48":{"tf":1.0}}}}}}}}},"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"48":{"tf":2.449489742783178}}},"df":0,"docs":{}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":2,"docs":{"2":{"tf":1.0},"48":{"tf":2.23606797749979}}}}}}}}},"df":3,"docs":{"45":{"tf":1.0},"47":{"tf":2.0},"48":{"tf":1.7320508075688772}}}}},"i":{"df":0,"docs":{},"r":{"df":1,"docs":{"5":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"df":6,"docs":{"0":{"tf":1.7320508075688772},"42":{"tf":2.23606797749979},"43":{"tf":1.0},"44":{"tf":2.23606797749979},"46":{"tf":2.23606797749979},"48":{"tf":1.0}},"e":{"_":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"f":{"a":{"c":{"a":{"d":{"df":1,"docs":{"48":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"42":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"42":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"44":{"tf":1.0}},"s":{"\"":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"44":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"\"":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"46":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":1,"docs":{"46":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"f":{"a":{"c":{"a":{"d":{"df":1,"docs":{"42":{"tf":1.4142135623730951}},"e":{"<":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":2,"docs":{"46":{"tf":1.0},"48":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"s":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"(":{"\"":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"\"":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"42":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"m":{"\"":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"42":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":2,"docs":{"44":{"tf":1.0},"46":{"tf":1.0}}}}}}}}},":":{":":{"<":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{">":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":2,"docs":{"44":{"tf":1.0},"46":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"<":{"(":{")":{">":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"42":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":3,"docs":{"2":{"tf":1.7320508075688772},"6":{"tf":1.0},"9":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"43":{"tf":1.0}}}}},"i":{"df":1,"docs":{"6":{"tf":1.0}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":8,"docs":{"13":{"tf":1.0},"14":{"tf":1.7320508075688772},"15":{"tf":1.7320508075688772},"16":{"tf":1.7320508075688772},"40":{"tf":1.0},"42":{"tf":1.4142135623730951},"43":{"tf":1.0},"45":{"tf":1.0}}}}}}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"k":{"df":1,"docs":{"6":{"tf":1.0}}}}},"m":{"df":2,"docs":{"3":{"tf":1.0},"7":{"tf":1.4142135623730951}}},"u":{"df":0,"docs":{},"n":{"df":6,"docs":{"0":{"tf":1.0},"3":{"tf":1.0},"4":{"tf":1.7320508075688772},"7":{"tf":2.23606797749979},"8":{"tf":1.7320508075688772},"9":{"tf":1.0}}}}},"s":{"c":{"a":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"42":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"a":{"df":1,"docs":{"0":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"48":{"tf":1.0}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"42":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"df":2,"docs":{"12":{"tf":1.0},"6":{"tf":1.0}}},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"5":{"tf":1.0}}}},"df":0,"docs":{}}},"n":{"d":{"df":1,"docs":{"48":{"tf":1.0}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"v":{"df":1,"docs":{"1":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"40":{"tf":1.4142135623730951}}}},"i":{"c":{"df":1,"docs":{"0":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"t":{"df":12,"docs":{"0":{"tf":1.0},"12":{"tf":1.0},"22":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.0},"3":{"tf":1.0},"44":{"tf":1.0},"46":{"tf":1.0},"5":{"tf":1.0},"6":{"tf":1.7320508075688772},"7":{"tf":2.0},"8":{"tf":1.0}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"24":{"tf":1.0},"42":{"tf":1.0}}}}}},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"6":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"45":{"tf":1.0}}}},"df":0,"docs":{}}}}},"n":{"df":1,"docs":{"35":{"tf":1.0}}},"z":{"df":0,"docs":{},"e":{"df":1,"docs":{"42":{"tf":1.7320508075688772}}}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":2,"docs":{"19":{"tf":1.0},"23":{"tf":1.4142135623730951}}}}}},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"0":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"r":{"c":{"df":1,"docs":{"2":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":1,"docs":{"24":{"tf":1.0}},"i":{"df":2,"docs":{"42":{"tf":1.0},"48":{"tf":1.0}}}}}},"df":0,"docs":{}}},"r":{"c":{"/":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"2":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":3,"docs":{"27":{"tf":1.0},"28":{"tf":1.7320508075688772},"37":{"tf":1.0}}},"df":0,"docs":{}},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"3":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"47":{"tf":1.0}}},"i":{"c":{"df":2,"docs":{"2":{"tf":1.0},"39":{"tf":2.0}}},"df":0,"docs":{}},"u":{"df":8,"docs":{"14":{"tf":1.0},"15":{"tf":1.4142135623730951},"18":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0},"22":{"tf":1.4142135623730951},"23":{"tf":1.4142135623730951},"26":{"tf":1.4142135623730951}}}}},"d":{":":{":":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{":":{":":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"p":{"df":2,"docs":{"2":{"tf":1.0},"42":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"n":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{":":{":":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"2":{"tf":1.0}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"r":{"df":1,"docs":{"2":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"\"":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"11":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":7,"docs":{"10":{"tf":1.7320508075688772},"2":{"tf":1.0},"42":{"tf":1.7320508075688772},"44":{"tf":1.0},"46":{"tf":1.4142135623730951},"48":{"tf":1.0},"7":{"tf":1.4142135623730951}}}}},"u":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"2":{"tf":1.0},"48":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}},"u":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"7":{"tf":1.0}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"0":{"tf":1.0}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":2,"docs":{"12":{"tf":1.0},"5":{"tf":1.0}}}}}}}},"y":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"48":{"tf":1.0}}},"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"x":{"df":1,"docs":{"12":{"tf":1.0}}}},"df":0,"docs":{}}}}},"t":{"df":1,"docs":{"7":{"tf":1.4142135623730951}},"e":{"a":{"df":0,"docs":{},"m":{"\"":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":2,"docs":{"11":{"tf":1.0},"42":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":3,"docs":{"10":{"tf":1.4142135623730951},"11":{"tf":1.0},"42":{"tf":2.449489742783178}},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"10":{"tf":1.0}},"e":{"\"":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"11":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"7":{"tf":1.4142135623730951}},"s":{"/":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"/":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"/":{"d":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"7":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":1,"docs":{"7":{"tf":1.7320508075688772}}}}}}}}}},"df":0,"docs":{}}}}}}}}}},"df":0,"docs":{}}}},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"10":{"tf":1.4142135623730951}}}}},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":1,"docs":{"12":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":3,"docs":{"1":{"tf":1.0},"47":{"tf":1.0},"6":{"tf":1.0}}}}}}}},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":3,"docs":{"43":{"tf":1.0},"45":{"tf":1.0},"9":{"tf":1.0}}}},"n":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{"df":1,"docs":{"7":{"tf":1.0}}}}}}},"df":2,"docs":{"5":{"tf":1.0},"7":{"tf":1.0}}}}}}}}}},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"2":{"tf":1.0}}}}}},"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{":":{":":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"2":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"p":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":1,"docs":{"46":{"tf":1.4142135623730951}},"s":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"(":{"\"":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"\"":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"46":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":1,"docs":{"46":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"46":{"tf":1.0}}}}}},"df":1,"docs":{"46":{"tf":1.7320508075688772}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"r":{"a":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":2,"docs":{"12":{"tf":1.0},"6":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":3,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"7":{"tf":1.4142135623730951}}}}},"w":{"df":0,"docs":{},"o":{"df":1,"docs":{"5":{"tf":1.0}}}},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"11":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}},"df":11,"docs":{"10":{"tf":1.7320508075688772},"11":{"tf":1.0},"12":{"tf":1.7320508075688772},"2":{"tf":1.4142135623730951},"41":{"tf":1.0},"42":{"tf":2.23606797749979},"43":{"tf":1.0},"44":{"tf":1.4142135623730951},"46":{"tf":1.4142135623730951},"48":{"tf":1.7320508075688772},"7":{"tf":1.4142135623730951}}}}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"6":{"tf":1.0}}}}},"p":{"d":{"a":{"df":0,"docs":{},"t":{"df":8,"docs":{"0":{"tf":1.0},"12":{"tf":1.0},"21":{"tf":2.23606797749979},"22":{"tf":1.7320508075688772},"23":{"tf":1.7320508075688772},"24":{"tf":1.7320508075688772},"34":{"tf":1.7320508075688772},"35":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":4,"docs":{"5":{"tf":1.0},"6":{"tf":1.4142135623730951},"7":{"tf":1.0},"8":{"tf":1.0}}},"s":{"a":{"df":0,"docs":{},"g":{"df":4,"docs":{"42":{"tf":1.4142135623730951},"44":{"tf":1.4142135623730951},"46":{"tf":1.4142135623730951},"48":{"tf":1.4142135623730951}}}},"df":9,"docs":{"1":{"tf":1.4142135623730951},"11":{"tf":1.0},"2":{"tf":2.6457513110645907},"39":{"tf":1.0},"42":{"tf":2.0},"5":{"tf":1.4142135623730951},"6":{"tf":1.4142135623730951},"7":{"tf":2.0},"8":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"\"":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"11":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"2":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":10,"docs":{"10":{"tf":1.7320508075688772},"11":{"tf":1.0},"16":{"tf":1.4142135623730951},"19":{"tf":1.4142135623730951},"2":{"tf":1.4142135623730951},"20":{"tf":1.4142135623730951},"23":{"tf":1.4142135623730951},"32":{"tf":1.0},"33":{"tf":1.0},"46":{"tf":1.4142135623730951}},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"10":{"tf":1.0}},"e":{"\"":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"11":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"u":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"7":{"tf":1.0}}},"df":0,"docs":{}}}},"v":{"1":{".":{"0":{".":{"0":{"df":1,"docs":{"0":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"7":{"tf":1.0}}},"df":0,"docs":{}},"u":{"df":5,"docs":{"40":{"tf":1.0},"43":{"tf":1.7320508075688772},"44":{"tf":1.4142135623730951},"45":{"tf":1.4142135623730951},"46":{"tf":1.0}},"e":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"(":{"\"":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"0":{"\"":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"46":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"u":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"d":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"_":{"df":0,"docs":{},"v":{"4":{"(":{")":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"h":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"d":{"(":{")":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"46":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"6":{"4":{"(":{"5":{"df":1,"docs":{"42":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"(":{"\"":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":1,"docs":{"42":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},">":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"46":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"i":{"a":{"b":{"df":0,"docs":{},"l":{"df":4,"docs":{"5":{"tf":1.0},"6":{"tf":1.0},"7":{"tf":2.0},"8":{"tf":1.0}}}},"df":0,"docs":{}},"df":1,"docs":{"42":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"c":{"!":{"[":{"\"":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"\"":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"11":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"11":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"11":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"11":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}},"df":1,"docs":{"11":{"tf":1.7320508075688772}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":8,"docs":{"0":{"tf":1.4142135623730951},"10":{"tf":1.0},"2":{"tf":1.4142135623730951},"40":{"tf":2.23606797749979},"42":{"tf":1.0},"6":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":1,"docs":{"7":{"tf":1.0}}}}}}},"i":{"a":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"49":{"tf":1.0}}}}}},"w":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"k":{"df":1,"docs":{"1":{"tf":1.0}}}},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"0":{"tf":1.0}}}},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":2,"docs":{"0":{"tf":1.0},"7":{"tf":1.0}}}}},"df":0,"docs":{}}},"n":{"df":1,"docs":{"0":{"tf":1.0}}},"p":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":19,"docs":{"0":{"tf":2.0},"1":{"tf":1.4142135623730951},"10":{"tf":1.0},"11":{"tf":1.0},"12":{"tf":2.0},"2":{"tf":2.0},"3":{"tf":1.0},"39":{"tf":1.0},"4":{"tf":1.0},"41":{"tf":1.0},"43":{"tf":1.4142135623730951},"44":{"tf":1.0},"46":{"tf":1.0},"48":{"tf":1.0},"5":{"tf":1.4142135623730951},"6":{"tf":2.0},"7":{"tf":2.0},"8":{"tf":1.7320508075688772},"9":{"tf":2.0}},"e":{"df":0,"docs":{},"r":{":":{":":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"2":{"tf":1.0},"42":{"tf":1.0}},"e":{":":{":":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{":":{":":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"2":{"tf":1.0}}}}}}}}}},"df":0,"docs":{},"{":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":1,"docs":{"11":{"tf":1.0}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{":":{":":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"2":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"d":{"a":{"df":0,"docs":{},"t":{"a":{"b":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{":":{":":{"d":{"a":{"df":0,"docs":{},"t":{"a":{"b":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"2":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"o":{"4":{"df":0,"docs":{},"j":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"o":{"4":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"2":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{":":{":":{"df":0,"docs":{},"{":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"f":{"a":{"c":{"a":{"d":{"df":1,"docs":{"42":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{":":{":":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":1,"docs":{"42":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":1,"docs":{"5":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"y":{"df":1,"docs":{"6":{"tf":1.0}}}},"df":0,"docs":{},"e":{"b":{"df":2,"docs":{"0":{"tf":1.0},"1":{"tf":1.0}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"0":{"tf":1.0}}}}},"g":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"=":{"*":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":1,"docs":{"6":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"p":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"=":{"*":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":1,"docs":{"6":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"=":{"4":{"4":{"3":{"df":1,"docs":{"6":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"=":{"/":{"d":{"b":{"df":0,"docs":{},"s":{"/":{"*":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":1,"docs":{"6":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"_":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"=":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":1,"docs":{"7":{"tf":1.0}}}}}},"df":1,"docs":{"7":{"tf":1.0}}}}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"=":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"7":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"p":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"=":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"7":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"=":{"8":{"1":{"8":{"2":{"df":1,"docs":{"7":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"=":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"7":{"tf":1.0}}}}}}}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"i":{"d":{"=":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":1,"docs":{"7":{"tf":1.0}}}}}},"df":1,"docs":{"7":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"o":{"4":{"df":0,"docs":{},"j":{"_":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"=":{"1":{"2":{"7":{".":{"0":{".":{"0":{".":{"1":{"df":2,"docs":{"3":{"tf":1.0},"8":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"p":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"=":{"*":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":2,"docs":{"3":{"tf":1.0},"8":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"=":{"7":{"6":{"8":{"7":{"df":2,"docs":{"3":{"tf":1.0},"8":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"=":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"o":{"4":{"df":0,"docs":{},"j":{"df":2,"docs":{"3":{"tf":1.0},"8":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"(":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"df":4,"docs":{"42":{"tf":1.0},"44":{"tf":1.0},"46":{"tf":1.0},"48":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}}}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"(":{"\"":{"0":{".":{"1":{".":{"0":{"\"":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"40":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"6":{"tf":1.0}}}}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"6":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}},"title":{"root":{"a":{"d":{"d":{"df":1,"docs":{"24":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":1,"docs":{"12":{"tf":1.0}}}},"z":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"6":{"tf":1.0}}}}}},"b":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":1,"docs":{"7":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":2,"docs":{"32":{"tf":1.0},"33":{"tf":1.0}}}}}}}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":3,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"9":{"tf":1.0}}}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"23":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"47":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":1,"docs":{"6":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":7,"docs":{"17":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":1.0}}}},"df":0,"docs":{}},"u":{"d":{"df":1,"docs":{"12":{"tf":1.0}}},"df":0,"docs":{}}}},"d":{"a":{"df":0,"docs":{},"t":{"a":{"b":{"a":{"df":0,"docs":{},"s":{"df":3,"docs":{"3":{"tf":1.0},"5":{"tf":1.0},"7":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"b":{"df":1,"docs":{"6":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"41":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":4,"docs":{"25":{"tf":1.0},"26":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"29":{"tf":1.0}}}},"y":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":2,"docs":{"43":{"tf":1.0},"45":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"39":{"tf":1.0},"41":{"tf":1.0}}}}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"38":{"tf":1.0}}}}}},"x":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"49":{"tf":1.0}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":3,"docs":{"20":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":1.0}}}}}}},"f":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"38":{"tf":1.0}}}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"n":{"d":{"df":3,"docs":{"28":{"tf":1.0},"29":{"tf":1.0},"30":{"tf":1.0}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"49":{"tf":1.0}}}}}},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"7":{"tf":1.0}}}}}}}}},"m":{"a":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"df":5,"docs":{"15":{"tf":1.0},"16":{"tf":1.0},"22":{"tf":1.0},"23":{"tf":1.0},"26":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"24":{"tf":1.0}}}}}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"o":{"4":{"df":0,"docs":{},"j":{"df":1,"docs":{"8":{"tf":1.0}}}},"df":0,"docs":{}},"w":{"df":2,"docs":{"19":{"tf":1.0},"33":{"tf":1.0}}}},"o":{"d":{"df":0,"docs":{},"e":{"df":18,"docs":{"13":{"tf":1.0},"14":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":1.4142135623730951},"17":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.4142135623730951},"20":{"tf":1.4142135623730951},"21":{"tf":1.0},"22":{"tf":1.0},"23":{"tf":1.4142135623730951},"24":{"tf":1.4142135623730951},"25":{"tf":1.0},"26":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"p":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":1,"docs":{"32":{"tf":1.0}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"11":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"p":{"df":8,"docs":{"15":{"tf":1.0},"16":{"tf":1.0},"22":{"tf":1.4142135623730951},"23":{"tf":1.4142135623730951},"26":{"tf":1.0},"30":{"tf":1.0},"35":{"tf":1.0},"43":{"tf":1.0}}}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"1":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":2,"docs":{"13":{"tf":1.0},"27":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":18,"docs":{"16":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"30":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0},"45":{"tf":1.0}}}}}}}}}}},"df":1,"docs":{"30":{"tf":1.0}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"47":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":3,"docs":{"14":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"n":{"df":1,"docs":{"4":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"c":{"df":1,"docs":{"2":{"tf":1.0}}},"df":0,"docs":{}}}},"r":{"c":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}},"t":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"10":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"p":{"d":{"a":{"df":0,"docs":{},"t":{"df":6,"docs":{"21":{"tf":1.0},"22":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"s":{"a":{"df":0,"docs":{},"g":{"df":4,"docs":{"42":{"tf":1.0},"44":{"tf":1.0},"46":{"tf":1.0},"48":{"tf":1.0}}}},"df":0,"docs":{}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"40":{"tf":1.0}}}}}}}}},"w":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"p":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":3,"docs":{"0":{"tf":1.0},"12":{"tf":1.0},"9":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"lang":"English","pipeline":["trimmer","stopWordFilter","stemmer"],"ref":"id","version":"0.9.5"},"results_options":{"limit_results":30,"teaser_word_count":30},"search_options":{"bool":"OR","expand":true,"fields":{"body":{"boost":1},"breadcrumbs":{"boost":1},"title":{"boost":2}}}});